/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import com.android.internal.R;

public class TextAppearanceSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final int mStyle;
    private final ColorStateList mTextColor;
    private final ColorStateList mTextColorLink;
    private final int mTextSize;
    private final String mTypeface;

    public TextAppearanceSpan(Context context, int n) {
        this(context, n, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TextAppearanceSpan(Context context, int n, int n2) {
        TypedArray typedArray = context.obtainStyledAttributes(n, R.styleable.TextAppearance);
        ColorStateList colorStateList = typedArray.getColorStateList(3);
        this.mTextColorLink = typedArray.getColorStateList(6);
        this.mTextSize = typedArray.getDimensionPixelSize(0, -1);
        this.mStyle = typedArray.getInt(2, 0);
        String string2 = typedArray.getString(12);
        if (string2 != null) {
            this.mTypeface = string2;
        } else {
            switch (typedArray.getInt(1, 0)) {
                default: {
                    this.mTypeface = null;
                    break;
                }
                case 1: {
                    this.mTypeface = "sans";
                    break;
                }
                case 2: {
                    this.mTypeface = "serif";
                    break;
                }
                case 3: {
                    this.mTypeface = "monospace";
                    break;
                }
                case 4: {
                    this.mTypeface = "DFPhelvetica";
                    break;
                }
                case 5: {
                    this.mTypeface = "weatherfontReg";
                }
            }
        }
        typedArray.recycle();
        if (n2 >= 0) {
            TypedArray typedArray2 = context.obtainStyledAttributes(16973829, R.styleable.Theme);
            colorStateList = typedArray2.getColorStateList(n2);
            typedArray2.recycle();
        }
        this.mTextColor = colorStateList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TextAppearanceSpan(Parcel parcel) {
        this.mTypeface = parcel.readString();
        this.mStyle = parcel.readInt();
        this.mTextSize = parcel.readInt();
        this.mTextColor = parcel.readInt() != 0 ? ColorStateList.CREATOR.createFromParcel(parcel) : null;
        if (parcel.readInt() != 0) {
            this.mTextColorLink = ColorStateList.CREATOR.createFromParcel(parcel);
            return;
        }
        this.mTextColorLink = null;
    }

    public TextAppearanceSpan(String string2, int n, int n2, ColorStateList colorStateList, ColorStateList colorStateList2) {
        this.mTypeface = string2;
        this.mStyle = n;
        this.mTextSize = n2;
        this.mTextColor = colorStateList;
        this.mTextColorLink = colorStateList2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getFamily() {
        return this.mTypeface;
    }

    public ColorStateList getLinkTextColor() {
        return this.mTextColorLink;
    }

    @Override
    public int getSpanTypeId() {
        return 17;
    }

    public ColorStateList getTextColor() {
        return this.mTextColor;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public int getTextStyle() {
        return this.mStyle;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        this.updateMeasureState(textPaint);
        if (this.mTextColor != null) {
            textPaint.setColor(this.mTextColor.getColorForState(textPaint.drawableState, 0));
        }
        if (this.mTextColorLink != null) {
            textPaint.linkColor = this.mTextColorLink.getColorForState(textPaint.drawableState, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateMeasureState(TextPaint textPaint) {
        if (this.mTypeface != null || this.mStyle != 0) {
            Typeface typeface;
            int n;
            int n2;
            Typeface typeface2 = textPaint.getTypeface();
            int n3 = 0;
            if (typeface2 != null) {
                n3 = typeface2.getStyle();
            }
            if (((n2 = (n = n3 | this.mStyle) & (0xFFFFFFFF ^ (typeface = this.mTypeface != null ? Typeface.create(this.mTypeface, n) : (typeface2 == null ? Typeface.defaultFromStyle(n) : Typeface.create(typeface2, n))).getStyle())) & 1) != 0) {
                textPaint.setFakeBoldText(true);
            }
            if ((n2 & 2) != 0) {
                textPaint.setTextSkewX(-0.25f);
            }
            textPaint.setTypeface(typeface);
        }
        if (this.mTextSize > 0) {
            textPaint.setTextSize(this.mTextSize);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mTypeface);
        parcel.writeInt(this.mStyle);
        parcel.writeInt(this.mTextSize);
        if (this.mTextColor != null) {
            parcel.writeInt(1);
            this.mTextColor.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        if (this.mTextColorLink != null) {
            parcel.writeInt(1);
            this.mTextColorLink.writeToParcel(parcel, n);
            return;
        }
        parcel.writeInt(0);
    }
}

