/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.method.BaseKeyListener;
import android.text.method.KeyListener;
import android.text.method.TextKeyListener;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;

public class MultiTapKeyListener
extends BaseKeyListener
implements SpanWatcher {
    private static MultiTapKeyListener[] sInstance = new MultiTapKeyListener[2 * TextKeyListener.Capitalize.values().length];
    private static final SparseArray<String> sRecs = new SparseArray();
    private boolean mAutoText;
    private TextKeyListener.Capitalize mCapitalize;

    static {
        sRecs.put(8, ".,1!@#$%^&*:/?'=()");
        sRecs.put(9, "abc2ABC");
        sRecs.put(10, "def3DEF");
        sRecs.put(11, "ghi4GHI");
        sRecs.put(12, "jkl5JKL");
        sRecs.put(13, "mno6MNO");
        sRecs.put(14, "pqrs7PQRS");
        sRecs.put(15, "tuv8TUV");
        sRecs.put(16, "wxyz9WXYZ");
        sRecs.put(7, "0+");
        sRecs.put(18, " ");
    }

    public MultiTapKeyListener(TextKeyListener.Capitalize capitalize, boolean bl) {
        this.mCapitalize = capitalize;
        this.mAutoText = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MultiTapKeyListener getInstance(boolean bl, TextKeyListener.Capitalize capitalize) {
        int n;
        int n2 = 2 * capitalize.ordinal();
        int n3 = n2 + (n = bl ? 1 : 0);
        if (sInstance[n3] == null) {
            MultiTapKeyListener.sInstance[n3] = new MultiTapKeyListener(capitalize, bl);
        }
        return sInstance[n3];
    }

    private static void removeTimeouts(Spannable spannable) {
        Timeout[] timeoutArray = spannable.getSpans(0, spannable.length(), Timeout.class);
        for (int i = 0; i < timeoutArray.length; ++i) {
            Timeout timeout = timeoutArray[i];
            timeout.removeCallbacks(timeout);
            Timeout.access$002(timeout, null);
            spannable.removeSpan(timeout);
        }
    }

    @Override
    public int getInputType() {
        return MultiTapKeyListener.makeTextContentType(this.mCapitalize, this.mAutoText);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        int n2;
        String string2;
        int n3;
        int n4;
        int n5;
        block16: {
            int n6 = 0;
            if (view != null) {
                n6 = TextKeyListener.getInstance().getPrefs(view.getContext());
            }
            int n7 = Selection.getSelectionStart(editable);
            int n8 = Selection.getSelectionEnd(editable);
            n5 = Math.min(n7, n8);
            n4 = Math.max(n7, n8);
            int n9 = editable.getSpanStart(TextKeyListener.ACTIVE);
            int n10 = editable.getSpanEnd(TextKeyListener.ACTIVE);
            int n11 = (0xFF000000 & editable.getSpanFlags(TextKeyListener.ACTIVE)) >>> 24;
            if (n9 == n5 && n10 == n4 && n4 - n5 == 1 && n11 >= 0 && n11 < sRecs.size()) {
                String string3;
                int n12;
                if (n == 17) {
                    char c = editable.charAt(n5);
                    if (Character.isLowerCase(c)) {
                        editable.replace(n5, n4, String.valueOf(c).toUpperCase());
                        MultiTapKeyListener.removeTimeouts(editable);
                        new Timeout(editable);
                        return true;
                    }
                    if (Character.isUpperCase(c)) {
                        editable.replace(n5, n4, String.valueOf(c).toLowerCase());
                        MultiTapKeyListener.removeTimeouts(editable);
                        new Timeout(editable);
                        return true;
                    }
                }
                if (sRecs.indexOfKey(n) == n11 && (n12 = (string3 = sRecs.valueAt(n11)).indexOf(editable.charAt(n5))) >= 0) {
                    int n13 = (n12 + 1) % string3.length();
                    editable.replace(n5, n4, string3, n13, n13 + 1);
                    MultiTapKeyListener.removeTimeouts(editable);
                    new Timeout(editable);
                    return true;
                }
                n3 = sRecs.indexOfKey(n);
                if (n3 >= 0) {
                    Selection.setSelection(editable, n4, n4);
                    n5 = n4;
                }
            } else {
                n3 = sRecs.indexOfKey(n);
            }
            if (n3 < 0) {
                return super.onKeyDown(view, editable, n, keyEvent);
            }
            string2 = sRecs.valueAt(n3);
            int n14 = n6 & 1;
            n2 = 0;
            if (n14 != 0) {
                boolean bl = TextKeyListener.shouldCap(this.mCapitalize, editable, n5);
                n2 = 0;
                if (bl) {
                    int n15 = 0;
                    do {
                        int n16 = string2.length();
                        int n17 = ++n15;
                        n2 = 0;
                        if (n17 >= n16) break block16;
                    } while (!Character.isUpperCase(string2.charAt(n15)));
                    n2 = n15;
                }
            }
        }
        if (n5 != n4) {
            Selection.setSelection(editable, n4);
        }
        editable.setSpan(OLD_SEL_START, n5, n5, 17);
        int n18 = n2 + 1;
        editable.replace(n5, n4, string2, n2, n18);
        int n19 = editable.getSpanStart(OLD_SEL_START);
        int n20 = Selection.getSelectionEnd(editable);
        if (n20 != n19) {
            Selection.setSelection(editable, n19, n20);
            editable.setSpan(TextKeyListener.LAST_TYPED, n19, n20, 33);
            editable.setSpan(TextKeyListener.ACTIVE, n19, n20, 0x21 | n3 << 24);
        }
        MultiTapKeyListener.removeTimeouts(editable);
        new Timeout(editable);
        if (editable.getSpanStart(this) < 0) {
            KeyListener[] keyListenerArray = editable.getSpans(0, editable.length(), KeyListener.class);
            int n21 = keyListenerArray.length;
            for (int i = 0; i < n21; ++i) {
                editable.removeSpan(keyListenerArray[i]);
            }
            editable.setSpan(this, 0, editable.length(), 18);
        }
        return true;
    }

    @Override
    public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
    }

    @Override
    public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
        if (object == Selection.SELECTION_END) {
            spannable.removeSpan(TextKeyListener.ACTIVE);
            MultiTapKeyListener.removeTimeouts(spannable);
        }
    }

    @Override
    public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
    }

    private class Timeout
    extends Handler
    implements Runnable {
        private Editable mBuffer;

        public Timeout(Editable editable) {
            this.mBuffer = editable;
            this.mBuffer.setSpan(this, 0, this.mBuffer.length(), 18);
            this.postAtTime(this, 2000L + SystemClock.uptimeMillis());
        }

        static /* synthetic */ Editable access$002(Timeout timeout, Editable editable) {
            timeout.mBuffer = editable;
            return editable;
        }

        @Override
        public void run() {
            Editable editable = this.mBuffer;
            if (editable != null) {
                int n = Selection.getSelectionStart(editable);
                int n2 = Selection.getSelectionEnd(editable);
                int n3 = editable.getSpanStart(TextKeyListener.ACTIVE);
                int n4 = editable.getSpanEnd(TextKeyListener.ACTIVE);
                if (n == n3 && n2 == n4) {
                    Selection.setSelection(editable, Selection.getSelectionEnd(editable));
                }
                editable.removeSpan(this);
            }
        }
    }
}

