/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.text.format.TimeFormatter;
import android.util.TimeFormatException;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import libcore.util.ZoneInfo;
import libcore.util.ZoneInfoDB;

public class Time {
    private static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int EPOCH_JULIAN_DAY = 2440588;
    public static final int FRIDAY = 5;
    public static final int HOUR = 3;
    public static final int MINUTE = 2;
    public static final int MONDAY = 1;
    public static final int MONDAY_BEFORE_JULIAN_EPOCH = 2440585;
    public static final int MONTH = 5;
    public static final int MONTH_DAY = 4;
    public static final int SATURDAY = 6;
    public static final int SECOND = 1;
    public static final int SUNDAY = 0;
    public static final int THURSDAY = 4;
    public static final String TIMEZONE_UTC = "UTC";
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int WEEK_DAY = 7;
    public static final int WEEK_NUM = 9;
    public static final int YEAR = 6;
    public static final int YEAR_DAY = 8;
    private static final String Y_M_D = "%Y-%m-%d";
    private static final String Y_M_D_T_H_M_S_000 = "%Y-%m-%dT%H:%M:%S.000";
    private static final String Y_M_D_T_H_M_S_000_Z = "%Y-%m-%dT%H:%M:%S.000Z";
    private static final int[] sThursdayOffset = new int[]{-3, 3, 2, 1, 0, -1, -2};
    public boolean allDay;
    private TimeCalculator calculator;
    public long gmtoff;
    public int hour;
    public int isDst;
    public int minute;
    public int month;
    public int monthDay;
    public int second;
    public String timezone;
    public int weekDay;
    public int year;
    public int yearDay;

    public Time() {
        this.initialize(TimeZone.getDefault().getID());
    }

    public Time(Time time) {
        this.initialize(time.timezone);
        this.set(time);
    }

    public Time(String string2) {
        if (string2 == null) {
            throw new NullPointerException("timezoneId is null!");
        }
        this.initialize(string2);
    }

    private void checkChar(String string2, int n, char c) {
        char c2 = string2.charAt(n);
        if (c2 != c) {
            Object[] objectArray = new Object[]{(int)c2, n, (int)c, Character.valueOf(c)};
            throw new TimeFormatException(String.format("Unexpected character 0x%02d at pos=%d.  Expected 0x%02d ('%c').", objectArray));
        }
    }

    public static int compare(Time time, Time time2) {
        if (time == null) {
            throw new NullPointerException("a == null");
        }
        if (time2 == null) {
            throw new NullPointerException("b == null");
        }
        time.calculator.copyFieldsFromTime(time);
        time2.calculator.copyFieldsFromTime(time2);
        return TimeCalculator.compare(time.calculator, time2.calculator);
    }

    private static int getChar(String string2, int n, int n2) {
        char c = string2.charAt(n);
        if (Character.isDigit(c)) {
            return n2 * Character.getNumericValue(c);
        }
        throw new TimeFormatException("Parse error at pos=" + n);
    }

    public static String getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    public static int getJulianDay(long l, long l2) {
        return 2440588 + (int)((l + l2 * 1000L) / 86400000L);
    }

    public static int getJulianMondayFromWeeksSinceEpoch(int n) {
        return 2440585 + n * 7;
    }

    public static int getWeeksSinceEpochFromJulianDay(int n, int n2) {
        int n3 = 4 - n2;
        if (n3 < 0) {
            n3 += 7;
        }
        return (n - (2440588 - n3)) / 7;
    }

    private void initialize(String string2) {
        this.timezone = string2;
        this.year = 1970;
        this.monthDay = 1;
        this.isDst = -1;
        this.calculator = new TimeCalculator(string2);
    }

    public static boolean isEpoch(Time time) {
        return Time.getJulianDay(time.toMillis(true), 0L) == 2440588;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parse3339Internal(String string2) {
        boolean bl;
        int n = string2.length();
        if (n < 10) {
            throw new TimeFormatException("String too short --- expected at least 10 characters.");
        }
        this.year = Time.getChar(string2, 0, 1000) + Time.getChar(string2, 1, 100) + Time.getChar(string2, 2, 10) + Time.getChar(string2, 3, 1);
        this.checkChar(string2, 4, '-');
        this.month = -1 + (Time.getChar(string2, 5, 10) + Time.getChar(string2, 6, 1));
        this.checkChar(string2, 7, '-');
        this.monthDay = Time.getChar(string2, 8, 10) + Time.getChar(string2, 9, 1);
        if (n >= 19) {
            this.checkChar(string2, 10, 'T');
            this.allDay = false;
            int n2 = Time.getChar(string2, 11, 10) + Time.getChar(string2, 12, 1);
            this.checkChar(string2, 13, ':');
            int n3 = Time.getChar(string2, 14, 10) + Time.getChar(string2, 15, 1);
            this.checkChar(string2, 16, ':');
            this.second = Time.getChar(string2, 17, 10) + Time.getChar(string2, 18, 1);
            int n4 = 19;
            if (n4 < n && string2.charAt(n4) == '.') {
                while (++n4 < n && Character.isDigit(string2.charAt(n4))) {
                }
            }
            bl = false;
            int n5 = 0;
            if (n > n4) {
                char c = string2.charAt(n4);
                switch (c) {
                    default: {
                        Object[] objectArray = new Object[]{(int)c, n4};
                        throw new TimeFormatException(String.format("Unexpected character 0x%02d at position %d.  Expected + or -", objectArray));
                    }
                    case 'Z': {
                        n5 = 0;
                        break;
                    }
                    case '-': {
                        n5 = 1;
                        break;
                    }
                    case '+': {
                        n5 = -1;
                    }
                }
                bl = true;
                if (n5 != 0) {
                    if (n < n4 + 6) {
                        Object[] objectArray = new Object[]{n4 + 6};
                        throw new TimeFormatException(String.format("Unexpected length; should be %d characters", objectArray));
                    }
                    n2 += n5 * (Time.getChar(string2, n4 + 1, 10) + Time.getChar(string2, n4 + 2, 1));
                    n3 += n5 * (Time.getChar(string2, n4 + 4, 10) + Time.getChar(string2, n4 + 5, 1));
                }
            }
            this.hour = n2;
            this.minute = n3;
            if (n5 != 0) {
                this.normalize(false);
            }
        } else {
            this.allDay = true;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            bl = false;
        }
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseInternal(String string2) {
        boolean bl;
        int n = string2.length();
        if (n < 8) {
            throw new TimeFormatException("String is too short: \"" + string2 + "\" Expected at least 8 characters.");
        }
        this.year = Time.getChar(string2, 0, 1000) + Time.getChar(string2, 1, 100) + Time.getChar(string2, 2, 10) + Time.getChar(string2, 3, 1);
        this.month = -1 + (Time.getChar(string2, 4, 10) + Time.getChar(string2, 5, 1));
        this.monthDay = Time.getChar(string2, 6, 10) + Time.getChar(string2, 7, 1);
        if (n > 8) {
            if (n < 15) {
                throw new TimeFormatException("String is too short: \"" + string2 + "\" If there are more than 8 characters there must be at least" + " 15.");
            }
            this.checkChar(string2, 8, 'T');
            this.allDay = false;
            this.hour = Time.getChar(string2, 9, 10) + Time.getChar(string2, 10, 1);
            this.minute = Time.getChar(string2, 11, 10) + Time.getChar(string2, 12, 1);
            this.second = Time.getChar(string2, 13, 10) + Time.getChar(string2, 14, 1);
            bl = false;
            if (n > 15) {
                this.checkChar(string2, 15, 'Z');
                bl = true;
            }
        } else {
            this.allDay = true;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            bl = false;
        }
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
        return bl;
    }

    public boolean after(Time time) {
        return Time.compare(this, time) > 0;
    }

    public boolean before(Time time) {
        return Time.compare(this, time) < 0;
    }

    public void clear(String string2) {
        if (string2 == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = string2;
        this.allDay = false;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = 0;
        this.month = 0;
        this.year = 0;
        this.weekDay = 0;
        this.yearDay = 0;
        this.gmtoff = 0L;
        this.isDst = -1;
    }

    public String format(String string2) {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.format(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String format2445() {
        boolean bl;
        this.calculator.copyFieldsFromTime(this);
        TimeCalculator timeCalculator = this.calculator;
        if (!this.allDay) {
            bl = true;
            return timeCalculator.format2445(bl);
        }
        bl = false;
        return timeCalculator.format2445(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String format3339(boolean bl) {
        if (bl) {
            return this.format(Y_M_D);
        }
        if (TIMEZONE_UTC.equals(this.timezone)) {
            return this.format(Y_M_D_T_H_M_S_000_Z);
        }
        String string2 = this.format(Y_M_D_T_H_M_S_000);
        String string3 = this.gmtoff < 0L ? "-" : "+";
        int n = (int)Math.abs(this.gmtoff);
        int n2 = n % 3600 / 60;
        int n3 = n / 3600;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{string2, string3, n3, n2};
        return String.format(locale, "%s%s%02d:%02d", objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getActualMaximum(int n) {
        int n2 = 28;
        switch (n) {
            default: {
                throw new RuntimeException("bad field=" + n);
            }
            case 1: {
                return 59;
            }
            case 2: {
                return 59;
            }
            case 3: {
                return 23;
            }
            case 4: {
                int n3 = DAYS_PER_MONTH[this.month];
                if (n3 != n2) {
                    return n3;
                }
                int n4 = this.year;
                if (n4 % 4 != 0) return n2;
                if (n4 % 100 != 0) return 29;
                if (n4 % 400 != 0) return n2;
                return 29;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 2037;
            }
            case 7: {
                return 6;
            }
            case 8: {
                int n5 = this.year;
                if (n5 % 4 != 0) return 364;
                if (n5 % 100 != 0) return 365;
                if (n5 % 400 != 0) return 364;
                return 365;
            }
            case 9: 
        }
        throw new RuntimeException("WEEK_NUM not implemented");
    }

    public int getWeekNumber() {
        int n = this.yearDay + sThursdayOffset[this.weekDay];
        if (n >= 0 && n <= 364) {
            return 1 + n / 7;
        }
        Time time = new Time(this);
        time.monthDay += sThursdayOffset[this.weekDay];
        time.normalize(true);
        return 1 + time.yearDay / 7;
    }

    public long normalize(boolean bl) {
        this.calculator.copyFieldsFromTime(this);
        long l = this.calculator.toMillis(bl);
        this.calculator.copyFieldsToTime(this);
        return l;
    }

    public boolean parse(String string2) {
        if (string2 == null) {
            throw new NullPointerException("time string is null");
        }
        if (this.parseInternal(string2)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    public boolean parse3339(String string2) {
        if (string2 == null) {
            throw new NullPointerException("time string is null");
        }
        if (this.parse3339Internal(string2)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    public void set(int n, int n2, int n3) {
        this.allDay = true;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = n;
        this.month = n2;
        this.year = n3;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.allDay = false;
        this.second = n;
        this.minute = n2;
        this.hour = n3;
        this.monthDay = n4;
        this.month = n5;
        this.year = n6;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public void set(long l) {
        this.allDay = false;
        this.calculator.timezone = this.timezone;
        this.calculator.setTimeInMillis(l);
        this.calculator.copyFieldsToTime(this);
    }

    public void set(Time time) {
        this.timezone = time.timezone;
        this.allDay = time.allDay;
        this.second = time.second;
        this.minute = time.minute;
        this.hour = time.hour;
        this.monthDay = time.monthDay;
        this.month = time.month;
        this.year = time.year;
        this.weekDay = time.weekDay;
        this.yearDay = time.yearDay;
        this.isDst = time.isDst;
        this.gmtoff = time.gmtoff;
    }

    public long setJulianDay(int n) {
        long l = 86400000L * (long)(n - 2440588);
        this.set(l);
        this.monthDay = n - Time.getJulianDay(l, this.gmtoff) + this.monthDay;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        return this.normalize(true);
    }

    public void setToNow() {
        this.set(System.currentTimeMillis());
    }

    public void switchTimezone(String string2) {
        this.calculator.copyFieldsFromTime(this);
        this.calculator.switchTimeZone(string2);
        this.calculator.copyFieldsToTime(this);
        this.timezone = string2;
    }

    public long toMillis(boolean bl) {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.toMillis(bl);
    }

    public String toString() {
        TimeCalculator timeCalculator = new TimeCalculator(this.timezone);
        timeCalculator.copyFieldsFromTime(this);
        return timeCalculator.toStringInternal();
    }

    private static class TimeCalculator {
        public String timezone;
        public final ZoneInfo.WallTime wallTime;
        private ZoneInfo zoneInfo;

        public TimeCalculator(String string2) {
            this.zoneInfo = TimeCalculator.lookupZoneInfo(string2);
            this.wallTime = new ZoneInfo.WallTime();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int compare(TimeCalculator timeCalculator, TimeCalculator timeCalculator2) {
            if (timeCalculator.timezone.equals(timeCalculator2.timezone)) {
                int n = timeCalculator.wallTime.getYear() - timeCalculator2.wallTime.getYear();
                if (n != 0) {
                    return n;
                }
                n = timeCalculator.wallTime.getMonth() - timeCalculator2.wallTime.getMonth();
                if (n != 0) return n;
                n = timeCalculator.wallTime.getMonthDay() - timeCalculator2.wallTime.getMonthDay();
                if (n != 0) return n;
                n = timeCalculator.wallTime.getHour() - timeCalculator2.wallTime.getHour();
                if (n != 0) return n;
                n = timeCalculator.wallTime.getMinute() - timeCalculator2.wallTime.getMinute();
                if (n != 0) return n;
                n = timeCalculator.wallTime.getSecond() - timeCalculator2.wallTime.getSecond();
                if (n != 0) return n;
                return 0;
            }
            long l = timeCalculator.toMillis(false) - timeCalculator2.toMillis(false);
            if (l < 0L) {
                return -1;
            }
            long l2 = l - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            int n = 0;
            if (l3 <= 0) return n;
            return 1;
        }

        private static ZoneInfo lookupZoneInfo(String string2) {
            ZoneInfo zoneInfo;
            block5: {
                block4: {
                    try {
                        zoneInfo = ZoneInfoDB.getInstance().makeTimeZone(string2);
                        if (zoneInfo != null) break block4;
                    }
                    catch (IOException iOException) {
                        throw new AssertionError("Error loading timezone: \"" + string2 + "\"", iOException);
                    }
                    zoneInfo = ZoneInfoDB.getInstance().makeTimeZone("GMT");
                }
                if (zoneInfo != null) break block5;
                throw new AssertionError((Object)("GMT not found: \"" + string2 + "\""));
            }
            return zoneInfo;
        }

        private char toChar(int n) {
            if (n >= 0 && n <= 9) {
                return (char)(n + 48);
            }
            return ' ';
        }

        private void updateZoneInfoFromTimeZone() {
            if (!this.zoneInfo.getID().equals(this.timezone)) {
                this.zoneInfo = TimeCalculator.lookupZoneInfo(this.timezone);
            }
        }

        public void copyFieldsFromTime(Time time) {
            this.wallTime.setSecond(time.second);
            this.wallTime.setMinute(time.minute);
            this.wallTime.setHour(time.hour);
            this.wallTime.setMonthDay(time.monthDay);
            this.wallTime.setMonth(time.month);
            this.wallTime.setYear(time.year);
            this.wallTime.setWeekDay(time.weekDay);
            this.wallTime.setYearDay(time.yearDay);
            this.wallTime.setIsDst(time.isDst);
            this.wallTime.setGmtOffset((int)time.gmtoff);
            if (time.allDay && (time.second != 0 || time.minute != 0 || time.hour != 0)) {
                throw new IllegalArgumentException("allDay is true but sec, min, hour are not 0.");
            }
            this.timezone = time.timezone;
            this.updateZoneInfoFromTimeZone();
        }

        public void copyFieldsToTime(Time time) {
            time.second = this.wallTime.getSecond();
            time.minute = this.wallTime.getMinute();
            time.hour = this.wallTime.getHour();
            time.monthDay = this.wallTime.getMonthDay();
            time.month = this.wallTime.getMonth();
            time.year = this.wallTime.getYear();
            time.weekDay = this.wallTime.getWeekDay();
            time.yearDay = this.wallTime.getYearDay();
            time.isDst = this.wallTime.getIsDst();
            time.gmtoff = this.wallTime.getGmtOffset();
        }

        public String format(String string2) {
            if (string2 == null) {
                string2 = "%c";
            }
            return new TimeFormatter().format(string2, this.wallTime, this.zoneInfo);
        }

        /*
         * Enabled aggressive block sorting
         */
        public String format2445(boolean bl) {
            int n = bl ? 16 : 8;
            char[] cArray = new char[n];
            int n2 = this.wallTime.getYear();
            cArray[0] = this.toChar(n2 / 1000);
            int n3 = n2 % 1000;
            cArray[1] = this.toChar(n3 / 100);
            int n4 = n3 % 100;
            cArray[2] = this.toChar(n4 / 10);
            cArray[3] = this.toChar(n4 % 10);
            int n5 = 1 + this.wallTime.getMonth();
            cArray[4] = this.toChar(n5 / 10);
            cArray[5] = this.toChar(n5 % 10);
            int n6 = this.wallTime.getMonthDay();
            cArray[6] = this.toChar(n6 / 10);
            cArray[7] = this.toChar(n6 % 10);
            if (!bl) {
                return new String(cArray, 0, 8);
            }
            cArray[8] = 84;
            int n7 = this.wallTime.getHour();
            cArray[9] = this.toChar(n7 / 10);
            cArray[10] = this.toChar(n7 % 10);
            int n8 = this.wallTime.getMinute();
            cArray[11] = this.toChar(n8 / 10);
            cArray[12] = this.toChar(n8 % 10);
            int n9 = this.wallTime.getSecond();
            cArray[13] = this.toChar(n9 / 10);
            cArray[14] = this.toChar(n9 % 10);
            if (Time.TIMEZONE_UTC.equals(this.timezone)) {
                cArray[15] = 90;
                return new String(cArray, 0, 16);
            }
            return new String(cArray, 0, 15);
        }

        public void setTimeInMillis(long l) {
            int n = (int)(l / 1000L);
            this.updateZoneInfoFromTimeZone();
            this.wallTime.localtime(n, this.zoneInfo);
        }

        public void switchTimeZone(String string2) {
            int n = this.wallTime.mktime(this.zoneInfo);
            this.timezone = string2;
            this.updateZoneInfoFromTimeZone();
            this.wallTime.localtime(n, this.zoneInfo);
        }

        public long toMillis(boolean bl) {
            int n;
            if (bl) {
                this.wallTime.setIsDst(-1);
            }
            if ((n = this.wallTime.mktime(this.zoneInfo)) == -1) {
                return -1L;
            }
            return 1000L * (long)n;
        }

        public String toStringInternal() {
            Object[] objectArray = new Object[]{this.wallTime.getYear(), 1 + this.wallTime.getMonth(), this.wallTime.getMonthDay(), this.wallTime.getHour(), this.wallTime.getMinute(), this.wallTime.getSecond(), this.timezone, this.wallTime.getWeekDay(), this.wallTime.getYearDay(), this.wallTime.getGmtOffset(), this.wallTime.getIsDst(), this.toMillis(false) / 1000L};
            return String.format("%04d%02d%02dT%02d%02d%02d%s(%d,%d,%d,%d,%d)", objectArray);
        }
    }
}

