/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.format.DateFormat;
import android.text.format.Time;
import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import libcore.icu.DateIntervalFormat;
import libcore.icu.LocaleData;

public class DateUtils {
    @Deprecated
    public static final String ABBREV_MONTH_FORMAT = "%b";
    public static final String ABBREV_WEEKDAY_FORMAT = "%a";
    public static final long DAY_IN_MILLIS = 86400000L;
    @Deprecated
    public static final int FORMAT_12HOUR = 64;
    @Deprecated
    public static final int FORMAT_24HOUR = 128;
    public static final int FORMAT_ABBREV_ALL = 524288;
    public static final int FORMAT_ABBREV_MONTH = 65536;
    public static final int FORMAT_ABBREV_RELATIVE = 262144;
    public static final int FORMAT_ABBREV_TIME = 16384;
    public static final int FORMAT_ABBREV_WEEKDAY = 32768;
    @Deprecated
    public static final int FORMAT_CAP_AMPM = 256;
    @Deprecated
    public static final int FORMAT_CAP_MIDNIGHT = 4096;
    @Deprecated
    public static final int FORMAT_CAP_NOON = 1024;
    @Deprecated
    public static final int FORMAT_CAP_NOON_MIDNIGHT = 5120;
    public static final int FORMAT_NO_MIDNIGHT = 2048;
    public static final int FORMAT_NO_MONTH_DAY = 32;
    public static final int FORMAT_NO_NOON = 512;
    @Deprecated
    public static final int FORMAT_NO_NOON_MIDNIGHT = 2560;
    public static final int FORMAT_NO_YEAR = 8;
    public static final int FORMAT_NUMERIC_DATE = 131072;
    public static final int FORMAT_SHOW_DATE = 16;
    public static final int FORMAT_SHOW_TIME = 1;
    public static final int FORMAT_SHOW_WEEKDAY = 2;
    public static final int FORMAT_SHOW_YEAR = 4;
    @Deprecated
    public static final int FORMAT_UTC = 8192;
    public static final long HOUR_IN_MILLIS = 3600000L;
    @Deprecated
    public static final String HOUR_MINUTE_24 = "%H:%M";
    @Deprecated
    public static final int LENGTH_LONG = 10;
    @Deprecated
    public static final int LENGTH_MEDIUM = 20;
    @Deprecated
    public static final int LENGTH_SHORT = 30;
    @Deprecated
    public static final int LENGTH_SHORTER = 40;
    @Deprecated
    public static final int LENGTH_SHORTEST = 50;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final String MONTH_DAY_FORMAT = "%-d";
    public static final String MONTH_FORMAT = "%B";
    public static final String NUMERIC_MONTH_FORMAT = "%m";
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final String WEEKDAY_FORMAT = "%A";
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final String YEAR_FORMAT = "%Y";
    public static final String YEAR_FORMAT_TWO_DIGITS = "%g";
    public static final long YEAR_IN_MILLIS = 31449600000L;
    private static String sElapsedFormatHMMSS;
    private static String sElapsedFormatMMSS;
    private static Configuration sLastConfig;
    private static final Object sLock;
    private static Time sNowTime;
    private static Time sThenTime;
    public static final int[] sameMonthTable;
    public static final int[] sameYearTable;

    static {
        sLock = new Object();
        sameYearTable = null;
        sameMonthTable = null;
    }

    public static String formatDateRange(Context context, long l, long l2, int n) {
        return DateUtils.formatDateRange(context, new Formatter(new StringBuilder(50), Locale.getDefault()), l, l2, n).toString();
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long l, long l2, int n) {
        return DateUtils.formatDateRange(context, formatter, l, l2, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Formatter formatDateRange(Context context, Formatter formatter, long l, long l2, int n, String string2) {
        if ((n & 0xC1) == 1) {
            int n2 = DateFormat.is24HourFormat(context) ? 128 : 64;
            n |= n2;
        }
        String string3 = DateIntervalFormat.formatDateRange((long)l, (long)l2, (int)n, (String)string2);
        try {
            formatter.out().append(string3);
            return formatter;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static String formatDateTime(Context context, long l, int n) {
        return DateUtils.formatDateRange(context, l, l, n);
    }

    public static CharSequence formatDuration(long l) {
        Resources resources = Resources.getSystem();
        if (l >= 3600000L) {
            int n = (int)((1800000L + l) / 3600000L);
            Object[] objectArray = new Object[]{n};
            return resources.getQuantityString(0x1140014, n, objectArray);
        }
        if (l >= 60000L) {
            int n = (int)((30000L + l) / 60000L);
            Object[] objectArray = new Object[]{n};
            return resources.getQuantityString(18087955, n, objectArray);
        }
        int n = (int)((500L + l) / 1000L);
        Object[] objectArray = new Object[]{n};
        return resources.getQuantityString(18087954, n, objectArray);
    }

    public static String formatElapsedTime(long l) {
        return DateUtils.formatElapsedTime(null, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String formatElapsedTime(StringBuilder stringBuilder, long l) {
        long l2 = 0L;
        long l3 = 0L;
        if (l >= 3600L) {
            l2 = l / 3600L;
            l -= 3600L * l2;
        }
        if (l >= 60L) {
            l3 = l / 60L;
            l -= 60L * l3;
        }
        long l4 = l;
        StringBuilder stringBuilder2 = stringBuilder;
        if (stringBuilder2 == null) {
            stringBuilder2 = new StringBuilder(8);
        } else {
            stringBuilder2.setLength(0);
        }
        Formatter formatter = new Formatter(stringBuilder2, Locale.getDefault());
        DateUtils.initFormatStrings();
        if (l2 > 0L) {
            String string2 = sElapsedFormatHMMSS;
            Object[] objectArray = new Object[]{l2, l3, l4};
            return formatter.format(string2, objectArray).toString();
        }
        String string3 = sElapsedFormatMMSS;
        Object[] objectArray = new Object[]{l3, l4};
        return formatter.format(string3, objectArray).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final CharSequence formatSameDayTime(long l, long l2, int n, int n2) {
        java.text.DateFormat dateFormat;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        Date date = gregorianCalendar.getTime();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(l2);
        if (gregorianCalendar.get(1) == gregorianCalendar2.get(1) && gregorianCalendar.get(2) == gregorianCalendar2.get(2) && gregorianCalendar.get(5) == gregorianCalendar2.get(5)) {
            dateFormat = java.text.DateFormat.getTimeInstance(n2);
            return dateFormat.format(date);
        }
        dateFormat = java.text.DateFormat.getDateInstance(n);
        return dateFormat.format(date);
    }

    @Deprecated
    public static String getAMPMString(int n) {
        return LocaleData.get((Locale)Locale.getDefault()).amPm[n + 0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String getDayOfWeekString(int n, int n2) {
        String[] stringArray;
        LocaleData localeData = LocaleData.get((Locale)Locale.getDefault());
        switch (n2) {
            default: {
                stringArray = localeData.shortWeekdayNames;
                return stringArray[n];
            }
            case 10: {
                stringArray = localeData.longWeekdayNames;
                return stringArray[n];
            }
            case 20: {
                stringArray = localeData.shortWeekdayNames;
                return stringArray[n];
            }
            case 30: {
                stringArray = localeData.shortWeekdayNames;
                return stringArray[n];
            }
            case 40: {
                stringArray = localeData.shortWeekdayNames;
                return stringArray[n];
            }
            case 50: 
        }
        stringArray = localeData.tinyWeekdayNames;
        return stringArray[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String getMonthString(int n, int n2) {
        String[] stringArray;
        LocaleData localeData = LocaleData.get((Locale)Locale.getDefault());
        switch (n2) {
            default: {
                stringArray = localeData.shortMonthNames;
                return stringArray[n];
            }
            case 10: {
                stringArray = localeData.longMonthNames;
                return stringArray[n];
            }
            case 20: {
                stringArray = localeData.shortMonthNames;
                return stringArray[n];
            }
            case 30: {
                stringArray = localeData.shortMonthNames;
                return stringArray[n];
            }
            case 40: {
                stringArray = localeData.shortMonthNames;
                return stringArray[n];
            }
            case 50: 
        }
        stringArray = localeData.tinyMonthNames;
        return stringArray[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence getRelativeDateTimeString(Context context, long l, long l2, long l3, int n) {
        Resources resources = Resources.getSystem();
        long l4 = System.currentTimeMillis();
        long l5 = Math.abs(l4 - l);
        if (l3 > 604800000L) {
            l3 = 604800000L;
        } else if (l3 < 86400000L) {
            l3 = 86400000L;
        }
        String string2 = DateUtils.formatDateRange(context, l, l, 1);
        if (l5 < l3) {
            return resources.getString(17040462, DateUtils.getRelativeTimeSpanString(l, l4, l2, n), string2);
        }
        return resources.getString(17039451, DateUtils.getRelativeTimeSpanString(context, l, false), string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String getRelativeDayString(Resources resources, long l, long l2) {
        Locale locale = resources.getConfiguration().locale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Time time = new Time();
        time.set(l);
        int n = Time.getJulianDay(l, time.gmtoff);
        Time time2 = new Time();
        time2.set(l2);
        int n2 = Math.abs(Time.getJulianDay(l2, time2.gmtoff) - n);
        boolean bl = l2 > l;
        if (n2 == 1) {
            if (bl) {
                return LocaleData.get((Locale)locale).yesterday;
            }
            return LocaleData.get((Locale)locale).tomorrow;
        }
        if (n2 == 0) {
            return LocaleData.get((Locale)locale).today;
        }
        int n3 = bl ? 18087941 : 18087945;
        String string2 = resources.getQuantityString(n3, n2);
        Object[] objectArray = new Object[]{n2};
        return String.format(string2, objectArray);
    }

    public static CharSequence getRelativeTimeSpanString(long l) {
        return DateUtils.getRelativeTimeSpanString(l, System.currentTimeMillis(), 60000L);
    }

    public static CharSequence getRelativeTimeSpanString(long l, long l2, long l3) {
        return DateUtils.getRelativeTimeSpanString(l, l2, l3, 65556);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence getRelativeTimeSpanString(long l, long l2, long l3, int n) {
        long l4;
        Resources resources;
        block5: {
            int n2;
            long l5;
            block3: {
                boolean bl;
                boolean bl2;
                block4: {
                    block2: {
                        resources = Resources.getSystem();
                        bl2 = (0xC0000 & n) != 0;
                        bl = l2 >= l;
                        l4 = Math.abs(l2 - l);
                        if (l4 >= 60000L || l3 >= 60000L) break block2;
                        l5 = l4 / 1000L;
                        n2 = bl ? (bl2 ? 18087946 : 0x1140001) : (bl2 ? 18087950 : 18087942);
                        break block3;
                    }
                    if (l4 >= 3600000L || l3 >= 3600000L) break block4;
                    l5 = l4 / 60000L;
                    n2 = bl ? (bl2 ? 18087947 : 18087938) : (bl2 ? 18087951 : 18087943);
                    break block3;
                }
                if (l4 < 86400000L && l3 < 86400000L) {
                    l5 = l4 / 3600000L;
                    n2 = bl ? (bl2 ? 18087948 : 18087939) : (bl2 ? 0x1140010 : 18087944);
                }
                break block5;
            }
            int n3 = (int)l5;
            String string2 = resources.getQuantityString(n2, n3);
            Object[] objectArray = new Object[]{l5};
            return String.format(string2, objectArray);
        }
        if (l4 < 604800000L && l3 < 604800000L) {
            return DateUtils.getRelativeDayString(resources, l, l2);
        }
        return DateUtils.formatDateRange(null, l, l, n);
    }

    public static CharSequence getRelativeTimeSpanString(Context context, long l) {
        return DateUtils.getRelativeTimeSpanString(context, l, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharSequence getRelativeTimeSpanString(Context context, long l, boolean bl) {
        long l2 = System.currentTimeMillis();
        long l3 = Math.abs(l2 - l);
        synchronized (DateUtils.class) {
            int n;
            String string2;
            if (sNowTime == null) {
                sNowTime = new Time();
            }
            if (sThenTime == null) {
                sThenTime = new Time();
            }
            sNowTime.set(l2);
            sThenTime.set(l);
            if (l3 < 86400000L && DateUtils.sNowTime.weekDay == DateUtils.sThenTime.weekDay) {
                string2 = DateUtils.formatDateRange(context, l, l, 1);
                n = 0x1040440;
            } else if (DateUtils.sNowTime.year != DateUtils.sThenTime.year) {
                string2 = DateUtils.formatDateRange(context, l, l, 131092);
                n = 17040447;
            } else {
                string2 = DateUtils.formatDateRange(context, l, l, 65552);
                n = 17040447;
            }
            if (!bl) return string2;
            return context.getResources().getString(n, string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initFormatStrings() {
        Object object = sLock;
        synchronized (object) {
            DateUtils.initFormatStringsLocked();
            return;
        }
    }

    private static void initFormatStringsLocked() {
        Resources resources = Resources.getSystem();
        Configuration configuration = resources.getConfiguration();
        if (sLastConfig == null || !sLastConfig.equals(configuration)) {
            sLastConfig = configuration;
            sElapsedFormatMMSS = resources.getString(17040467);
            sElapsedFormatHMMSS = resources.getString(17040468);
        }
    }

    public static boolean isToday(long l) {
        Time time = new Time();
        time.set(l);
        int n = time.year;
        int n2 = time.month;
        int n3 = time.monthDay;
        time.set(System.currentTimeMillis());
        return n == time.year && n2 == time.month && n3 == time.monthDay;
    }
}

