/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.TabStopSpan;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;

public class StaticLayout
extends Layout {
    private static final int CHAR_FIRST_HIGH_SURROGATE = 55296;
    private static final int CHAR_LAST_LOW_SURROGATE = 57343;
    private static final char CHAR_NEW_LINE = '\n';
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_ZWSP = '\u200b';
    private static final int COLUMNS_ELLIPSIZE = 5;
    private static final int COLUMNS_NORMAL = 3;
    private static final int DESCENT = 2;
    private static final int DIR = 0;
    private static final int DIR_SHIFT = 30;
    private static final int ELLIPSIS_COUNT = 4;
    private static final int ELLIPSIS_START = 3;
    private static final double EXTRA_ROUNDING = 0.5;
    private static final int START = 0;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int TAB = 0;
    private static final int TAB_INCREMENT = 20;
    private static final int TAB_MASK = 0x20000000;
    static final String TAG = "StaticLayout";
    private static final int TOP = 1;
    private int mBottomPadding;
    private int mColumns;
    private int mEllipsizedWidth;
    private Paint.FontMetricsInt mFontMetricsInt;
    private int mLineCount;
    private Layout.Directions[] mLineDirections;
    private int[] mLines;
    private int mMaximumVisibleLineCount;
    private MeasuredText mMeasured;
    private int mTopPadding;

    StaticLayout(CharSequence charSequence) {
        super(charSequence, null, 0, null, 0.0f, 0.0f);
        this.mMaximumVisibleLineCount = Integer.MAX_VALUE;
        this.mFontMetricsInt = new Paint.FontMetricsInt();
        this.mColumns = 5;
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMeasured = MeasuredText.obtain();
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, n, n2, textPaint, n3, alignment, f, f2, bl, null, 0);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4) {
        this(charSequence, n, n2, textPaint, n3, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, f, f2, bl, truncateAt, n4, Integer.MAX_VALUE);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this(charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl, null, 0, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4, int n5) {
        CharSequence charSequence2 = truncateAt == null ? charSequence : (charSequence instanceof Spanned ? new Layout.SpannedEllipsizer(charSequence) : new Layout.Ellipsizer(charSequence));
        super(charSequence2, textPaint, n3, alignment, textDirectionHeuristic, f, f2);
        this.mMaximumVisibleLineCount = Integer.MAX_VALUE;
        this.mFontMetricsInt = new Paint.FontMetricsInt();
        if (truncateAt != null) {
            Layout.Ellipsizer ellipsizer = (Layout.Ellipsizer)this.getText();
            ellipsizer.mLayout = this;
            ellipsizer.mWidth = n4;
            ellipsizer.mMethod = truncateAt;
            this.mEllipsizedWidth = n4;
            this.mColumns = 5;
        } else {
            this.mColumns = 3;
            this.mEllipsizedWidth = n3;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMaximumVisibleLineCount = n5;
        this.mMeasured = MeasuredText.obtain();
        this.generate(charSequence, n, n2, textPaint, n3, textDirectionHeuristic, f, f2, bl, bl, n4, truncateAt);
        this.mMeasured = MeasuredText.recycle(this.mMeasured);
        this.mFontMetricsInt = null;
    }

    public StaticLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, 0, charSequence.length(), textPaint, n, alignment, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this(charSequence, 0, charSequence.length(), textPaint, n, alignment, textDirectionHeuristic, f, f2, bl);
    }

    /*
     * Unable to fully structure code
     */
    private void calculateEllipsis(int var1_1, int var2_2, float[] var3_3, int var4_4, float var5_5, TextUtils.TruncateAt var6_6, int var7_7, float var8_8, TextPaint var9_9, boolean var10_10) {
        block15: {
            block13: {
                block10: {
                    block11: {
                        block12: {
                            if (var8_8 <= var5_5 && !var10_10) {
                                this.mLines[3 + var7_7 * this.mColumns] = 0;
                                this.mLines[4 + var7_7 * this.mColumns] = 0;
                                return;
                            }
                            if (var6_6 == TextUtils.TruncateAt.END_SMALL) {
                                var11_11 = StaticLayout.ELLIPSIS_TWO_DOTS;
lbl7:
                                // 2 sources

                                while (true) {
                                    var12_12 = var9_9.measureText(var11_11, 0, 1);
                                    var13_13 = var2_2 - var1_1;
                                    if (var6_6 != TextUtils.TruncateAt.START) break block10;
                                    if (this.mMaximumVisibleLineCount != 1) break block11;
                                    var31_14 = 0.0f;
                                    var32_15 = var13_13;
lbl14:
                                    // 2 sources

                                    while (true) {
                                        if (var32_15 < 0 || var12_12 + ((var33_16 = var3_3[var1_1 + (var32_15 - 1) - var4_4]) + var31_14) > var5_5) {
                                            var16_17 = 0;
                                            var17_18 = var32_15;
lbl18:
                                            // 7 sources

                                            while (true) {
                                                this.mLines[3 + var7_7 * this.mColumns] = var16_17;
                                                this.mLines[4 + var7_7 * this.mColumns] = var17_18;
                                                return;
                                            }
                                        }
                                        break block12;
                                        break;
                                    }
                                    break;
                                }
                            }
                            var11_11 = StaticLayout.ELLIPSIS_NORMAL;
                            ** while (true)
                        }
                        var31_14 += var33_16;
                        --var32_15;
                        ** while (true)
                    }
                    var29_19 = Log.isLoggable("StaticLayout", 5);
                    var17_18 = 0;
                    var16_17 = 0;
                    if (!var29_19) ** GOTO lbl18
                    Log.w("StaticLayout", "Start Ellipsis only supported with one line");
                    var17_18 = 0;
                    var16_17 = 0;
                    ** GOTO lbl18
                }
                if (var6_6 != TextUtils.TruncateAt.END && var6_6 != TextUtils.TruncateAt.MARQUEE && var6_6 != TextUtils.TruncateAt.END_SMALL) break block13;
                var14_20 = 0.0f;
                var15_21 = 0;
                while (true) {
                    block14: {
                        if (var15_21 < var13_13 && !(var12_12 + ((var18_22 = var3_3[var15_21 + var1_1 - var4_4]) + var14_20) > var5_5)) break block14;
                        var16_17 = var15_21;
                        var17_18 = var13_13 - var15_21;
                        if (var10_10 && var17_18 == 0 && var13_13 > 0) {
                            var16_17 = var13_13 - 1;
                            var17_18 = 1;
                        }
                        ** GOTO lbl18
                    }
                    var14_20 += var18_22;
                    ++var15_21;
                }
            }
            if (this.mMaximumVisibleLineCount != 1) break block15;
            var21_23 = 0.0f;
            var22_24 = 0.0f;
            var23_25 = (var5_5 - var12_12) / 2.0f;
            var24_26 = var13_13;
            block4: while (true) {
                block16: {
                    if (var24_26 >= 0 && !((var28_27 = var3_3[var1_1 + (var24_26 - 1) - var4_4]) + var22_24 > var23_25)) break block16;
                    var25_28 = var5_5 - var12_12 - var22_24;
                    var26_29 = 0;
lbl65:
                    // 2 sources

                    while (true) {
                        if (var26_29 < var24_26 && !((var27_30 = var3_3[var26_29 + var1_1 - var4_4]) + var21_23 > var25_28)) break block4;
                        var16_17 = var26_29;
                        var17_18 = var24_26 - var26_29;
                        ** GOTO lbl18
                        break;
                    }
                }
                var22_24 += var28_27;
                --var24_26;
            }
            var21_23 += var27_30;
            ++var26_29;
            ** while (true)
        }
        var19_31 = Log.isLoggable("StaticLayout", 5);
        var17_18 = 0;
        var16_17 = 0;
        if (!var19_31) ** GOTO lbl18
        Log.w("StaticLayout", "Middle Ellipsis only supported with one line");
        var17_18 = 0;
        var16_17 = 0;
        ** while (true)
    }

    private static native int[] nLineBreakOpportunities(String var0, char[] var1, int var2, int[] var3);

    /*
     * Enabled aggressive block sorting
     */
    private int out(CharSequence charSequence, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, LineHeightSpan[] lineHeightSpanArray, int[] nArray, Paint.FontMetricsInt fontMetricsInt, boolean bl, boolean bl2, byte[] byArray, int n8, boolean bl3, int n9, boolean bl4, boolean bl5, char[] cArray, float[] fArray, int n10, TextUtils.TruncateAt truncateAt, float f3, float f4, TextPaint textPaint, boolean bl6) {
        double d;
        int n11 = this.mLineCount;
        int n12 = n11 * this.mColumns;
        int n13 = 1 + (n12 + this.mColumns);
        int[] nArray2 = this.mLines;
        if (n13 >= nArray2.length) {
            Layout.Directions[] directionsArray = ArrayUtils.newUnpaddedArray(Layout.Directions.class, GrowingArrayUtils.growSize(n13));
            System.arraycopy(this.mLineDirections, 0, directionsArray, 0, this.mLineDirections.length);
            this.mLineDirections = directionsArray;
            int[] nArray3 = new int[directionsArray.length];
            int n14 = nArray2.length;
            System.arraycopy((int[])nArray2, (int)0, (int[])nArray3, (int)0, (int)n14);
            this.mLines = nArray3;
            nArray2 = nArray3;
        }
        if (lineHeightSpanArray != null) {
            int n15;
            fontMetricsInt.ascent = n3;
            fontMetricsInt.descent = n4;
            fontMetricsInt.top = n5;
            fontMetricsInt.bottom = n6;
            for (int i = 0; i < (n15 = lineHeightSpanArray.length); ++i) {
                if (lineHeightSpanArray[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)lineHeightSpanArray[i]).chooseHeight(charSequence, n, n2, nArray[i], n7, fontMetricsInt, textPaint);
                    continue;
                }
                lineHeightSpanArray[i].chooseHeight(charSequence, n, n2, nArray[i], n7, fontMetricsInt);
            }
            n3 = fontMetricsInt.ascent;
            n4 = fontMetricsInt.descent;
            n5 = fontMetricsInt.top;
            n6 = fontMetricsInt.bottom;
        }
        boolean bl7 = n11 == 0;
        boolean bl8 = n11 + 1 == this.mMaximumVisibleLineCount;
        boolean bl9 = bl8 || n2 == n9;
        if (bl7) {
            if (bl5) {
                this.mTopPadding = n5 - n3;
            }
            if (bl4) {
                n3 = n5;
            }
        }
        if (bl9) {
            if (bl5) {
                this.mBottomPadding = n6 - n4;
            }
            if (bl4) {
                n4 = n6;
            }
        }
        int n16 = bl2 && !bl9 ? ((d = (double)(f2 + (float)(n4 - n3) * (f - 1.0f))) >= 0.0 ? (int)(0.5 + d) : -((int)(0.5 + -d))) : 0;
        nArray2[n12 + 0] = n;
        nArray2[n12 + 1] = n7;
        nArray2[n12 + 2] = n4 + n16;
        int n17 = n7 + (n16 + (n4 - n3));
        nArray2[0 + (n12 + this.mColumns)] = n2;
        nArray2[1 + (n12 + this.mColumns)] = n17;
        if (bl) {
            int n18 = n12 + 0;
            nArray2[n18] = 0x20000000 | nArray2[n18];
        }
        int n19 = n12 + 0;
        nArray2[n19] = nArray2[n19] | n8 << 30;
        Layout.Directions directions = DIRS_ALL_LEFT_TO_RIGHT;
        this.mLineDirections[n11] = bl3 ? directions : AndroidBidi.directions(n8, byArray, n - n10, cArray, n - n10, n2 - n);
        if (truncateAt != null) {
            boolean bl10 = bl6 && 1 + this.mLineCount == this.mMaximumVisibleLineCount;
            boolean bl11 = (this.mMaximumVisibleLineCount == 1 && bl6 || bl7 && !bl6) && truncateAt != TextUtils.TruncateAt.MARQUEE || !bl7 && (bl8 || !bl6) && truncateAt == TextUtils.TruncateAt.END;
            if (bl11) {
                this.calculateEllipsis(n, n2, fArray, n10, f3, truncateAt, n11, f4, textPaint, bl10);
            }
        }
        this.mLineCount = 1 + this.mLineCount;
        return n17;
    }

    void finish() {
        this.mMeasured = MeasuredText.recycle(this.mMeasured);
    }

    /*
     * Enabled aggressive block sorting
     */
    void generate(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, boolean bl2, float f3, TextUtils.TruncateAt truncateAt) {
        int[] nArray = null;
        String string2 = textPaint.getTextLocale().toLanguageTag();
        this.mLineCount = 0;
        int n4 = 0;
        boolean bl3 = f != 1.0f || f2 != 0.0f;
        Paint.FontMetricsInt fontMetricsInt = this.mFontMetricsInt;
        int[] nArray2 = null;
        MeasuredText measuredText = this.mMeasured;
        boolean bl4 = charSequence instanceof Spanned;
        Spanned spanned = null;
        if (bl4) {
            spanned = (Spanned)charSequence;
        }
        int n5 = n;
        block0: while (n5 <= n2) {
            int n6 = TextUtils.indexOf(charSequence, '\n', n5, n2);
            int n7 = n6 < 0 ? n2 : n6 + 1;
            int n8 = 1 + this.mLineCount;
            int n9 = n3;
            int n10 = n3;
            LineHeightSpan[] lineHeightSpanArray = null;
            if (spanned != null) {
                int n11;
                LeadingMarginSpan[] leadingMarginSpanArray = StaticLayout.getParagraphSpans(spanned, n5, n7, LeadingMarginSpan.class);
                for (int i = 0; i < (n11 = leadingMarginSpanArray.length); ++i) {
                    LeadingMarginSpan leadingMarginSpan = leadingMarginSpanArray[i];
                    n9 -= leadingMarginSpanArray[i].getLeadingMargin(true);
                    n10 -= leadingMarginSpanArray[i].getLeadingMargin(false);
                    if (!(leadingMarginSpan instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 leadingMarginSpan2 = (LeadingMarginSpan.LeadingMarginSpan2)leadingMarginSpan;
                    int n12 = this.getLineForOffset(spanned.getSpanStart(leadingMarginSpan2)) + leadingMarginSpan2.getLeadingMarginLineCount();
                    n8 = Math.max(n8, n12);
                }
                lineHeightSpanArray = StaticLayout.getParagraphSpans(spanned, n5, n7, LineHeightSpan.class);
                if (lineHeightSpanArray.length != 0) {
                    int n13;
                    if (nArray2 == null || nArray2.length < lineHeightSpanArray.length) {
                        nArray2 = ArrayUtils.newUnpaddedIntArray(lineHeightSpanArray.length);
                    }
                    for (int i = 0; i < (n13 = lineHeightSpanArray.length); ++i) {
                        LineHeightSpan lineHeightSpan = lineHeightSpanArray[i];
                        int n14 = spanned.getSpanStart(lineHeightSpan);
                        nArray2[i] = n14 < n5 ? this.getLineTop(this.getLineForOffset(n14)) : n4;
                    }
                }
            }
            measuredText.setPara(charSequence, n5, n7, textDirectionHeuristic);
            char[] cArray = measuredText.mChars;
            float[] fArray = measuredText.mWidths;
            byte[] byArray = measuredText.mLevels;
            int n15 = measuredText.mDir;
            boolean bl5 = measuredText.mEasy;
            nArray = StaticLayout.nLineBreakOpportunities(string2, cArray, n7 - n5, nArray);
            int n16 = 0;
            int n17 = n9;
            float f4 = 0.0f;
            int n18 = n5;
            int n19 = n5;
            float f5 = 0.0f;
            int n20 = 0;
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = n5;
            float f6 = 0.0f;
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            float f7 = 0.0f;
            boolean bl6 = false;
            boolean bl7 = false;
            Layout.TabStops tabStops = null;
            int n29 = n5;
            while (true) {
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                if (n29 < n7) {
                    if (spanned == null) {
                        n34 = n7;
                        measuredText.addStyleRun(textPaint, n34 - n29, fontMetricsInt);
                    } else {
                        n34 = spanned.nextSpanTransition(n29, n7, MetricAffectingSpan.class);
                        int n35 = n34 - n29;
                        measuredText.addStyleRun(textPaint, TextUtils.removeEmptySpans(spanned.getSpans(n29, n34, MetricAffectingSpan.class), spanned, MetricAffectingSpan.class), n35, fontMetricsInt);
                    }
                    n33 = fontMetricsInt.top;
                    n32 = fontMetricsInt.bottom;
                    n31 = fontMetricsInt.ascent;
                    n30 = fontMetricsInt.descent;
                } else {
                    if (n7 != n18 && this.mLineCount < this.mMaximumVisibleLineCount) {
                        if (!(n25 | (n26 | (n27 | n28)))) {
                            textPaint.getFontMetricsInt(fontMetricsInt);
                            n27 = fontMetricsInt.top;
                            n28 = fontMetricsInt.bottom;
                            n25 = fontMetricsInt.ascent;
                            n26 = fontMetricsInt.descent;
                        }
                        boolean bl8 = n7 != n2;
                        n4 = this.out(charSequence, n18, n7, n25, n26, n27, n28, n4, f, f2, lineHeightSpanArray, nArray2, fontMetricsInt, bl6, bl3, byArray, n15, bl5, n2, bl, bl2, cArray, fArray, n5, truncateAt, f3, f4, textPaint, bl8);
                    }
                    if (n7 == n2) break block0;
                    n5 = n7;
                    continue block0;
                }
                for (int i = n29; i < n34; ++i) {
                    boolean bl9;
                    float f8;
                    int n36;
                    int n37;
                    int n38;
                    int n39;
                    int n40;
                    char c;
                    block43: {
                        block45: {
                            block44: {
                                c = cArray[i - n5];
                                if (c == '\n') break block43;
                                if (c != '\t') break block44;
                                if (!bl7) {
                                    Object[] objectArray;
                                    bl7 = true;
                                    bl6 = true;
                                    if (spanned != null && (objectArray = StaticLayout.getParagraphSpans(spanned, n5, n7, TabStopSpan.class)).length > 0) {
                                        tabStops = new Layout.TabStops(20, objectArray);
                                    }
                                }
                                f4 = tabStops != null ? tabStops.nextTab(f4) : Layout.TabStops.nextDefaultStop(f4, 20);
                                break block43;
                            }
                            if (c < '\ud800' || c > '\udfff' || i + 1 >= n34) break block45;
                            int n41 = Character.codePointAt(cArray, i - n5);
                            if (n41 >= MIN_EMOJI && n41 <= MAX_EMOJI) {
                                Bitmap bitmap = EMOJI_FACTORY.getBitmapFromAndroidPua(n41);
                                if (bitmap != null) {
                                    TextPaint textPaint2 = spanned == null ? textPaint : this.mWorkPaint;
                                    f4 += (float)bitmap.getWidth() * -textPaint2.ascent() / (float)bitmap.getHeight();
                                    bl6 = true;
                                    ++i;
                                    break block43;
                                } else {
                                    f4 += fArray[i - n5];
                                }
                                break block43;
                            } else {
                                f4 += fArray[i - n5];
                            }
                            break block43;
                        }
                        f4 += fArray[i - n5];
                    }
                    boolean bl10 = c == ' ' || c == '\t' || c == '\u200b';
                    if (f4 <= (float)n17 || bl10) {
                        f6 = f4;
                        if (!bl10) {
                            f7 = f4;
                        }
                        n24 = i + 1;
                        if (n33 < n27) {
                            n27 = n33;
                        }
                        if (n31 < n25) {
                            n25 = n31;
                        }
                        if (n30 > n26) {
                            n26 = n30;
                        }
                        if (n32 > n28) {
                            n28 = n32;
                        }
                        while (nArray[n16] != -1 && nArray[n16] < 1 + (i - n5)) {
                            ++n16;
                        }
                        int n42 = nArray.length;
                        boolean bl11 = n16 < n42 && nArray[n16] == 1 + (i - n5);
                        if (!bl11) continue;
                        f5 = f7;
                        n19 = i + 1;
                        if (n27 < n22) {
                            n22 = n27;
                        }
                        if (n25 < n20) {
                            n20 = n25;
                        }
                        if (n26 > n21) {
                            n21 = n26;
                        }
                        if (n28 <= n23) continue;
                        n23 = n28;
                        continue;
                    }
                    if (n19 != n18) {
                        n40 = n19;
                        n39 = n20;
                        n38 = n21;
                        n37 = n22;
                        n36 = n23;
                        f8 = f5;
                        bl9 = i + 1 < n34;
                    } else if (n24 != n18) {
                        n40 = n24;
                        n39 = n25;
                        n38 = n26;
                        n37 = n27;
                        n36 = n28;
                        f8 = f6;
                        bl9 = i + 1 < n34;
                    } else {
                        for (n40 = n18 + 1; n40 < n34 && fArray[n40 - n5] == 0.0f; ++n40) {
                        }
                        n39 = n31;
                        n38 = n30;
                        n37 = n33;
                        n36 = n32;
                        f8 = fArray[n18 - n5];
                        bl9 = n40 < n34;
                    }
                    n4 = this.out(charSequence, n18, n40, n39, n38, n37, n36, n4, f, f2, lineHeightSpanArray, nArray2, fontMetricsInt, bl6, bl3, byArray, n15, bl5, n2, bl, bl2, cArray, fArray, n5, truncateAt, f3, f8, textPaint, bl9);
                    n18 = n40;
                    i = n18 - 1;
                    n24 = n18;
                    n19 = n18;
                    f4 = 0.0f;
                    f7 = 0.0f;
                    n28 = 0;
                    n27 = 0;
                    n26 = 0;
                    n25 = 0;
                    n23 = 0;
                    n22 = 0;
                    n21 = 0;
                    n20 = 0;
                    if (--n8 <= 0) {
                        n17 = n10;
                    }
                    if (n18 < n29) {
                        measuredText.setPos(n18);
                        n34 = n18;
                        break;
                    }
                    int n43 = this.mLineCount;
                    int n44 = this.mMaximumVisibleLineCount;
                    n25 = 0;
                    n26 = 0;
                    n27 = 0;
                    n28 = 0;
                    f4 = 0.0f;
                    f7 = 0.0f;
                    n20 = 0;
                    n23 = 0;
                    n21 = 0;
                    n22 = 0;
                    if (n43 >= n44) return;
                }
                n29 = n34;
            }
        }
        if (n2 != n && charSequence.charAt(n2 - 1) != '\n' || this.mLineCount >= this.mMaximumVisibleLineCount) {
            return;
        }
        measuredText.setPara(charSequence, n, n2, textDirectionHeuristic);
        textPaint.getFontMetricsInt(fontMetricsInt);
        int n45 = fontMetricsInt.ascent;
        int n46 = fontMetricsInt.descent;
        int n47 = fontMetricsInt.top;
        int n48 = fontMetricsInt.bottom;
        byte[] byArray = measuredText.mLevels;
        int n49 = measuredText.mDir;
        boolean bl12 = measuredText.mEasy;
        this.out(charSequence, n2, n2, n45, n46, n47, n48, n4, f, f2, null, null, fontMetricsInt, false, bl3, byArray, n49, bl12, n2, bl, bl2, null, null, n, truncateAt, f3, 0.0f, textPaint, false);
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getEllipsisCount(int n) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[4 + n * this.mColumns];
    }

    @Override
    public int getEllipsisStart(int n) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[3 + n * this.mColumns];
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public boolean getLineContainsTab(int n) {
        return (0x20000000 & this.mLines[0 + n * this.mColumns]) != 0;
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    @Override
    public int getLineDescent(int n) {
        int n2 = this.mLines[2 + n * this.mColumns];
        if (this.mMaximumVisibleLineCount > 0 && n >= -1 + this.mMaximumVisibleLineCount && n != this.mLineCount) {
            n2 += this.getBottomPadding();
        }
        return n2;
    }

    @Override
    public final Layout.Directions getLineDirections(int n) {
        return this.mLineDirections[n];
    }

    @Override
    public int getLineForVertical(int n) {
        int n2 = this.mLineCount;
        int n3 = -1;
        int[] nArray = this.mLines;
        while (n2 - n3 > 1) {
            int n4 = n2 + n3 >> 1;
            if (nArray[1 + n4 * this.mColumns] > n) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    @Override
    public int getLineStart(int n) {
        return 0x1FFFFFFF & this.mLines[0 + n * this.mColumns];
    }

    @Override
    public int getLineTop(int n) {
        int n2 = this.mLines[1 + n * this.mColumns];
        if (this.mMaximumVisibleLineCount > 0 && n >= this.mMaximumVisibleLineCount && n != this.mLineCount) {
            n2 += this.getBottomPadding();
        }
        return n2;
    }

    @Override
    public int getParagraphDirection(int n) {
        return this.mLines[0 + n * this.mColumns] >> 30;
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    void prepare() {
        this.mMeasured = MeasuredText.obtain();
    }
}

