/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import java.io.IOException;
import java.io.StringReader;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class HtmlToSpannedConverter
implements ContentHandler {
    private static final float[] HEADER_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    private Html.ImageGetter mImageGetter;
    private XMLReader mReader;
    private String mSource;
    private SpannableStringBuilder mSpannableStringBuilder;
    private Html.TagHandler mTagHandler;

    public HtmlToSpannedConverter(String string2, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser) {
        this.mSource = string2;
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mReader = parser;
    }

    private static void end(SpannableStringBuilder spannableStringBuilder, Class clazz, Object object) {
        int n = spannableStringBuilder.length();
        Object object2 = HtmlToSpannedConverter.getLast(spannableStringBuilder, clazz);
        int n2 = spannableStringBuilder.getSpanStart(object2);
        spannableStringBuilder.removeSpan(object2);
        if (n2 != n) {
            spannableStringBuilder.setSpan(object, n2, n, 33);
        }
    }

    private static void endA(SpannableStringBuilder spannableStringBuilder) {
        int n = spannableStringBuilder.length();
        Object object = HtmlToSpannedConverter.getLast(spannableStringBuilder, Href.class);
        int n2 = spannableStringBuilder.getSpanStart(object);
        spannableStringBuilder.removeSpan(object);
        if (n2 != n) {
            Href href = (Href)object;
            if (href.mHref != null) {
                spannableStringBuilder.setSpan(new URLSpan(href.mHref), n2, n, 33);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void endFont(SpannableStringBuilder spannableStringBuilder) {
        int n = spannableStringBuilder.length();
        Object object = HtmlToSpannedConverter.getLast(spannableStringBuilder, Font.class);
        int n2 = spannableStringBuilder.getSpanStart(object);
        spannableStringBuilder.removeSpan(object);
        if (n2 != n) {
            Font font = (Font)object;
            if (!TextUtils.isEmpty(font.mColor)) {
                if (font.mColor.startsWith("@")) {
                    Resources resources = Resources.getSystem();
                    int n3 = resources.getIdentifier(font.mColor.substring(1), "color", "android");
                    if (n3 != 0) {
                        spannableStringBuilder.setSpan(new TextAppearanceSpan(null, 0, 0, resources.getColorStateList(n3), null), n2, n, 33);
                    }
                } else {
                    int n4 = Color.getHtmlColor(font.mColor);
                    if (n4 != -1) {
                        spannableStringBuilder.setSpan(new ForegroundColorSpan(0xFF000000 | n4), n2, n, 33);
                    }
                }
            }
            if (font.mFace != null) {
                spannableStringBuilder.setSpan(new TypefaceSpan(font.mFace), n2, n, 33);
            }
        }
    }

    private static void endHeader(SpannableStringBuilder spannableStringBuilder) {
        int n;
        Object object = HtmlToSpannedConverter.getLast(spannableStringBuilder, Header.class);
        int n2 = spannableStringBuilder.getSpanStart(object);
        spannableStringBuilder.removeSpan(object);
        for (n = spannableStringBuilder.length(); n > n2 && spannableStringBuilder.charAt(n - 1) == '\n'; --n) {
        }
        if (n2 != n) {
            Header header = (Header)object;
            spannableStringBuilder.setSpan(new RelativeSizeSpan(HEADER_SIZES[header.mLevel]), n2, n, 33);
            spannableStringBuilder.setSpan(new StyleSpan(1), n2, n, 33);
        }
    }

    private static Object getLast(Spanned spanned, Class clazz) {
        T[] TArray = spanned.getSpans(0, spanned.length(), clazz);
        if (TArray.length == 0) {
            return null;
        }
        return TArray[-1 + TArray.length];
    }

    private static void handleBr(SpannableStringBuilder spannableStringBuilder) {
        spannableStringBuilder.append("\n");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleEndTag(String string2) {
        if (string2.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.mSpannableStringBuilder);
            return;
        } else {
            if (string2.equalsIgnoreCase("p")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                return;
            }
            if (string2.equalsIgnoreCase("div")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                return;
            }
            if (string2.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
                return;
            }
            if (string2.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
                return;
            }
            if (string2.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
                return;
            }
            if (string2.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
                return;
            }
            if (string2.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
                return;
            }
            if (string2.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
                return;
            }
            if (string2.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Big.class, new RelativeSizeSpan(1.25f));
                return;
            }
            if (string2.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Small.class, new RelativeSizeSpan(0.8f));
                return;
            }
            if (string2.equalsIgnoreCase("font")) {
                HtmlToSpannedConverter.endFont(this.mSpannableStringBuilder);
                return;
            }
            if (string2.equalsIgnoreCase("blockquote")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Blockquote.class, new QuoteSpan());
                return;
            }
            if (string2.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Monospace.class, new TypefaceSpan("monospace"));
                return;
            }
            if (string2.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.endA(this.mSpannableStringBuilder);
                return;
            }
            if (string2.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Underline.class, new UnderlineSpan());
                return;
            }
            if (string2.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Super.class, new SuperscriptSpan());
                return;
            }
            if (string2.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Sub.class, new SubscriptSpan());
                return;
            }
            if (string2.length() == 2 && Character.toLowerCase(string2.charAt(0)) == 'h' && string2.charAt(1) >= '1' && string2.charAt(1) <= '6') {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                HtmlToSpannedConverter.endHeader(this.mSpannableStringBuilder);
                return;
            }
            if (this.mTagHandler == null) return;
            this.mTagHandler.handleTag(false, string2, this.mSpannableStringBuilder, this.mReader);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void handleP(SpannableStringBuilder spannableStringBuilder) {
        int n = spannableStringBuilder.length();
        if (n >= 1 && spannableStringBuilder.charAt(n - 1) == '\n') {
            if (n >= 2 && spannableStringBuilder.charAt(n - 2) == '\n') return;
            spannableStringBuilder.append("\n");
            return;
        }
        if (n == 0) {
            return;
        }
        spannableStringBuilder.append("\n\n");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleStartTag(String string2, Attributes attributes) {
        block23: {
            block22: {
                if (string2.equalsIgnoreCase("br")) break block22;
                if (string2.equalsIgnoreCase("p")) {
                    HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                    return;
                }
                if (string2.equalsIgnoreCase("div")) {
                    HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                    return;
                }
                if (string2.equalsIgnoreCase("strong")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold());
                    return;
                }
                if (string2.equalsIgnoreCase("b")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold());
                    return;
                }
                if (string2.equalsIgnoreCase("em")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
                    return;
                }
                if (string2.equalsIgnoreCase("cite")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
                    return;
                }
                if (string2.equalsIgnoreCase("dfn")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
                    return;
                }
                if (string2.equalsIgnoreCase("i")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
                    return;
                }
                if (string2.equalsIgnoreCase("big")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Big());
                    return;
                }
                if (string2.equalsIgnoreCase("small")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Small());
                    return;
                }
                if (string2.equalsIgnoreCase("font")) {
                    HtmlToSpannedConverter.startFont(this.mSpannableStringBuilder, attributes);
                    return;
                }
                if (string2.equalsIgnoreCase("blockquote")) {
                    HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Blockquote());
                    return;
                }
                if (string2.equalsIgnoreCase("tt")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Monospace());
                    return;
                }
                if (string2.equalsIgnoreCase("a")) {
                    HtmlToSpannedConverter.startA(this.mSpannableStringBuilder, attributes);
                    return;
                }
                if (string2.equalsIgnoreCase("u")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Underline());
                    return;
                }
                if (string2.equalsIgnoreCase("sup")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Super());
                    return;
                }
                if (string2.equalsIgnoreCase("sub")) {
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Sub());
                    return;
                }
                if (string2.length() == 2 && Character.toLowerCase(string2.charAt(0)) == 'h' && string2.charAt(1) >= '1' && string2.charAt(1) <= '6') {
                    HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                    HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Header(-49 + string2.charAt(1)));
                    return;
                }
                if (string2.equalsIgnoreCase("img")) {
                    HtmlToSpannedConverter.startImg(this.mSpannableStringBuilder, attributes, this.mImageGetter);
                    return;
                }
                if (this.mTagHandler != null) break block23;
            }
            return;
        }
        this.mTagHandler.handleTag(true, string2, this.mSpannableStringBuilder, this.mReader);
    }

    private static void start(SpannableStringBuilder spannableStringBuilder, Object object) {
        int n = spannableStringBuilder.length();
        spannableStringBuilder.setSpan(object, n, n, 17);
    }

    private static void startA(SpannableStringBuilder spannableStringBuilder, Attributes attributes) {
        String string2 = attributes.getValue("", "href");
        int n = spannableStringBuilder.length();
        spannableStringBuilder.setSpan(new Href(string2), n, n, 17);
    }

    private static void startFont(SpannableStringBuilder spannableStringBuilder, Attributes attributes) {
        String string2 = attributes.getValue("", "color");
        String string3 = attributes.getValue("", "face");
        int n = spannableStringBuilder.length();
        spannableStringBuilder.setSpan(new Font(string2, string3), n, n, 17);
    }

    private static void startImg(SpannableStringBuilder spannableStringBuilder, Attributes attributes, Html.ImageGetter imageGetter) {
        String string2 = attributes.getValue("", "src");
        Drawable drawable2 = null;
        if (imageGetter != null) {
            drawable2 = imageGetter.getDrawable(string2);
        }
        if (drawable2 == null) {
            drawable2 = Resources.getSystem().getDrawable(17303598);
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        }
        int n = spannableStringBuilder.length();
        spannableStringBuilder.append("\ufffc");
        spannableStringBuilder.setSpan(new ImageSpan(drawable2, string2), n, spannableStringBuilder.length(), 33);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.mSpannableStringBuilder.append(stringBuilder);
                return;
            }
            char c = cArray[n3 + n];
            if (c == ' ' || c == '\n') {
                int n4;
                int n5 = stringBuilder.length();
                int n6 = n5 == 0 ? ((n4 = this.mSpannableStringBuilder.length()) == 0 ? 10 : (int)this.mSpannableStringBuilder.charAt(n4 - 1)) : stringBuilder.charAt(n5 - 1);
                if (n6 != 32 && n6 != 10) {
                    stringBuilder.append(' ');
                }
            } else {
                stringBuilder.append(c);
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Spanned convert() {
        int n;
        ParagraphStyle[] paragraphStyleArray;
        this.mReader.setContentHandler(this);
        try {
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
            paragraphStyleArray = this.mSpannableStringBuilder.getSpans(0, this.mSpannableStringBuilder.length(), ParagraphStyle.class);
            n = 0;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        while (n < paragraphStyleArray.length) {
            int n2 = this.mSpannableStringBuilder.getSpanStart(paragraphStyleArray[n]);
            int n3 = this.mSpannableStringBuilder.getSpanEnd(paragraphStyleArray[n]);
            if (n3 - 2 >= 0 && this.mSpannableStringBuilder.charAt(n3 - 1) == '\n' && this.mSpannableStringBuilder.charAt(n3 - 2) == '\n') {
                --n3;
            }
            if (n3 == n2) {
                this.mSpannableStringBuilder.removeSpan(paragraphStyleArray[n]);
            } else {
                this.mSpannableStringBuilder.setSpan(paragraphStyleArray[n], n2, n3, 51);
            }
            ++n;
        }
        return this.mSpannableStringBuilder;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        this.handleEndTag(string3);
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        this.handleStartTag(string3, attributes);
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
    }

    private static class Big {
        private Big() {
        }
    }

    private static class Blockquote {
        private Blockquote() {
        }
    }

    private static class Bold {
        private Bold() {
        }
    }

    private static class Font {
        public String mColor;
        public String mFace;

        public Font(String string2, String string3) {
            this.mColor = string2;
            this.mFace = string3;
        }
    }

    private static class Header {
        private int mLevel;

        public Header(int n) {
            this.mLevel = n;
        }
    }

    private static class Href {
        public String mHref;

        public Href(String string2) {
            this.mHref = string2;
        }
    }

    private static class Italic {
        private Italic() {
        }
    }

    private static class Monospace {
        private Monospace() {
        }
    }

    private static class Small {
        private Small() {
        }
    }

    private static class Sub {
        private Sub() {
        }
    }

    private static class Super {
        private Super() {
        }
    }

    private static class Underline {
        private Underline() {
        }
    }
}

