/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.BaseColumns;
import android.telephony.Rlog;
import android.telephony.SubInfoRecord;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.ISub;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionManager
implements BaseColumns {
    public static final long ASK_USER_SUB_ID = -1001L;
    public static final String COLOR = "color";
    public static final int COLOR_1 = 0;
    public static final int COLOR_2 = 1;
    public static final int COLOR_3 = 2;
    public static final int COLOR_4 = 3;
    public static final int COLOR_DEFAULT = 0;
    public static final Uri CONTENT_URI = Uri.parse("content://telephony/siminfo");
    public static final String DATA_ROAMING = "data_roaming";
    public static final int DATA_ROAMING_DEFAULT = 0;
    public static final int DATA_ROAMING_DISABLE = 0;
    public static final int DATA_ROAMING_ENABLE = 1;
    private static final boolean DBG = true;
    public static final int DEFAULT_INT_VALUE = -100;
    public static final int DEFAULT_NAME_RES = 17039374;
    public static final int DEFAULT_PHONE_ID = Integer.MAX_VALUE;
    public static final int DEFAULT_SLOT_ID = Integer.MAX_VALUE;
    public static final String DEFAULT_STRING_VALUE = "N/A";
    public static final long DEFAULT_SUB_ID = Long.MAX_VALUE;
    public static final int DISLPAY_NUMBER_DEFAULT = 1;
    public static final String DISPLAY_NAME = "display_name";
    public static final int DISPLAY_NUMBER_FIRST = 1;
    public static final String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static final int DISPLAY_NUMBER_LAST = 2;
    public static final int DISPLAY_NUMBER_NONE = 0;
    public static final int EXTRA_VALUE_NEW_SIM = 1;
    public static final int EXTRA_VALUE_NOCHANGE = 4;
    public static final int EXTRA_VALUE_REMOVE_SIM = 2;
    public static final int EXTRA_VALUE_REPOSITION_SIM = 3;
    public static final String ICC_ID = "icc_id";
    public static final String INTENT_KEY_DETECT_STATUS = "simDetectStatus";
    public static final String INTENT_KEY_NEW_SIM_SLOT = "newSIMSlot";
    public static final String INTENT_KEY_NEW_SIM_STATUS = "newSIMStatus";
    public static final String INTENT_KEY_SIM_COUNT = "simCount";
    public static final int INVALID_PHONE_ID = -1000;
    public static final int INVALID_SLOT_ID = -1000;
    public static final long INVALID_SUB_ID = -1000L;
    private static final String LOG_TAG = "SUB";
    public static final String MCC = "mcc";
    public static final String MNC = "mnc";
    public static final String NAME_SOURCE = "name_source";
    public static final int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static final int NAME_SOURCE_SIM_SOURCE = 1;
    public static final int NAME_SOURCE_UNDEFINDED = -1;
    public static final int NAME_SOURCE_USER_INPUT = 2;
    public static final String NUMBER = "number";
    private static final int RES_TYPE_BACKGROUND_DARK = 0;
    private static final int RES_TYPE_BACKGROUND_LIGHT = 1;
    public static final String SIM_ID = "sim_id";
    public static final int SIM_NOT_INSERTED = -1;
    public static final String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";
    private static final boolean VDBG;
    private static final int[] sSimBackgroundDarkRes;

    static {
        sSimBackgroundDarkRes = SubscriptionManager.setSimResource(0);
    }

    public SubscriptionManager() {
        SubscriptionManager.logd("SubscriptionManager created");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Uri addSubInfoRecord(String string2, int n) {
        block6: {
            ISub iSub;
            if (string2 == null) {
                SubscriptionManager.logd("[addSubInfoRecord]- null iccId");
            }
            if (!SubscriptionManager.isValidSlotId(n)) {
                SubscriptionManager.logd("[addSubInfoRecord]- invalid slotId");
            }
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub == null) break block6;
            }
            catch (RemoteException remoteException) {
                return null;
            }
            iSub.addSubInfoRecord(string2, n);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean allDefaultsSelected() {
        return SubscriptionManager.getDefaultDataSubId() != -1000L && SubscriptionManager.getDefaultSmsSubId() != -1000L && SubscriptionManager.getDefaultVoiceSubId() != -1000L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearDefaultsForInactiveSubIds() {
        ISub iSub;
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        iSub.clearDefaultsForInactiveSubIds();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearSubInfo() {
        ISub iSub;
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        iSub.clearSubInfo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearSubInfoBySlotId(int n) {
        ISub iSub;
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        iSub.clearSubInfoBySlotId(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long[] getActiveSubIdList() {
        long[] lArray;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            lArray = null;
            if (iSub != null) {
                long[] lArray2 = iSub.getActiveSubIdList();
                lArray = lArray2;
            }
        }
        catch (RemoteException remoteException) {
            lArray = null;
        }
        if (lArray != null) return lArray;
        return new long[0];
    }

    public static int getActiveSubInfoCount() {
        int n;
        block3: {
            int n2;
            ISub iSub;
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                n = 0;
                if (iSub == null) break block3;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
            n = n2 = iSub.getActiveSubInfoCount();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SubInfoRecord> getActiveSubInfoList() {
        void var1_5;
        void var1_3;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            Object var1_1 = null;
            if (iSub != null) {
                List<SubInfoRecord> list;
                List<SubInfoRecord> list2 = list = iSub.getActiveSubInfoList();
            }
        }
        catch (RemoteException remoteException) {
            Object var1_6 = null;
        }
        if (var1_3 == null) {
            ArrayList arrayList = new ArrayList();
        }
        return var1_5;
    }

    public static int getAllSubInfoCount() {
        int n;
        block3: {
            int n2;
            ISub iSub;
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                n = 0;
                if (iSub == null) break block3;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
            n = n2 = iSub.getAllSubInfoCount();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SubInfoRecord> getAllSubInfoList() {
        void var1_5;
        void var1_3;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            Object var1_1 = null;
            if (iSub != null) {
                List<SubInfoRecord> list;
                List<SubInfoRecord> list2 = list = iSub.getAllSubInfoList();
            }
        }
        catch (RemoteException remoteException) {
            Object var1_6 = null;
        }
        if (var1_3 == null) {
            ArrayList arrayList = new ArrayList();
        }
        return var1_5;
    }

    public static int getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubId());
    }

    public static long getDefaultDataSubId() {
        long l;
        block3: {
            long l2;
            ISub iSub;
            l = -1000L;
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub == null) break block3;
            }
            catch (RemoteException remoteException) {
                return l;
            }
            l = l2 = iSub.getDefaultDataSubId();
        }
        return l;
    }

    public static SubInfoRecord getDefaultDataSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultDataSubId());
    }

    public static int getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubId());
    }

    public static long getDefaultSmsSubId() {
        long l;
        block3: {
            long l2;
            ISub iSub;
            l = -1000L;
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub == null) break block3;
            }
            catch (RemoteException remoteException) {
                return l;
            }
            l = l2 = iSub.getDefaultSmsSubId();
        }
        return l;
    }

    public static SubInfoRecord getDefaultSmsSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultSmsSubId());
    }

    public static long getDefaultSubId() {
        long l;
        block3: {
            long l2;
            ISub iSub;
            l = -1000L;
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub == null) break block3;
            }
            catch (RemoteException remoteException) {
                return l;
            }
            l = l2 = iSub.getDefaultSubId();
        }
        return l;
    }

    public static int getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubId());
    }

    public static long getDefaultVoiceSubId() {
        long l;
        block3: {
            long l2;
            ISub iSub;
            l = -1000L;
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub == null) break block3;
            }
            catch (RemoteException remoteException) {
                return l;
            }
            l = l2 = iSub.getDefaultVoiceSubId();
        }
        return l;
    }

    public static SubInfoRecord getDefaultVoiceSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultVoiceSubId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPhoneId(long l) {
        ISub iSub;
        if (!SubscriptionManager.isValidSubId(l)) {
            SubscriptionManager.logd("[getPhoneId]- fail");
            return -1000;
        }
        int n = -1000;
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return n;
        }
        catch (RemoteException remoteException) {
            return n;
        }
        return iSub.getPhoneId(l);
    }

    public static int getSlotId(long l) {
        int n;
        block4: {
            int n2;
            ISub iSub;
            if (!SubscriptionManager.isValidSubId(l)) {
                SubscriptionManager.logd("[getSlotId]- fail");
            }
            n = -1000;
            try {
                iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
                if (iSub == null) break block4;
            }
            catch (RemoteException remoteException) {
                return n;
            }
            n = n2 = iSub.getSlotId(l);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long[] getSubId(int n) {
        ISub iSub;
        if (!SubscriptionManager.isValidSlotId(n)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        return iSub.getSubId(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubInfoRecord getSubInfoForSubscriber(long l) {
        ISub iSub;
        if (!SubscriptionManager.isValidSubId(l)) {
            SubscriptionManager.logd("[getSubInfoForSubscriberx]- invalid subId");
            return null;
        }
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        return iSub.getSubInfoForSubscriber(l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SubInfoRecord> getSubInfoUsingIccId(String string2) {
        List<SubInfoRecord> list;
        if (string2 == null) {
            SubscriptionManager.logd("[getSubInfoUsingIccId]- null iccid");
            return null;
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            list = null;
            if (iSub != null) {
                List<SubInfoRecord> list2;
                list = list2 = iSub.getSubInfoUsingIccId(string2);
            }
        }
        catch (RemoteException remoteException) {
            list = null;
        }
        if (list != null) return list;
        return new ArrayList<SubInfoRecord>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SubInfoRecord> getSubInfoUsingSlotId(int n) {
        List<SubInfoRecord> list;
        if (!SubscriptionManager.isValidSlotId(n)) {
            SubscriptionManager.logd("[getSubInfoUsingSlotId]- invalid slotId");
            return null;
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            list = null;
            if (iSub != null) {
                List<SubInfoRecord> list2;
                list = list2 = iSub.getSubInfoUsingSlotId(n);
            }
        }
        catch (RemoteException remoteException) {
            list = null;
        }
        if (list != null) return list;
        return new ArrayList<SubInfoRecord>();
    }

    public static boolean isValidPhoneId(int n) {
        return n != -1000 && n >= 0 && n < TelephonyManager.getDefault().getPhoneCount();
    }

    public static boolean isValidSlotId(int n) {
        return n != -1000 && n >= 0 && n < TelephonyManager.getDefault().getSimCount();
    }

    public static boolean isValidSubId(long l) {
        return l > -1000L;
    }

    public static boolean isVoicePromptEnabled() {
        SubscriptionManager.logd("[isVoicePromptEnabled] Need RIL TODO");
        return false;
    }

    private static void logd(String string2) {
        Rlog.d(LOG_TAG, "[SubManager] " + string2);
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n) {
        long[] lArray = SubscriptionManager.getSubId(n);
        if (lArray != null && lArray.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, n, lArray[0]);
            return;
        }
        SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n, long l) {
        intent.putExtra("subscription", l);
        intent.putExtra("phone", n);
        intent.putExtra("slot", n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int setColor(int n, long l) {
        ISub iSub;
        int n2 = sSimBackgroundDarkRes.length;
        if (!SubscriptionManager.isValidSubId(l) || n < 0 || n >= n2) {
            SubscriptionManager.logd("[setColor]- fail");
            return -1;
        }
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            int n3 = 0;
            if (iSub == null) return n3;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        return iSub.setColor(n, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int setDataRoaming(int n, long l) {
        ISub iSub;
        if (n < 0 || !SubscriptionManager.isValidSubId(l)) {
            SubscriptionManager.logd("[setDataRoaming]- fail");
            return -1;
        }
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            int n2 = 0;
            if (iSub == null) return n2;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        return iSub.setDataRoaming(n, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDefaultDataSubId(long l) {
        ISub iSub;
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        iSub.setDefaultDataSubId(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDefaultSmsSubId(long l) {
        ISub iSub;
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        iSub.setDefaultSmsSubId(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDefaultVoiceSubId(long l) {
        ISub iSub;
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub == null) return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        iSub.setDefaultVoiceSubId(l);
    }

    public static int setDisplayName(String string2, long l) {
        return SubscriptionManager.setDisplayName(string2, l, -1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int setDisplayName(String string2, long l, long l2) {
        ISub iSub;
        if (!SubscriptionManager.isValidSubId(l)) {
            SubscriptionManager.logd("[setDisplayName]- fail");
            return -1;
        }
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            int n = 0;
            if (iSub == null) return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        return iSub.setDisplayNameUsingSrc(string2, l, l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int setDisplayNumber(String string2, long l) {
        ISub iSub;
        if (string2 == null || !SubscriptionManager.isValidSubId(l)) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            int n = 0;
            if (iSub == null) return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        return iSub.setDisplayNumber(string2, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int setDisplayNumberFormat(int n, long l) {
        ISub iSub;
        if (n < 0 || !SubscriptionManager.isValidSubId(l)) {
            SubscriptionManager.logd("[setDisplayNumberFormat]- fail, return -1");
            return -1;
        }
        try {
            iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            int n2 = 0;
            if (iSub == null) return n2;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        return iSub.setDisplayNumberFormat(n, l);
    }

    private static int[] setSimResource(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return new int[]{17303272, 17303274, 17303273, 17303275};
            }
            case 1: 
        }
        return new int[]{17303276, 17303278, 17303277, 17303279};
    }

    public static void setVoicePromptEnabled(boolean bl) {
        SubscriptionManager.logd("[setVoicePromptEnabled] Need RIL TODO");
    }
}

