/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;

public class ServiceState
implements Parcelable {
    public static final Parcelable.Creator<ServiceState> CREATOR = new Parcelable.Creator<ServiceState>(){

        @Override
        public ServiceState createFromParcel(Parcel parcel) {
            return new ServiceState(parcel);
        }

        public ServiceState[] newArray(int n) {
            return new ServiceState[n];
        }
    };
    static final boolean DBG = true;
    static final String LOG_TAG = "PHONE";
    public static final int REGISTRATION_STATE_HOME_NETWORK = 1;
    public static final int REGISTRATION_STATE_NOT_REGISTERED_AND_NOT_SEARCHING = 0;
    public static final int REGISTRATION_STATE_NOT_REGISTERED_AND_SEARCHING = 2;
    public static final int REGISTRATION_STATE_REGISTRATION_DENIED = 3;
    public static final int REGISTRATION_STATE_ROAMING = 5;
    public static final int REGISTRATION_STATE_UNKNOWN = 4;
    public static final int RIL_RADIO_TECHNOLOGY_1xRTT = 6;
    public static final int RIL_RADIO_TECHNOLOGY_EDGE = 2;
    public static final int RIL_RADIO_TECHNOLOGY_EHRPD = 13;
    public static final int RIL_RADIO_TECHNOLOGY_EVDO_0 = 7;
    public static final int RIL_RADIO_TECHNOLOGY_EVDO_A = 8;
    public static final int RIL_RADIO_TECHNOLOGY_EVDO_B = 12;
    public static final int RIL_RADIO_TECHNOLOGY_GPRS = 1;
    public static final int RIL_RADIO_TECHNOLOGY_GSM = 16;
    public static final int RIL_RADIO_TECHNOLOGY_HSDPA = 9;
    public static final int RIL_RADIO_TECHNOLOGY_HSPA = 11;
    public static final int RIL_RADIO_TECHNOLOGY_HSPAP = 15;
    public static final int RIL_RADIO_TECHNOLOGY_HSUPA = 10;
    public static final int RIL_RADIO_TECHNOLOGY_IS95A = 4;
    public static final int RIL_RADIO_TECHNOLOGY_IS95B = 5;
    public static final int RIL_RADIO_TECHNOLOGY_LTE = 14;
    public static final int RIL_RADIO_TECHNOLOGY_TD_SCDMA = 17;
    public static final int RIL_RADIO_TECHNOLOGY_UMTS = 3;
    public static final int RIL_RADIO_TECHNOLOGY_UNKNOWN = 0;
    public static final int RIL_REG_STATE_DENIED = 3;
    public static final int RIL_REG_STATE_DENIED_EMERGENCY_CALL_ENABLED = 13;
    public static final int RIL_REG_STATE_HOME = 1;
    public static final int RIL_REG_STATE_NOT_REG = 0;
    public static final int RIL_REG_STATE_NOT_REG_EMERGENCY_CALL_ENABLED = 10;
    public static final int RIL_REG_STATE_ROAMING = 5;
    public static final int RIL_REG_STATE_SEARCHING = 2;
    public static final int RIL_REG_STATE_SEARCHING_EMERGENCY_CALL_ENABLED = 12;
    public static final int RIL_REG_STATE_UNKNOWN = 4;
    public static final int RIL_REG_STATE_UNKNOWN_EMERGENCY_CALL_ENABLED = 14;
    public static final int STATE_EMERGENCY_ONLY = 2;
    public static final int STATE_IN_SERVICE = 0;
    public static final int STATE_OUT_OF_SERVICE = 1;
    public static final int STATE_POWER_OFF = 3;
    private int mCdmaDefaultRoamingIndicator;
    private int mCdmaEriIconIndex;
    private int mCdmaEriIconMode;
    private int mCdmaRoamingIndicator;
    private boolean mCssIndicator;
    private int mDataRegState;
    private boolean mIsEmergencyOnly;
    private boolean mIsManualNetworkSelection;
    private int mNetworkId;
    private String mOperatorAlphaLong;
    private String mOperatorAlphaShort;
    private String mOperatorNumeric;
    private int mRilDataRadioTechnology;
    private int mRilVoiceRadioTechnology;
    private boolean mRoaming;
    private int mSystemId;
    private int mVoiceRegState;

    public ServiceState() {
        this.mVoiceRegState = 1;
        this.mDataRegState = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ServiceState(Parcel parcel) {
        int n = 1;
        this.mVoiceRegState = n;
        this.mDataRegState = n;
        this.mVoiceRegState = parcel.readInt();
        this.mDataRegState = parcel.readInt();
        int n2 = parcel.readInt() != 0 ? n : 0;
        this.mRoaming = n2;
        this.mOperatorAlphaLong = parcel.readString();
        this.mOperatorAlphaShort = parcel.readString();
        this.mOperatorNumeric = parcel.readString();
        int n3 = parcel.readInt() != 0 ? n : 0;
        this.mIsManualNetworkSelection = n3;
        this.mRilVoiceRadioTechnology = parcel.readInt();
        this.mRilDataRadioTechnology = parcel.readInt();
        int n4 = parcel.readInt() != 0 ? n : 0;
        this.mCssIndicator = n4;
        this.mNetworkId = parcel.readInt();
        this.mSystemId = parcel.readInt();
        this.mCdmaRoamingIndicator = parcel.readInt();
        this.mCdmaDefaultRoamingIndicator = parcel.readInt();
        this.mCdmaEriIconIndex = parcel.readInt();
        this.mCdmaEriIconMode = parcel.readInt();
        if (parcel.readInt() == 0) {
            n = 0;
        }
        this.mIsEmergencyOnly = n;
    }

    public ServiceState(ServiceState serviceState) {
        this.mVoiceRegState = 1;
        this.mDataRegState = 1;
        this.copyFrom(serviceState);
    }

    private static boolean equalsHandlesNulls(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static boolean isCdma(int n) {
        return n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 12 || n == 13;
    }

    public static boolean isGsm(int n) {
        return n == 1 || n == 2 || n == 3 || n == 9 || n == 10 || n == 11 || n == 14 || n == 15 || n == 16 || n == 17;
    }

    public static ServiceState newFromBundle(Bundle bundle) {
        ServiceState serviceState = new ServiceState();
        serviceState.setFromNotifierBundle(bundle);
        return serviceState;
    }

    private int rilRadioTechnologyToNetworkType(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 13;
            }
            case 15: {
                return 15;
            }
            case 16: 
        }
        return 16;
    }

    public static String rilRadioTechnologyToString(int n) {
        switch (n) {
            default: {
                Rlog.w(LOG_TAG, "Unexpected radioTechnology=" + n);
                return "Unexpected";
            }
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 4: {
                return "CDMA-IS95A";
            }
            case 5: {
                return "CDMA-IS95B";
            }
            case 6: {
                return "1xRTT";
            }
            case 7: {
                return "EvDo-rev.0";
            }
            case 8: {
                return "EvDo-rev.A";
            }
            case 9: {
                return "HSDPA";
            }
            case 10: {
                return "HSUPA";
            }
            case 11: {
                return "HSPA";
            }
            case 12: {
                return "EvDo-rev.B";
            }
            case 13: {
                return "eHRPD";
            }
            case 14: {
                return "LTE";
            }
            case 15: {
                return "HSPAP";
            }
            case 16: 
        }
        return "GSM";
    }

    private void setFromNotifierBundle(Bundle bundle) {
        this.mVoiceRegState = bundle.getInt("voiceRegState");
        this.mDataRegState = bundle.getInt("dataRegState");
        this.mRoaming = bundle.getBoolean("roaming");
        this.mOperatorAlphaLong = bundle.getString("operator-alpha-long");
        this.mOperatorAlphaShort = bundle.getString("operator-alpha-short");
        this.mOperatorNumeric = bundle.getString("operator-numeric");
        this.mIsManualNetworkSelection = bundle.getBoolean("manual");
        this.mRilVoiceRadioTechnology = bundle.getInt("radioTechnology");
        this.mRilDataRadioTechnology = bundle.getInt("dataRadioTechnology");
        this.mCssIndicator = bundle.getBoolean("cssIndicator");
        this.mNetworkId = bundle.getInt("networkId");
        this.mSystemId = bundle.getInt("systemId");
        this.mCdmaRoamingIndicator = bundle.getInt("cdmaRoamingIndicator");
        this.mCdmaDefaultRoamingIndicator = bundle.getInt("cdmaDefaultRoamingIndicator");
        this.mIsEmergencyOnly = bundle.getBoolean("emergencyOnly");
    }

    private void setNullState(int n) {
        Rlog.d(LOG_TAG, "[ServiceState] setNullState=" + n);
        this.mVoiceRegState = n;
        this.mDataRegState = n;
        this.mRoaming = false;
        this.mOperatorAlphaLong = null;
        this.mOperatorAlphaShort = null;
        this.mOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
        this.mRilVoiceRadioTechnology = 0;
        this.mRilDataRadioTechnology = 0;
        this.mCssIndicator = false;
        this.mNetworkId = -1;
        this.mSystemId = -1;
        this.mCdmaRoamingIndicator = -1;
        this.mCdmaDefaultRoamingIndicator = -1;
        this.mCdmaEriIconIndex = -1;
        this.mCdmaEriIconMode = -1;
        this.mIsEmergencyOnly = false;
    }

    protected void copyFrom(ServiceState serviceState) {
        this.mVoiceRegState = serviceState.mVoiceRegState;
        this.mDataRegState = serviceState.mDataRegState;
        this.mRoaming = serviceState.mRoaming;
        this.mOperatorAlphaLong = serviceState.mOperatorAlphaLong;
        this.mOperatorAlphaShort = serviceState.mOperatorAlphaShort;
        this.mOperatorNumeric = serviceState.mOperatorNumeric;
        this.mIsManualNetworkSelection = serviceState.mIsManualNetworkSelection;
        this.mRilVoiceRadioTechnology = serviceState.mRilVoiceRadioTechnology;
        this.mRilDataRadioTechnology = serviceState.mRilDataRadioTechnology;
        this.mCssIndicator = serviceState.mCssIndicator;
        this.mNetworkId = serviceState.mNetworkId;
        this.mSystemId = serviceState.mSystemId;
        this.mCdmaRoamingIndicator = serviceState.mCdmaRoamingIndicator;
        this.mCdmaDefaultRoamingIndicator = serviceState.mCdmaDefaultRoamingIndicator;
        this.mCdmaEriIconIndex = serviceState.mCdmaEriIconIndex;
        this.mCdmaEriIconMode = serviceState.mCdmaEriIconMode;
        this.mIsEmergencyOnly = serviceState.mIsEmergencyOnly;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        ServiceState serviceState;
        block3: {
            try {
                serviceState = (ServiceState)object;
                if (object != null) break block3;
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        if (this.mVoiceRegState == serviceState.mVoiceRegState && this.mDataRegState == serviceState.mDataRegState && this.mRoaming == serviceState.mRoaming && this.mIsManualNetworkSelection == serviceState.mIsManualNetworkSelection && ServiceState.equalsHandlesNulls(this.mOperatorAlphaLong, serviceState.mOperatorAlphaLong) && ServiceState.equalsHandlesNulls(this.mOperatorAlphaShort, serviceState.mOperatorAlphaShort) && ServiceState.equalsHandlesNulls(this.mOperatorNumeric, serviceState.mOperatorNumeric) && ServiceState.equalsHandlesNulls(this.mRilVoiceRadioTechnology, serviceState.mRilVoiceRadioTechnology) && ServiceState.equalsHandlesNulls(this.mRilDataRadioTechnology, serviceState.mRilDataRadioTechnology) && ServiceState.equalsHandlesNulls(this.mCssIndicator, serviceState.mCssIndicator) && ServiceState.equalsHandlesNulls(this.mNetworkId, serviceState.mNetworkId) && ServiceState.equalsHandlesNulls(this.mSystemId, serviceState.mSystemId) && ServiceState.equalsHandlesNulls(this.mCdmaRoamingIndicator, serviceState.mCdmaRoamingIndicator) && ServiceState.equalsHandlesNulls(this.mCdmaDefaultRoamingIndicator, serviceState.mCdmaDefaultRoamingIndicator) && this.mIsEmergencyOnly == serviceState.mIsEmergencyOnly) return true;
        return false;
    }

    public void fillInNotifierBundle(Bundle bundle) {
        bundle.putInt("voiceRegState", this.mVoiceRegState);
        bundle.putInt("dataRegState", this.mDataRegState);
        bundle.putBoolean("roaming", this.mRoaming);
        bundle.putString("operator-alpha-long", this.mOperatorAlphaLong);
        bundle.putString("operator-alpha-short", this.mOperatorAlphaShort);
        bundle.putString("operator-numeric", this.mOperatorNumeric);
        bundle.putBoolean("manual", this.mIsManualNetworkSelection);
        bundle.putInt("radioTechnology", this.mRilVoiceRadioTechnology);
        bundle.putInt("dataRadioTechnology", this.mRilDataRadioTechnology);
        bundle.putBoolean("cssIndicator", this.mCssIndicator);
        bundle.putInt("networkId", this.mNetworkId);
        bundle.putInt("systemId", this.mSystemId);
        bundle.putInt("cdmaRoamingIndicator", this.mCdmaRoamingIndicator);
        bundle.putInt("cdmaDefaultRoamingIndicator", this.mCdmaDefaultRoamingIndicator);
        bundle.putBoolean("emergencyOnly", this.mIsEmergencyOnly);
    }

    public int getCdmaDefaultRoamingIndicator() {
        return this.mCdmaDefaultRoamingIndicator;
    }

    public int getCdmaEriIconIndex() {
        return this.mCdmaEriIconIndex;
    }

    public int getCdmaEriIconMode() {
        return this.mCdmaEriIconMode;
    }

    public int getCdmaRoamingIndicator() {
        return this.mCdmaRoamingIndicator;
    }

    public int getCssIndicator() {
        if (this.mCssIndicator) {
            return 1;
        }
        return 0;
    }

    public int getDataNetworkType() {
        return this.rilRadioTechnologyToNetworkType(this.mRilDataRadioTechnology);
    }

    public int getDataRegState() {
        return this.mDataRegState;
    }

    public boolean getIsManualSelection() {
        return this.mIsManualNetworkSelection;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public int getNetworkType() {
        Rlog.e(LOG_TAG, "ServiceState.getNetworkType() DEPRECATED will be removed *******");
        return this.rilRadioTechnologyToNetworkType(this.mRilVoiceRadioTechnology);
    }

    public String getOperatorAlphaLong() {
        return this.mOperatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.mOperatorAlphaShort;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public int getRadioTechnology() {
        Rlog.e(LOG_TAG, "ServiceState.getRadioTechnology() DEPRECATED will be removed *******");
        return this.getRilDataRadioTechnology();
    }

    public int getRilDataRadioTechnology() {
        return this.mRilDataRadioTechnology;
    }

    public int getRilVoiceRadioTechnology() {
        return this.mRilVoiceRadioTechnology;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public int getState() {
        return this.getVoiceRegState();
    }

    public int getSystemId() {
        return this.mSystemId;
    }

    public int getVoiceNetworkType() {
        return this.rilRadioTechnologyToNetworkType(this.mRilVoiceRadioTechnology);
    }

    public int getVoiceRegState() {
        return this.mVoiceRegState;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = 1;
        int n2 = 31 * this.mVoiceRegState + 37 * this.mDataRegState;
        int n3 = this.mRoaming ? n : 0;
        int n4 = n2 + n3;
        int n5 = this.mIsManualNetworkSelection ? n : 0;
        int n6 = n4 + n5;
        int n7 = this.mOperatorAlphaLong == null ? 0 : this.mOperatorAlphaLong.hashCode();
        int n8 = n6 + n7;
        int n9 = this.mOperatorAlphaShort == null ? 0 : this.mOperatorAlphaShort.hashCode();
        int n10 = n8 + n9;
        int n11 = this.mOperatorNumeric == null ? 0 : this.mOperatorNumeric.hashCode();
        int n12 = n11 + n10 + this.mCdmaRoamingIndicator + this.mCdmaDefaultRoamingIndicator;
        if (this.mIsEmergencyOnly) {
            return n12 + n;
        }
        n = 0;
        return n12 + n;
    }

    public boolean isEmergencyOnly() {
        return this.mIsEmergencyOnly;
    }

    public void setCdmaDefaultRoamingIndicator(int n) {
        this.mCdmaDefaultRoamingIndicator = n;
    }

    public void setCdmaEriIconIndex(int n) {
        this.mCdmaEriIconIndex = n;
    }

    public void setCdmaEriIconMode(int n) {
        this.mCdmaEriIconMode = n;
    }

    public void setCdmaRoamingIndicator(int n) {
        this.mCdmaRoamingIndicator = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCssIndicator(int n) {
        boolean bl = n != 0;
        this.mCssIndicator = bl;
    }

    public void setDataRegState(int n) {
        this.mDataRegState = n;
        Rlog.d(LOG_TAG, "[ServiceState] setDataRegState=" + this.mDataRegState);
    }

    public void setEmergencyOnly(boolean bl) {
        this.mIsEmergencyOnly = bl;
    }

    public void setIsManualSelection(boolean bl) {
        this.mIsManualNetworkSelection = bl;
    }

    public void setOperatorAlphaLong(String string2) {
        this.mOperatorAlphaLong = string2;
    }

    public void setOperatorName(String string2, String string3, String string4) {
        this.mOperatorAlphaLong = string2;
        this.mOperatorAlphaShort = string3;
        this.mOperatorNumeric = string4;
    }

    public void setRilDataRadioTechnology(int n) {
        this.mRilDataRadioTechnology = n;
        Rlog.d(LOG_TAG, "[ServiceState] setDataRadioTechnology=" + this.mRilDataRadioTechnology);
    }

    public void setRilVoiceRadioTechnology(int n) {
        this.mRilVoiceRadioTechnology = n;
    }

    public void setRoaming(boolean bl) {
        this.mRoaming = bl;
    }

    public void setState(int n) {
        this.setVoiceRegState(n);
        Rlog.e(LOG_TAG, "[ServiceState] setState deprecated use setVoiceRegState()");
    }

    public void setStateOff() {
        this.setNullState(3);
    }

    public void setStateOutOfService() {
        this.setNullState(1);
    }

    public void setSystemAndNetworkId(int n, int n2) {
        this.mSystemId = n;
        this.mNetworkId = n2;
    }

    public void setVoiceRegState(int n) {
        this.mVoiceRegState = n;
        Rlog.d(LOG_TAG, "[ServiceState] setVoiceRegState=" + this.mVoiceRegState);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        String string3 = ServiceState.rilRadioTechnologyToString(this.mRilVoiceRadioTechnology);
        String string4 = ServiceState.rilRadioTechnologyToString(this.mRilDataRadioTechnology);
        StringBuilder stringBuilder = new StringBuilder().append(this.mVoiceRegState).append(" ").append(this.mDataRegState).append(" ");
        String string5 = this.mRoaming ? "roaming" : "home";
        StringBuilder stringBuilder2 = stringBuilder.append(string5).append(" ").append(this.mOperatorAlphaLong).append(" ").append(this.mOperatorAlphaShort).append(" ").append(this.mOperatorNumeric).append(" ");
        String string6 = this.mIsManualNetworkSelection ? "(manual)" : "";
        StringBuilder stringBuilder3 = stringBuilder2.append(string6).append(" ").append(string3).append(" ").append(string4).append(" ");
        if (this.mCssIndicator) {
            string2 = "CSS supported";
            return stringBuilder3.append(string2).append(" ").append(this.mNetworkId).append(" ").append(this.mSystemId).append(" RoamInd=").append(this.mCdmaRoamingIndicator).append(" DefRoamInd=").append(this.mCdmaDefaultRoamingIndicator).append(" EmergOnly=").append(this.mIsEmergencyOnly).toString();
        }
        string2 = "CSS not supported";
        return stringBuilder3.append(string2).append(" ").append(this.mNetworkId).append(" ").append(this.mSystemId).append(" RoamInd=").append(this.mCdmaRoamingIndicator).append(" DefRoamInd=").append(this.mCdmaDefaultRoamingIndicator).append(" EmergOnly=").append(this.mIsEmergencyOnly).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mVoiceRegState);
        parcel.writeInt(this.mDataRegState);
        int n3 = this.mRoaming ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeString(this.mOperatorAlphaLong);
        parcel.writeString(this.mOperatorAlphaShort);
        parcel.writeString(this.mOperatorNumeric);
        int n4 = this.mIsManualNetworkSelection ? n2 : 0;
        parcel.writeInt(n4);
        parcel.writeInt(this.mRilVoiceRadioTechnology);
        parcel.writeInt(this.mRilDataRadioTechnology);
        int n5 = this.mCssIndicator ? n2 : 0;
        parcel.writeInt(n5);
        parcel.writeInt(this.mNetworkId);
        parcel.writeInt(this.mSystemId);
        parcel.writeInt(this.mCdmaRoamingIndicator);
        parcel.writeInt(this.mCdmaDefaultRoamingIndicator);
        parcel.writeInt(this.mCdmaEriIconIndex);
        parcel.writeInt(this.mCdmaEriIconMode);
        if (!this.mIsEmergencyOnly) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

