/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;

public class NeighboringCellInfo
implements Parcelable {
    public static final Parcelable.Creator<NeighboringCellInfo> CREATOR = new Parcelable.Creator<NeighboringCellInfo>(){

        @Override
        public NeighboringCellInfo createFromParcel(Parcel parcel) {
            return new NeighboringCellInfo(parcel);
        }

        public NeighboringCellInfo[] newArray(int n) {
            return new NeighboringCellInfo[n];
        }
    };
    public static final int UNKNOWN_CID = -1;
    public static final int UNKNOWN_RSSI = 99;
    private int mCid;
    private int mLac;
    private int mNetworkType;
    private int mPsc;
    private int mRssi;

    @Deprecated
    public NeighboringCellInfo() {
        this.mRssi = 99;
        this.mLac = -1;
        this.mCid = -1;
        this.mPsc = -1;
        this.mNetworkType = 0;
    }

    @Deprecated
    public NeighboringCellInfo(int n, int n2) {
        this.mRssi = n;
        this.mCid = n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NeighboringCellInfo(int n, String string2, int n2) {
        this.mRssi = n;
        this.mNetworkType = 0;
        this.mPsc = -1;
        this.mLac = -1;
        this.mCid = -1;
        int n3 = string2.length();
        if (n3 > 8) return;
        if (n3 < 8) {
            for (int i = 0; i < 8 - n3; ++i) {
                string2 = "0" + string2;
            }
        }
        switch (n2) {
            default: {
                return;
            }
            case 1: 
            case 2: {
                try {
                    this.mNetworkType = n2;
                    if (string2.equalsIgnoreCase("FFFFFFFF")) return;
                    this.mCid = Integer.valueOf(string2.substring(4), 16);
                    this.mLac = Integer.valueOf(string2.substring(0, 4), 16);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    this.mPsc = -1;
                    this.mLac = -1;
                    this.mCid = -1;
                    this.mNetworkType = 0;
                    return;
                }
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
        }
        {
            this.mNetworkType = n2;
            this.mPsc = Integer.valueOf(string2, 16);
            return;
        }
    }

    public NeighboringCellInfo(Parcel parcel) {
        this.mRssi = parcel.readInt();
        this.mLac = parcel.readInt();
        this.mCid = parcel.readInt();
        this.mPsc = parcel.readInt();
        this.mNetworkType = parcel.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getCid() {
        return this.mCid;
    }

    public int getLac() {
        return this.mLac;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    public int getPsc() {
        return this.mPsc;
    }

    public int getRssi() {
        return this.mRssi;
    }

    @Deprecated
    public void setCid(int n) {
        this.mCid = n;
    }

    @Deprecated
    public void setRssi(int n) {
        this.mRssi = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (this.mPsc != -1) {
            StringBuilder stringBuilder2 = stringBuilder.append(Integer.toHexString(this.mPsc)).append("@");
            Object object = this.mRssi == 99 ? "-" : Integer.valueOf(this.mRssi);
            stringBuilder2.append(object);
        } else if (this.mLac != -1 && this.mCid != -1) {
            StringBuilder stringBuilder3 = stringBuilder.append(Integer.toHexString(this.mLac)).append(Integer.toHexString(this.mCid)).append("@");
            Object object = this.mRssi == 99 ? "-" : Integer.valueOf(this.mRssi);
            stringBuilder3.append(object);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mRssi);
        parcel.writeInt(this.mLac);
        parcel.writeInt(this.mCid);
        parcel.writeInt(this.mPsc);
        parcel.writeInt(this.mNetworkType);
    }
}

