/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.util.Log;
import com.android.internal.telecom.ITelecomService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TelecomManager {
    public static final String ACTION_CHANGE_PHONE_ACCOUNTS = "android.telecom.action.CHANGE_PHONE_ACCOUNTS";
    public static final String ACTION_CONNECTION_SERVICE_CONFIGURE = "android.telecom.action.CONNECTION_SERVICE_CONFIGURE";
    public static final String ACTION_CURRENT_TTY_MODE_CHANGED = "android.telecom.action.CURRENT_TTY_MODE_CHANGED";
    public static final String ACTION_INCOMING_CALL = "android.telecom.action.INCOMING_CALL";
    public static final String ACTION_NEW_UNKNOWN_CALL = "android.telecom.action.NEW_UNKNOWN_CALL";
    public static final String ACTION_SHOW_CALL_SETTINGS = "android.telecom.action.SHOW_CALL_SETTINGS";
    public static final String ACTION_TTY_PREFERRED_MODE_CHANGED = "android.telecom.action.TTY_PREFERRED_MODE_CHANGED";
    public static final char DTMF_CHARACTER_PAUSE = ',';
    public static final char DTMF_CHARACTER_WAIT = ';';
    public static final String EXTRA_CALL_BACK_NUMBER = "android.telecom.extra.CALL_BACK_NUMBER";
    public static final String EXTRA_CALL_DISCONNECT_CAUSE = "android.telecom.extra.CALL_DISCONNECT_CAUSE";
    public static final String EXTRA_CALL_DISCONNECT_MESSAGE = "android.telecom.extra.CALL_DISCONNECT_MESSAGE";
    public static final String EXTRA_CONNECTION_SERVICE = "android.telecom.extra.CONNECTION_SERVICE";
    public static final String EXTRA_CURRENT_TTY_MODE = "android.telecom.intent.extra.CURRENT_TTY_MODE";
    public static final String EXTRA_INCOMING_CALL_EXTRAS = "android.telecom.extra.INCOMING_CALL_EXTRAS";
    public static final String EXTRA_OUTGOING_CALL_EXTRAS = "android.telecom.extra.OUTGOING_CALL_EXTRAS";
    public static final String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telecom.extra.PHONE_ACCOUNT_HANDLE";
    public static final String EXTRA_START_CALL_WITH_SPEAKERPHONE = "android.telecom.extra.START_CALL_WITH_SPEAKERPHONE";
    public static final String EXTRA_START_CALL_WITH_VIDEO_STATE = "android.telecom.extra.START_CALL_WITH_VIDEO_STATE";
    public static final String EXTRA_TTY_PREFERRED_MODE = "android.telecom.intent.extra.TTY_PREFERRED";
    public static final String EXTRA_UNKNOWN_CALL_HANDLE = "android.telecom.extra.UNKNOWN_CALL_HANDLE";
    public static final String GATEWAY_ORIGINAL_ADDRESS = "android.telecom.extra.GATEWAY_ORIGINAL_ADDRESS";
    public static final String GATEWAY_PROVIDER_PACKAGE = "android.telecom.extra.GATEWAY_PROVIDER_PACKAGE";
    public static final int PRESENTATION_ALLOWED = 1;
    public static final int PRESENTATION_PAYPHONE = 4;
    public static final int PRESENTATION_RESTRICTED = 2;
    public static final int PRESENTATION_UNKNOWN = 3;
    private static final String TAG = "TelecomManager";
    public static final int TTY_MODE_FULL = 1;
    public static final int TTY_MODE_HCO = 2;
    public static final int TTY_MODE_OFF = 0;
    public static final int TTY_MODE_VCO = 3;
    private final Context mContext;

    public TelecomManager(Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            this.mContext = context2;
            return;
        }
        this.mContext = context;
    }

    public static TelecomManager from(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }

    private ITelecomService getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isServiceConnected() {
        if (this.getTelecomService() != null) {
            return true;
        }
        boolean bl = false;
        if (bl) return bl;
        Log.w(TAG, "Telecom Service not found.");
        return bl;
    }

    public void acceptRingingCall() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().acceptRingingCall();
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#acceptRingingCall", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addNewIncomingCall(PhoneAccountHandle phoneAccountHandle, Bundle bundle) {
        try {
            if (this.isServiceConnected()) {
                ITelecomService iTelecomService = this.getTelecomService();
                if (bundle == null) {
                    bundle = new Bundle();
                }
                iTelecomService.addNewIncomingCall(phoneAccountHandle, bundle);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException adding a new incoming call: " + phoneAccountHandle, remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addNewUnknownCall(PhoneAccountHandle phoneAccountHandle, Bundle bundle) {
        try {
            if (this.isServiceConnected()) {
                ITelecomService iTelecomService = this.getTelecomService();
                if (bundle == null) {
                    bundle = new Bundle();
                }
                iTelecomService.addNewUnknownCall(phoneAccountHandle, bundle);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException adding a new unknown call: " + phoneAccountHandle, remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancelMissedCallsNotification() {
        ITelecomService iTelecomService = this.getTelecomService();
        if (iTelecomService == null) return;
        try {
            iTelecomService.cancelMissedCallsNotification();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#cancelMissedCallsNotification", remoteException);
            return;
        }
    }

    public void clearAccounts() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().clearAccounts(this.mContext.getPackageName());
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#clearAccounts", remoteException);
            return;
        }
    }

    public boolean endCall() {
        try {
            if (this.isServiceConnected()) {
                boolean bl = this.getTelecomService().endCall();
                return bl;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#endCall", remoteException);
        }
        return false;
    }

    public long getActiveSubscription() {
        try {
            if (this.isServiceConnected()) {
                long l = this.getTelecomService().getActiveSubscription();
                return l;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException attempting to get the active subsription.", remoteException);
        }
        return -1000L;
    }

    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        try {
            if (this.isServiceConnected()) {
                List<PhoneAccountHandle> list = this.getTelecomService().getAllPhoneAccountHandles();
                return list;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccountHandles", remoteException);
        }
        return Collections.EMPTY_LIST;
    }

    public List<PhoneAccount> getAllPhoneAccounts() {
        try {
            if (this.isServiceConnected()) {
                List<PhoneAccount> list = this.getTelecomService().getAllPhoneAccounts();
                return list;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccounts", remoteException);
        }
        return Collections.EMPTY_LIST;
    }

    public int getAllPhoneAccountsCount() {
        try {
            if (this.isServiceConnected()) {
                int n = this.getTelecomService().getAllPhoneAccountsCount();
                return n;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccountsCount", remoteException);
        }
        return 0;
    }

    public List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        try {
            if (this.isServiceConnected()) {
                List<PhoneAccountHandle> list = this.getTelecomService().getCallCapablePhoneAccounts();
                return list;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getCallCapablePhoneAccounts", remoteException);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    public int getCallState() {
        try {
            if (this.isServiceConnected()) {
                int n = this.getTelecomService().getCallState();
                return n;
            }
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "RemoteException calling getCallState().", remoteException);
        }
        return 0;
    }

    public PhoneAccountHandle getConnectionManager() {
        return this.getSimCallManager();
    }

    public int getCurrentTtyMode() {
        try {
            if (this.isServiceConnected()) {
                int n = this.getTelecomService().getCurrentTtyMode();
                return n;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException attempting to get the current TTY mode.", remoteException);
        }
        return 0;
    }

    public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String string2) {
        try {
            if (this.isServiceConnected()) {
                PhoneAccountHandle phoneAccountHandle = this.getTelecomService().getDefaultOutgoingPhoneAccount(string2);
                return phoneAccountHandle;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getDefaultOutgoingPhoneAccount", remoteException);
        }
        return null;
    }

    public ComponentName getDefaultPhoneApp() {
        try {
            if (this.isServiceConnected()) {
                ComponentName componentName = this.getTelecomService().getDefaultPhoneApp();
                return componentName;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException attempting to get the default phone app.", remoteException);
        }
        return null;
    }

    public PhoneAccount getPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        try {
            if (this.isServiceConnected()) {
                PhoneAccount phoneAccount = this.getTelecomService().getPhoneAccount(phoneAccountHandle);
                return phoneAccount;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getPhoneAccount", remoteException);
        }
        return null;
    }

    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        try {
            if (this.isServiceConnected()) {
                List<PhoneAccountHandle> list = this.getTelecomService().getPhoneAccountsForPackage(this.mContext.getPackageName());
                return list;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getPhoneAccountsForPackage", remoteException);
        }
        return null;
    }

    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String string2) {
        try {
            if (this.isServiceConnected()) {
                List<PhoneAccountHandle> list = this.getTelecomService().getPhoneAccountsSupportingScheme(string2);
                return list;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getPhoneAccountsSupportingScheme", remoteException);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    public PhoneAccountHandle getSimCallManager() {
        try {
            if (this.isServiceConnected()) {
                PhoneAccountHandle phoneAccountHandle = this.getTelecomService().getSimCallManager();
                return phoneAccountHandle;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getSimCallManager");
        }
        return null;
    }

    public List<PhoneAccountHandle> getSimCallManagers() {
        try {
            if (this.isServiceConnected()) {
                List<PhoneAccountHandle> list = this.getTelecomService().getSimCallManagers();
                return list;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getSimCallManagers");
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        try {
            if (this.isServiceConnected()) {
                PhoneAccountHandle phoneAccountHandle = this.getTelecomService().getUserSelectedOutgoingPhoneAccount();
                return phoneAccountHandle;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#getUserSelectedOutgoingPhoneAccount", remoteException);
        }
        return null;
    }

    public boolean handleMmi(String string2) {
        ITelecomService iTelecomService = this.getTelecomService();
        if (iTelecomService != null) {
            try {
                boolean bl = iTelecomService.handlePinMmi(string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error calling ITelecomService#handlePinMmi", remoteException);
            }
        }
        return false;
    }

    public boolean hasMultipleCallCapableAccounts() {
        return this.getCallCapablePhoneAccounts().size() > 1;
    }

    public boolean isInCall() {
        try {
            if (this.isServiceConnected()) {
                boolean bl = this.getTelecomService().isInCall();
                return bl;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException calling isInCall().", remoteException);
        }
        return false;
    }

    public boolean isRinging() {
        try {
            if (this.isServiceConnected()) {
                boolean bl = this.getTelecomService().isRinging();
                return bl;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException attempting to get ringing state of phone app.", remoteException);
        }
        return false;
    }

    public boolean isTtySupported() {
        try {
            if (this.isServiceConnected()) {
                boolean bl = this.getTelecomService().isTtySupported();
                return bl;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException attempting to get TTY supported state.", remoteException);
        }
        return false;
    }

    public void registerPhoneAccount(PhoneAccount phoneAccount) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().registerPhoneAccount(phoneAccount);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#registerPhoneAccount", remoteException);
            return;
        }
    }

    public void setSimCallManager(PhoneAccountHandle phoneAccountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().setSimCallManager(phoneAccountHandle);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#setSimCallManager");
            return;
        }
    }

    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().setUserSelectedOutgoingPhoneAccount(phoneAccountHandle);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#setUserSelectedOutgoingPhoneAccount");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showInCallScreen(boolean bl) {
        ITelecomService iTelecomService = this.getTelecomService();
        if (iTelecomService == null) return;
        try {
            iTelecomService.showInCallScreen(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#showCallScreen", remoteException);
            return;
        }
    }

    public void silenceRinger() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().silenceRinger();
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#silenceRinger", remoteException);
            return;
        }
    }

    public void switchToOtherActiveSub(long l) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().switchToOtherActiveSub(l);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException attempting to switchToOtherActiveSub.", remoteException);
            return;
        }
    }

    public void unregisterPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().unregisterPhoneAccount(phoneAccountHandle);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error calling ITelecomService#unregisterPhoneAccount", remoteException);
            return;
        }
    }
}

