/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Connection;
import android.telecom.PhoneAccountHandle;
import android.telecom.PhoneCapabilities;
import java.util.ArrayList;
import java.util.List;

public final class ParcelableConference
implements Parcelable {
    public static final Parcelable.Creator<ParcelableConference> CREATOR = new Parcelable.Creator<ParcelableConference>(){

        @Override
        public ParcelableConference createFromParcel(Parcel parcel) {
            ClassLoader classLoader = ParcelableConference.class.getClassLoader();
            PhoneAccountHandle phoneAccountHandle = (PhoneAccountHandle)parcel.readParcelable(classLoader);
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            ArrayList<String> arrayList = new ArrayList<String>(2);
            parcel.readList(arrayList, classLoader);
            return new ParcelableConference(phoneAccountHandle, n, n2, arrayList);
        }

        public ParcelableConference[] newArray(int n) {
            return new ParcelableConference[n];
        }
    };
    private int mCapabilities;
    private List<String> mConnectionIds;
    private PhoneAccountHandle mPhoneAccount;
    private int mState;

    public ParcelableConference(PhoneAccountHandle phoneAccountHandle, int n, int n2, List<String> list) {
        this.mPhoneAccount = phoneAccountHandle;
        this.mState = n;
        this.mCapabilities = n2;
        this.mConnectionIds = list;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    public List<String> getConnectionIds() {
        return this.mConnectionIds;
    }

    public PhoneAccountHandle getPhoneAccount() {
        return this.mPhoneAccount;
    }

    public int getState() {
        return this.mState;
    }

    public String toString() {
        return new StringBuffer().append("account: ").append(this.mPhoneAccount).append(", state: ").append(Connection.stateToString(this.mState)).append(", capabilities: ").append(PhoneCapabilities.toString(this.mCapabilities)).append(", children: ").append(this.mConnectionIds).toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mPhoneAccount, 0);
        parcel.writeInt(this.mState);
        parcel.writeInt(this.mCapabilities);
        parcel.writeList(this.mConnectionIds);
    }
}

