/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.telecom.AudioState;
import android.telecom.Connection;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class Conference {
    private AudioState mAudioState;
    private int mCapabilities;
    private final List<Connection> mChildConnections;
    private final List<Connection> mConferenceableConnections;
    private final Connection.Listener mConnectionDeathListener;
    private DisconnectCause mDisconnectCause;
    private String mDisconnectMessage;
    private final Set<Listener> mListeners = new CopyOnWriteArraySet<Listener>();
    private PhoneAccountHandle mPhoneAccount;
    private int mState = 1;
    private final List<Connection> mUnmodifiableChildConnections;
    private final List<Connection> mUnmodifiableConferenceableConnections;

    public Conference(PhoneAccountHandle phoneAccountHandle) {
        this.mChildConnections = new CopyOnWriteArrayList<Connection>();
        this.mUnmodifiableChildConnections = Collections.unmodifiableList(this.mChildConnections);
        this.mConferenceableConnections = new ArrayList<Connection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mConnectionDeathListener = new Connection.Listener(){

            @Override
            public void onDestroyed(Connection connection) {
                if (Conference.this.mConferenceableConnections.remove(connection)) {
                    Conference.this.fireOnConferenceableConnectionsChanged();
                }
            }
        };
        this.mPhoneAccount = phoneAccountHandle;
    }

    private final void clearConferenceableList() {
        Iterator<Connection> iterator = this.mConferenceableConnections.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeConnectionListener(this.mConnectionDeathListener);
        }
        this.mConferenceableConnections.clear();
    }

    private final void fireOnConferenceableConnectionsChanged() {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConferenceableConnectionsChanged(this, this.getConferenceableConnections());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setState(int n) {
        if (n != 4 && n != 5 && n != 6) {
            Object[] objectArray = new Object[]{Connection.stateToString(n)};
            Log.w(this, "Unsupported state transition for Conference call.", objectArray);
            return;
        } else {
            if (this.mState == n) return;
            int n2 = this.mState;
            this.mState = n;
            Iterator<Listener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onStateChanged(this, n2, n);
            }
        }
    }

    public final boolean addConnection(Connection connection) {
        if (connection != null && !this.mChildConnections.contains(connection) && connection.setConference(this)) {
            this.mChildConnections.add(connection);
            Iterator<Listener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onConnectionAdded(this, connection);
            }
            return true;
        }
        return false;
    }

    public final Conference addListener(Listener listener) {
        this.mListeners.add(listener);
        return this;
    }

    public final void destroy() {
        Log.d(this, "destroying conference : %s", this);
        for (Connection connection : this.mChildConnections) {
            Log.d(this, "removing connection %s", connection);
            this.removeConnection(connection);
        }
        if (this.mState != 6) {
            Log.d(this, "setting to disconnected", new Object[0]);
            this.setDisconnected(new DisconnectCause(2));
        }
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroyed(this);
        }
    }

    public final AudioState getAudioState() {
        return this.mAudioState;
    }

    public final int getCapabilities() {
        return this.mCapabilities;
    }

    public final List<Connection> getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    public final List<Connection> getConnections() {
        return this.mUnmodifiableChildConnections;
    }

    public final PhoneAccountHandle getPhoneAccountHandle() {
        return this.mPhoneAccount;
    }

    public final int getState() {
        return this.mState;
    }

    public void onAudioStateChanged(AudioState audioState) {
    }

    public void onDisconnect() {
    }

    public void onHold() {
    }

    public void onMerge() {
    }

    public void onMerge(Connection connection) {
    }

    public void onPlayDtmfTone(char c) {
    }

    public void onSeparate(Connection connection) {
    }

    public void onStopDtmfTone() {
    }

    public void onSwap() {
    }

    public void onUnhold() {
    }

    public final void removeConnection(Connection connection) {
        Object[] objectArray = new Object[]{connection, this.mChildConnections};
        Log.d(this, "removing %s from %s", objectArray);
        if (connection != null && this.mChildConnections.remove(connection)) {
            connection.resetConference();
            Iterator<Listener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onConnectionRemoved(this, connection);
            }
        }
    }

    public final Conference removeListener(Listener listener) {
        this.mListeners.remove(listener);
        return this;
    }

    public final void setActive() {
        this.setState(4);
    }

    final void setAudioState(AudioState audioState) {
        Log.d(this, "setAudioState %s", audioState);
        this.mAudioState = audioState;
        this.onAudioStateChanged(audioState);
    }

    public final void setCapabilities(int n) {
        if (n != this.mCapabilities) {
            this.mCapabilities = n;
            Iterator<Listener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onCapabilitiesChanged(this, this.mCapabilities);
            }
        }
    }

    public final void setConferenceableConnections(List<Connection> list) {
        this.clearConferenceableList();
        for (Connection connection : list) {
            if (this.mConferenceableConnections.contains(connection)) continue;
            connection.addConnectionListener(this.mConnectionDeathListener);
            this.mConferenceableConnections.add(connection);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    public final void setDisconnected(DisconnectCause disconnectCause) {
        this.mDisconnectCause = disconnectCause;
        this.setState(6);
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDisconnected(this, this.mDisconnectCause);
        }
    }

    public final void setOnHold() {
        this.setState(5);
    }

    public static abstract class Listener {
        public void onCapabilitiesChanged(Conference conference, int n) {
        }

        public void onConferenceableConnectionsChanged(Conference conference, List<Connection> list) {
        }

        public void onConnectionAdded(Conference conference, Connection connection) {
        }

        public void onConnectionRemoved(Conference conference, Connection connection) {
        }

        public void onDestroyed(Conference conference) {
        }

        public void onDisconnected(Conference conference, DisconnectCause disconnectCause) {
        }

        public void onStateChanged(Conference conference, int n, int n2) {
        }
    }
}

