/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;

public final class AudioState
implements Parcelable {
    public static final Parcelable.Creator<AudioState> CREATOR = new Parcelable.Creator<AudioState>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AudioState createFromParcel(Parcel parcel) {
            boolean bl;
            if (parcel.readByte() == 0) {
                bl = false;
                return new AudioState(bl, parcel.readInt(), parcel.readInt());
            }
            bl = true;
            return new AudioState(bl, parcel.readInt(), parcel.readInt());
        }

        public AudioState[] newArray(int n) {
            return new AudioState[n];
        }
    };
    public static final int ROUTE_ALL = 15;
    public static final int ROUTE_BLUETOOTH = 2;
    public static final int ROUTE_EARPIECE = 1;
    public static final int ROUTE_SPEAKER = 8;
    public static final int ROUTE_WIRED_HEADSET = 4;
    public static final int ROUTE_WIRED_OR_EARPIECE = 5;
    public final boolean isMuted;
    public final int route;
    public final int supportedRouteMask;

    public AudioState(AudioState audioState) {
        this.isMuted = audioState.isMuted;
        this.route = audioState.route;
        this.supportedRouteMask = audioState.supportedRouteMask;
    }

    public AudioState(boolean bl, int n, int n2) {
        this.isMuted = bl;
        this.route = n;
        this.supportedRouteMask = n2;
    }

    public static String audioRouteToString(int n) {
        if (n == 0 || (n & 0xFFFFFFF0) != 0) {
            return "UNKNOWN";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) == 1) {
            AudioState.listAppend(stringBuffer, "EARPIECE");
        }
        if ((n & 2) == 2) {
            AudioState.listAppend(stringBuffer, "BLUETOOTH");
        }
        if ((n & 4) == 4) {
            AudioState.listAppend(stringBuffer, "WIRED_HEADSET");
        }
        if ((n & 8) == 8) {
            AudioState.listAppend(stringBuffer, "SPEAKER");
        }
        return stringBuffer.toString();
    }

    private static void listAppend(StringBuffer stringBuffer, String string2) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(", ");
        }
        stringBuffer.append(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (object == null || !(object instanceof AudioState)) break block2;
                AudioState audioState = (AudioState)object;
                if (this.isMuted == audioState.isMuted && this.route == audioState.route && this.supportedRouteMask == audioState.supportedRouteMask) break block3;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{this.isMuted, AudioState.audioRouteToString(this.route), AudioState.audioRouteToString(this.supportedRouteMask)};
        return String.format(locale, "[AudioState isMuted: %b, route; %s, supportedRouteMask: %s]", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        boolean bl = this.isMuted;
        parcel.writeByte((byte)(bl ? 1 : 0));
        parcel.writeInt(this.route);
        parcel.writeInt(this.supportedRouteMask);
    }
}

