/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.app.Service;
import android.content.Intent;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.AudioPlaybackQueueItem;
import android.speech.tts.EventLoggerV1;
import android.speech.tts.FileSynthesisCallback;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.PlaybackSynthesisCallback;
import android.speech.tts.SilencePlaybackQueueItem;
import android.speech.tts.SynthesisCallback;
import android.speech.tts.SynthesisRequest;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TtsEngines;
import android.speech.tts.Voice;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public abstract class TextToSpeechService
extends Service {
    private static final boolean DBG = false;
    private static final String SYNTH_THREAD_NAME = "SynthThread";
    private static final String TAG = "TextToSpeechService";
    private AudioPlaybackHandler mAudioPlaybackHandler;
    private final ITextToSpeechService.Stub mBinder;
    private CallbackMap mCallbacks;
    private TtsEngines mEngineHelper;
    private String mPackageName;
    private SynthHandler mSynthHandler;
    private final Object mVoicesInfoLock = new Object();

    public TextToSpeechService() {
        this.mBinder = new ITextToSpeechService.Stub(){

            private boolean checkNonNull(Object ... objectArray) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (objectArray[i] != null) continue;
                    return false;
                }
                return true;
            }

            private String intern(String string2) {
                return string2.intern();
            }

            @Override
            public String[] getClientDefaultLanguage() {
                return TextToSpeechService.this.getSettingsLocale();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public String getDefaultVoiceNameFor(String string2, String string3, String string4) {
                int n;
                if (!this.checkNonNull(string2) || (n = TextToSpeechService.this.onIsLanguageAvailable(string2, string3, string4)) != 0 && n != 1 && n != 2) {
                    return null;
                }
                return TextToSpeechService.this.onGetDefaultVoiceNameFor(string2, string3, string4);
            }

            @Override
            public String[] getFeaturesForLanguage(String string2, String string3, String string4) {
                Set<String> set = TextToSpeechService.this.onGetFeaturesForLanguage(string2, string3, string4);
                if (set != null) {
                    String[] stringArray = new String[set.size()];
                    set.toArray(stringArray);
                    return stringArray;
                }
                return new String[0];
            }

            @Override
            public String[] getLanguage() {
                return TextToSpeechService.this.onGetLanguage();
            }

            @Override
            public List<Voice> getVoices() {
                return TextToSpeechService.this.onGetVoices();
            }

            @Override
            public int isLanguageAvailable(String string2, String string3, String string4) {
                if (!this.checkNonNull(string2)) {
                    return -1;
                }
                return TextToSpeechService.this.onIsLanguageAvailable(string2, string3, string4);
            }

            @Override
            public boolean isSpeaking() {
                return TextToSpeechService.this.mSynthHandler.isSpeaking() || TextToSpeechService.this.mAudioPlaybackHandler.isSpeaking();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int loadLanguage(IBinder iBinder, String string2, String string3, String string4) {
                if (!this.checkNonNull(string2)) {
                    return -1;
                }
                int n = TextToSpeechService.this.onIsLanguageAvailable(string2, string3, string4);
                if (n != 0 && n != 1) {
                    if (n != 2) return n;
                }
                LoadLanguageItem loadLanguageItem = new LoadLanguageItem(iBinder, Binder.getCallingUid(), Binder.getCallingPid(), string2, string3, string4);
                if (TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, loadLanguageItem) == 0) return n;
                return -1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int loadVoice(IBinder iBinder, String string2) {
                if (!this.checkNonNull(string2)) {
                    return -1;
                }
                int n = TextToSpeechService.this.onIsValidVoiceName(string2);
                if (n != 0) return n;
                LoadVoiceItem loadVoiceItem = new LoadVoiceItem(iBinder, Binder.getCallingUid(), Binder.getCallingPid(), string2);
                if (TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, loadVoiceItem) == 0) return n;
                return -1;
            }

            @Override
            public int playAudio(IBinder iBinder, Uri uri, int n, Bundle bundle, String string2) {
                if (!this.checkNonNull(iBinder, uri, bundle)) {
                    return -1;
                }
                AudioSpeechItemV1 audioSpeechItemV1 = new AudioSpeechItemV1(iBinder, Binder.getCallingUid(), Binder.getCallingPid(), bundle, string2, uri);
                return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(n, audioSpeechItemV1);
            }

            @Override
            public int playSilence(IBinder iBinder, long l, int n, String string2) {
                if (!this.checkNonNull(iBinder)) {
                    return -1;
                }
                SilenceSpeechItem silenceSpeechItem = new SilenceSpeechItem(iBinder, Binder.getCallingUid(), Binder.getCallingPid(), string2, l);
                return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(n, silenceSpeechItem);
            }

            @Override
            public void setCallback(IBinder iBinder, ITextToSpeechCallback iTextToSpeechCallback) {
                if (!this.checkNonNull(iBinder)) {
                    return;
                }
                TextToSpeechService.this.mCallbacks.setCallback(iBinder, iTextToSpeechCallback);
            }

            @Override
            public int speak(IBinder iBinder, CharSequence charSequence, int n, Bundle bundle, String string2) {
                if (!this.checkNonNull(iBinder, charSequence, bundle)) {
                    return -1;
                }
                SynthesisSpeechItemV1 synthesisSpeechItemV1 = new SynthesisSpeechItemV1(iBinder, Binder.getCallingUid(), Binder.getCallingPid(), bundle, string2, charSequence);
                return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(n, synthesisSpeechItemV1);
            }

            @Override
            public int stop(IBinder iBinder) {
                if (!this.checkNonNull(iBinder)) {
                    return -1;
                }
                return TextToSpeechService.this.mSynthHandler.stopForApp(iBinder);
            }

            @Override
            public int synthesizeToFileDescriptor(IBinder iBinder, CharSequence charSequence, ParcelFileDescriptor parcelFileDescriptor, Bundle bundle, String string2) {
                if (!this.checkNonNull(iBinder, charSequence, parcelFileDescriptor, bundle)) {
                    return -1;
                }
                ParcelFileDescriptor parcelFileDescriptor2 = ParcelFileDescriptor.adoptFd(parcelFileDescriptor.detachFd());
                SynthesisToFileOutputStreamSpeechItemV1 synthesisToFileOutputStreamSpeechItemV1 = new SynthesisToFileOutputStreamSpeechItemV1(iBinder, Binder.getCallingUid(), Binder.getCallingPid(), bundle, string2, charSequence, new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor2));
                return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, synthesisToFileOutputStreamSpeechItemV1);
            }
        };
    }

    private int getDefaultSpeechRate() {
        return this.getSecureSettingInt("tts_default_rate", 100);
    }

    private int getExpectedLanguageAvailableStatus(Locale locale) {
        block3: {
            int n;
            block2: {
                n = 2;
                if (!locale.getVariant().isEmpty()) break block2;
                if (!locale.getCountry().isEmpty()) break block3;
                n = 0;
            }
            return n;
        }
        return 1;
    }

    private int getSecureSettingInt(String string2, int n) {
        return Settings.Secure.getInt(this.getContentResolver(), string2, n);
    }

    private String[] getSettingsLocale() {
        return TtsEngines.toOldLocaleStringFormat(this.mEngineHelper.getLocalePrefForEngine(this.mPackageName));
    }

    @Override
    public IBinder onBind(Intent intent) {
        if ("android.intent.action.TTS_SERVICE".equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        SynthThread synthThread = new SynthThread();
        synthThread.start();
        this.mSynthHandler = new SynthHandler(synthThread.getLooper());
        this.mAudioPlaybackHandler = new AudioPlaybackHandler();
        this.mAudioPlaybackHandler.start();
        this.mEngineHelper = new TtsEngines(this);
        this.mCallbacks = new CallbackMap();
        this.mPackageName = this.getApplicationInfo().packageName;
        String[] stringArray = this.getSettingsLocale();
        this.onLoadLanguage(stringArray[0], stringArray[1], stringArray[2]);
    }

    @Override
    public void onDestroy() {
        this.mSynthHandler.quit();
        this.mAudioPlaybackHandler.quit();
        this.mCallbacks.kill();
        super.onDestroy();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String onGetDefaultVoiceNameFor(String string2, String string3, String string4) {
        String string5;
        Locale locale;
        switch (this.onIsLanguageAvailable(string2, string3, string4)) {
            default: {
                return null;
            }
            case 0: {
                locale = new Locale(string2);
                break;
            }
            case 1: {
                locale = new Locale(string2, string3);
                break;
            }
            case 2: {
                locale = new Locale(string2, string3, string4);
            }
        }
        if (this.onIsValidVoiceName(string5 = TtsEngines.normalizeTTSLocale(locale).toLanguageTag()) == 0) return string5;
        return null;
    }

    protected Set<String> onGetFeaturesForLanguage(String string2, String string3, String string4) {
        return null;
    }

    protected abstract String[] onGetLanguage();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Voice> onGetVoices() {
        ArrayList<Voice> arrayList = new ArrayList<Voice>();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (true) {
            block5: {
                if (n2 >= n) {
                    return arrayList;
                }
                Locale locale = localeArray[n2];
                int n3 = this.getExpectedLanguageAvailableStatus(locale);
                try {
                    int n4 = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
                    if (n4 != n3) {
                    }
                }
                catch (MissingResourceException missingResourceException) {}
                break block5;
                Set<String> set = this.onGetFeaturesForLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
                arrayList.add(new Voice(locale.toLanguageTag(), locale, 300, 300, false, set));
            }
            ++n2;
        }
    }

    protected abstract int onIsLanguageAvailable(String var1, String var2, String var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int onIsValidVoiceName(String string2) {
        Locale locale = Locale.forLanguageTag(string2);
        if (locale == null) return -1;
        int n = this.getExpectedLanguageAvailableStatus(locale);
        try {
            int n2 = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            if (n2 != n) return -1;
            return 0;
        }
        catch (MissingResourceException missingResourceException) {
            return -1;
        }
    }

    protected abstract int onLoadLanguage(String var1, String var2, String var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int onLoadVoice(String string2) {
        Locale locale = Locale.forLanguageTag(string2);
        if (locale == null) return -1;
        int n = this.getExpectedLanguageAvailableStatus(locale);
        try {
            if (this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant()) != n) return -1;
            this.onLoadLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            return 0;
        }
        catch (MissingResourceException missingResourceException) {
            return -1;
        }
    }

    protected abstract void onStop();

    protected abstract void onSynthesizeText(SynthesisRequest var1, SynthesisCallback var2);

    static class AudioOutputParams {
        public final AudioAttributes mAudioAttributes;
        public final float mPan;
        public final int mSessionId;
        public final float mVolume;

        AudioOutputParams() {
            this.mSessionId = 0;
            this.mVolume = 1.0f;
            this.mPan = 0.0f;
            this.mAudioAttributes = null;
        }

        AudioOutputParams(int n, float f, float f2, AudioAttributes audioAttributes) {
            this.mSessionId = n;
            this.mVolume = f;
            this.mPan = f2;
            this.mAudioAttributes = audioAttributes;
        }

        /*
         * Enabled aggressive block sorting
         */
        static AudioOutputParams createFromV1ParamsBundle(Bundle bundle, boolean bl) {
            if (bundle == null) {
                return new AudioOutputParams();
            }
            AudioAttributes audioAttributes = (AudioAttributes)bundle.getParcelable("audioAttributes");
            if (audioAttributes == null) {
                int n = bundle.getInt("streamType", 3);
                AudioAttributes.Builder builder = new AudioAttributes.Builder().setLegacyStreamType(n);
                int n2 = bl ? 1 : 4;
                audioAttributes = builder.setContentType(n2).build();
            }
            return new AudioOutputParams(bundle.getInt("sessionId", 0), bundle.getFloat("volume", 1.0f), bundle.getFloat("pan", 0.0f), audioAttributes);
        }
    }

    private class AudioSpeechItemV1
    extends SpeechItemV1 {
        private final AudioPlaybackQueueItem mItem;

        public AudioSpeechItemV1(Object object, int n, int n2, Bundle bundle, String string2, Uri uri) {
            super(object, n, n2, bundle, string2);
            this.mItem = new AudioPlaybackQueueItem(this, this.getCallerIdentity(), TextToSpeechService.this, uri, this.getAudioParams());
        }

        @Override
        AudioOutputParams getAudioParams() {
            return AudioOutputParams.createFromV1ParamsBundle(this.mParams, false);
        }

        @Override
        public String getUtteranceId() {
            return this.getStringParam(this.mParams, "utteranceId", null);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.mAudioPlaybackHandler.enqueue(this.mItem);
        }

        @Override
        protected void stopImpl() {
        }
    }

    private class CallbackMap
    extends RemoteCallbackList<ITextToSpeechCallback> {
        private final HashMap<IBinder, ITextToSpeechCallback> mCallerToCallback = new HashMap();

        private CallbackMap() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ITextToSpeechCallback getCallbackFor(Object object) {
            IBinder iBinder = (IBinder)object;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                return this.mCallerToCallback.get(iBinder);
            }
        }

        public void dispatchOnError(Object object, String string2, int n) {
            ITextToSpeechCallback iTextToSpeechCallback = this.getCallbackFor(object);
            if (iTextToSpeechCallback == null) {
                return;
            }
            try {
                iTextToSpeechCallback.onError(string2, n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TextToSpeechService.TAG, "Callback onError failed: " + remoteException);
                return;
            }
        }

        public void dispatchOnStart(Object object, String string2) {
            ITextToSpeechCallback iTextToSpeechCallback = this.getCallbackFor(object);
            if (iTextToSpeechCallback == null) {
                return;
            }
            try {
                iTextToSpeechCallback.onStart(string2);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TextToSpeechService.TAG, "Callback onStart failed: " + remoteException);
                return;
            }
        }

        public void dispatchOnStop(Object object, String string2) {
            ITextToSpeechCallback iTextToSpeechCallback = this.getCallbackFor(object);
            if (iTextToSpeechCallback == null) {
                return;
            }
            try {
                iTextToSpeechCallback.onStop(string2);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TextToSpeechService.TAG, "Callback onStop failed: " + remoteException);
                return;
            }
        }

        public void dispatchOnSuccess(Object object, String string2) {
            ITextToSpeechCallback iTextToSpeechCallback = this.getCallbackFor(object);
            if (iTextToSpeechCallback == null) {
                return;
            }
            try {
                iTextToSpeechCallback.onSuccess(string2);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TextToSpeechService.TAG, "Callback onDone failed: " + remoteException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void kill() {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.clear();
                super.kill();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCallbackDied(ITextToSpeechCallback iTextToSpeechCallback, Object object) {
            IBinder iBinder = (IBinder)object;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.remove(iBinder);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setCallback(IBinder iBinder, ITextToSpeechCallback iTextToSpeechCallback) {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                ITextToSpeechCallback iTextToSpeechCallback2;
                if (iTextToSpeechCallback != null) {
                    this.register(iTextToSpeechCallback, iBinder);
                    iTextToSpeechCallback2 = this.mCallerToCallback.put(iBinder, iTextToSpeechCallback);
                } else {
                    iTextToSpeechCallback2 = this.mCallerToCallback.remove(iBinder);
                }
                if (iTextToSpeechCallback2 != null && iTextToSpeechCallback2 != iTextToSpeechCallback) {
                    this.unregister(iTextToSpeechCallback2);
                }
                return;
            }
        }
    }

    private class LoadLanguageItem
    extends SpeechItem {
        private final String mCountry;
        private final String mLanguage;
        private final String mVariant;

        public LoadLanguageItem(Object object, int n, int n2, String string2, String string3, String string4) {
            super(object, n, n2);
            this.mLanguage = string2;
            this.mCountry = string3;
            this.mVariant = string4;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.onLoadLanguage(this.mLanguage, this.mCountry, this.mVariant);
        }

        @Override
        protected void stopImpl() {
        }
    }

    private class LoadVoiceItem
    extends SpeechItem {
        private final String mVoiceName;

        public LoadVoiceItem(Object object, int n, int n2, String string2) {
            super(object, n, n2);
            this.mVoiceName = string2;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.onLoadVoice(this.mVoiceName);
        }

        @Override
        protected void stopImpl() {
        }
    }

    private class SilenceSpeechItem
    extends UtteranceSpeechItem {
        private final long mDuration;
        private final String mUtteranceId;

        public SilenceSpeechItem(Object object, int n, int n2, String string2, long l) {
            super(object, n, n2);
            this.mUtteranceId = string2;
            this.mDuration = l;
        }

        @Override
        public String getUtteranceId() {
            return this.mUtteranceId;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.mAudioPlaybackHandler.enqueue(new SilencePlaybackQueueItem(this, this.getCallerIdentity(), this.mDuration));
        }

        @Override
        protected void stopImpl() {
        }
    }

    private abstract class SpeechItem {
        private final Object mCallerIdentity;
        private final int mCallerPid;
        private final int mCallerUid;
        private boolean mStarted = false;
        private boolean mStopped = false;

        public SpeechItem(Object object, int n, int n2) {
            this.mCallerIdentity = object;
            this.mCallerUid = n;
            this.mCallerPid = n2;
        }

        public Object getCallerIdentity() {
            return this.mCallerIdentity;
        }

        public int getCallerPid() {
            return this.mCallerPid;
        }

        public int getCallerUid() {
            return this.mCallerUid;
        }

        protected boolean isStopped() {
            synchronized (this) {
                boolean bl = this.mStopped;
                return bl;
            }
        }

        public abstract boolean isValid();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void play() {
            synchronized (this) {
                if (this.mStarted) {
                    throw new IllegalStateException("play() called twice");
                }
                this.mStarted = true;
            }
            this.playImpl();
        }

        protected abstract void playImpl();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void stop() {
            synchronized (this) {
                if (this.mStopped) {
                    throw new IllegalStateException("stop() called twice");
                }
                this.mStopped = true;
            }
            this.stopImpl();
        }

        protected abstract void stopImpl();
    }

    private abstract class SpeechItemV1
    extends UtteranceSpeechItem {
        protected final Bundle mParams;
        protected final String mUtteranceId;

        SpeechItemV1(Object object, int n, int n2, Bundle bundle, String string2) {
            super(object, n, n2);
            this.mParams = bundle;
            this.mUtteranceId = string2;
        }

        AudioOutputParams getAudioParams() {
            return AudioOutputParams.createFromV1ParamsBundle(this.mParams, true);
        }

        int getPitch() {
            return this.getIntParam(this.mParams, "pitch", 100);
        }

        int getSpeechRate() {
            return this.getIntParam(this.mParams, "rate", TextToSpeechService.this.getDefaultSpeechRate());
        }

        @Override
        public String getUtteranceId() {
            return this.mUtteranceId;
        }

        boolean hasLanguage() {
            return !TextUtils.isEmpty(this.getStringParam(this.mParams, "language", null));
        }
    }

    private class SynthHandler
    extends Handler {
        private SpeechItem mCurrentSpeechItem;

        public SynthHandler(Looper looper) {
            super(looper);
            this.mCurrentSpeechItem = null;
        }

        private SpeechItem getCurrentSpeechItem() {
            synchronized (this) {
                SpeechItem speechItem = this.mCurrentSpeechItem;
                return speechItem;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private SpeechItem maybeRemoveCurrentSpeechItem(Object object) {
            synchronized (this) {
                SpeechItem speechItem = this.mCurrentSpeechItem;
                SpeechItem speechItem2 = null;
                if (speechItem != null) {
                    Object object2 = this.mCurrentSpeechItem.getCallerIdentity();
                    speechItem2 = null;
                    if (object2 == object) {
                        speechItem2 = this.mCurrentSpeechItem;
                        this.mCurrentSpeechItem = null;
                    }
                }
                return speechItem2;
            }
        }

        private SpeechItem setCurrentSpeechItem(SpeechItem speechItem) {
            synchronized (this) {
                SpeechItem speechItem2 = this.mCurrentSpeechItem;
                this.mCurrentSpeechItem = speechItem;
                return speechItem2;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public int enqueueSpeechItem(int n, final SpeechItem speechItem) {
            boolean bl = speechItem instanceof UtteranceProgressDispatcher;
            UtteranceProgressDispatcher utteranceProgressDispatcher = null;
            if (bl) {
                utteranceProgressDispatcher = (UtteranceProgressDispatcher)((Object)speechItem);
            }
            if (!speechItem.isValid()) {
                if (utteranceProgressDispatcher == null) return -1;
                utteranceProgressDispatcher.dispatchOnError(-8);
                return -1;
            }
            if (n == 0) {
                this.stopForApp(speechItem.getCallerIdentity());
            } else if (n == 2) {
                this.stopAll();
            }
            Message message = Message.obtain((Handler)this, new Runnable(){

                @Override
                public void run() {
                    SynthHandler.this.setCurrentSpeechItem(speechItem);
                    speechItem.play();
                    SynthHandler.this.setCurrentSpeechItem(null);
                }
            });
            message.obj = speechItem.getCallerIdentity();
            if (this.sendMessage(message)) {
                return 0;
            }
            Log.w(TextToSpeechService.TAG, "SynthThread has quit");
            if (utteranceProgressDispatcher == null) return -1;
            utteranceProgressDispatcher.dispatchOnError(-4);
            return -1;
        }

        public boolean isSpeaking() {
            return this.getCurrentSpeechItem() != null;
        }

        public void quit() {
            this.getLooper().quit();
            SpeechItem speechItem = this.setCurrentSpeechItem(null);
            if (speechItem != null) {
                speechItem.stop();
            }
        }

        public int stopAll() {
            SpeechItem speechItem = this.setCurrentSpeechItem(null);
            if (speechItem != null) {
                speechItem.stop();
            }
            this.removeCallbacksAndMessages(null);
            TextToSpeechService.this.mAudioPlaybackHandler.stop();
            return 0;
        }

        public int stopForApp(Object object) {
            if (object == null) {
                return -1;
            }
            this.removeCallbacksAndMessages(object);
            SpeechItem speechItem = this.maybeRemoveCurrentSpeechItem(object);
            if (speechItem != null) {
                speechItem.stop();
            }
            TextToSpeechService.this.mAudioPlaybackHandler.stopForApp(object);
            return 0;
        }
    }

    private class SynthThread
    extends HandlerThread
    implements MessageQueue.IdleHandler {
        private boolean mFirstIdle;

        public SynthThread() {
            super(TextToSpeechService.SYNTH_THREAD_NAME, 0);
            this.mFirstIdle = true;
        }

        private void broadcastTtsQueueProcessingCompleted() {
            Intent intent = new Intent("android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED");
            TextToSpeechService.this.sendBroadcast(intent);
        }

        @Override
        protected void onLooperPrepared() {
            this.getLooper().getQueue().addIdleHandler(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean queueIdle() {
            if (this.mFirstIdle) {
                this.mFirstIdle = false;
                return true;
            }
            this.broadcastTtsQueueProcessingCompleted();
            return true;
        }
    }

    class SynthesisSpeechItemV1
    extends SpeechItemV1 {
        private final int mCallerUid;
        private final String[] mDefaultLocale;
        private final EventLoggerV1 mEventLogger;
        private AbstractSynthesisCallback mSynthesisCallback;
        private final SynthesisRequest mSynthesisRequest;
        private final CharSequence mText;

        public SynthesisSpeechItemV1(Object object, int n, int n2, Bundle bundle, String string2, CharSequence charSequence) {
            super(object, n, n2, bundle, string2);
            this.mText = charSequence;
            this.mCallerUid = n;
            this.mSynthesisRequest = new SynthesisRequest(this.mText, this.mParams);
            this.mDefaultLocale = TextToSpeechService.this.getSettingsLocale();
            this.setRequestParams(this.mSynthesisRequest);
            this.mEventLogger = new EventLoggerV1(this.mSynthesisRequest, n, n2, TextToSpeechService.this.mPackageName);
        }

        private String getCountry() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[1];
            }
            return this.getStringParam(this.mParams, "country", "");
        }

        private String getVariant() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[2];
            }
            return this.getStringParam(this.mParams, "variant", "");
        }

        private void setRequestParams(SynthesisRequest synthesisRequest) {
            String string2 = this.getVoiceName();
            synthesisRequest.setLanguage(this.getLanguage(), this.getCountry(), this.getVariant());
            if (!TextUtils.isEmpty(string2)) {
                synthesisRequest.setVoiceName(this.getVoiceName());
            }
            synthesisRequest.setSpeechRate(this.getSpeechRate());
            synthesisRequest.setCallerUid(this.mCallerUid);
            synthesisRequest.setPitch(this.getPitch());
        }

        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new PlaybackSynthesisCallback(this.getAudioParams(), TextToSpeechService.this.mAudioPlaybackHandler, this, this.getCallerIdentity(), this.mEventLogger, false);
        }

        public String getLanguage() {
            return this.getStringParam(this.mParams, "language", this.mDefaultLocale[0]);
        }

        public CharSequence getText() {
            return this.mText;
        }

        public String getVoiceName() {
            return this.getStringParam(this.mParams, "voiceName", "");
        }

        @Override
        public boolean isValid() {
            if (this.mText == null) {
                Log.e(TextToSpeechService.TAG, "null synthesis text");
                return false;
            }
            if (this.mText.length() >= TextToSpeech.getMaxSpeechInputLength()) {
                Log.w(TextToSpeechService.TAG, "Text too long: " + this.mText.length() + " chars");
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void playImpl() {
            AbstractSynthesisCallback abstractSynthesisCallback;
            this.mEventLogger.onRequestProcessingStart();
            synchronized (this) {
                if (this.isStopped()) {
                    return;
                }
                abstractSynthesisCallback = this.mSynthesisCallback = this.createSynthesisCallback();
            }
            TextToSpeechService.this.onSynthesizeText(this.mSynthesisRequest, abstractSynthesisCallback);
            if (abstractSynthesisCallback.hasStarted() && !abstractSynthesisCallback.hasFinished()) {
                abstractSynthesisCallback.done();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        protected void stopImpl() {
            // MONITORENTER : this
            AbstractSynthesisCallback abstractSynthesisCallback = this.mSynthesisCallback;
            // MONITOREXIT : this
            if (abstractSynthesisCallback == null) return;
            abstractSynthesisCallback.stop();
            TextToSpeechService.this.onStop();
        }
    }

    private class SynthesisToFileOutputStreamSpeechItemV1
    extends SynthesisSpeechItemV1 {
        private final FileOutputStream mFileOutputStream;

        public SynthesisToFileOutputStreamSpeechItemV1(Object object, int n, int n2, Bundle bundle, String string2, CharSequence charSequence, FileOutputStream fileOutputStream) {
            super(object, n, n2, bundle, string2, charSequence);
            this.mFileOutputStream = fileOutputStream;
        }

        @Override
        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new FileSynthesisCallback(this.mFileOutputStream.getChannel(), this, this.getCallerIdentity(), false);
        }

        @Override
        protected void playImpl() {
            this.dispatchOnStart();
            super.playImpl();
            try {
                this.mFileOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                Log.w(TextToSpeechService.TAG, "Failed to close output file", iOException);
                return;
            }
        }
    }

    static interface UtteranceProgressDispatcher {
        public void dispatchOnError(int var1);

        public void dispatchOnStart();

        public void dispatchOnStop();

        public void dispatchOnSuccess();
    }

    private abstract class UtteranceSpeechItem
    extends SpeechItem
    implements UtteranceProgressDispatcher {
        public UtteranceSpeechItem(Object object, int n, int n2) {
            super(object, n, n2);
        }

        @Override
        public void dispatchOnError(int n) {
            String string2 = this.getUtteranceId();
            if (string2 != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnError(this.getCallerIdentity(), string2, n);
            }
        }

        @Override
        public void dispatchOnStart() {
            String string2 = this.getUtteranceId();
            if (string2 != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnStart(this.getCallerIdentity(), string2);
            }
        }

        @Override
        public void dispatchOnStop() {
            String string2 = this.getUtteranceId();
            if (string2 != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnStop(this.getCallerIdentity(), string2);
            }
        }

        @Override
        public void dispatchOnSuccess() {
            String string2 = this.getUtteranceId();
            if (string2 != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnSuccess(this.getCallerIdentity(), string2);
            }
        }

        float getFloatParam(Bundle bundle, String string2, float f) {
            if (bundle == null) {
                return f;
            }
            return bundle.getFloat(string2, f);
        }

        int getIntParam(Bundle bundle, String string2, int n) {
            if (bundle == null) {
                return n;
            }
            return bundle.getInt(string2, n);
        }

        String getStringParam(Bundle bundle, String string2, String string3) {
            if (bundle == null) {
                return string3;
            }
            return bundle.getString(string2, string3);
        }

        public abstract String getUtteranceId();
    }
}

