/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.TtsEngines;
import android.speech.tts.UtteranceProgressListener;
import android.speech.tts.Voice;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

public class TextToSpeech {
    public static final String ACTION_TTS_QUEUE_PROCESSING_COMPLETED = "android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED";
    public static final int ERROR = -1;
    public static final int ERROR_INVALID_REQUEST = -8;
    public static final int ERROR_NETWORK = -6;
    public static final int ERROR_NETWORK_TIMEOUT = -7;
    public static final int ERROR_NOT_INSTALLED_YET = -9;
    public static final int ERROR_OUTPUT = -5;
    public static final int ERROR_SERVICE = -4;
    public static final int ERROR_SYNTHESIS = -3;
    public static final int LANG_AVAILABLE = 0;
    public static final int LANG_COUNTRY_AVAILABLE = 1;
    public static final int LANG_COUNTRY_VAR_AVAILABLE = 2;
    public static final int LANG_MISSING_DATA = -1;
    public static final int LANG_NOT_SUPPORTED = -2;
    public static final int QUEUE_ADD = 1;
    static final int QUEUE_DESTROY = 2;
    public static final int QUEUE_FLUSH = 0;
    public static final int STOPPED = -2;
    public static final int SUCCESS = 0;
    private static final String TAG = "TextToSpeech";
    private Connection mConnectingServiceConnection;
    private final Context mContext;
    private volatile String mCurrentEngine = null;
    private final Map<String, Uri> mEarcons;
    private final TtsEngines mEnginesHelper;
    private OnInitListener mInitListener;
    private final Bundle mParams;
    private String mRequestedEngine;
    private Connection mServiceConnection;
    private final Object mStartLock = new Object();
    private final boolean mUseFallback;
    private volatile UtteranceProgressListener mUtteranceProgressListener;
    private final Map<CharSequence, Uri> mUtterances;

    public TextToSpeech(Context context, OnInitListener onInitListener) {
        this(context, onInitListener, null);
    }

    public TextToSpeech(Context context, OnInitListener onInitListener, String string2) {
        this(context, onInitListener, string2, null, true);
    }

    public TextToSpeech(Context context, OnInitListener onInitListener, String string2, String string3, boolean bl) {
        this.mParams = new Bundle();
        this.mContext = context;
        this.mInitListener = onInitListener;
        this.mRequestedEngine = string2;
        this.mUseFallback = bl;
        this.mEarcons = new HashMap<String, Uri>();
        this.mUtterances = new HashMap<CharSequence, Uri>();
        this.mUtteranceProgressListener = null;
        this.mEnginesHelper = new TtsEngines(this.mContext);
        this.initTts();
    }

    static /* synthetic */ Connection access$1502(TextToSpeech textToSpeech, Connection connection) {
        textToSpeech.mConnectingServiceConnection = connection;
        return connection;
    }

    static /* synthetic */ Connection access$202(TextToSpeech textToSpeech, Connection connection) {
        textToSpeech.mServiceConnection = connection;
        return connection;
    }

    static /* synthetic */ String access$302(TextToSpeech textToSpeech, String string2) {
        textToSpeech.mCurrentEngine = string2;
        return string2;
    }

    private boolean connectToEngine(String string2) {
        Connection connection = new Connection();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(string2);
        if (!this.mContext.bindService(intent, connection, 1)) {
            Log.e(TAG, "Failed to bind to " + string2);
            return false;
        }
        Log.i(TAG, "Sucessfully bound to " + string2);
        this.mConnectingServiceConnection = connection;
        return true;
    }

    private Bundle convertParamsHashMaptoBundle(HashMap<String, String> hashMap) {
        Bundle bundle;
        if (hashMap != null && !hashMap.isEmpty()) {
            bundle = new Bundle();
            this.copyIntParam(bundle, hashMap, "streamType");
            this.copyIntParam(bundle, hashMap, "sessionId");
            this.copyStringParam(bundle, hashMap, "utteranceId");
            this.copyFloatParam(bundle, hashMap, "volume");
            this.copyFloatParam(bundle, hashMap, "pan");
            this.copyStringParam(bundle, hashMap, "networkTts");
            this.copyStringParam(bundle, hashMap, "embeddedTts");
            this.copyIntParam(bundle, hashMap, "networkTimeoutMs");
            this.copyIntParam(bundle, hashMap, "networkRetriesCount");
            if (!TextUtils.isEmpty(this.mCurrentEngine)) {
                for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                    String string2 = entry.getKey();
                    if (string2 == null || !string2.startsWith(this.mCurrentEngine)) continue;
                    bundle.putString(string2, entry.getValue());
                }
            }
        } else {
            bundle = null;
        }
        return bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFloatParam(Bundle bundle, HashMap<String, String> hashMap, String string2) {
        String string3 = hashMap.get(string2);
        if (TextUtils.isEmpty(string3)) return;
        try {
            bundle.putFloat(string2, Float.parseFloat(string3));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyIntParam(Bundle bundle, HashMap<String, String> hashMap, String string2) {
        String string3 = hashMap.get(string2);
        if (TextUtils.isEmpty(string3)) return;
        try {
            bundle.putInt(string2, Integer.parseInt(string3));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void copyStringParam(Bundle bundle, HashMap<String, String> hashMap, String string2) {
        String string3 = hashMap.get(string2);
        if (string3 != null) {
            bundle.putString(string2, string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchOnInit(int n) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mInitListener != null) {
                this.mInitListener.onInit(n);
                this.mInitListener = null;
            }
            return;
        }
    }

    private IBinder getCallerIdentity() {
        return this.mServiceConnection.getCallerIdentity();
    }

    public static int getMaxSpeechInputLength() {
        return 4000;
    }

    private Bundle getParams(Bundle bundle) {
        if (bundle != null && !bundle.isEmpty()) {
            Bundle bundle2 = new Bundle(this.mParams);
            bundle2.putAll(bundle);
            TextToSpeech.verifyIntegerBundleParam(bundle2, "streamType");
            TextToSpeech.verifyIntegerBundleParam(bundle2, "sessionId");
            TextToSpeech.verifyStringBundleParam(bundle2, "utteranceId");
            TextToSpeech.verifyFloatBundleParam(bundle2, "volume");
            TextToSpeech.verifyFloatBundleParam(bundle2, "pan");
            TextToSpeech.verifyBooleanBundleParam(bundle2, "networkTts");
            TextToSpeech.verifyBooleanBundleParam(bundle2, "embeddedTts");
            TextToSpeech.verifyIntegerBundleParam(bundle2, "networkTimeoutMs");
            TextToSpeech.verifyIntegerBundleParam(bundle2, "networkRetriesCount");
            return bundle2;
        }
        return this.mParams;
    }

    private int initTts() {
        String string2;
        if (this.mRequestedEngine != null) {
            if (this.mEnginesHelper.isEngineInstalled(this.mRequestedEngine)) {
                if (this.connectToEngine(this.mRequestedEngine)) {
                    this.mCurrentEngine = this.mRequestedEngine;
                    return 0;
                }
                if (!this.mUseFallback) {
                    this.mCurrentEngine = null;
                    this.dispatchOnInit(-1);
                    return -1;
                }
            } else if (!this.mUseFallback) {
                Log.i(TAG, "Requested engine not installed: " + this.mRequestedEngine);
                this.mCurrentEngine = null;
                this.dispatchOnInit(-1);
                return -1;
            }
        }
        if ((string2 = this.getDefaultEngine()) != null && !string2.equals(this.mRequestedEngine) && this.connectToEngine(string2)) {
            this.mCurrentEngine = string2;
            return 0;
        }
        String string3 = this.mEnginesHelper.getHighestRankedEngineName();
        if (string3 != null && !string3.equals(this.mRequestedEngine) && !string3.equals(string2) && this.connectToEngine(string3)) {
            this.mCurrentEngine = string3;
            return 0;
        }
        this.mCurrentEngine = null;
        this.dispatchOnInit(-1);
        return -1;
    }

    private Uri makeResourceUri(String string2, int n) {
        return new Uri.Builder().scheme("android.resource").encodedAuthority(string2).appendEncodedPath(String.valueOf(n)).build();
    }

    private <R> R runAction(Action<R> action, R r, String string2) {
        return this.runAction(action, r, string2, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R runAction(Action<R> action, R r, String string2, boolean bl, boolean bl2) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mServiceConnection == null) {
                Log.w(TAG, string2 + " failed: not bound to TTS engine");
                return r;
            }
            R r2 = this.mServiceConnection.runAction(action, r, string2, bl, bl2);
            return r2;
        }
    }

    private <R> R runActionNoReconnect(Action<R> action, R r, String string2, boolean bl) {
        return this.runAction(action, r, string2, false, bl);
    }

    private static boolean verifyBooleanBundleParam(Bundle bundle, String string2) {
        if (bundle.containsKey(string2) && !(bundle.get(string2) instanceof Boolean) && !(bundle.get(string2) instanceof String)) {
            bundle.remove(string2);
            Log.w(TAG, "Synthesis request paramter " + string2 + " containst value " + " with invalid type. Should be a Boolean or String");
            return false;
        }
        return true;
    }

    private static boolean verifyFloatBundleParam(Bundle bundle, String string2) {
        if (bundle.containsKey(string2) && !(bundle.get(string2) instanceof Float) && !(bundle.get(string2) instanceof Double)) {
            bundle.remove(string2);
            Log.w(TAG, "Synthesis request paramter " + string2 + " containst value " + " with invalid type. Should be a Float or a Double");
            return false;
        }
        return true;
    }

    private static boolean verifyIntegerBundleParam(Bundle bundle, String string2) {
        if (bundle.containsKey(string2) && !(bundle.get(string2) instanceof Integer) && !(bundle.get(string2) instanceof Long)) {
            bundle.remove(string2);
            Log.w(TAG, "Synthesis request paramter " + string2 + " containst value " + " with invalid type. Should be an Integer or a Long");
            return false;
        }
        return true;
    }

    private static boolean verifyStringBundleParam(Bundle bundle, String string2) {
        if (bundle.containsKey(string2) && !(bundle.get(string2) instanceof String)) {
            bundle.remove(string2);
            Log.w(TAG, "Synthesis request paramter " + string2 + " containst value " + " with invalid type. Should be a String");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addEarcon(String string2, File file) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(string2, Uri.fromFile(file));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public int addEarcon(String string2, String string3) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(string2, Uri.parse(string3));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addEarcon(String string2, String string3, int n) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(string2, this.makeResourceUri(string3, n));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addSpeech(CharSequence charSequence, File file) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(charSequence, Uri.fromFile(file));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addSpeech(CharSequence charSequence, String string2, int n) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(charSequence, this.makeResourceUri(string2, n));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addSpeech(String string2, String string3) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(string2, Uri.parse(string3));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addSpeech(String string2, String string3, int n) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(string2, this.makeResourceUri(string3, n));
            return 0;
        }
    }

    @Deprecated
    public boolean areDefaultsEnforced() {
        return false;
    }

    public Set<Locale> getAvailableLanguages() {
        return this.runAction(new Action<Set<Locale>>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Set<Locale> run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                List<Voice> list = iTextToSpeechService.getVoices();
                if (list == null) {
                    return new HashSet<Locale>();
                }
                HashSet<Locale> hashSet = new HashSet();
                Iterator<Voice> iterator = list.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next().getLocale());
                }
                return hashSet;
            }
        }, null, "getAvailableLanguages");
    }

    public String getCurrentEngine() {
        return this.mCurrentEngine;
    }

    public String getDefaultEngine() {
        return this.mEnginesHelper.getDefaultEngine();
    }

    @Deprecated
    public Locale getDefaultLanguage() {
        return this.runAction(new Action<Locale>(){

            @Override
            public Locale run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                String[] stringArray = iTextToSpeechService.getClientDefaultLanguage();
                return new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
        }, null, "getDefaultLanguage");
    }

    public Voice getDefaultVoice() {
        return this.runAction(new Action<Voice>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public Voice run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                Voice voice;
                String string2;
                String string3;
                String[] stringArray = iTextToSpeechService.getClientDefaultLanguage();
                if (stringArray == null || stringArray.length == 0) {
                    Log.e(TextToSpeech.TAG, "service.getClientDefaultLanguage() returned empty array");
                    return null;
                }
                String string4 = stringArray[0];
                String string5 = stringArray.length > 1 ? stringArray[1] : "";
                int n = iTextToSpeechService.isLanguageAvailable(string4, string5, string3 = stringArray.length > 2 ? stringArray[2] : "");
                if (n < 0) {
                    return null;
                }
                if (n < 2) {
                    string3 = "";
                    if (n < 1) {
                        string5 = "";
                    }
                }
                if (TextUtils.isEmpty(string2 = iTextToSpeechService.getDefaultVoiceNameFor(string4, string5, string3))) {
                    return null;
                }
                List<Voice> list = iTextToSpeechService.getVoices();
                if (list == null) {
                    return null;
                }
                Iterator<Voice> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return null;
                } while (!(voice = iterator.next()).getName().equals(string2));
                return voice;
            }
        }, null, "getDefaultVoice");
    }

    public List<EngineInfo> getEngines() {
        return this.mEnginesHelper.getEngines();
    }

    @Deprecated
    public Set<String> getFeatures(final Locale locale) {
        return this.runAction(new Action<Set<String>>(){

            @Override
            public Set<String> run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                HashSet hashSet;
                block2: {
                    String[] stringArray;
                    try {
                        stringArray = iTextToSpeechService.getFeaturesForLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
                        hashSet = null;
                        if (stringArray == null) break block2;
                    }
                    catch (MissingResourceException missingResourceException) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve 3 letter ISO 639-2/T language and/or ISO 3166 country code for locale: " + locale, missingResourceException);
                        return null;
                    }
                    hashSet = new HashSet();
                    Collections.addAll(hashSet, stringArray);
                }
                return hashSet;
            }
        }, null, "getFeatures");
    }

    @Deprecated
    public Locale getLanguage() {
        return this.runAction(new Action<Locale>(){

            @Override
            public Locale run(ITextToSpeechService iTextToSpeechService) {
                return new Locale(TextToSpeech.this.mParams.getString("language", ""), TextToSpeech.this.mParams.getString("country", ""), TextToSpeech.this.mParams.getString("variant", ""));
            }
        }, null, "getLanguage");
    }

    public Voice getVoice() {
        return this.runAction(new Action<Voice>(){

            @Override
            public Voice run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                String string2 = TextToSpeech.this.mParams.getString("voiceName", "");
                if (TextUtils.isEmpty(string2)) {
                    return null;
                }
                List<Voice> list = iTextToSpeechService.getVoices();
                if (list == null) {
                    return null;
                }
                for (Voice voice : list) {
                    if (!voice.getName().equals(string2)) continue;
                    return voice;
                }
                return null;
            }
        }, null, "getVoice");
    }

    public Set<Voice> getVoices() {
        return this.runAction(new Action<Set<Voice>>(){

            @Override
            public Set<Voice> run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                List<Voice> list = iTextToSpeechService.getVoices();
                if (list != null) {
                    return new HashSet<Voice>(list);
                }
                return new HashSet<Voice>();
            }
        }, null, "getVoices");
    }

    public int isLanguageAvailable(final Locale locale) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                String string2;
                String string3;
                try {
                    string3 = locale.getISO3Language();
                }
                catch (MissingResourceException missingResourceException) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + locale, missingResourceException);
                    return -2;
                }
                try {
                    string2 = locale.getISO3Country();
                }
                catch (MissingResourceException missingResourceException) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + locale, missingResourceException);
                    return -2;
                }
                return iTextToSpeechService.isLanguageAvailable(string3, string2, locale.getVariant());
            }
        }, -2, "isLanguageAvailable");
    }

    public boolean isSpeaking() {
        return this.runAction(new Action<Boolean>(){

            @Override
            public Boolean run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return iTextToSpeechService.isSpeaking();
            }
        }, false, "isSpeaking");
    }

    public int playEarcon(final String string2, final int n, final Bundle bundle, final String string3) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                Uri uri = (Uri)TextToSpeech.this.mEarcons.get(string2);
                if (uri == null) {
                    return -1;
                }
                return iTextToSpeechService.playAudio(TextToSpeech.this.getCallerIdentity(), uri, n, TextToSpeech.this.getParams(bundle), string3);
            }
        }, -1, "playEarcon");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public int playEarcon(String string2, int n, HashMap<String, String> hashMap) {
        String string3;
        Bundle bundle = this.convertParamsHashMaptoBundle(hashMap);
        if (hashMap == null) {
            string3 = null;
            return this.playEarcon(string2, n, bundle, string3);
        }
        string3 = hashMap.get("utteranceId");
        return this.playEarcon(string2, n, bundle, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public int playSilence(long l, int n, HashMap<String, String> hashMap) {
        String string2;
        if (hashMap == null) {
            string2 = null;
            return this.playSilentUtterance(l, n, string2);
        }
        string2 = hashMap.get("utteranceId");
        return this.playSilentUtterance(l, n, string2);
    }

    public int playSilentUtterance(final long l, final int n, final String string2) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return iTextToSpeechService.playSilence(TextToSpeech.this.getCallerIdentity(), l, n, string2);
            }
        }, -1, "playSilentUtterance");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setAudioAttributes(AudioAttributes audioAttributes) {
        if (audioAttributes != null) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putParcelable("audioAttributes", audioAttributes);
                return 0;
            }
        }
        return -1;
    }

    @Deprecated
    public int setEngineByPackageName(String string2) {
        this.mRequestedEngine = string2;
        return this.initTts();
    }

    public int setLanguage(final Locale locale) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                int n;
                block9: {
                    String string2;
                    String string3;
                    String string4;
                    if (locale == null) {
                        return -2;
                    }
                    try {
                        string4 = locale.getISO3Language();
                    }
                    catch (MissingResourceException missingResourceException) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + locale, missingResourceException);
                        return -2;
                    }
                    try {
                        String string5;
                        string3 = string5 = locale.getISO3Country();
                    }
                    catch (MissingResourceException missingResourceException) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + locale, missingResourceException);
                        return -2;
                    }
                    String string6 = locale.getVariant();
                    n = iTextToSpeechService.isLanguageAvailable(string4, string3, string6);
                    if (n < 0) break block9;
                    if (n < 2) {
                        string6 = "";
                        if (n < 1) {
                            string3 = "";
                        }
                    }
                    if (TextUtils.isEmpty(string2 = iTextToSpeechService.getDefaultVoiceNameFor(string4, string3, string6))) {
                        Log.w(TextToSpeech.TAG, "Couldn't find the default voice for " + string4 + "/" + string3 + "/" + string6);
                        return -2;
                    }
                    if (iTextToSpeechService.loadVoice(TextToSpeech.this.getCallerIdentity(), string2) == -1) {
                        return -2;
                    }
                    TextToSpeech.this.mParams.putString("voiceName", string2);
                    TextToSpeech.this.mParams.putString("language", string4);
                    TextToSpeech.this.mParams.putString("country", string3);
                    TextToSpeech.this.mParams.putString("variant", string6);
                }
                return n;
            }
        }, -2, "setLanguage");
    }

    @Deprecated
    public int setOnUtteranceCompletedListener(OnUtteranceCompletedListener onUtteranceCompletedListener) {
        this.mUtteranceProgressListener = UtteranceProgressListener.from(onUtteranceCompletedListener);
        return 0;
    }

    public int setOnUtteranceProgressListener(UtteranceProgressListener utteranceProgressListener) {
        this.mUtteranceProgressListener = utteranceProgressListener;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setPitch(float f) {
        int n;
        if (f > 0.0f && (n = (int)(100.0f * f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("pitch", n);
                return 0;
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setSpeechRate(float f) {
        int n;
        if (f > 0.0f && (n = (int)(100.0f * f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("rate", n);
                return 0;
            }
        }
        return -1;
    }

    public int setVoice(final Voice voice) {
        return this.runAction(new Action<Integer>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                int n = iTextToSpeechService.loadVoice(TextToSpeech.this.getCallerIdentity(), voice.getName());
                if (n == 0) {
                    TextToSpeech.this.mParams.putString("voiceName", voice.getName());
                    String string2 = "";
                    try {
                        String string3;
                        string2 = string3 = voice.getLocale().getISO3Language();
                    }
                    catch (MissingResourceException missingResourceException) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + voice.getLocale(), missingResourceException);
                    }
                    String string4 = "";
                    try {
                        String string5;
                        string4 = string5 = voice.getLocale().getISO3Country();
                    }
                    catch (MissingResourceException missingResourceException) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + voice.getLocale(), missingResourceException);
                    }
                    TextToSpeech.this.mParams.putString("language", string2);
                    TextToSpeech.this.mParams.putString("country", string4);
                    TextToSpeech.this.mParams.putString("variant", voice.getLocale().getVariant());
                }
                return n;
            }
        }, -2, "setVoice");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mConnectingServiceConnection != null) {
                this.mContext.unbindService(this.mConnectingServiceConnection);
                this.mConnectingServiceConnection = null;
                return;
            }
        }
        this.runActionNoReconnect(new Action<Void>(){

            @Override
            public Void run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                iTextToSpeechService.setCallback(TextToSpeech.this.getCallerIdentity(), null);
                iTextToSpeechService.stop(TextToSpeech.this.getCallerIdentity());
                TextToSpeech.this.mServiceConnection.disconnect();
                TextToSpeech.access$202(TextToSpeech.this, null);
                TextToSpeech.access$302(TextToSpeech.this, null);
                return null;
            }
        }, null, "shutdown", false);
    }

    public int speak(final CharSequence charSequence, final int n, final Bundle bundle, final String string2) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                Uri uri = (Uri)TextToSpeech.this.mUtterances.get(charSequence);
                if (uri != null) {
                    return iTextToSpeechService.playAudio(TextToSpeech.this.getCallerIdentity(), uri, n, TextToSpeech.this.getParams(bundle), string2);
                }
                return iTextToSpeechService.speak(TextToSpeech.this.getCallerIdentity(), charSequence, n, TextToSpeech.this.getParams(bundle), string2);
            }
        }, -1, "speak");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public int speak(String string2, int n, HashMap<String, String> hashMap) {
        String string3;
        Bundle bundle = this.convertParamsHashMaptoBundle(hashMap);
        if (hashMap == null) {
            string3 = null;
            return this.speak(string2, n, bundle, string3);
        }
        string3 = hashMap.get("utteranceId");
        return this.speak(string2, n, bundle, string3);
    }

    public int stop() {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return iTextToSpeechService.stop(TextToSpeech.this.getCallerIdentity());
            }
        }, -1, "stop");
    }

    public int synthesizeToFile(final CharSequence charSequence, final Bundle bundle, final File file, final String string2) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                try {
                    if (file.exists() && !file.canWrite()) {
                        Log.e(TextToSpeech.TAG, "Can't write to " + file);
                        return -1;
                    }
                    ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open(file, 0x2C000000);
                    int n = iTextToSpeechService.synthesizeToFileDescriptor(TextToSpeech.this.getCallerIdentity(), charSequence, parcelFileDescriptor, TextToSpeech.this.getParams(bundle), string2);
                    parcelFileDescriptor.close();
                    Integer n2 = n;
                    return n2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.e(TextToSpeech.TAG, "Opening file " + file + " failed", fileNotFoundException);
                    return -1;
                }
                catch (IOException iOException) {
                    Log.e(TextToSpeech.TAG, "Closing file " + file + " failed", iOException);
                    return -1;
                }
            }
        }, -1, "synthesizeToFile");
    }

    @Deprecated
    public int synthesizeToFile(String string2, HashMap<String, String> hashMap, String string3) {
        return this.synthesizeToFile(string2, this.convertParamsHashMaptoBundle(hashMap), new File(string3), hashMap.get("utteranceId"));
    }

    private static interface Action<R> {
        public R run(ITextToSpeechService var1) throws RemoteException;
    }

    private class Connection
    implements ServiceConnection {
        private final ITextToSpeechCallback.Stub mCallback = new ITextToSpeechCallback.Stub(){

            @Override
            public void onError(String string2, int n) {
                UtteranceProgressListener utteranceProgressListener = TextToSpeech.this.mUtteranceProgressListener;
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onError(string2);
                }
            }

            @Override
            public void onStart(String string2) {
                UtteranceProgressListener utteranceProgressListener = TextToSpeech.this.mUtteranceProgressListener;
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onStart(string2);
                }
            }

            @Override
            public void onStop(String string2) throws RemoteException {
                UtteranceProgressListener utteranceProgressListener = TextToSpeech.this.mUtteranceProgressListener;
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onDone(string2);
                }
            }

            @Override
            public void onSuccess(String string2) {
                UtteranceProgressListener utteranceProgressListener = TextToSpeech.this.mUtteranceProgressListener;
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onDone(string2);
                }
            }
        };
        private boolean mEstablished;
        private SetupConnectionAsyncTask mOnSetupConnectionAsyncTask;
        private ITextToSpeechService mService;

        private Connection() {
        }

        static /* synthetic */ SetupConnectionAsyncTask access$1202(Connection connection, SetupConnectionAsyncTask setupConnectionAsyncTask) {
            connection.mOnSetupConnectionAsyncTask = setupConnectionAsyncTask;
            return setupConnectionAsyncTask;
        }

        static /* synthetic */ boolean access$1302(Connection connection, boolean bl) {
            connection.mEstablished = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean clearServiceConnection() {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                SetupConnectionAsyncTask setupConnectionAsyncTask = this.mOnSetupConnectionAsyncTask;
                boolean bl = false;
                if (setupConnectionAsyncTask != null) {
                    bl = this.mOnSetupConnectionAsyncTask.cancel(false);
                    this.mOnSetupConnectionAsyncTask = null;
                }
                this.mService = null;
                if (TextToSpeech.this.mServiceConnection == this) {
                    TextToSpeech.access$202(TextToSpeech.this, null);
                }
                return bl;
            }
        }

        public void disconnect() {
            TextToSpeech.this.mContext.unbindService(this);
            this.clearServiceConnection();
        }

        public IBinder getCallerIdentity() {
            return this.mCallback;
        }

        public boolean isEstablished() {
            return this.mService != null && this.mEstablished;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                TextToSpeech.access$1502(TextToSpeech.this, null);
                Log.i(TextToSpeech.TAG, "Connected to " + componentName);
                if (this.mOnSetupConnectionAsyncTask != null) {
                    this.mOnSetupConnectionAsyncTask.cancel(false);
                }
                this.mService = ITextToSpeechService.Stub.asInterface(iBinder);
                TextToSpeech.access$202(TextToSpeech.this, this);
                this.mEstablished = false;
                this.mOnSetupConnectionAsyncTask = new SetupConnectionAsyncTask(componentName);
                this.mOnSetupConnectionAsyncTask.execute(new Void[0]);
                return;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Log.i(TextToSpeech.TAG, "Asked to disconnect from " + componentName);
            if (this.clearServiceConnection()) {
                TextToSpeech.this.dispatchOnInit(-1);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <R> R runAction(Action<R> action, R r, String string2, boolean bl, boolean bl2) {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                R r2;
                try {
                    if (this.mService == null) {
                        Log.w(TextToSpeech.TAG, string2 + " failed: not connected to TTS engine");
                        return r;
                    }
                    if (bl2 && !this.isEstablished()) {
                        Log.w(TextToSpeech.TAG, string2 + " failed: TTS engine connection not fully set up");
                        return r;
                    }
                }
                catch (RemoteException remoteException) {
                    Log.e(TextToSpeech.TAG, string2 + " failed", remoteException);
                    if (!bl) return r;
                    this.disconnect();
                    TextToSpeech.this.initTts();
                    return r;
                }
                {
                    r2 = action.run(this.mService);
                }
                return r2;
            }
        }

        private class SetupConnectionAsyncTask
        extends AsyncTask<Void, Void, Integer> {
            private final ComponentName mName;

            public SetupConnectionAsyncTask(ComponentName componentName) {
                this.mName = componentName;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Integer doInBackground(Void ... voidArray) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    try {
                        Connection.this.mService.setCallback(Connection.this.getCallerIdentity(), Connection.this.mCallback);
                        if (TextToSpeech.this.mParams.getString("language") == null) {
                            String[] stringArray = Connection.this.mService.getClientDefaultLanguage();
                            TextToSpeech.this.mParams.putString("language", stringArray[0]);
                            TextToSpeech.this.mParams.putString("country", stringArray[1]);
                            TextToSpeech.this.mParams.putString("variant", stringArray[2]);
                            String string2 = Connection.this.mService.getDefaultVoiceNameFor(stringArray[0], stringArray[1], stringArray[2]);
                            TextToSpeech.this.mParams.putString("voiceName", string2);
                        }
                        Log.i(TextToSpeech.TAG, "Set up connection to " + this.mName);
                        return 0;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TextToSpeech.TAG, "Error connecting to service, setCallback() failed");
                        return -1;
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void onPostExecute(Integer n) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    if (Connection.this.mOnSetupConnectionAsyncTask == this) {
                        Connection.access$1202(Connection.this, null);
                    }
                    Connection.access$1302(Connection.this, true);
                    TextToSpeech.this.dispatchOnInit(n);
                    return;
                }
            }
        }
    }

    public class Engine {
        public static final String ACTION_CHECK_TTS_DATA = "android.speech.tts.engine.CHECK_TTS_DATA";
        public static final String ACTION_GET_SAMPLE_TEXT = "android.speech.tts.engine.GET_SAMPLE_TEXT";
        public static final String ACTION_INSTALL_TTS_DATA = "android.speech.tts.engine.INSTALL_TTS_DATA";
        public static final String ACTION_TTS_DATA_INSTALLED = "android.speech.tts.engine.TTS_DATA_INSTALLED";
        @Deprecated
        public static final int CHECK_VOICE_DATA_BAD_DATA = -1;
        public static final int CHECK_VOICE_DATA_FAIL = 0;
        @Deprecated
        public static final int CHECK_VOICE_DATA_MISSING_DATA = -2;
        @Deprecated
        public static final int CHECK_VOICE_DATA_MISSING_VOLUME = -3;
        public static final int CHECK_VOICE_DATA_PASS = 1;
        @Deprecated
        public static final String DEFAULT_ENGINE = "com.svox.pico";
        public static final float DEFAULT_PAN = 0.0f;
        public static final int DEFAULT_PITCH = 100;
        public static final int DEFAULT_RATE = 100;
        public static final int DEFAULT_STREAM = 3;
        public static final float DEFAULT_VOLUME = 1.0f;
        public static final String EXTRA_AVAILABLE_VOICES = "availableVoices";
        @Deprecated
        public static final String EXTRA_CHECK_VOICE_DATA_FOR = "checkVoiceDataFor";
        public static final String EXTRA_SAMPLE_TEXT = "sampleText";
        @Deprecated
        public static final String EXTRA_TTS_DATA_INSTALLED = "dataInstalled";
        public static final String EXTRA_UNAVAILABLE_VOICES = "unavailableVoices";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_FILES = "dataFiles";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_FILES_INFO = "dataFilesInfo";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_ROOT_DIRECTORY = "dataRoot";
        public static final String INTENT_ACTION_TTS_SERVICE = "android.intent.action.TTS_SERVICE";
        @Deprecated
        public static final String KEY_FEATURE_EMBEDDED_SYNTHESIS = "embeddedTts";
        public static final String KEY_FEATURE_NETWORK_RETRIES_COUNT = "networkRetriesCount";
        @Deprecated
        public static final String KEY_FEATURE_NETWORK_SYNTHESIS = "networkTts";
        public static final String KEY_FEATURE_NETWORK_TIMEOUT_MS = "networkTimeoutMs";
        public static final String KEY_FEATURE_NOT_INSTALLED = "notInstalled";
        public static final String KEY_PARAM_AUDIO_ATTRIBUTES = "audioAttributes";
        public static final String KEY_PARAM_COUNTRY = "country";
        public static final String KEY_PARAM_ENGINE = "engine";
        public static final String KEY_PARAM_LANGUAGE = "language";
        public static final String KEY_PARAM_PAN = "pan";
        public static final String KEY_PARAM_PITCH = "pitch";
        public static final String KEY_PARAM_RATE = "rate";
        public static final String KEY_PARAM_SESSION_ID = "sessionId";
        public static final String KEY_PARAM_STREAM = "streamType";
        public static final String KEY_PARAM_UTTERANCE_ID = "utteranceId";
        public static final String KEY_PARAM_VARIANT = "variant";
        public static final String KEY_PARAM_VOICE_NAME = "voiceName";
        public static final String KEY_PARAM_VOLUME = "volume";
        public static final String SERVICE_META_DATA = "android.speech.tts";
        public static final int USE_DEFAULTS;
    }

    public static class EngineInfo {
        public int icon;
        public String label;
        public String name;
        public int priority;
        public boolean system;

        public String toString() {
            return "EngineInfo{name=" + this.name + "}";
        }
    }

    public static interface OnInitListener {
        public void onInit(int var1);
    }

    @Deprecated
    public static interface OnUtteranceCompletedListener {
        public void onUtteranceCompleted(String var1);
    }
}

