/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.Context;
import java.security.KeyStore;

public final class KeyStoreParameter
implements KeyStore.ProtectionParameter {
    private int mFlags;

    private KeyStoreParameter(int n) {
        this.mFlags = n;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean isEncryptionRequired() {
        return (1 & this.mFlags) != 0;
    }

    public static final class Builder {
        private int mFlags;

        public Builder(Context context) {
            if (context == null) {
                throw new NullPointerException("context == null");
            }
        }

        public KeyStoreParameter build() {
            return new KeyStoreParameter(this.mFlags);
        }

        public Builder setEncryptionRequired(boolean bl) {
            if (bl) {
                this.mFlags = 1 | this.mFlags;
                return this;
            }
            this.mFlags = 0xFFFFFFFE & this.mFlags;
            return this;
        }
    }
}

