/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.Context;
import android.security.KeyStore;
import android.text.TextUtils;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public final class KeyPairGeneratorSpec
implements AlgorithmParameterSpec {
    private static final int DSA_DEFAULT_KEY_SIZE = 1024;
    private static final int DSA_MAX_KEY_SIZE = 8192;
    private static final int DSA_MIN_KEY_SIZE = 512;
    private static final int EC_DEFAULT_KEY_SIZE = 256;
    private static final int EC_MAX_KEY_SIZE = 521;
    private static final int EC_MIN_KEY_SIZE = 192;
    private static final int RSA_DEFAULT_KEY_SIZE = 2048;
    private static final int RSA_MAX_KEY_SIZE = 8192;
    private static final int RSA_MIN_KEY_SIZE = 512;
    private final Context mContext;
    private final Date mEndDate;
    private final int mFlags;
    private final int mKeySize;
    private final String mKeyType;
    private final String mKeystoreAlias;
    private final BigInteger mSerialNumber;
    private final AlgorithmParameterSpec mSpec;
    private final Date mStartDate;
    private final X500Principal mSubjectDN;

    public KeyPairGeneratorSpec(Context context, String string2, String string3, int n, AlgorithmParameterSpec algorithmParameterSpec, X500Principal x500Principal, BigInteger bigInteger, Date date, Date date2, int n2) {
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("keyStoreAlias must not be empty");
        }
        if (x500Principal == null) {
            throw new IllegalArgumentException("subjectDN == null");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("serialNumber == null");
        }
        if (date == null) {
            throw new IllegalArgumentException("startDate == null");
        }
        if (date2 == null) {
            throw new IllegalArgumentException("endDate == null");
        }
        if (date2.before(date)) {
            throw new IllegalArgumentException("endDate < startDate");
        }
        int n3 = KeyStore.getKeyTypeForAlgorithm(string3);
        if (n == -1) {
            n = KeyPairGeneratorSpec.getDefaultKeySizeForType(n3);
        }
        KeyPairGeneratorSpec.checkCorrectParametersSpec(n3, n, algorithmParameterSpec);
        KeyPairGeneratorSpec.checkValidKeySize(n3, n);
        this.mContext = context;
        this.mKeystoreAlias = string2;
        this.mKeyType = string3;
        this.mKeySize = n;
        this.mSpec = algorithmParameterSpec;
        this.mSubjectDN = x500Principal;
        this.mSerialNumber = bigInteger;
        this.mStartDate = date;
        this.mEndDate = date2;
        this.mFlags = n2;
    }

    private static void checkCorrectParametersSpec(int n, int n2, AlgorithmParameterSpec algorithmParameterSpec) {
        if (n == 116 && algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new IllegalArgumentException("DSA keys must have DSAParameterSpec specified");
            }
        } else if (n == 6 && algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof RSAKeyGenParameterSpec) {
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
                if (n2 != -1 && n2 != rSAKeyGenParameterSpec.getKeysize()) {
                    throw new IllegalArgumentException("RSA key size must match: " + n2 + " vs " + rSAKeyGenParameterSpec.getKeysize());
                }
            } else {
                throw new IllegalArgumentException("RSA may only use RSAKeyGenParameterSpec");
            }
        }
    }

    private static void checkValidKeySize(int n, int n2) {
        if (n == 116) {
            if (n2 < 512 || n2 > 8192) {
                throw new IllegalArgumentException("DSA keys must be >= 512 and <= 8192");
            }
        } else if (n == 408) {
            if (n2 < 192 || n2 > 521) {
                throw new IllegalArgumentException("EC keys must be >= 192 and <= 521");
            }
        } else if (n == 6) {
            if (n2 < 512 || n2 > 8192) {
                throw new IllegalArgumentException("RSA keys must be >= 512 and <= 8192");
            }
        } else {
            throw new IllegalArgumentException("Invalid key type " + n);
        }
    }

    private static int getDefaultKeySizeForType(int n) {
        if (n == 116) {
            return 1024;
        }
        if (n == 408) {
            return 256;
        }
        if (n == 6) {
            return 2048;
        }
        throw new IllegalArgumentException("Invalid key type " + n);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.mSpec;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Date getEndDate() {
        return this.mEndDate;
    }

    int getFlags() {
        return this.mFlags;
    }

    public int getKeySize() {
        return this.mKeySize;
    }

    public String getKeyType() {
        return this.mKeyType;
    }

    public String getKeystoreAlias() {
        return this.mKeystoreAlias;
    }

    public BigInteger getSerialNumber() {
        return this.mSerialNumber;
    }

    public Date getStartDate() {
        return this.mStartDate;
    }

    public X500Principal getSubjectDN() {
        return this.mSubjectDN;
    }

    public boolean isEncryptionRequired() {
        return (1 & this.mFlags) != 0;
    }

    public static final class Builder {
        private final Context mContext;
        private Date mEndDate;
        private int mFlags;
        private int mKeySize = -1;
        private String mKeyType = "RSA";
        private String mKeystoreAlias;
        private BigInteger mSerialNumber;
        private AlgorithmParameterSpec mSpec;
        private Date mStartDate;
        private X500Principal mSubjectDN;

        public Builder(Context context) {
            if (context == null) {
                throw new NullPointerException("context == null");
            }
            this.mContext = context;
        }

        public KeyPairGeneratorSpec build() {
            return new KeyPairGeneratorSpec(this.mContext, this.mKeystoreAlias, this.mKeyType, this.mKeySize, this.mSpec, this.mSubjectDN, this.mSerialNumber, this.mStartDate, this.mEndDate, this.mFlags);
        }

        public Builder setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec == null) {
                throw new NullPointerException("spec == null");
            }
            this.mSpec = algorithmParameterSpec;
            return this;
        }

        public Builder setAlias(String string2) {
            if (string2 == null) {
                throw new NullPointerException("alias == null");
            }
            this.mKeystoreAlias = string2;
            return this;
        }

        public Builder setEncryptionRequired() {
            this.mFlags = 1 | this.mFlags;
            return this;
        }

        public Builder setEndDate(Date date) {
            if (date == null) {
                throw new NullPointerException("endDate == null");
            }
            this.mEndDate = date;
            return this;
        }

        public Builder setKeySize(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("keySize < 0");
            }
            this.mKeySize = n;
            return this;
        }

        public Builder setKeyType(String string2) throws NoSuchAlgorithmException {
            if (string2 == null) {
                throw new NullPointerException("keyType == null");
            }
            try {
                KeyStore.getKeyTypeForAlgorithm(string2);
                this.mKeyType = string2;
                return this;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new NoSuchAlgorithmException("Unsupported key type: " + string2);
            }
        }

        public Builder setSerialNumber(BigInteger bigInteger) {
            if (bigInteger == null) {
                throw new NullPointerException("serialNumber == null");
            }
            this.mSerialNumber = bigInteger;
            return this;
        }

        public Builder setStartDate(Date date) {
            if (date == null) {
                throw new NullPointerException("startDate == null");
            }
            this.mStartDate = date;
            return this;
        }

        public Builder setSubject(X500Principal x500Principal) {
            if (x500Principal == null) {
                throw new NullPointerException("subject == null");
            }
            this.mSubjectDN = x500Principal;
            return this;
        }
    }
}

