/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.renderscript.RenderScriptGL;
import android.util.AttributeSet;
import android.view.TextureView;

public class RSTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private RenderScriptGL mRS;
    private SurfaceTexture mSurfaceTexture;

    public RSTextureView(Context context) {
        super(context);
        this.init();
    }

    public RSTextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    private void init() {
        this.setSurfaceTextureListener(this);
    }

    public RenderScriptGL createRenderScriptGL(RenderScriptGL.SurfaceConfig surfaceConfig) {
        RenderScriptGL renderScriptGL = new RenderScriptGL(this.getContext(), surfaceConfig);
        this.setRenderScriptGL(renderScriptGL);
        if (this.mSurfaceTexture != null) {
            this.mRS.setSurfaceTexture(this.mSurfaceTexture, this.getWidth(), this.getHeight());
        }
        return renderScriptGL;
    }

    public void destroyRenderScriptGL() {
        this.mRS.destroy();
        this.mRS = null;
    }

    public RenderScriptGL getRenderScriptGL() {
        return this.mRS;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        this.mSurfaceTexture = surfaceTexture;
        if (this.mRS != null) {
            this.mRS.setSurfaceTexture(this.mSurfaceTexture, n, n2);
        }
    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.mSurfaceTexture = surfaceTexture;
        if (this.mRS != null) {
            this.mRS.setSurfaceTexture(null, 0, 0);
        }
        return true;
    }

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        this.mSurfaceTexture = surfaceTexture;
        if (this.mRS != null) {
            this.mRS.setSurfaceTexture(this.mSurfaceTexture, n, n2);
        }
    }

    @Override
    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.mSurfaceTexture = surfaceTexture;
    }

    public void pause() {
        if (this.mRS != null) {
            this.mRS.pause();
        }
    }

    public void resume() {
        if (this.mRS != null) {
            this.mRS.resume();
        }
    }

    public void setRenderScriptGL(RenderScriptGL renderScriptGL) {
        this.mRS = renderScriptGL;
        if (this.mSurfaceTexture != null) {
            this.mRS.setSurfaceTexture(this.mSurfaceTexture, this.getWidth(), this.getHeight());
        }
    }
}

