/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.Matrix4f;
import android.renderscript.Program;
import android.renderscript.ProgramVertex;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class ProgramVertexFixedFunction
extends ProgramVertex {
    ProgramVertexFixedFunction(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public void bindConstants(Constants constants) {
        this.mRS.validate();
        this.bindConstants(constants.getAllocation(), 0);
    }

    public static class Builder {
        RenderScript mRS;
        String mShader;
        boolean mTextureMatrixEnable;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void buildShaderString() {
            this.mShader = "//rs_shader_internal\n";
            this.mShader = this.mShader + "varying vec4 varColor;\n";
            this.mShader = this.mShader + "varying vec2 varTex0;\n";
            this.mShader = this.mShader + "void main() {\n";
            this.mShader = this.mShader + "  gl_Position = UNI_MVP * ATTRIB_position;\n";
            this.mShader = this.mShader + "  gl_PointSize = 1.0;\n";
            this.mShader = this.mShader + "  varColor = ATTRIB_color;\n";
            this.mShader = this.mTextureMatrixEnable ? this.mShader + "  varTex0 = (UNI_TexMatrix * vec4(ATTRIB_texture0, 0.0, 1.0)).xy;\n" : this.mShader + "  varTex0 = ATTRIB_texture0;\n";
            this.mShader = this.mShader + "}\n";
        }

        static Type getConstantInputType(RenderScript renderScript) {
            Element.Builder builder = new Element.Builder(renderScript);
            builder.add(Element.MATRIX4X4(renderScript), "MV");
            builder.add(Element.MATRIX4X4(renderScript), "P");
            builder.add(Element.MATRIX4X4(renderScript), "TexMatrix");
            builder.add(Element.MATRIX4X4(renderScript), "MVP");
            Type.Builder builder2 = new Type.Builder(renderScript, builder.create());
            builder2.setX(1);
            return builder2.create();
        }

        public ProgramVertexFixedFunction create() {
            this.buildShaderString();
            InternalBuilder internalBuilder = new InternalBuilder(this.mRS);
            internalBuilder.setShader(this.mShader);
            internalBuilder.addConstant(Builder.getConstantInputType(this.mRS));
            Element.Builder builder = new Element.Builder(this.mRS);
            builder.add(Element.F32_4(this.mRS), "position");
            builder.add(Element.F32_4(this.mRS), "color");
            builder.add(Element.F32_3(this.mRS), "normal");
            builder.add(Element.F32_2(this.mRS), "texture0");
            internalBuilder.addInput(builder.create());
            return internalBuilder.create();
        }

        public Builder setTextureMatrixEnable(boolean bl) {
            this.mTextureMatrixEnable = bl;
            return this;
        }
    }

    public static class Constants {
        static final int MODELVIEW_OFFSET = 0;
        static final int PROJECTION_OFFSET = 16;
        static final int TEXTURE_OFFSET = 32;
        Allocation mAlloc;
        private FieldPacker mIOBuffer;
        Matrix4f mModel;
        Matrix4f mProjection;
        Matrix4f mTexture;

        public Constants(RenderScript renderScript) {
            Type type = Builder.getConstantInputType(renderScript);
            this.mAlloc = Allocation.createTyped(renderScript, type);
            this.mIOBuffer = new FieldPacker(type.getElement().getBytesSize() * type.getCount());
            this.mModel = new Matrix4f();
            this.mProjection = new Matrix4f();
            this.mTexture = new Matrix4f();
            this.setModelview(new Matrix4f());
            this.setProjection(new Matrix4f());
            this.setTexture(new Matrix4f());
        }

        private void addToBuffer(int n, Matrix4f matrix4f) {
            this.mIOBuffer.reset(n);
            for (int i = 0; i < 16; ++i) {
                this.mIOBuffer.addF32(matrix4f.mMat[i]);
            }
            this.mIOBuffer.reset(this.mIOBuffer.getData().length);
            this.mAlloc.setFromFieldPacker(0, this.mIOBuffer);
        }

        public void destroy() {
            this.mAlloc.destroy();
            this.mAlloc = null;
        }

        Allocation getAllocation() {
            return this.mAlloc;
        }

        public void setModelview(Matrix4f matrix4f) {
            this.mModel.load(matrix4f);
            this.addToBuffer(0, matrix4f);
        }

        public void setProjection(Matrix4f matrix4f) {
            this.mProjection.load(matrix4f);
            this.addToBuffer(64, matrix4f);
        }

        public void setTexture(Matrix4f matrix4f) {
            this.mTexture.load(matrix4f);
            this.addToBuffer(128, matrix4f);
        }
    }

    static class InternalBuilder
    extends Program.BaseProgramBuilder {
        public InternalBuilder(RenderScript renderScript) {
            super(renderScript);
        }

        public InternalBuilder addInput(Element element) throws IllegalStateException {
            if (this.mInputCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (element.isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            Element[] elementArray = this.mInputs;
            int n = this.mInputCount;
            this.mInputCount = n + 1;
            elementArray[n] = element;
            return this;
        }

        public ProgramVertexFixedFunction create() {
            this.mRS.validate();
            long[] lArray = new long[2 * (this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount)];
            String[] stringArray = new String[this.mTextureCount];
            int n = 0;
            for (int i = 0; i < this.mInputCount; ++i) {
                int n2 = n + 1;
                lArray[n] = Program.ProgramParam.INPUT.mID;
                n = n2 + 1;
                lArray[n2] = this.mInputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mOutputCount; ++i) {
                int n3 = n + 1;
                lArray[n] = Program.ProgramParam.OUTPUT.mID;
                n = n3 + 1;
                lArray[n3] = this.mOutputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mConstantCount; ++i) {
                int n4 = n + 1;
                lArray[n] = Program.ProgramParam.CONSTANT.mID;
                n = n4 + 1;
                lArray[n4] = this.mConstants[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mTextureCount; ++i) {
                int n5 = n + 1;
                lArray[n] = Program.ProgramParam.TEXTURE_TYPE.mID;
                n = n5 + 1;
                lArray[n5] = this.mTextureTypes[i].mID;
                stringArray[i] = this.mTextureNames[i];
            }
            ProgramVertexFixedFunction programVertexFixedFunction = new ProgramVertexFixedFunction(this.mRS.nProgramVertexCreate(this.mShader, stringArray, lArray), this.mRS);
            this.initProgram(programVertexFixedFunction);
            return programVertexFixedFunction;
        }
    }
}

