/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class ProgramStore
extends BaseObj {
    BlendDstFunc mBlendDst;
    BlendSrcFunc mBlendSrc;
    boolean mColorMaskA;
    boolean mColorMaskB;
    boolean mColorMaskG;
    boolean mColorMaskR;
    DepthFunc mDepthFunc;
    boolean mDepthMask;
    boolean mDither;

    ProgramStore(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public static ProgramStore BLEND_ALPHA_DEPTH_NONE(RenderScript renderScript) {
        if (renderScript.mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH == null) {
            Builder builder = new Builder(renderScript);
            builder.setDepthFunc(DepthFunc.ALWAYS);
            builder.setBlendFunc(BlendSrcFunc.SRC_ALPHA, BlendDstFunc.ONE_MINUS_SRC_ALPHA);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(false);
            renderScript.mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH = builder.create();
        }
        return renderScript.mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    }

    public static ProgramStore BLEND_ALPHA_DEPTH_TEST(RenderScript renderScript) {
        if (renderScript.mProgramStore_BLEND_ALPHA_DEPTH_TEST == null) {
            Builder builder = new Builder(renderScript);
            builder.setDepthFunc(DepthFunc.LESS);
            builder.setBlendFunc(BlendSrcFunc.SRC_ALPHA, BlendDstFunc.ONE_MINUS_SRC_ALPHA);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(true);
            renderScript.mProgramStore_BLEND_ALPHA_DEPTH_TEST = builder.create();
        }
        return renderScript.mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    }

    public static ProgramStore BLEND_NONE_DEPTH_NONE(RenderScript renderScript) {
        if (renderScript.mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH == null) {
            Builder builder = new Builder(renderScript);
            builder.setDepthFunc(DepthFunc.ALWAYS);
            builder.setBlendFunc(BlendSrcFunc.ONE, BlendDstFunc.ZERO);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(false);
            renderScript.mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH = builder.create();
        }
        return renderScript.mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    }

    public static ProgramStore BLEND_NONE_DEPTH_TEST(RenderScript renderScript) {
        if (renderScript.mProgramStore_BLEND_NONE_DEPTH_TEST == null) {
            Builder builder = new Builder(renderScript);
            builder.setDepthFunc(DepthFunc.LESS);
            builder.setBlendFunc(BlendSrcFunc.ONE, BlendDstFunc.ZERO);
            builder.setDitherEnabled(false);
            builder.setDepthMaskEnabled(true);
            renderScript.mProgramStore_BLEND_NONE_DEPTH_TEST = builder.create();
        }
        return renderScript.mProgramStore_BLEND_NONE_DEPTH_TEST;
    }

    public BlendDstFunc getBlendDstFunc() {
        return this.mBlendDst;
    }

    public BlendSrcFunc getBlendSrcFunc() {
        return this.mBlendSrc;
    }

    public DepthFunc getDepthFunc() {
        return this.mDepthFunc;
    }

    public boolean isColorMaskAlphaEnabled() {
        return this.mColorMaskA;
    }

    public boolean isColorMaskBlueEnabled() {
        return this.mColorMaskB;
    }

    public boolean isColorMaskGreenEnabled() {
        return this.mColorMaskG;
    }

    public boolean isColorMaskRedEnabled() {
        return this.mColorMaskR;
    }

    public boolean isDepthMaskEnabled() {
        return this.mDepthMask;
    }

    public boolean isDitherEnabled() {
        return this.mDither;
    }

    public static final class BlendDstFunc
    extends Enum<BlendDstFunc> {
        private static final /* synthetic */ BlendDstFunc[] $VALUES;
        public static final /* enum */ BlendDstFunc DST_ALPHA;
        public static final /* enum */ BlendDstFunc ONE;
        public static final /* enum */ BlendDstFunc ONE_MINUS_DST_ALPHA;
        public static final /* enum */ BlendDstFunc ONE_MINUS_SRC_ALPHA;
        public static final /* enum */ BlendDstFunc ONE_MINUS_SRC_COLOR;
        public static final /* enum */ BlendDstFunc SRC_ALPHA;
        public static final /* enum */ BlendDstFunc SRC_COLOR;
        public static final /* enum */ BlendDstFunc ZERO;
        int mID;

        static {
            ZERO = new BlendDstFunc(0);
            ONE = new BlendDstFunc(1);
            SRC_COLOR = new BlendDstFunc(2);
            ONE_MINUS_SRC_COLOR = new BlendDstFunc(3);
            SRC_ALPHA = new BlendDstFunc(4);
            ONE_MINUS_SRC_ALPHA = new BlendDstFunc(5);
            DST_ALPHA = new BlendDstFunc(6);
            ONE_MINUS_DST_ALPHA = new BlendDstFunc(7);
            BlendDstFunc[] blendDstFuncArray = new BlendDstFunc[]{ZERO, ONE, SRC_COLOR, ONE_MINUS_SRC_COLOR, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, DST_ALPHA, ONE_MINUS_DST_ALPHA};
            $VALUES = blendDstFuncArray;
        }

        private BlendDstFunc(int n2) {
            this.mID = n2;
        }

        public static BlendDstFunc valueOf(String string2) {
            return Enum.valueOf(BlendDstFunc.class, string2);
        }

        public static BlendDstFunc[] values() {
            return (BlendDstFunc[])$VALUES.clone();
        }
    }

    public static final class BlendSrcFunc
    extends Enum<BlendSrcFunc> {
        private static final /* synthetic */ BlendSrcFunc[] $VALUES;
        public static final /* enum */ BlendSrcFunc DST_ALPHA;
        public static final /* enum */ BlendSrcFunc DST_COLOR;
        public static final /* enum */ BlendSrcFunc ONE;
        public static final /* enum */ BlendSrcFunc ONE_MINUS_DST_ALPHA;
        public static final /* enum */ BlendSrcFunc ONE_MINUS_DST_COLOR;
        public static final /* enum */ BlendSrcFunc ONE_MINUS_SRC_ALPHA;
        public static final /* enum */ BlendSrcFunc SRC_ALPHA;
        public static final /* enum */ BlendSrcFunc SRC_ALPHA_SATURATE;
        public static final /* enum */ BlendSrcFunc ZERO;
        int mID;

        static {
            ZERO = new BlendSrcFunc(0);
            ONE = new BlendSrcFunc(1);
            DST_COLOR = new BlendSrcFunc(2);
            ONE_MINUS_DST_COLOR = new BlendSrcFunc(3);
            SRC_ALPHA = new BlendSrcFunc(4);
            ONE_MINUS_SRC_ALPHA = new BlendSrcFunc(5);
            DST_ALPHA = new BlendSrcFunc(6);
            ONE_MINUS_DST_ALPHA = new BlendSrcFunc(7);
            SRC_ALPHA_SATURATE = new BlendSrcFunc(8);
            BlendSrcFunc[] blendSrcFuncArray = new BlendSrcFunc[]{ZERO, ONE, DST_COLOR, ONE_MINUS_DST_COLOR, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, DST_ALPHA, ONE_MINUS_DST_ALPHA, SRC_ALPHA_SATURATE};
            $VALUES = blendSrcFuncArray;
        }

        private BlendSrcFunc(int n2) {
            this.mID = n2;
        }

        public static BlendSrcFunc valueOf(String string2) {
            return Enum.valueOf(BlendSrcFunc.class, string2);
        }

        public static BlendSrcFunc[] values() {
            return (BlendSrcFunc[])$VALUES.clone();
        }
    }

    public static class Builder {
        BlendDstFunc mBlendDst;
        BlendSrcFunc mBlendSrc;
        boolean mColorMaskA;
        boolean mColorMaskB;
        boolean mColorMaskG;
        boolean mColorMaskR;
        DepthFunc mDepthFunc;
        boolean mDepthMask;
        boolean mDither;
        RenderScript mRS;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mDepthFunc = DepthFunc.ALWAYS;
            this.mDepthMask = false;
            this.mColorMaskR = true;
            this.mColorMaskG = true;
            this.mColorMaskB = true;
            this.mColorMaskA = true;
            this.mBlendSrc = BlendSrcFunc.ONE;
            this.mBlendDst = BlendDstFunc.ZERO;
        }

        public ProgramStore create() {
            this.mRS.validate();
            ProgramStore programStore = new ProgramStore(this.mRS.nProgramStoreCreate(this.mColorMaskR, this.mColorMaskG, this.mColorMaskB, this.mColorMaskA, this.mDepthMask, this.mDither, this.mBlendSrc.mID, this.mBlendDst.mID, this.mDepthFunc.mID), this.mRS);
            programStore.mDepthFunc = this.mDepthFunc;
            programStore.mDepthMask = this.mDepthMask;
            programStore.mColorMaskR = this.mColorMaskR;
            programStore.mColorMaskG = this.mColorMaskG;
            programStore.mColorMaskB = this.mColorMaskB;
            programStore.mColorMaskA = this.mColorMaskA;
            programStore.mBlendSrc = this.mBlendSrc;
            programStore.mBlendDst = this.mBlendDst;
            programStore.mDither = this.mDither;
            return programStore;
        }

        public Builder setBlendFunc(BlendSrcFunc blendSrcFunc, BlendDstFunc blendDstFunc) {
            this.mBlendSrc = blendSrcFunc;
            this.mBlendDst = blendDstFunc;
            return this;
        }

        public Builder setColorMaskEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.mColorMaskR = bl;
            this.mColorMaskG = bl2;
            this.mColorMaskB = bl3;
            this.mColorMaskA = bl4;
            return this;
        }

        public Builder setDepthFunc(DepthFunc depthFunc) {
            this.mDepthFunc = depthFunc;
            return this;
        }

        public Builder setDepthMaskEnabled(boolean bl) {
            this.mDepthMask = bl;
            return this;
        }

        public Builder setDitherEnabled(boolean bl) {
            this.mDither = bl;
            return this;
        }
    }

    public static final class DepthFunc
    extends Enum<DepthFunc> {
        private static final /* synthetic */ DepthFunc[] $VALUES;
        public static final /* enum */ DepthFunc ALWAYS = new DepthFunc(0);
        public static final /* enum */ DepthFunc EQUAL;
        public static final /* enum */ DepthFunc GREATER;
        public static final /* enum */ DepthFunc GREATER_OR_EQUAL;
        public static final /* enum */ DepthFunc LESS;
        public static final /* enum */ DepthFunc LESS_OR_EQUAL;
        public static final /* enum */ DepthFunc NOT_EQUAL;
        int mID;

        static {
            LESS = new DepthFunc(1);
            LESS_OR_EQUAL = new DepthFunc(2);
            GREATER = new DepthFunc(3);
            GREATER_OR_EQUAL = new DepthFunc(4);
            EQUAL = new DepthFunc(5);
            NOT_EQUAL = new DepthFunc(6);
            DepthFunc[] depthFuncArray = new DepthFunc[]{ALWAYS, LESS, LESS_OR_EQUAL, GREATER, GREATER_OR_EQUAL, EQUAL, NOT_EQUAL};
            $VALUES = depthFuncArray;
        }

        private DepthFunc(int n2) {
            this.mID = n2;
        }

        public static DepthFunc valueOf(String string2) {
            return Enum.valueOf(DepthFunc.class, string2);
        }

        public static DepthFunc[] values() {
            return (DepthFunc[])$VALUES.clone();
        }
    }
}

