/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BaseObj {
    private boolean mDestroyed;
    private long mID;
    private String mName;
    RenderScript mRS;

    BaseObj(long l, RenderScript renderScript) {
        renderScript.validate();
        this.mRS = renderScript;
        this.mID = l;
        this.mDestroyed = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void helpDestroy() {
        // MONITORENTER : this
        boolean bl = this.mDestroyed;
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
            this.mDestroyed = true;
        }
        // MONITOREXIT : this
        if (!bl2) return;
        ReentrantReadWriteLock.ReadLock readLock = this.mRS.mRWLock.readLock();
        readLock.lock();
        if (this.mRS.isAlive() && this.mID != 0L) {
            this.mRS.nObjDestroy(this.mID);
        }
        readLock.unlock();
        this.mRS = null;
        this.mID = 0L;
    }

    void checkValid() {
        if (this.mID == 0L) {
            throw new RSIllegalArgumentException("Invalid object.");
        }
    }

    public void destroy() {
        if (this.mDestroyed) {
            throw new RSInvalidStateException("Object already destroyed.");
        }
        this.helpDestroy();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (this == object) break block5;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                BaseObj baseObj = (BaseObj)object;
                if (this.mID != baseObj.mID) break block6;
            }
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.helpDestroy();
        super.finalize();
    }

    long getID(RenderScript renderScript) {
        this.mRS.validate();
        if (this.mDestroyed) {
            throw new RSInvalidStateException("using a destroyed object.");
        }
        if (this.mID == 0L) {
            throw new RSRuntimeException("Internal error: Object id 0.");
        }
        if (renderScript != null && renderScript != this.mRS) {
            throw new RSInvalidStateException("using object with mismatched context.");
        }
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public int hashCode() {
        return (int)(0xFFFFFFFL & this.mID ^ this.mID >> 32);
    }

    void setID(long l) {
        if (this.mID != 0L) {
            throw new RSRuntimeException("Internal Error, reset of object ID.");
        }
        this.mID = l;
    }

    public void setName(String string2) {
        if (string2 == null) {
            throw new RSIllegalArgumentException("setName requires a string of non-zero length.");
        }
        if (string2.length() < 1) {
            throw new RSIllegalArgumentException("setName does not accept a zero length string.");
        }
        if (this.mName != null) {
            throw new RSIllegalArgumentException("setName object already has a name.");
        }
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            this.mRS.nAssignName(this.mID, byArray);
            this.mName = string2;
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    void updateFromNative() {
        this.mRS.validate();
        this.mName = this.mRS.nGetName(this.getID(this.mRS));
    }
}

