/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.AndroidException;
import android.util.Log;
import com.android.internal.widget.ILockSettings;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public final class Settings {
    public static final String ACTION_ACCESSIBILITY_SETTINGS = "android.settings.ACCESSIBILITY_SETTINGS";
    public static final String ACTION_ADD_ACCOUNT = "android.settings.ADD_ACCOUNT_SETTINGS";
    public static final String ACTION_AIRPLANE_MODE_SETTINGS = "android.settings.AIRPLANE_MODE_SETTINGS";
    public static final String ACTION_APN_SETTINGS = "android.settings.APN_SETTINGS";
    public static final String ACTION_APPLICATION_DETAILS_SETTINGS = "android.settings.APPLICATION_DETAILS_SETTINGS";
    public static final String ACTION_APPLICATION_DEVELOPMENT_SETTINGS = "android.settings.APPLICATION_DEVELOPMENT_SETTINGS";
    public static final String ACTION_APPLICATION_SETTINGS = "android.settings.APPLICATION_SETTINGS";
    public static final String ACTION_APP_NOTIFICATION_REDACTION = "android.settings.ACTION_APP_NOTIFICATION_REDACTION";
    public static final String ACTION_APP_NOTIFICATION_SETTINGS = "android.settings.APP_NOTIFICATION_SETTINGS";
    public static final String ACTION_APP_OPS_SETTINGS = "android.settings.APP_OPS_SETTINGS";
    public static final String ACTION_BATTERY_SAVER_SETTINGS = "android.settings.BATTERY_SAVER_SETTINGS";
    public static final String ACTION_BLUETOOTH_SETTINGS = "android.settings.BLUETOOTH_SETTINGS";
    public static final String ACTION_CAPTIONING_SETTINGS = "android.settings.CAPTIONING_SETTINGS";
    public static final String ACTION_CAST_SETTINGS = "android.settings.CAST_SETTINGS";
    public static final String ACTION_CONDITION_PROVIDER_SETTINGS = "android.settings.ACTION_CONDITION_PROVIDER_SETTINGS";
    public static final String ACTION_DATA_ROAMING_SETTINGS = "android.settings.DATA_ROAMING_SETTINGS";
    public static final String ACTION_DATE_SETTINGS = "android.settings.DATE_SETTINGS";
    public static final String ACTION_DEVICE_INFO_SETTINGS = "android.settings.DEVICE_INFO_SETTINGS";
    public static final String ACTION_DISPLAY_SETTINGS = "android.settings.DISPLAY_SETTINGS";
    public static final String ACTION_DREAM_SETTINGS = "android.settings.DREAM_SETTINGS";
    public static final String ACTION_HOME_SETTINGS = "android.settings.HOME_SETTINGS";
    public static final String ACTION_INPUT_METHOD_SETTINGS = "android.settings.INPUT_METHOD_SETTINGS";
    public static final String ACTION_INPUT_METHOD_SUBTYPE_SETTINGS = "android.settings.INPUT_METHOD_SUBTYPE_SETTINGS";
    public static final String ACTION_INTERNAL_STORAGE_SETTINGS = "android.settings.INTERNAL_STORAGE_SETTINGS";
    public static final String ACTION_LOCALE_SETTINGS = "android.settings.LOCALE_SETTINGS";
    public static final String ACTION_LOCATION_SOURCE_SETTINGS = "android.settings.LOCATION_SOURCE_SETTINGS";
    public static final String ACTION_MANAGE_ALL_APPLICATIONS_SETTINGS = "android.settings.MANAGE_ALL_APPLICATIONS_SETTINGS";
    public static final String ACTION_MANAGE_APPLICATIONS_SETTINGS = "android.settings.MANAGE_APPLICATIONS_SETTINGS";
    public static final String ACTION_MEMORY_CARD_SETTINGS = "android.settings.MEMORY_CARD_SETTINGS";
    public static final String ACTION_MONITORING_CERT_INFO = "com.android.settings.MONITORING_CERT_INFO";
    public static final String ACTION_NETWORK_OPERATOR_SETTINGS = "android.settings.NETWORK_OPERATOR_SETTINGS";
    public static final String ACTION_NFCSHARING_SETTINGS = "android.settings.NFCSHARING_SETTINGS";
    public static final String ACTION_NFC_PAYMENT_SETTINGS = "android.settings.NFC_PAYMENT_SETTINGS";
    public static final String ACTION_NFC_SETTINGS = "android.settings.NFC_SETTINGS";
    public static final String ACTION_NOTIFICATION_LISTENER_SETTINGS = "android.settings.NOTIFICATION_LISTENER_SETTINGS";
    public static final String ACTION_NOTIFICATION_SETTINGS = "android.settings.NOTIFICATION_SETTINGS";
    public static final String ACTION_PAIRING_SETTINGS = "android.settings.PAIRING_SETTINGS";
    public static final String ACTION_PRINT_SETTINGS = "android.settings.ACTION_PRINT_SETTINGS";
    public static final String ACTION_PRIVACY_SETTINGS = "android.settings.PRIVACY_SETTINGS";
    public static final String ACTION_QUICK_LAUNCH_SETTINGS = "android.settings.QUICK_LAUNCH_SETTINGS";
    public static final String ACTION_SEARCH_SETTINGS = "android.search.action.SEARCH_SETTINGS";
    public static final String ACTION_SECURITY_SETTINGS = "android.settings.SECURITY_SETTINGS";
    public static final String ACTION_SETTINGS = "android.settings.SETTINGS";
    public static final String ACTION_SHOW_INPUT_METHOD_PICKER = "android.settings.SHOW_INPUT_METHOD_PICKER";
    public static final String ACTION_SHOW_REGULATORY_INFO = "android.settings.SHOW_REGULATORY_INFO";
    public static final String ACTION_SOUND_SETTINGS = "android.settings.SOUND_SETTINGS";
    public static final String ACTION_SYNC_SETTINGS = "android.settings.SYNC_SETTINGS";
    public static final String ACTION_SYSTEM_UPDATE_SETTINGS = "android.settings.SYSTEM_UPDATE_SETTINGS";
    public static final String ACTION_TRUSTED_CREDENTIALS_USER = "com.android.settings.TRUSTED_CREDENTIALS_USER";
    public static final String ACTION_USAGE_ACCESS_SETTINGS = "android.settings.USAGE_ACCESS_SETTINGS";
    public static final String ACTION_USER_DICTIONARY_INSERT = "com.android.settings.USER_DICTIONARY_INSERT";
    public static final String ACTION_USER_DICTIONARY_SETTINGS = "android.settings.USER_DICTIONARY_SETTINGS";
    public static final String ACTION_VOICE_CONTROL_AIRPLANE_MODE = "android.settings.VOICE_CONTROL_AIRPLANE_MODE";
    public static final String ACTION_VOICE_INPUT_SETTINGS = "android.settings.VOICE_INPUT_SETTINGS";
    public static final String ACTION_WIFI_DISPLAY_SETTINGS = "android.settings.WIFI_DISPLAY_SETTINGS";
    public static final String ACTION_WIFI_IP_SETTINGS = "android.settings.WIFI_IP_SETTINGS";
    public static final String ACTION_WIFI_SETTINGS = "android.settings.WIFI_SETTINGS";
    public static final String ACTION_WIRELESS_SETTINGS = "android.settings.WIRELESS_SETTINGS";
    public static final String ACTION_ZEN_MODE_SETTINGS = "android.settings.ZEN_MODE_SETTINGS";
    public static final String AUTHORITY = "settings";
    public static final String CALL_METHOD_GET_GLOBAL = "GET_global";
    public static final String CALL_METHOD_GET_SECURE = "GET_secure";
    public static final String CALL_METHOD_GET_SYSTEM = "GET_system";
    public static final String CALL_METHOD_PUT_GLOBAL = "PUT_global";
    public static final String CALL_METHOD_PUT_SECURE = "PUT_secure";
    public static final String CALL_METHOD_PUT_SYSTEM = "PUT_system";
    public static final String CALL_METHOD_USER_KEY = "_user";
    public static final String DEVICE_NAME_SETTINGS = "android.settings.DEVICE_NAME";
    public static final String EXTRA_ACCOUNT_TYPES = "account_types";
    public static final String EXTRA_AIRPLANE_MODE_ENABLED = "airplane_mode_enabled";
    public static final String EXTRA_APP_PACKAGE = "app_package";
    public static final String EXTRA_APP_UID = "app_uid";
    public static final String EXTRA_AUTHORITIES = "authorities";
    public static final String EXTRA_INPUT_DEVICE_IDENTIFIER = "input_device_identifier";
    public static final String EXTRA_INPUT_METHOD_ID = "input_method_id";
    private static final String JID_RESOURCE_PREFIX = "android";
    private static final boolean LOCAL_LOGV = false;
    private static final String TAG = "Settings";
    private static final Object mLocationSettingsLock = new Object();

    public static String getGTalkDeviceId(long l) {
        return "android-" + Long.toHexString(l);
    }

    public static final class Bookmarks
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://settings/bookmarks");
        public static final String FOLDER = "folder";
        public static final String ID = "_id";
        public static final String INTENT = "intent";
        public static final String ORDERING = "ordering";
        public static final String SHORTCUT = "shortcut";
        private static final String TAG = "Bookmarks";
        public static final String TITLE = "title";
        private static final String[] sIntentProjection = new String[]{"intent"};
        private static final String[] sShortcutProjection = new String[]{"_id", "shortcut"};
        private static final String sShortcutSelection = "shortcut=?";

        public static Uri add(ContentResolver contentResolver, Intent intent, String string2, String string3, char c, int n) {
            if (c != '\u0000') {
                Uri uri = CONTENT_URI;
                String[] stringArray = new String[]{String.valueOf((int)c)};
                contentResolver.delete(uri, sShortcutSelection, stringArray);
            }
            ContentValues contentValues = new ContentValues();
            if (string2 != null) {
                contentValues.put(TITLE, string2);
            }
            if (string3 != null) {
                contentValues.put(FOLDER, string3);
            }
            contentValues.put(INTENT, intent.toUri(0));
            if (c != '\u0000') {
                contentValues.put(SHORTCUT, Integer.valueOf(c));
            }
            contentValues.put(ORDERING, n);
            return contentResolver.insert(CONTENT_URI, contentValues);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Intent getIntentForShortcut(ContentResolver contentResolver, char c) {
            Intent intent = null;
            Uri uri = CONTENT_URI;
            String[] stringArray = sIntentProjection;
            String[] stringArray2 = new String[]{String.valueOf((int)c)};
            Cursor cursor = contentResolver.query(uri, stringArray, sShortcutSelection, stringArray2, ORDERING);
            while (intent == null) {
                try {
                    boolean bl = cursor.moveToNext();
                    if (!bl) break;
                    try {
                        Intent intent2;
                        intent = intent2 = Intent.parseUri(cursor.getString(cursor.getColumnIndexOrThrow(INTENT)), 0);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.w(TAG, "Intent column not found", illegalArgumentException);
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
            }
            if (cursor != null) {
                cursor.close();
            }
            return intent;
        }

        public static CharSequence getLabelForFolder(Resources resources, String string2) {
            return string2;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static CharSequence getTitle(Context context, Cursor cursor) {
            void var10_10;
            int n = cursor.getColumnIndex(TITLE);
            int n2 = cursor.getColumnIndex(INTENT);
            if (n == -1 || n2 == -1) {
                throw new IllegalArgumentException("The cursor must contain the TITLE and INTENT columns.");
            }
            String string2 = cursor.getString(n);
            if (!TextUtils.isEmpty(string2)) {
                return string2;
            }
            String string3 = cursor.getString(n2);
            if (TextUtils.isEmpty(string3)) {
                return "";
            }
            try {
                Intent intent = Intent.parseUri(string3, 0);
                PackageManager packageManager = context.getPackageManager();
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 0);
                if (resolveInfo == null) return var10_10;
                CharSequence charSequence = resolveInfo.loadLabel(packageManager);
            }
            catch (URISyntaxException uRISyntaxException) {
                return "";
            }
            return var10_10;
        }
    }

    public static final class Global
    extends NameValueTable {
        public static final String ADB_ENABLED = "adb_enabled";
        public static final String ADD_USERS_WHEN_LOCKED = "add_users_when_locked";
        public static final String AIRPLANE_MODE_ON = "airplane_mode_on";
        public static final String AIRPLANE_MODE_RADIOS = "airplane_mode_radios";
        public static final String AIRPLANE_MODE_TOGGLEABLE_RADIOS = "airplane_mode_toggleable_radios";
        public static final String ALWAYS_FINISH_ACTIVITIES = "always_finish_activities";
        public static final String ANIMATOR_DURATION_SCALE = "animator_duration_scale";
        public static final String ASSISTED_GPS_ENABLED = "assisted_gps_enabled";
        public static final String ASUS_AUTO_BRIGHTNESS_ADJ = "asus_auto_brightness_adj";
        public static final String ASUS_AUTO_BRIGHTNESS_POLICY = "asus_auto_brightness_policy";
        public static final String ASUS_THEME_ACTIVE_THEME_PACK = "asus_theme_active_theme_pack";
        public static final String ASUS_ZEN_MODE_IMPORTANT_INTERRUPTIONS = "ZEN_MODE_IMPORTANT_INTERRUPTIONS";
        public static final String ASUS_ZEN_MODE_NO_INTERRUPTIONS = "ZEN_MODE_NO_INTERRUPTIONS";
        public static final String ASUS_ZEN_MODE_OFF = "ZEN_MODE_OFF";
        public static final String AUDIO_SAFE_VOLUME_STATE = "audio_safe_volume_state";
        public static final String AUTO_TIME = "auto_time";
        public static final String AUTO_TIME_ZONE = "auto_time_zone";
        public static final String BATTERY_DISCHARGE_DURATION_THRESHOLD = "battery_discharge_duration_threshold";
        public static final String BATTERY_DISCHARGE_THRESHOLD = "battery_discharge_threshold";
        public static final String BLUETOOTH_A2DP_SINK_PRIORITY_PREFIX = "bluetooth_a2dp_sink_priority_";
        public static final String BLUETOOTH_HEADSET_PRIORITY_PREFIX = "bluetooth_headset_priority_";
        public static final String BLUETOOTH_INPUT_DEVICE_PRIORITY_PREFIX = "bluetooth_input_device_priority_";
        public static final String BLUETOOTH_MAP_PRIORITY_PREFIX = "bluetooth_map_priority_";
        public static final String BLUETOOTH_ON = "bluetooth_on";
        public static final String BUGREPORT_IN_POWER_MENU = "bugreport_in_power_menu";
        public static final String CALL_AUTO_RETRY = "call_auto_retry";
        public static final String CAPTIVE_PORTAL_DETECTION_ENABLED = "captive_portal_detection_enabled";
        public static final String CAPTIVE_PORTAL_SERVER = "captive_portal_server";
        public static final String CAR_DOCK_SOUND = "car_dock_sound";
        public static final String CAR_UNDOCK_SOUND = "car_undock_sound";
        public static final String CDMA_CELL_BROADCAST_SMS = "cdma_cell_broadcast_sms";
        public static final String CDMA_ROAMING_MODE = "roaming_settings";
        public static final String CDMA_SUBSCRIPTION_MODE = "subscription_mode";
        public static final String CERT_PIN_UPDATE_CONTENT_URL = "cert_pin_content_url";
        public static final String CERT_PIN_UPDATE_METADATA_URL = "cert_pin_metadata_url";
        public static final String COMPATIBILITY_MODE = "compatibility_mode";
        public static final String CONNECTIVITY_CHANGE_DELAY = "connectivity_change_delay";
        public static final String CONNECTIVITY_SAMPLING_INTERVAL_IN_SECONDS = "connectivity_sampling_interval_in_seconds";
        public static final Uri CONTENT_URI = Uri.parse("content://settings/global");
        public static final String CPU_TURBE_MODE = "cpu_turbe_mode";
        public static final String DATA_ACTIVITY_TIMEOUT_MOBILE = "data_activity_timeout_mobile";
        public static final String DATA_ACTIVITY_TIMEOUT_WIFI = "data_activity_timeout_wifi";
        public static final String DATA_ROAMING = "data_roaming";
        public static final String DATA_STALL_ALARM_AGGRESSIVE_DELAY_IN_MS = "data_stall_alarm_aggressive_delay_in_ms";
        public static final String DATA_STALL_ALARM_NON_AGGRESSIVE_DELAY_IN_MS = "data_stall_alarm_non_aggressive_delay_in_ms";
        public static final String DEBUG_APP = "debug_app";
        public static final String DEBUG_VIEW_ATTRIBUTES = "debug_view_attributes";
        public static final String DEFAULT_DNS_SERVER = "default_dns_server";
        public static final String DEFAULT_INSTALL_LOCATION = "default_install_location";
        public static final String DESK_DOCK_SOUND = "desk_dock_sound";
        public static final String DESK_UNDOCK_SOUND = "desk_undock_sound";
        public static final String DEVELOPMENT_FORCE_RTL = "debug.force_rtl";
        public static final String DEVELOPMENT_SETTINGS_ENABLED = "development_settings_enabled";
        public static final String DEVICE_NAME = "device_name";
        public static final String DEVICE_PROVISIONED = "device_provisioned";
        public static final String DISK_FREE_CHANGE_REPORTING_THRESHOLD = "disk_free_change_reporting_threshold";
        public static final String DISPLAY_DENSITY_FORCED = "display_density_forced";
        public static final String DISPLAY_SIZE_FORCED = "display_size_forced";
        public static final String DOCK_AUDIO_MEDIA_ENABLED = "dock_audio_media_enabled";
        public static final String DOCK_POWER_SAVING = "dock_power_saving";
        public static final String DOCK_SOUNDS_ENABLED = "dock_sounds_enabled";
        public static final String DOWNLOAD_MAX_BYTES_OVER_MOBILE = "download_manager_max_bytes_over_mobile";
        public static final String DOWNLOAD_RECOMMENDED_MAX_BYTES_OVER_MOBILE = "download_manager_recommended_max_bytes_over_mobile";
        public static final String DROPBOX_AGE_SECONDS = "dropbox_age_seconds";
        public static final String DROPBOX_MAX_FILES = "dropbox_max_files";
        public static final String DROPBOX_QUOTA_KB = "dropbox_quota_kb";
        public static final String DROPBOX_QUOTA_PERCENT = "dropbox_quota_percent";
        public static final String DROPBOX_RESERVE_PERCENT = "dropbox_reserve_percent";
        public static final String DROPBOX_TAG_PREFIX = "dropbox:";
        public static final String DUAL_SLOT_1_ENABLED = "dual_slot_1_eanbled";
        public static final String DUAL_SLOT_2_ENABLED = "dual_slot_2_eanbled";
        public static final String EMERGENCY_TONE = "emergency_tone";
        public static final String ENABLE_ACCESSIBILITY_GLOBAL_GESTURE_ENABLED = "enable_accessibility_global_gesture_enabled";
        public static final String ERROR_LOGCAT_PREFIX = "logcat_for_";
        public static final String FANCY_IME_ANIMATIONS = "fancy_ime_animations";
        public static final String FLIPFONT_SETTINGS_NAME = "flipfont_settings_name";
        public static final String FLIPFONT_SETTINGS_PATH = "flipfont_settings_path";
        public static final String FORCE_EXTERNAL_STORAGE_INSTALLATION_ON = "force_external_storage_installation";
        public static final String GLOBAL_HTTP_PROXY_EXCLUSION_LIST = "global_http_proxy_exclusion_list";
        public static final String GLOBAL_HTTP_PROXY_HOST = "global_http_proxy_host";
        public static final String GLOBAL_HTTP_PROXY_PAC = "global_proxy_pac_url";
        public static final String GLOBAL_HTTP_PROXY_PORT = "global_http_proxy_port";
        public static final String GPRS_REGISTER_CHECK_PERIOD_MS = "gprs_register_check_period_ms";
        public static final String GUEST_USER_ENABLED = "guest_user_enabled";
        public static final String HDMI_CONTROL_AUTO_DEVICE_OFF_ENABLED = "hdmi_control_auto_device_off_enabled";
        public static final String HDMI_CONTROL_AUTO_WAKEUP_ENABLED = "hdmi_control_auto_wakeup_enabled";
        public static final String HDMI_CONTROL_ENABLED = "hdmi_control_enabled";
        public static final String HDMI_SYSTEM_AUDIO_ENABLED = "hdmi_system_audio_enabled";
        public static final String HEADS_UP_NOTIFICATIONS_ENABLED = "heads_up_notifications_enabled";
        public static final int HEADS_UP_OFF = 0;
        public static final int HEADS_UP_ON = 1;
        public static final String HTTP_PROXY = "http_proxy";
        public static final String INET_CONDITION_DEBOUNCE_DOWN_DELAY = "inet_condition_debounce_down_delay";
        public static final String INET_CONDITION_DEBOUNCE_UP_DELAY = "inet_condition_debounce_up_delay";
        @Deprecated
        public static final String INSTALL_NON_MARKET_APPS = "install_non_market_apps";
        public static final String INTENT_FIREWALL_UPDATE_CONTENT_URL = "intent_firewall_content_url";
        public static final String INTENT_FIREWALL_UPDATE_METADATA_URL = "intent_firewall_metadata_url";
        public static final String LOCK_SOUND = "lock_sound";
        public static final String LOW_BATTERY_SOUND = "low_battery_sound";
        public static final String LOW_BATTERY_SOUND_TIMEOUT = "low_battery_sound_timeout";
        public static final String LOW_POWER_MODE = "low_power";
        public static final String LOW_POWER_MODE_TRIGGER_LEVEL = "low_power_trigger_level";
        public static final String MDC_INITIAL_MAX_RETRY = "mdc_initial_max_retry";
        public static final String MHL_INPUT_SWITCHING_ENABLED = "mhl_input_switching_enabled";
        public static final String MHL_POWER_CHARGE_ENABLED = "mhl_power_charge_enabled";
        public static final String MOBILE_DATA = "mobile_data";
        public static final String MOBILE_SLEEP_POLICY = "mobile_sleep_policy";
        public static final int MOBILE_SLEEP_POLICY_DEFAULT = 0;
        public static final int MOBILE_SLEEP_POLICY_NEVER = 2;
        public static final int MOBILE_SLEEP_POLICY_NEVER_WHILE_PLUGGED = 1;
        public static final String MODE_RINGER = "mode_ringer";
        private static final HashSet<String> MOVED_TO_SECURE;
        public static final String MULTI_SIM_DATA_CALL_SUBSCRIPTION = "multi_sim_data_call";
        public static final String MULTI_SIM_SMS_PROMPT = "multi_sim_sms_prompt";
        public static final String MULTI_SIM_SMS_SUBSCRIPTION = "multi_sim_sms";
        public static final String[] MULTI_SIM_USER_PREFERRED_SUBS;
        public static final String MULTI_SIM_VOICE_CALL_SUBSCRIPTION = "multi_sim_voice_call";
        public static final String MULTI_SIM_VOICE_PROMPT = "multi_sim_voice_prompt";
        public static final String NETSTATS_DEV_BUCKET_DURATION = "netstats_dev_bucket_duration";
        public static final String NETSTATS_DEV_DELETE_AGE = "netstats_dev_delete_age";
        public static final String NETSTATS_DEV_PERSIST_BYTES = "netstats_dev_persist_bytes";
        public static final String NETSTATS_DEV_ROTATE_AGE = "netstats_dev_rotate_age";
        public static final String NETSTATS_ENABLED = "netstats_enabled";
        public static final String NETSTATS_GLOBAL_ALERT_BYTES = "netstats_global_alert_bytes";
        public static final String NETSTATS_POLL_INTERVAL = "netstats_poll_interval";
        public static final String NETSTATS_REPORT_XT_OVER_DEV = "netstats_report_xt_over_dev";
        public static final String NETSTATS_SAMPLE_ENABLED = "netstats_sample_enabled";
        public static final String NETSTATS_TIME_CACHE_MAX_AGE = "netstats_time_cache_max_age";
        public static final String NETSTATS_UID_BUCKET_DURATION = "netstats_uid_bucket_duration";
        public static final String NETSTATS_UID_DELETE_AGE = "netstats_uid_delete_age";
        public static final String NETSTATS_UID_PERSIST_BYTES = "netstats_uid_persist_bytes";
        public static final String NETSTATS_UID_ROTATE_AGE = "netstats_uid_rotate_age";
        public static final String NETSTATS_UID_TAG_BUCKET_DURATION = "netstats_uid_tag_bucket_duration";
        public static final String NETSTATS_UID_TAG_DELETE_AGE = "netstats_uid_tag_delete_age";
        public static final String NETSTATS_UID_TAG_PERSIST_BYTES = "netstats_uid_tag_persist_bytes";
        public static final String NETSTATS_UID_TAG_ROTATE_AGE = "netstats_uid_tag_rotate_age";
        public static final String NETWORK_PREFERENCE = "network_preference";
        public static final String NETWORK_SCORER_APP = "network_scorer_app";
        public static final String NETWORK_SCORING_PROVISIONED = "network_scoring_provisioned";
        public static final String NITZ_UPDATE_DIFF = "nitz_update_diff";
        public static final String NITZ_UPDATE_SPACING = "nitz_update_spacing";
        public static final String NSD_ON = "nsd_on";
        public static final String NTP_SERVER = "ntp_server";
        public static final String NTP_TIMEOUT = "ntp_timeout";
        public static final String OVERLAY_DISPLAY_DEVICES = "overlay_display_devices";
        public static final String PACKAGE_VERIFIER_DEFAULT_RESPONSE = "verifier_default_response";
        public static final String PACKAGE_VERIFIER_ENABLE = "package_verifier_enable";
        public static final String PACKAGE_VERIFIER_INCLUDE_ADB = "verifier_verify_adb_installs";
        public static final String PACKAGE_VERIFIER_SETTING_VISIBLE = "verifier_setting_visible";
        public static final String PACKAGE_VERIFIER_TIMEOUT = "verifier_timeout";
        public static final String PAC_CHANGE_DELAY = "pac_change_delay";
        public static final String PDP_WATCHDOG_ERROR_POLL_COUNT = "pdp_watchdog_error_poll_count";
        public static final String PDP_WATCHDOG_ERROR_POLL_INTERVAL_MS = "pdp_watchdog_error_poll_interval_ms";
        public static final String PDP_WATCHDOG_LONG_POLL_INTERVAL_MS = "pdp_watchdog_long_poll_interval_ms";
        public static final String PDP_WATCHDOG_MAX_PDP_RESET_FAIL_COUNT = "pdp_watchdog_max_pdp_reset_fail_count";
        public static final String PDP_WATCHDOG_POLL_INTERVAL_MS = "pdp_watchdog_poll_interval_ms";
        public static final String PDP_WATCHDOG_TRIGGER_PACKET_COUNT = "pdp_watchdog_trigger_packet_count";
        public static final String POLICY_CONTROL = "policy_control";
        public static final String POWER_SAVER_ENABLED = "power_saver_enabled";
        public static final String POWER_SAVING_SLEEP_POLICY_ENABLE = "power_sleep_policy";
        public static final String POWER_SAVING_WARNING_ACTIONBAR_ENABLED = "warning_action_bar";
        public static final String POWER_SOUNDS_ENABLED = "power_sounds_enabled";
        public static final String PREFERRED_NETWORK_MODE = "preferred_network_mode";
        public static final String PRIMARY_SLOT_VOICE = "primary_slot_voice";
        public static final String PROVISIONING_APN_ALARM_DELAY_IN_MS = "provisioning_apn_alarm_delay_in_ms";
        public static final String RADIO_BLUETOOTH = "bluetooth";
        public static final String RADIO_CELL = "cell";
        public static final String RADIO_NFC = "nfc";
        public static final String RADIO_WIFI = "wifi";
        public static final String RADIO_WIMAX = "wimax";
        public static final String READ_EXTERNAL_STORAGE_ENFORCED_DEFAULT = "read_external_storage_enforced_default";
        public static final String REQUIRE_PASSWORD_TO_DECRYPT = "require_password_to_decrypt";
        public static final String SAMPLING_PROFILER_MS = "sampling_profiler_ms";
        public static final String SELINUX_STATUS = "selinux_status";
        public static final String SELINUX_UPDATE_CONTENT_URL = "selinux_content_url";
        public static final String SELINUX_UPDATE_METADATA_URL = "selinux_metadata_url";
        public static final String SEND_ACTION_APP_ERROR = "send_action_app_error";
        public static final String[] SETTINGS_TO_BACKUP;
        public static final String SETUP_PREPAID_DATA_SERVICE_URL = "setup_prepaid_data_service_url";
        public static final String SETUP_PREPAID_DETECTION_REDIR_HOST = "setup_prepaid_detection_redir_host";
        public static final String SETUP_PREPAID_DETECTION_TARGET_URL = "setup_prepaid_detection_target_url";
        public static final String SET_GLOBAL_HTTP_PROXY = "set_global_http_proxy";
        public static final String SET_INSTALL_LOCATION = "set_install_location";
        public static final String SHOW_LIGHT_SENSOR = "show_light_sensor";
        public static final String SHOW_PROCESSES = "show_processes";
        public static final String SMS_OUTGOING_CHECK_INTERVAL_MS = "sms_outgoing_check_interval_ms";
        public static final String SMS_OUTGOING_CHECK_MAX_COUNT = "sms_outgoing_check_max_count";
        public static final String SMS_SHORT_CODES_UPDATE_CONTENT_URL = "sms_short_codes_content_url";
        public static final String SMS_SHORT_CODES_UPDATE_METADATA_URL = "sms_short_codes_metadata_url";
        public static final String SMS_SHORT_CODE_CONFIRMATION = "sms_short_code_confirmation";
        public static final String SMS_SHORT_CODE_RULE = "sms_short_code_rule";
        public static final String STAY_ON_WHILE_PLUGGED_IN = "stay_on_while_plugged_in";
        public static final String SYNC_MAX_RETRY_DELAY_IN_SECONDS = "sync_max_retry_delay_in_seconds";
        public static final String SYS_FREE_STORAGE_LOG_INTERVAL = "sys_free_storage_log_interval";
        public static final String SYS_PROP_SETTING_VERSION = "sys.settings_global_version";
        public static final String SYS_STORAGE_FULL_THRESHOLD_BYTES = "sys_storage_full_threshold_bytes";
        public static final String SYS_STORAGE_THRESHOLD_MAX_BYTES = "sys_storage_threshold_max_bytes";
        public static final String SYS_STORAGE_THRESHOLD_PERCENTAGE = "sys_storage_threshold_percentage";
        public static final String TCP_DEFAULT_INIT_RWND = "tcp_default_init_rwnd";
        public static final String TETHER_DUN_APN = "tether_dun_apn";
        public static final String TETHER_DUN_REQUIRED = "tether_dun_required";
        public static final String TETHER_SUPPORTED = "tether_supported";
        public static final String TRANSITION_ANIMATION_SCALE = "transition_animation_scale";
        public static final String TRUSTED_SOUND = "trusted_sound";
        public static final String TZINFO_UPDATE_CONTENT_URL = "tzinfo_content_url";
        public static final String TZINFO_UPDATE_METADATA_URL = "tzinfo_metadata_url";
        public static final String UNLOCK_SOUND = "unlock_sound";
        public static final String USB_MASS_STORAGE_ENABLED = "usb_mass_storage_enabled";
        public static final String USER_SNAPVIEW_SETTINGS_AVATAR = "user_snapview_settings_avatar";
        public static final String USER_SNAPVIEW_SETTINGS_DUMMY_NOTIFY = "user_snapview_settings_dummy_notify";
        public static final String USER_SNAPVIEW_SETTINGS_DUMMY_NOTIFY_ICON = "user_snapview_settings_dummy_notify_icon";
        public static final String USER_SNAPVIEW_SETTINGS_HINT_COLOR = "user_snapview_settings_hint_color";
        public static final String USER_SNAPVIEW_SETTINGS_HINT_LOCK = "user_snapview_settings_hint_lock";
        public static final String USER_SNAPVIEW_SETTINGS_HINT_NOTIFY = "user_snapview_settings_hint_notify";
        public static final String USE_GOOGLE_MAIL = "use_google_mail";
        public static final int VOLUME_MODE = 4;
        public static final String WAIT_FOR_DEBUGGER = "wait_for_debugger";
        public static final String WEBVIEW_DATA_REDUCTION_PROXY_KEY = "webview_data_reduction_proxy_key";
        public static final String WIFI_BOUNCE_DELAY_OVERRIDE_MS = "wifi_bounce_delay_override_ms";
        public static final String WIFI_COUNTRY_CODE = "wifi_country_code";
        public static final String WIFI_DISPLAY_CERTIFICATION_ON = "wifi_display_certification_on";
        public static final String WIFI_DISPLAY_ON = "wifi_display_on";
        public static final String WIFI_DISPLAY_WPS_CONFIG = "wifi_display_wps_config";
        public static final String WIFI_ENHANCED_AUTO_JOIN = "wifi_enhanced_auto_join";
        public static final String WIFI_FRAMEWORK_SCAN_INTERVAL_MS = "wifi_framework_scan_interval_ms";
        public static final String WIFI_FREQUENCY_BAND = "wifi_frequency_band";
        public static final String WIFI_IDLE_MS = "wifi_idle_ms";
        public static final String WIFI_MAX_DHCP_RETRY_COUNT = "wifi_max_dhcp_retry_count";
        public static final String WIFI_MOBILE_DATA_TRANSITION_WAKELOCK_TIMEOUT_MS = "wifi_mobile_data_transition_wakelock_timeout_ms";
        public static final String WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON = "wifi_networks_available_notification_on";
        public static final String WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY = "wifi_networks_available_repeat_delay";
        public static final String WIFI_NETWORK_SHOW_RSSI = "wifi_network_show_rssi";
        public static final String WIFI_NUM_OPEN_NETWORKS_KEPT = "wifi_num_open_networks_kept";
        public static final String WIFI_ON = "wifi_on";
        public static final String WIFI_P2P_DEVICE_NAME = "wifi_p2p_device_name";
        public static final String WIFI_REENABLE_DELAY_MS = "wifi_reenable_delay";
        public static final String WIFI_SAVED_STATE = "wifi_saved_state";
        public static final String WIFI_SCAN_ALWAYS_AVAILABLE = "wifi_scan_always_enabled";
        public static final String WIFI_SCAN_INTERVAL_WHEN_P2P_CONNECTED_MS = "wifi_scan_interval_p2p_connected_ms";
        public static final String WIFI_SLEEP_POLICY = "wifi_sleep_policy";
        public static final int WIFI_SLEEP_POLICY_DEFAULT = 0;
        public static final int WIFI_SLEEP_POLICY_NEVER = 2;
        public static final int WIFI_SLEEP_POLICY_NEVER_WHILE_PLUGGED = 1;
        public static final String WIFI_SUPPLICANT_SCAN_INTERVAL_MS = "wifi_supplicant_scan_interval_ms";
        public static final String WIFI_SUSPEND_OPTIMIZATIONS_ENABLED = "wifi_suspend_optimizations_enabled";
        public static final String WIFI_WATCHDOG_ON = "wifi_watchdog_on";
        public static final String WIFI_WATCHDOG_POOR_NETWORK_TEST_ENABLED = "wifi_watchdog_poor_network_test_enabled";
        public static final String WIMAX_NETWORKS_AVAILABLE_NOTIFICATION_ON = "wimax_networks_available_notification_on";
        public static final String WINDOW_ANIMATION_SCALE = "window_animation_scale";
        public static final String WIRELESS_CHARGING_STARTED_SOUND = "wireless_charging_started_sound";
        public static final String WTF_IS_FATAL = "wtf_is_fatal";
        public static final String ZEN_MODE = "zen_mode";
        public static final String ZEN_MODE_CONFIG_ETAG = "zen_mode_config_etag";
        public static final int ZEN_MODE_IMPORTANT_INTERRUPTIONS = 1;
        public static final int ZEN_MODE_INTERRUPTIONS = 3;
        public static final int ZEN_MODE_NO_INTERRUPTIONS = 2;
        public static final int ZEN_MODE_OFF;
        private static NameValueCache sNameValueCache;

        static {
            SETTINGS_TO_BACKUP = new String[]{BUGREPORT_IN_POWER_MENU, STAY_ON_WHILE_PLUGGED_IN, AUTO_TIME, AUTO_TIME_ZONE, POWER_SOUNDS_ENABLED, DOCK_SOUNDS_ENABLED, USB_MASS_STORAGE_ENABLED, ENABLE_ACCESSIBILITY_GLOBAL_GESTURE_ENABLED, WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON, WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY, WIFI_WATCHDOG_POOR_NETWORK_TEST_ENABLED, WIFI_NUM_OPEN_NETWORKS_KEPT, EMERGENCY_TONE, CALL_AUTO_RETRY, DOCK_AUDIO_MEDIA_ENABLED};
            sNameValueCache = new NameValueCache(SYS_PROP_SETTING_VERSION, CONTENT_URI, Settings.CALL_METHOD_GET_GLOBAL, Settings.CALL_METHOD_PUT_GLOBAL);
            MOVED_TO_SECURE = new HashSet(1);
            MOVED_TO_SECURE.add(INSTALL_NON_MARKET_APPS);
            MULTI_SIM_USER_PREFERRED_SUBS = new String[]{"user_preferred_sub1", "user_preferred_sub2", "user_preferred_sub3"};
        }

        public static final String getBluetoothA2dpSinkPriorityKey(String string2) {
            return BLUETOOTH_A2DP_SINK_PRIORITY_PREFIX + string2.toUpperCase(Locale.ROOT);
        }

        public static final String getBluetoothHeadsetPriorityKey(String string2) {
            return BLUETOOTH_HEADSET_PRIORITY_PREFIX + string2.toUpperCase(Locale.ROOT);
        }

        public static final String getBluetoothInputDevicePriorityKey(String string2) {
            return BLUETOOTH_INPUT_DEVICE_PRIORITY_PREFIX + string2.toUpperCase(Locale.ROOT);
        }

        public static final String getBluetoothMapPriorityKey(String string2) {
            return BLUETOOTH_MAP_PRIORITY_PREFIX + string2.toUpperCase(Locale.ROOT);
        }

        public static float getFloat(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = Global.getString(contentResolver, string2);
            if (string3 == null) {
                throw new SettingNotFoundException(string2);
            }
            try {
                float f = Float.parseFloat(string3);
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static float getFloat(ContentResolver contentResolver, String string2, float f) {
            String string3 = Global.getString(contentResolver, string2);
            if (string3 == null) return f;
            try {
                float f2 = Float.parseFloat(string3);
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        public static int getInt(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = Global.getString(contentResolver, string2);
            try {
                int n = Integer.parseInt(string3);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int getInt(ContentResolver contentResolver, String string2, int n) {
            String string3 = Global.getString(contentResolver, string2);
            if (string3 == null) return n;
            try {
                int n2 = Integer.parseInt(string3);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        public static long getLong(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = Global.getString(contentResolver, string2);
            try {
                long l = Long.parseLong(string3);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static long getLong(ContentResolver contentResolver, String string2, long l) {
            String string3 = Global.getString(contentResolver, string2);
            if (string3 == null) return l;
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        public static String getString(ContentResolver contentResolver, String string2) {
            return Global.getStringForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static String getStringForUser(ContentResolver contentResolver, String string2, int n) {
            if (MOVED_TO_SECURE.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.Global" + " to android.provider.Settings.Secure, returning read-only value.");
                return Secure.getStringForUser(contentResolver, string2, n);
            }
            return sNameValueCache.getStringForUser(contentResolver, string2, n);
        }

        public static Uri getUriFor(String string2) {
            return Global.getUriFor(CONTENT_URI, string2);
        }

        public static boolean putFloat(ContentResolver contentResolver, String string2, float f) {
            return Global.putString(contentResolver, string2, Float.toString(f));
        }

        public static boolean putInt(ContentResolver contentResolver, String string2, int n) {
            return Global.putString(contentResolver, string2, Integer.toString(n));
        }

        public static boolean putLong(ContentResolver contentResolver, String string2, long l) {
            return Global.putString(contentResolver, string2, Long.toString(l));
        }

        public static boolean putString(ContentResolver contentResolver, String string2, String string3) {
            return Global.putStringForUser(contentResolver, string2, string3, UserHandle.myUserId());
        }

        public static boolean putStringForUser(ContentResolver contentResolver, String string2, String string3, int n) {
            if (MOVED_TO_SECURE.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.Global" + " to android.provider.Settings.Secure, value is unchanged.");
                return Secure.putStringForUser(contentResolver, string2, string3, n);
            }
            return sNameValueCache.putStringForUser(contentResolver, string2, string3, n);
        }

        public static String zenModeToString(int n) {
            if (n == 1) {
                return ASUS_ZEN_MODE_IMPORTANT_INTERRUPTIONS;
            }
            if (n == 2) {
                return ASUS_ZEN_MODE_NO_INTERRUPTIONS;
            }
            return ASUS_ZEN_MODE_OFF;
        }
    }

    private static class NameValueCache {
        private static final String NAME_EQ_PLACEHOLDER = "name=?";
        private static final String[] SELECT_VALUE = new String[]{"value"};
        private final String mCallGetCommand;
        private final String mCallSetCommand;
        private IContentProvider mContentProvider = null;
        private final Uri mUri;
        private final HashMap<String, String> mValues = new HashMap();
        private long mValuesVersion = 0L;
        private final String mVersionSystemProperty;

        public NameValueCache(String string2, Uri uri, String string3, String string4) {
            this.mVersionSystemProperty = string2;
            this.mUri = uri;
            this.mCallGetCommand = string3;
            this.mCallSetCommand = string4;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IContentProvider lazyGetProvider(ContentResolver contentResolver) {
            synchronized (this) {
                IContentProvider iContentProvider;
                IContentProvider iContentProvider2 = this.mContentProvider;
                if (iContentProvider2 != null) return iContentProvider2;
                this.mContentProvider = iContentProvider = contentResolver.acquireProvider(this.mUri.getAuthority());
                return iContentProvider;
            }
        }

        /*
         * Exception decompiling
         */
        public String getStringForUser(ContentResolver var1_1, String var2_2, int var3_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [9 : 181->183)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean putStringForUser(ContentResolver contentResolver, String string2, String string3, int n) {
            try {
                Bundle bundle = new Bundle();
                bundle.putString("value", string3);
                bundle.putInt(Settings.CALL_METHOD_USER_KEY, n);
                this.lazyGetProvider(contentResolver).call(contentResolver.getPackageName(), this.mCallSetCommand, string2, bundle);
                return true;
            }
            catch (RemoteException remoteException) {
                Log.w(Settings.TAG, "Can't set key " + string2 + " in " + this.mUri, remoteException);
                return false;
            }
        }
    }

    public static class NameValueTable
    implements BaseColumns {
        public static final String NAME = "name";
        public static final String VALUE = "value";

        public static Uri getUriFor(Uri uri, String string2) {
            return Uri.withAppendedPath(uri, string2);
        }

        protected static boolean putString(ContentResolver contentResolver, Uri uri, String string2, String string3) {
            try {
                ContentValues contentValues = new ContentValues();
                contentValues.put(NAME, string2);
                contentValues.put(VALUE, string3);
                contentResolver.insert(uri, contentValues);
                return true;
            }
            catch (SQLException sQLException) {
                Log.w(Settings.TAG, "Can't set key " + string2 + " in " + uri, sQLException);
                return false;
            }
        }
    }

    public static final class Secure
    extends NameValueTable {
        public static final String ACCESSIBILITY_CAPTIONING_BACKGROUND_COLOR = "accessibility_captioning_background_color";
        public static final String ACCESSIBILITY_CAPTIONING_EDGE_COLOR = "accessibility_captioning_edge_color";
        public static final String ACCESSIBILITY_CAPTIONING_EDGE_TYPE = "accessibility_captioning_edge_type";
        public static final String ACCESSIBILITY_CAPTIONING_ENABLED = "accessibility_captioning_enabled";
        public static final String ACCESSIBILITY_CAPTIONING_FONT_SCALE = "accessibility_captioning_font_scale";
        public static final String ACCESSIBILITY_CAPTIONING_FOREGROUND_COLOR = "accessibility_captioning_foreground_color";
        public static final String ACCESSIBILITY_CAPTIONING_LOCALE = "accessibility_captioning_locale";
        public static final String ACCESSIBILITY_CAPTIONING_PRESET = "accessibility_captioning_preset";
        public static final String ACCESSIBILITY_CAPTIONING_TYPEFACE = "accessibility_captioning_typeface";
        public static final String ACCESSIBILITY_CAPTIONING_WINDOW_COLOR = "accessibility_captioning_window_color";
        public static final String ACCESSIBILITY_DISPLAY_DALTONIZER = "accessibility_display_daltonizer";
        public static final String ACCESSIBILITY_DISPLAY_DALTONIZER_ENABLED = "accessibility_display_daltonizer_enabled";
        public static final String ACCESSIBILITY_DISPLAY_INVERSION_ENABLED = "accessibility_display_inversion_enabled";
        public static final String ACCESSIBILITY_DISPLAY_MAGNIFICATION_AUTO_UPDATE = "accessibility_display_magnification_auto_update";
        public static final String ACCESSIBILITY_DISPLAY_MAGNIFICATION_ENABLED = "accessibility_display_magnification_enabled";
        public static final String ACCESSIBILITY_DISPLAY_MAGNIFICATION_SCALE = "accessibility_display_magnification_scale";
        public static final String ACCESSIBILITY_ENABLED = "accessibility_enabled";
        public static final String ACCESSIBILITY_HIGH_TEXT_CONTRAST_ENABLED = "high_text_contrast_enabled";
        public static final String ACCESSIBILITY_ONEHAND_CTRL_CLING_DISMISSED = "accessibility_onehand_ctrl_cling_dismissed";
        public static final String ACCESSIBILITY_ONEHAND_CTRL_ENABLED = "accessibility_onehand_ctrl_enabled";
        public static final String ACCESSIBILITY_ONEHAND_CTRL_POSITION = "accessibility_onehand_ctrl_position";
        public static final String ACCESSIBILITY_ONEHAND_CTRL_QUICK_TRIGGER_ENABLED = "accessibility_onehand_ctrl_quick_trigger_enabled";
        public static final String ACCESSIBILITY_ONEHAND_CTRL_SCALE = "accessibility_onehand_ctrl_scale";
        public static final String ACCESSIBILITY_SCREEN_READER_URL = "accessibility_script_injection_url";
        public static final String ACCESSIBILITY_SCRIPT_INJECTION = "accessibility_script_injection";
        public static final String ACCESSIBILITY_SPEAK_PASSWORD = "speak_password";
        public static final String ACCESSIBILITY_WEB_CONTENT_KEY_BINDINGS = "accessibility_web_content_key_bindings";
        @Deprecated
        public static final String ADB_ENABLED = "adb_enabled";
        public static final String ALLOWED_GEOLOCATION_ORIGINS = "allowed_geolocation_origins";
        public static final String ALLOW_MOCK_LOCATION = "mock_location";
        public static final String ANDROID_ID = "android_id";
        public static final String ANR_SHOW_BACKGROUND = "anr_show_background";
        public static final String ASUS_LOCKSCREEN_DISPLAY_APP = "asus.lockscreen.display.app";
        @Deprecated
        public static final String BACKGROUND_DATA = "background_data";
        public static final String BACKUP_AUTO_RESTORE = "backup_auto_restore";
        public static final String BACKUP_ENABLED = "backup_enabled";
        public static final String BACKUP_PROVISIONED = "backup_provisioned";
        public static final String BACKUP_TRANSPORT = "backup_transport";
        public static final String BAR_SERVICE_COMPONENT = "bar_service_component";
        public static final String BLUETOOTH_HCI_LOG = "bluetooth_hci_log";
        @Deprecated
        public static final String BLUETOOTH_ON = "bluetooth_on";
        @Deprecated
        public static final String BUGREPORT_IN_POWER_MENU = "bugreport_in_power_menu";
        public static final String[] CLONE_TO_MANAGED_PROFILE;
        public static final Uri CONTENT_URI;
        @Deprecated
        public static final String DATA_ROAMING = "data_roaming";
        public static final String DEFAULT_INPUT_METHOD = "default_input_method";
        @Deprecated
        public static final String DEVELOPMENT_SETTINGS_ENABLED = "development_settings_enabled";
        @Deprecated
        public static final String DEVICE_PROVISIONED = "device_provisioned";
        public static final String DISABLED_SYSTEM_INPUT_METHODS = "disabled_system_input_methods";
        public static final String DOZE_ENABLED = "doze_enabled";
        public static final String ENABLED_ACCESSIBILITY_SERVICES = "enabled_accessibility_services";
        public static final String ENABLED_CONDITION_PROVIDERS = "enabled_condition_providers";
        public static final String ENABLED_INPUT_METHODS = "enabled_input_methods";
        public static final String ENABLED_NOTIFICATION_LISTENERS = "enabled_notification_listeners";
        public static final String ENABLED_ON_FIRST_BOOT_SYSTEM_PRINT_SERVICES = "enabled_on_first_boot_system_print_services";
        public static final String ENABLED_PRINT_SERVICES = "enabled_print_services";
        public static final String ENHANCED_VOICE_PRIVACY_ENABLED = "enhanced_voice_privacy_enabled";
        @Deprecated
        public static final String HTTP_PROXY = "http_proxy";
        public static final String IMMERSIVE_MODE_CONFIRMATIONS = "immersive_mode_confirmations";
        public static final String INCALL_POWER_BUTTON_BEHAVIOR = "incall_power_button_behavior";
        public static final int INCALL_POWER_BUTTON_BEHAVIOR_DEFAULT = 1;
        public static final int INCALL_POWER_BUTTON_BEHAVIOR_HANGUP = 2;
        public static final int INCALL_POWER_BUTTON_BEHAVIOR_SCREEN_OFF = 1;
        public static final String INPUT_METHODS_SUBTYPE_HISTORY = "input_methods_subtype_history";
        public static final String INPUT_METHOD_SELECTOR_VISIBILITY = "input_method_selector_visibility";
        public static final String INSTALL_NON_MARKET_APPS = "install_non_market_apps";
        public static final String LAST_SETUP_SHOWN = "last_setup_shown";
        public static final String LOCATION_MODE = "location_mode";
        public static final int LOCATION_MODE_BATTERY_SAVING = 2;
        public static final int LOCATION_MODE_HIGH_ACCURACY = 3;
        public static final int LOCATION_MODE_OFF = 0;
        public static final int LOCATION_MODE_SENSORS_ONLY = 1;
        @Deprecated
        public static final String LOCATION_PROVIDERS_ALLOWED = "location_providers_allowed";
        public static final String LOCK_BIOMETRIC_WEAK_FLAGS = "lock_biometric_weak_flags";
        public static final String LOCK_PATTERN_ENABLED = "lock_pattern_autolock";
        @Deprecated
        public static final String LOCK_PATTERN_TACTILE_FEEDBACK_ENABLED = "lock_pattern_tactile_feedback_enabled";
        public static final String LOCK_PATTERN_VISIBLE = "lock_pattern_visible_pattern";
        public static final String LOCK_SCREEN_ALLOW_PRIVATE_NOTIFICATIONS = "lock_screen_allow_private_notifications";
        public static final String LOCK_SCREEN_APPWIDGET_IDS = "lock_screen_appwidget_ids";
        public static final String LOCK_SCREEN_FALLBACK_APPWIDGET_ID = "lock_screen_fallback_appwidget_id";
        public static final String LOCK_SCREEN_LOCK_AFTER_TIMEOUT = "lock_screen_lock_after_timeout";
        public static final String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
        public static final String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
        public static final String LOCK_SCREEN_SHOW_NOTIFICATIONS = "lock_screen_show_notifications";
        public static final String LOCK_SCREEN_STICKY_APPWIDGET = "lock_screen_sticky_appwidget";
        @Deprecated
        public static final String LOGGING_ID = "logging_id";
        public static final String LONG_PRESS_TIMEOUT = "long_press_timeout";
        public static final String MOUNT_PLAY_NOTIFICATION_SND = "mount_play_not_snd";
        public static final String MOUNT_UMS_AUTOSTART = "mount_ums_autostart";
        public static final String MOUNT_UMS_NOTIFY_ENABLED = "mount_ums_notify_enabled";
        public static final String MOUNT_UMS_PROMPT = "mount_ums_prompt";
        private static final HashSet<String> MOVED_TO_GLOBAL;
        private static final HashSet<String> MOVED_TO_LOCK_SETTINGS;
        @Deprecated
        public static final String NETWORK_PREFERENCE = "network_preference";
        public static final String NFC_PAYMENT_DEFAULT_COMPONENT = "nfc_payment_default_component";
        public static final String NFC_PAYMENT_FOREGROUND = "nfc_payment_foreground";
        public static final String PACKAGE_VERIFIER_USER_CONSENT = "package_verifier_user_consent";
        public static final String PARENTAL_CONTROL_ENABLED = "parental_control_enabled";
        public static final String PARENTAL_CONTROL_LAST_UPDATE = "parental_control_last_update";
        public static final String PARENTAL_CONTROL_REDIRECT_URL = "parental_control_redirect_url";
        public static final String PAYMENT_SERVICE_SEARCH_URI = "payment_service_search_uri";
        public static final String PREFERRED_TTY_MODE = "preferred_tty_mode";
        public static final String PRINT_SERVICE_SEARCH_URI = "print_service_search_uri";
        public static final String SCREENSAVER_ACTIVATE_ON_DOCK = "screensaver_activate_on_dock";
        public static final String SCREENSAVER_ACTIVATE_ON_SLEEP = "screensaver_activate_on_sleep";
        public static final String SCREENSAVER_COMPONENTS = "screensaver_components";
        public static final String SCREENSAVER_DEFAULT_COMPONENT = "screensaver_default_component";
        public static final String SCREENSAVER_ENABLED = "screensaver_enabled";
        public static final String SEARCH_GLOBAL_SEARCH_ACTIVITY = "search_global_search_activity";
        public static final String SEARCH_MAX_RESULTS_PER_SOURCE = "search_max_results_per_source";
        public static final String SEARCH_MAX_RESULTS_TO_DISPLAY = "search_max_results_to_display";
        public static final String SEARCH_MAX_SHORTCUTS_RETURNED = "search_max_shortcuts_returned";
        public static final String SEARCH_MAX_SOURCE_EVENT_AGE_MILLIS = "search_max_source_event_age_millis";
        public static final String SEARCH_MAX_STAT_AGE_MILLIS = "search_max_stat_age_millis";
        public static final String SEARCH_MIN_CLICKS_FOR_SOURCE_RANKING = "search_min_clicks_for_source_ranking";
        public static final String SEARCH_MIN_IMPRESSIONS_FOR_SOURCE_RANKING = "search_min_impressions_for_source_ranking";
        public static final String SEARCH_NUM_PROMOTED_SOURCES = "search_num_promoted_sources";
        public static final String SEARCH_PER_SOURCE_CONCURRENT_QUERY_LIMIT = "search_per_source_concurrent_query_limit";
        public static final String SEARCH_PREFILL_MILLIS = "search_prefill_millis";
        public static final String SEARCH_PROMOTED_SOURCE_DEADLINE_MILLIS = "search_promoted_source_deadline_millis";
        public static final String SEARCH_QUERY_THREAD_CORE_POOL_SIZE = "search_query_thread_core_pool_size";
        public static final String SEARCH_QUERY_THREAD_MAX_POOL_SIZE = "search_query_thread_max_pool_size";
        public static final String SEARCH_SHORTCUT_REFRESH_CORE_POOL_SIZE = "search_shortcut_refresh_core_pool_size";
        public static final String SEARCH_SHORTCUT_REFRESH_MAX_POOL_SIZE = "search_shortcut_refresh_max_pool_size";
        public static final String SEARCH_SOURCE_TIMEOUT_MILLIS = "search_source_timeout_millis";
        public static final String SEARCH_THREAD_KEEPALIVE_SECONDS = "search_thread_keepalive_seconds";
        public static final String SEARCH_WEB_RESULTS_OVERRIDE_LIMIT = "search_web_results_override_limit";
        public static final String SELECTED_INPUT_METHOD_SUBTYPE = "selected_input_method_subtype";
        public static final String SELECTED_SPELL_CHECKER = "selected_spell_checker";
        public static final String SELECTED_SPELL_CHECKER_SUBTYPE = "selected_spell_checker_subtype";
        public static final String SETTINGS_CLASSNAME = "settings_classname";
        public static final String[] SETTINGS_TO_BACKUP;
        public static final String SHOW_IME_WITH_HARD_KEYBOARD = "show_ime_with_hard_keyboard";
        public static final String SHOW_NOTE_ABOUT_NOTIFICATION_HIDING = "show_note_about_notification_hiding";
        public static final String SKIP_FIRST_USE_HINTS = "skip_first_use_hints";
        public static final String SLEEP_TIMEOUT = "sleep_timeout";
        public static final String SMS_DEFAULT_APPLICATION = "sms_default_application";
        public static final String SPELL_CHECKER_ENABLED = "spell_checker_enabled";
        public static final String SYS_PROP_SETTING_VERSION = "sys.settings_secure_version";
        public static final String TOUCH_EXPLORATION_ENABLED = "touch_exploration_enabled";
        public static final String TOUCH_EXPLORATION_GRANTED_ACCESSIBILITY_SERVICES = "touch_exploration_granted_accessibility_services";
        public static final String TRUST_AGENTS_INITIALIZED = "trust_agents_initialized";
        @Deprecated
        public static final String TTS_DEFAULT_COUNTRY = "tts_default_country";
        @Deprecated
        public static final String TTS_DEFAULT_LANG = "tts_default_lang";
        public static final String TTS_DEFAULT_LOCALE = "tts_default_locale";
        public static final String TTS_DEFAULT_PITCH = "tts_default_pitch";
        public static final String TTS_DEFAULT_RATE = "tts_default_rate";
        public static final String TTS_DEFAULT_SYNTH = "tts_default_synth";
        @Deprecated
        public static final String TTS_DEFAULT_VARIANT = "tts_default_variant";
        public static final String TTS_ENABLED_PLUGINS = "tts_enabled_plugins";
        @Deprecated
        public static final String TTS_USE_DEFAULTS = "tts_use_defaults";
        public static final String TTY_MODE_ENABLED = "tty_mode_enabled";
        public static final String TV_INPUT_CUSTOM_LABELS = "tv_input_custom_labels";
        public static final String TV_INPUT_HIDDEN_INPUTS = "tv_input_hidden_inputs";
        public static final String UI_NIGHT_MODE = "ui_night_mode";
        public static final String UNSAFE_VOLUME_MUSIC_ACTIVE_MS = "unsafe_volume_music_active_ms";
        public static final String USB_AUDIO_AUTOMATIC_ROUTING_DISABLED = "usb_audio_automatic_routing_disabled";
        @Deprecated
        public static final String USB_MASS_STORAGE_ENABLED = "usb_mass_storage_enabled";
        public static final String USER_FINGERPRINT_IDS = "user_fingerprint_ids";
        public static final String USER_SETUP_COMPLETE = "user_setup_complete";
        @Deprecated
        public static final String USE_GOOGLE_MAIL = "use_google_mail";
        public static final String VOICE_INTERACTION_SERVICE = "voice_interaction_service";
        public static final String VOICE_RECOGNITION_SERVICE = "voice_recognition_service";
        public static final String WAKE_GESTURE_ENABLED = "wake_gesture_enabled";
        public static final String WEBVIEW_DATA_REDUCTION_PROXY = "webview_data_reduction_proxy";
        @Deprecated
        public static final String WIFI_IDLE_MS = "wifi_idle_ms";
        @Deprecated
        public static final String WIFI_MAX_DHCP_RETRY_COUNT = "wifi_max_dhcp_retry_count";
        @Deprecated
        public static final String WIFI_MOBILE_DATA_TRANSITION_WAKELOCK_TIMEOUT_MS = "wifi_mobile_data_transition_wakelock_timeout_ms";
        @Deprecated
        public static final String WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON = "wifi_networks_available_notification_on";
        @Deprecated
        public static final String WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY = "wifi_networks_available_repeat_delay";
        @Deprecated
        public static final String WIFI_NUM_OPEN_NETWORKS_KEPT = "wifi_num_open_networks_kept";
        @Deprecated
        public static final String WIFI_ON = "wifi_on";
        @Deprecated
        public static final String WIFI_WATCHDOG_ACCEPTABLE_PACKET_LOSS_PERCENTAGE = "wifi_watchdog_acceptable_packet_loss_percentage";
        @Deprecated
        public static final String WIFI_WATCHDOG_AP_COUNT = "wifi_watchdog_ap_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_DELAY_MS = "wifi_watchdog_background_check_delay_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_ENABLED = "wifi_watchdog_background_check_enabled";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_TIMEOUT_MS = "wifi_watchdog_background_check_timeout_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_INITIAL_IGNORED_PING_COUNT = "wifi_watchdog_initial_ignored_ping_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_MAX_AP_CHECKS = "wifi_watchdog_max_ap_checks";
        @Deprecated
        public static final String WIFI_WATCHDOG_ON = "wifi_watchdog_on";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_COUNT = "wifi_watchdog_ping_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_DELAY_MS = "wifi_watchdog_ping_delay_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_TIMEOUT_MS = "wifi_watchdog_ping_timeout_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_WATCH_LIST = "wifi_watchdog_watch_list";
        private static boolean sIsSystemProcess;
        private static ILockSettings sLockSettings;
        private static final NameValueCache sNameValueCache;

        static {
            CONTENT_URI = Uri.parse("content://settings/secure");
            sNameValueCache = new NameValueCache(SYS_PROP_SETTING_VERSION, CONTENT_URI, Settings.CALL_METHOD_GET_SECURE, Settings.CALL_METHOD_PUT_SECURE);
            sLockSettings = null;
            MOVED_TO_LOCK_SETTINGS = new HashSet(3);
            MOVED_TO_LOCK_SETTINGS.add(LOCK_PATTERN_ENABLED);
            MOVED_TO_LOCK_SETTINGS.add(LOCK_PATTERN_VISIBLE);
            MOVED_TO_LOCK_SETTINGS.add(LOCK_PATTERN_TACTILE_FEEDBACK_ENABLED);
            MOVED_TO_GLOBAL = new HashSet();
            MOVED_TO_GLOBAL.add(ADB_ENABLED);
            MOVED_TO_GLOBAL.add("assisted_gps_enabled");
            MOVED_TO_GLOBAL.add(BLUETOOTH_ON);
            MOVED_TO_GLOBAL.add(BUGREPORT_IN_POWER_MENU);
            MOVED_TO_GLOBAL.add("cdma_cell_broadcast_sms");
            MOVED_TO_GLOBAL.add("roaming_settings");
            MOVED_TO_GLOBAL.add("subscription_mode");
            MOVED_TO_GLOBAL.add("data_activity_timeout_mobile");
            MOVED_TO_GLOBAL.add("data_activity_timeout_wifi");
            MOVED_TO_GLOBAL.add(DATA_ROAMING);
            MOVED_TO_GLOBAL.add(DEVELOPMENT_SETTINGS_ENABLED);
            MOVED_TO_GLOBAL.add(DEVICE_PROVISIONED);
            MOVED_TO_GLOBAL.add("display_density_forced");
            MOVED_TO_GLOBAL.add("display_size_forced");
            MOVED_TO_GLOBAL.add("download_manager_max_bytes_over_mobile");
            MOVED_TO_GLOBAL.add("download_manager_recommended_max_bytes_over_mobile");
            MOVED_TO_GLOBAL.add("mobile_data");
            MOVED_TO_GLOBAL.add("dual_slot_1_eanbled");
            MOVED_TO_GLOBAL.add("dual_slot_2_eanbled");
            MOVED_TO_GLOBAL.add("netstats_dev_bucket_duration");
            MOVED_TO_GLOBAL.add("netstats_dev_delete_age");
            MOVED_TO_GLOBAL.add("netstats_dev_persist_bytes");
            MOVED_TO_GLOBAL.add("netstats_dev_rotate_age");
            MOVED_TO_GLOBAL.add("netstats_enabled");
            MOVED_TO_GLOBAL.add("netstats_global_alert_bytes");
            MOVED_TO_GLOBAL.add("netstats_poll_interval");
            MOVED_TO_GLOBAL.add("netstats_report_xt_over_dev");
            MOVED_TO_GLOBAL.add("netstats_sample_enabled");
            MOVED_TO_GLOBAL.add("netstats_time_cache_max_age");
            MOVED_TO_GLOBAL.add("netstats_uid_bucket_duration");
            MOVED_TO_GLOBAL.add("netstats_uid_delete_age");
            MOVED_TO_GLOBAL.add("netstats_uid_persist_bytes");
            MOVED_TO_GLOBAL.add("netstats_uid_rotate_age");
            MOVED_TO_GLOBAL.add("netstats_uid_tag_bucket_duration");
            MOVED_TO_GLOBAL.add("netstats_uid_tag_delete_age");
            MOVED_TO_GLOBAL.add("netstats_uid_tag_persist_bytes");
            MOVED_TO_GLOBAL.add("netstats_uid_tag_rotate_age");
            MOVED_TO_GLOBAL.add(NETWORK_PREFERENCE);
            MOVED_TO_GLOBAL.add("nitz_update_diff");
            MOVED_TO_GLOBAL.add("nitz_update_spacing");
            MOVED_TO_GLOBAL.add("ntp_server");
            MOVED_TO_GLOBAL.add("ntp_timeout");
            MOVED_TO_GLOBAL.add("pdp_watchdog_error_poll_count");
            MOVED_TO_GLOBAL.add("pdp_watchdog_long_poll_interval_ms");
            MOVED_TO_GLOBAL.add("pdp_watchdog_max_pdp_reset_fail_count");
            MOVED_TO_GLOBAL.add("pdp_watchdog_poll_interval_ms");
            MOVED_TO_GLOBAL.add("pdp_watchdog_trigger_packet_count");
            MOVED_TO_GLOBAL.add("sampling_profiler_ms");
            MOVED_TO_GLOBAL.add("setup_prepaid_data_service_url");
            MOVED_TO_GLOBAL.add("setup_prepaid_detection_redir_host");
            MOVED_TO_GLOBAL.add("setup_prepaid_detection_target_url");
            MOVED_TO_GLOBAL.add("tether_dun_apn");
            MOVED_TO_GLOBAL.add("tether_dun_required");
            MOVED_TO_GLOBAL.add("tether_supported");
            MOVED_TO_GLOBAL.add(USB_MASS_STORAGE_ENABLED);
            MOVED_TO_GLOBAL.add(USE_GOOGLE_MAIL);
            MOVED_TO_GLOBAL.add("wifi_country_code");
            MOVED_TO_GLOBAL.add("wifi_framework_scan_interval_ms");
            MOVED_TO_GLOBAL.add("wifi_frequency_band");
            MOVED_TO_GLOBAL.add(WIFI_IDLE_MS);
            MOVED_TO_GLOBAL.add(WIFI_MAX_DHCP_RETRY_COUNT);
            MOVED_TO_GLOBAL.add(WIFI_MOBILE_DATA_TRANSITION_WAKELOCK_TIMEOUT_MS);
            MOVED_TO_GLOBAL.add(WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON);
            MOVED_TO_GLOBAL.add(WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY);
            MOVED_TO_GLOBAL.add(WIFI_NUM_OPEN_NETWORKS_KEPT);
            MOVED_TO_GLOBAL.add(WIFI_ON);
            MOVED_TO_GLOBAL.add("wifi_p2p_device_name");
            MOVED_TO_GLOBAL.add("wifi_saved_state");
            MOVED_TO_GLOBAL.add("wifi_supplicant_scan_interval_ms");
            MOVED_TO_GLOBAL.add("wifi_suspend_optimizations_enabled");
            MOVED_TO_GLOBAL.add("wifi_enhanced_auto_join");
            MOVED_TO_GLOBAL.add("wifi_network_show_rssi");
            MOVED_TO_GLOBAL.add(WIFI_WATCHDOG_ON);
            MOVED_TO_GLOBAL.add("wifi_watchdog_poor_network_test_enabled");
            MOVED_TO_GLOBAL.add("wimax_networks_available_notification_on");
            MOVED_TO_GLOBAL.add("package_verifier_enable");
            MOVED_TO_GLOBAL.add("verifier_timeout");
            MOVED_TO_GLOBAL.add("verifier_default_response");
            MOVED_TO_GLOBAL.add("data_stall_alarm_non_aggressive_delay_in_ms");
            MOVED_TO_GLOBAL.add("data_stall_alarm_aggressive_delay_in_ms");
            MOVED_TO_GLOBAL.add("gprs_register_check_period_ms");
            MOVED_TO_GLOBAL.add("wtf_is_fatal");
            MOVED_TO_GLOBAL.add("battery_discharge_duration_threshold");
            MOVED_TO_GLOBAL.add("battery_discharge_threshold");
            MOVED_TO_GLOBAL.add("send_action_app_error");
            MOVED_TO_GLOBAL.add("dropbox_age_seconds");
            MOVED_TO_GLOBAL.add("dropbox_max_files");
            MOVED_TO_GLOBAL.add("dropbox_quota_kb");
            MOVED_TO_GLOBAL.add("dropbox_quota_percent");
            MOVED_TO_GLOBAL.add("dropbox_reserve_percent");
            MOVED_TO_GLOBAL.add("dropbox:");
            MOVED_TO_GLOBAL.add("logcat_for_");
            MOVED_TO_GLOBAL.add("sys_free_storage_log_interval");
            MOVED_TO_GLOBAL.add("disk_free_change_reporting_threshold");
            MOVED_TO_GLOBAL.add("sys_storage_threshold_percentage");
            MOVED_TO_GLOBAL.add("sys_storage_threshold_max_bytes");
            MOVED_TO_GLOBAL.add("sys_storage_full_threshold_bytes");
            MOVED_TO_GLOBAL.add("sync_max_retry_delay_in_seconds");
            MOVED_TO_GLOBAL.add("connectivity_change_delay");
            MOVED_TO_GLOBAL.add("captive_portal_detection_enabled");
            MOVED_TO_GLOBAL.add("captive_portal_server");
            MOVED_TO_GLOBAL.add("nsd_on");
            MOVED_TO_GLOBAL.add("set_install_location");
            MOVED_TO_GLOBAL.add("default_install_location");
            MOVED_TO_GLOBAL.add("force_external_storage_installation");
            MOVED_TO_GLOBAL.add("inet_condition_debounce_up_delay");
            MOVED_TO_GLOBAL.add("inet_condition_debounce_down_delay");
            MOVED_TO_GLOBAL.add("read_external_storage_enforced_default");
            MOVED_TO_GLOBAL.add(HTTP_PROXY);
            MOVED_TO_GLOBAL.add("global_http_proxy_host");
            MOVED_TO_GLOBAL.add("global_http_proxy_port");
            MOVED_TO_GLOBAL.add("global_http_proxy_exclusion_list");
            MOVED_TO_GLOBAL.add("set_global_http_proxy");
            MOVED_TO_GLOBAL.add("default_dns_server");
            MOVED_TO_GLOBAL.add("preferred_network_mode");
            MOVED_TO_GLOBAL.add("webview_data_reduction_proxy_key");
            SETTINGS_TO_BACKUP = new String[]{BUGREPORT_IN_POWER_MENU, ALLOW_MOCK_LOCATION, PARENTAL_CONTROL_ENABLED, PARENTAL_CONTROL_REDIRECT_URL, USB_MASS_STORAGE_ENABLED, ACCESSIBILITY_DISPLAY_MAGNIFICATION_ENABLED, ACCESSIBILITY_DISPLAY_MAGNIFICATION_SCALE, ACCESSIBILITY_DISPLAY_MAGNIFICATION_AUTO_UPDATE, ACCESSIBILITY_SCRIPT_INJECTION, BACKUP_AUTO_RESTORE, ENABLED_ACCESSIBILITY_SERVICES, TOUCH_EXPLORATION_GRANTED_ACCESSIBILITY_SERVICES, TOUCH_EXPLORATION_ENABLED, ACCESSIBILITY_ENABLED, ACCESSIBILITY_SPEAK_PASSWORD, ACCESSIBILITY_HIGH_TEXT_CONTRAST_ENABLED, ACCESSIBILITY_CAPTIONING_ENABLED, ACCESSIBILITY_CAPTIONING_LOCALE, ACCESSIBILITY_CAPTIONING_BACKGROUND_COLOR, ACCESSIBILITY_CAPTIONING_FOREGROUND_COLOR, ACCESSIBILITY_CAPTIONING_EDGE_TYPE, ACCESSIBILITY_CAPTIONING_EDGE_COLOR, ACCESSIBILITY_CAPTIONING_TYPEFACE, ACCESSIBILITY_CAPTIONING_FONT_SCALE, TTS_USE_DEFAULTS, TTS_DEFAULT_RATE, TTS_DEFAULT_PITCH, TTS_DEFAULT_SYNTH, TTS_DEFAULT_LANG, TTS_DEFAULT_COUNTRY, TTS_ENABLED_PLUGINS, TTS_DEFAULT_LOCALE, WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON, WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY, WIFI_NUM_OPEN_NETWORKS_KEPT, MOUNT_PLAY_NOTIFICATION_SND, MOUNT_UMS_AUTOSTART, MOUNT_UMS_PROMPT, MOUNT_UMS_NOTIFY_ENABLED, UI_NIGHT_MODE, SLEEP_TIMEOUT};
            CLONE_TO_MANAGED_PROFILE = new String[]{ACCESSIBILITY_ENABLED, ALLOW_MOCK_LOCATION, ALLOWED_GEOLOCATION_ORIGINS, DEFAULT_INPUT_METHOD, ENABLED_ACCESSIBILITY_SERVICES, ENABLED_INPUT_METHODS, LOCATION_MODE, LOCATION_PROVIDERS_ALLOWED, LOCK_SCREEN_ALLOW_PRIVATE_NOTIFICATIONS, SELECTED_INPUT_METHOD_SUBTYPE, SELECTED_SPELL_CHECKER, SELECTED_SPELL_CHECKER_SUBTYPE};
        }

        public static float getFloat(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            return Secure.getFloatForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static float getFloat(ContentResolver contentResolver, String string2, float f) {
            return Secure.getFloatForUser(contentResolver, string2, f, UserHandle.myUserId());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static float getFloatForUser(ContentResolver contentResolver, String string2, float f, int n) {
            String string3 = Secure.getStringForUser(contentResolver, string2, n);
            if (string3 == null) return f;
            try {
                float f2 = Float.parseFloat(string3);
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        public static float getFloatForUser(ContentResolver contentResolver, String string2, int n) throws SettingNotFoundException {
            String string3 = Secure.getStringForUser(contentResolver, string2, n);
            if (string3 == null) {
                throw new SettingNotFoundException(string2);
            }
            try {
                float f = Float.parseFloat(string3);
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        public static int getInt(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            return Secure.getIntForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static int getInt(ContentResolver contentResolver, String string2, int n) {
            return Secure.getIntForUser(contentResolver, string2, n, UserHandle.myUserId());
        }

        public static int getIntForUser(ContentResolver contentResolver, String string2, int n) throws SettingNotFoundException {
            if (LOCATION_MODE.equals(string2)) {
                return Secure.getLocationModeForUser(contentResolver, n);
            }
            String string3 = Secure.getStringForUser(contentResolver, string2, n);
            try {
                int n2 = Integer.parseInt(string3);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int getIntForUser(ContentResolver contentResolver, String string2, int n, int n2) {
            if (LOCATION_MODE.equals(string2)) {
                return Secure.getLocationModeForUser(contentResolver, n2);
            }
            String string3 = Secure.getStringForUser(contentResolver, string2, n2);
            if (string3 == null) return n;
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static final int getLocationModeForUser(ContentResolver contentResolver, int n) {
            Object object = mLocationSettingsLock;
            synchronized (object) {
                boolean bl = Secure.isLocationProviderEnabledForUser(contentResolver, "gps", n);
                boolean bl2 = Secure.isLocationProviderEnabledForUser(contentResolver, "network", n);
                if (bl && bl2) {
                    return 3;
                }
                if (bl) {
                    return 1;
                }
                if (bl2) {
                    return 2;
                }
                return 0;
            }
        }

        public static long getLong(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            return Secure.getLongForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static long getLong(ContentResolver contentResolver, String string2, long l) {
            return Secure.getLongForUser(contentResolver, string2, l, UserHandle.myUserId());
        }

        public static long getLongForUser(ContentResolver contentResolver, String string2, int n) throws SettingNotFoundException {
            String string3 = Secure.getStringForUser(contentResolver, string2, n);
            try {
                long l = Long.parseLong(string3);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static long getLongForUser(ContentResolver contentResolver, String string2, long l, int n) {
            String string3 = Secure.getStringForUser(contentResolver, string2, n);
            if (string3 == null) return l;
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        public static void getMovedKeys(HashSet<String> hashSet) {
            hashSet.addAll(MOVED_TO_GLOBAL);
        }

        public static String getString(ContentResolver contentResolver, String string2) {
            return Secure.getStringForUser(contentResolver, string2, UserHandle.myUserId());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String getStringForUser(ContentResolver contentResolver, String string2, int n) {
            if (MOVED_TO_GLOBAL.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.Secure" + " to android.provider.Settings.Global.");
                return Global.getStringForUser(contentResolver, string2, n);
            }
            if (!MOVED_TO_LOCK_SETTINGS.contains(string2)) return sNameValueCache.getStringForUser(contentResolver, string2, n);
            synchronized (Secure.class) {
                if (sLockSettings == null) {
                    sLockSettings = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
                    boolean bl = Process.myUid() == 1000;
                    sIsSystemProcess = bl;
                }
            }
            if (sLockSettings == null) return sNameValueCache.getStringForUser(contentResolver, string2, n);
            if (sIsSystemProcess) return sNameValueCache.getStringForUser(contentResolver, string2, n);
            try {
                return sLockSettings.getString(string2, "0", n);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return sNameValueCache.getStringForUser(contentResolver, string2, n);
        }

        public static Uri getUriFor(String string2) {
            if (MOVED_TO_GLOBAL.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.Secure" + " to android.provider.Settings.Global, returning global URI.");
                return Global.getUriFor(Global.CONTENT_URI, string2);
            }
            return Secure.getUriFor(CONTENT_URI, string2);
        }

        @Deprecated
        public static final boolean isLocationProviderEnabled(ContentResolver contentResolver, String string2) {
            return Secure.isLocationProviderEnabledForUser(contentResolver, string2, UserHandle.myUserId());
        }

        @Deprecated
        public static final boolean isLocationProviderEnabledForUser(ContentResolver contentResolver, String string2, int n) {
            return TextUtils.delimitedStringContains(Secure.getStringForUser(contentResolver, LOCATION_PROVIDERS_ALLOWED, n), ',', string2);
        }

        public static boolean putFloat(ContentResolver contentResolver, String string2, float f) {
            return Secure.putFloatForUser(contentResolver, string2, f, UserHandle.myUserId());
        }

        public static boolean putFloatForUser(ContentResolver contentResolver, String string2, float f, int n) {
            return Secure.putStringForUser(contentResolver, string2, Float.toString(f), n);
        }

        public static boolean putInt(ContentResolver contentResolver, String string2, int n) {
            return Secure.putIntForUser(contentResolver, string2, n, UserHandle.myUserId());
        }

        public static boolean putIntForUser(ContentResolver contentResolver, String string2, int n, int n2) {
            return Secure.putStringForUser(contentResolver, string2, Integer.toString(n), n2);
        }

        public static boolean putLong(ContentResolver contentResolver, String string2, long l) {
            return Secure.putLongForUser(contentResolver, string2, l, UserHandle.myUserId());
        }

        public static boolean putLongForUser(ContentResolver contentResolver, String string2, long l, int n) {
            return Secure.putStringForUser(contentResolver, string2, Long.toString(l), n);
        }

        public static boolean putString(ContentResolver contentResolver, String string2, String string3) {
            return Secure.putStringForUser(contentResolver, string2, string3, UserHandle.myUserId());
        }

        public static boolean putStringForUser(ContentResolver contentResolver, String string2, String string3, int n) {
            if (LOCATION_MODE.equals(string2)) {
                return Secure.setLocationModeForUser(contentResolver, Integer.parseInt(string3), n);
            }
            if (MOVED_TO_GLOBAL.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Global");
                return Global.putStringForUser(contentResolver, string2, string3, n);
            }
            return sNameValueCache.putStringForUser(contentResolver, string2, string3, n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static final boolean setLocationModeForUser(ContentResolver contentResolver, int n, int n2) {
            Object object = mLocationSettingsLock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                switch (n) {
                    default: {
                        throw new IllegalArgumentException("Invalid location mode: " + n);
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl2 = true;
                        bl = false;
                        break;
                    }
                    case 3: {
                        bl = true;
                        bl2 = true;
                    }
                    case 0: 
                }
                boolean bl3 = Secure.setLocationProviderEnabledForUser(contentResolver, "gps", bl, n2);
                boolean bl4 = Secure.setLocationProviderEnabledForUser(contentResolver, "network", bl2, n2);
                if (!bl3) return false;
                if (!bl4) return false;
                return true;
            }
        }

        @Deprecated
        public static final void setLocationProviderEnabled(ContentResolver contentResolver, String string2, boolean bl) {
            Secure.setLocationProviderEnabledForUser(contentResolver, string2, bl, UserHandle.myUserId());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Deprecated
        public static final boolean setLocationProviderEnabledForUser(ContentResolver contentResolver, String string2, boolean bl, int n) {
            Object object = mLocationSettingsLock;
            synchronized (object) {
                String string3 = bl ? "+" + string2 : "-" + string2;
                return Secure.putStringForUser(contentResolver, LOCATION_PROVIDERS_ALLOWED, string3, n);
            }
        }
    }

    public static class SettingNotFoundException
    extends AndroidException {
        public SettingNotFoundException(String string2) {
            super(string2);
        }
    }

    public static final class System
    extends NameValueTable {
        public static final String ACCELEROMETER_ROTATION = "accelerometer_rotation";
        @Deprecated
        public static final String ADB_ENABLED = "adb_enabled";
        public static final String ADVANCED_SETTINGS = "advanced_settings";
        public static final int ADVANCED_SETTINGS_DEFAULT = 0;
        @Deprecated
        public static final String AIRPLANE_MODE_ON = "airplane_mode_on";
        @Deprecated
        public static final String AIRPLANE_MODE_RADIOS = "airplane_mode_radios";
        @Deprecated
        public static final String AIRPLANE_MODE_TOGGLEABLE_RADIOS = "airplane_mode_toggleable_radios";
        public static final String ALARM_ALERT = "alarm_alert";
        @Deprecated
        public static final String ALWAYS_FINISH_ACTIVITIES = "always_finish_activities";
        @Deprecated
        public static final String ANDROID_ID = "android_id";
        @Deprecated
        public static final String ANIMATOR_DURATION_SCALE = "animator_duration_scale";
        public static final String APPEND_FOR_LAST_AUDIBLE = "_last_audible";
        public static final String ASUS_ANALYTICS = "asus_analytics";
        public static final String ASUS_DOUBLE_TAP = "asus_double_tap";
        public static final String ASUS_EASY_LAUNCHER = "asus_easy_launcher";
        public static final int ASUS_EASY_LAUNCHER_DISABLED = 0;
        public static final int ASUS_EASY_LAUNCHER_ENABLED = 1;
        public static final String ASUS_LOCKSCREEN_ENABLE_CAMERA = "asus_lockscreen_enable_camera";
        public static final String ASUS_LOCKSCREEN_ENABLE_SECURE_LOCK = "asus_lockscreen_enable_secure_lock";
        public static final String ASUS_LOCKSCREEN_ENABLE_SLIDE_LOCK = "asus_lockscreen_enable_slide_lock";
        public static final String ASUS_LOCKSCREEN_ENABLE_WHATSNEXT_IN_SECURITY_MODE = "asus_lockscreen_enable_whatsnext_security_mode";
        public static final String ASUS_LOCKSCREEN_INSTANT_CAMERA = "asus_lockscreen_instant_camera";
        public static final String ASUS_LOCKSCREEN_SHORTCUT_NAME = "asus_lockscreen_shortcut_name";
        public static final String ASUS_LOCKSCREEN_SKIP_SLID_DISABLED = "asus_lockscreen_skipslid_disabled";
        public static final String ASUS_LOCKSCREEN_WHATSNEXT = "asus_lockscreen_whatsnext";
        public static final String ASUS_MOTION_SHAKE = "asus_motion_shake";
        public static final String ASUS_ONE_HAND_OPERATION = "ASUS_ONE_HAND_OPERATION";
        public static final String ASUS_ONE_HAND_OPERATION_ASUS_KEYBOARD = "ASUS_ONE_HAND_OPERATION_ASUS_KEYBOARD";
        public static final String ASUS_ONE_HAND_OPERATION_PHONE = "ASUS_ONE_HAND_OPERATION_PHONE";
        public static final String ASUS_ONE_HAND_OPERATION_UNLOCK = "ASUS_ONE_HAND_OPERATION_UNLOCK";
        public static final String ASUS_SHAKE_SENSITIVITY = "asus_shake_sensitivity";
        public static final String ASUS_TRANSCOVER = "asus_transcover";
        public static final String ASUS_TRANSCOVER_AUTOMATIC_UNLOCK = "asus_transcover_automatic_unlock";
        public static final int ASUS_TRANSCOVER_DEFAULT_MODE = 1;
        public static final int ASUS_TRANSCOVER_MODE_DISABLED = 0;
        public static final int ASUS_TRANSCOVER_MODE_ENABLED = 1;
        @Deprecated
        public static final String AUTO_TIME = "auto_time";
        @Deprecated
        public static final String AUTO_TIME_ZONE = "auto_time_zone";
        public static final String BLUETOOTH_DISCOVERABILITY = "bluetooth_discoverability";
        public static final String BLUETOOTH_DISCOVERABILITY_TIMEOUT = "bluetooth_discoverability_timeout";
        @Deprecated
        public static final String BLUETOOTH_ON = "bluetooth_on";
        public static final String CALENDARALERT_SOUND = "calendaralert_sound";
        @Deprecated
        public static final String CAR_DOCK_SOUND = "car_dock_sound";
        @Deprecated
        public static final String CAR_UNDOCK_SOUND = "car_undock_sound";
        public static final String CHARGING_POLICY = "charging_policy";
        public static final String[] CLONE_TO_MANAGED_PROFILE;
        public static final String COLOR_MASK = "color_mask";
        public static final int COLOR_MASK_SHOW = 1;
        public static final String COLOR_MASK_VALUE = "color_mask_value";
        public static final Uri CONTENT_URI;
        public static final String CPU_TURBE_MODE = "cpu_turbe_mode";
        @Deprecated
        public static final String DATA_ROAMING = "data_roaming";
        public static final String DATE_FORMAT = "date_format";
        @Deprecated
        public static final String DEBUG_APP = "debug_app";
        public static final Uri DEFAULT_ALARM_ALERT_URI;
        public static final Uri DEFAULT_CALENDARALERT_URI;
        public static final Uri DEFAULT_NEWMAIL_URI;
        public static final Uri DEFAULT_NOTIFICATION_URI;
        public static final Uri DEFAULT_NOTIFICATION_URI_2;
        public static final Uri DEFAULT_RINGTONE_URI;
        public static final Uri DEFAULT_RINGTONE_URI_2;
        public static final Uri DEFAULT_SENTMAIL_URI;
        @Deprecated
        public static final String DESK_DOCK_SOUND = "desk_dock_sound";
        @Deprecated
        public static final String DESK_UNDOCK_SOUND = "desk_undock_sound";
        public static final String DETECT_DRAIN_APPS = "detect_drain_apps";
        @Deprecated
        public static final String DEVICE_PROVISIONED = "device_provisioned";
        @Deprecated
        public static final String DIM_SCREEN = "dim_screen";
        public static final String DOCK_POWER_SAVING = "dock_power_saving";
        @Deprecated
        public static final String DOCK_SOUNDS_ENABLED = "dock_sounds_enabled";
        public static final String DOUBLE_TAP_MODE_CONFIRM_DIALOG = "double_tap_mode_confirm_dialog";
        public static final String DTMF_TONE_TYPE_WHEN_DIALING = "dtmf_tone_type";
        public static final String DTMF_TONE_WHEN_DIALING = "dtmf_tone";
        public static final String EGG_MODE = "egg_mode";
        public static final String END_BUTTON_BEHAVIOR = "end_button_behavior";
        public static final int END_BUTTON_BEHAVIOR_DEFAULT = 2;
        public static final int END_BUTTON_BEHAVIOR_HOME = 1;
        public static final int END_BUTTON_BEHAVIOR_SLEEP = 2;
        public static final String ETHERNET_CONNECT_POLICY = "ethernet_connect_policy";
        public static final String ETHERNET_ENABLE = "ethernet_enable";
        public static final String ETHERNET_STATIC_DNS1 = "ethernet_static_DNS1";
        public static final String ETHERNET_STATIC_DNS2 = "ethernet_static_DNS2";
        public static final String ETHERNET_STATIC_GATEWAY = "ethernet_static_gateway";
        public static final String ETHERNET_STATIC_IP = "ethernet_static_ip";
        public static final String ETHERNET_STATIC_NETMASK_LENGTH = "ethernet_static_netmask_length";
        public static final String ETHERNET_USE_STATIC_IP = "ethernet_use_static_ip";
        public static final String FLIPFONT = "flipfont";
        public static final String FONT_SCALE = "font_scale";
        public static final String GESTURE_SWITCH = "gesture_switch";
        public static final String GESTURE_TYPE1_APP = "gesture_type1_app";
        public static final String GESTURE_TYPE2_APP = "gesture_type2_app";
        public static final String GESTURE_TYPE3_APP = "gesture_type3_app";
        public static final String GESTURE_TYPE4_APP = "gesture_type4_app";
        public static final String GESTURE_TYPE5_APP = "gesture_type5_app";
        public static final String GESTURE_TYPE6_APP = "gesture_type6_app";
        public static final String GLOVE_MODE = "glove_mode";
        public static final String GLOVE_MODE_CONFIRM_DIALOG = "glove_mode_confirm_dialog";
        public static final String HAPTIC_FEEDBACK_ENABLED = "haptic_feedback_enabled";
        public static final String HEARING_AID = "hearing_aid";
        public static final String HIDE_ROTATION_LOCK_TOGGLE_FOR_ACCESSIBILITY = "hide_rotation_lock_toggle_for_accessibility";
        public static final String HOTSPOT_DISABLE_POLICY = "hotspot_disable_policy";
        public static final int HOTSPOT_DISABLE_POLICY_DEFAULT = 0;
        public static final int HOTSPOT_DISABLE_POLICY_NEVER = 0;
        @Deprecated
        public static final String HTTP_PROXY = "http_proxy";
        @Deprecated
        public static final String INSTALL_NON_MARKET_APPS = "install_non_market_apps";
        @Deprecated
        public static final String LOCATION_PROVIDERS_ALLOWED = "location_providers_allowed";
        public static final String LOCKSCREEN_DISABLED = "lockscreen.disabled";
        public static final String LOCKSCREEN_SOUNDS_ENABLED = "lockscreen_sounds_enabled";
        @Deprecated
        public static final String LOCK_PATTERN_ENABLED = "lock_pattern_autolock";
        @Deprecated
        public static final String LOCK_PATTERN_TACTILE_FEEDBACK_ENABLED = "lock_pattern_tactile_feedback_enabled";
        @Deprecated
        public static final String LOCK_PATTERN_VISIBLE = "lock_pattern_visible_pattern";
        @Deprecated
        public static final String LOCK_SOUND = "lock_sound";
        public static final String LOCK_TO_APP_ENABLED = "lock_to_app_enabled";
        public static final String LOCK_TO_APP_EXIT_LOCKED = "lock_to_app_exit_locked";
        @Deprecated
        public static final String LOGGING_ID = "logging_id";
        public static final String LONG_PRESSED_FUNC = "long_pressed_func";
        public static final int LONG_PRESSED_FUNC_DEFAULT = 1;
        public static final int LONG_PRESSED_FUNC_MENU = 1;
        public static final int LONG_PRESSED_FUNC_RECENTLIST = 2;
        public static final int LONG_PRESSED_FUNC_SCREENSHOT = 0;
        @Deprecated
        public static final String LOW_BATTERY_SOUND = "low_battery_sound";
        public static final String MEDIA_BUTTON_RECEIVER = "media_button_receiver";
        public static final String MICROPHONE_MUTE = "microphone_mute";
        public static final String MIDDLE_BUTTON_MAPPING = "middle_button_mapping";
        @Deprecated
        public static final String MOBILE_SLEEP_POLICY = "mobile_sleep_policy";
        @Deprecated
        public static final int MOBILE_SLEEP_POLICY_DEFAULT = 0;
        @Deprecated
        public static final int MOBILE_SLEEP_POLICY_NEVER = 2;
        @Deprecated
        public static final int MOBILE_SLEEP_POLICY_NEVER_WHILE_PLUGGED = 1;
        @Deprecated
        public static final String MODE_RINGER = "mode_ringer";
        public static final String MODE_RINGER_STREAMS_AFFECTED = "mode_ringer_streams_affected";
        private static final HashSet<String> MOVED_TO_GLOBAL;
        private static final HashSet<String> MOVED_TO_SECURE;
        private static final HashSet<String> MOVED_TO_SECURE_THEN_GLOBAL;
        public static final String MUTE_STREAMS_AFFECTED = "mute_streams_affected";
        @Deprecated
        public static final String NETWORK_PREFERENCE = "network_preference";
        public static final String NEWMAIL_SOUND = "newmail_sound";
        @Deprecated
        public static final String NEXT_ALARM_FORMATTED = "next_alarm_formatted";
        @Deprecated
        public static final String NOTIFICATIONS_USE_RING_VOLUME = "notifications_use_ring_volume";
        public static final String NOTIFICATION_LIGHT_PULSE = "notification_light_pulse";
        public static final String NOTIFICATION_SOUND = "notification_sound";
        public static final String NOTIFICATION_SOUND_2 = "notification_sound_2";
        @Deprecated
        public static final String PARENTAL_CONTROL_ENABLED = "parental_control_enabled";
        @Deprecated
        public static final String PARENTAL_CONTROL_LAST_UPDATE = "parental_control_last_update";
        @Deprecated
        public static final String PARENTAL_CONTROL_REDIRECT_URL = "parental_control_redirect_url";
        public static final String POINTER_LOCATION = "pointer_location";
        public static final String POINTER_SPEED = "pointer_speed";
        public static final String POWER_SAVER_ENABLED = "power_saver_enabled";
        @Deprecated
        public static final String POWER_SOUNDS_ENABLED = "power_sounds_enabled";
        public static final String QUICKBOX_AUDIOWIZARD_ORDER = "quickbox_audiowizard_order";
        public static final String QUICKBOX_BOOST_ORDER = "quickbox_boost_order";
        public static final String QUICKBOX_CALCULATOR_ORDER = "quickbox_calculator_order";
        public static final String QUICKBOX_CAMERA_ORDER = "quickbox_camera_order";
        public static final String QUICKBOX_DICTIONARY_ORDER = "quickbox_dictionary_order";
        public static final String QUICKBOX_FLASHLIGHT_ORDER = "quickbox_flashlight_order";
        public static final String QUICKBOX_FMRADIO_ORDER = "quickbox_fmradio_order";
        public static final String QUICKBOX_MIRROR_ORDER = "quickbox_mirror_order";
        public static final String QUICKBOX_QUICKMEMO_ORDER = "quickbox_quickmemo_order";
        public static final String QUICKBOX_SOUNDRECORDER_ORDER = "quickbox_soundrecord_order";
        public static final String QUICK_BOX_FIRST_TIME_REORDER = "quick_box_first_time_reorder";
        public static final int QUICK_SETTINGS_AIRPLANEMODE_ENABLED = 1;
        public static final String QUICK_SETTINGS_AIRPLANEMODE_ORDER;
        public static final int QUICK_SETTINGS_AUTOROTATE_ENABLED = 32;
        public static final String QUICK_SETTINGS_AUTOROTATE_ORDER;
        public static final int QUICK_SETTINGS_AUTOSYNC_ENABLED = 64;
        public static final String QUICK_SETTINGS_AUTOSYNC_ORDER;
        public static final int QUICK_SETTINGS_BLUETOOTH_ENABLED = 4;
        public static final String QUICK_SETTINGS_BLUETOOTH_ORDER;
        public static final int QUICK_SETTINGS_DEFAULT_ENABLED_CONTROLLERS = 0x21FFFFF;
        public static final int QUICK_SETTINGS_DO_NOT_DISTURB_ENABLED = 0x100000;
        public static final String QUICK_SETTINGS_DO_NOT_DISTURB_ORDER;
        public static final int QUICK_SETTINGS_DUAL_APPS_ENABLED = 524288;
        public static final String QUICK_SETTINGS_DUAL_APPS_ORDER;
        public static final String QUICK_SETTINGS_ENABLED_CONTROLLERS = "QUICK_SETTINGS_ENABLED_CONTROLLERS";
        public static final String QUICK_SETTINGS_FIRST_TIME_TO_BOOT = "QUICK_SETTINGS_FIRST_TIME_TO_BOOT";
        public static final int QUICK_SETTINGS_GLOVEMODE_ENABLED = 131072;
        public static final String QUICK_SETTINGS_GLOVEMODE_ORDER;
        public static final int QUICK_SETTINGS_GPS_ENABLED = 2;
        public static final String QUICK_SETTINGS_GPS_ORDER;
        public static final int QUICK_SETTINGS_INSTANTDIC_ENABLED = 256;
        public static final String QUICK_SETTINGS_INSTANTDIC_ORDER;
        public static final int QUICK_SETTINGS_MIRACAST_ENABLED = 32768;
        public static final String QUICK_SETTINGS_MIRACAST_ORDER;
        public static final int QUICK_SETTINGS_MOBILEDATA_ENABLED = 512;
        public static final String QUICK_SETTINGS_MOBILEDATA_ORDER;
        public static final int QUICK_SETTINGS_MULTISIM_ENABLED = 0x2000000;
        public static final String QUICK_SETTINGS_MULTISIM_ORDER;
        public static final int QUICK_SETTINGS_NFC_ENABLED = 1024;
        public static final String QUICK_SETTINGS_NFC_ORDER;
        public static final int QUICK_SETTINGS_ONEHAND_ENABLED = 16384;
        public static final String QUICK_SETTINGS_ONEHAND_ORDER;
        public static final int QUICK_SETTINGS_PLAYTO_ENABLED = 262144;
        public static final String QUICK_SETTINGS_PLAYTO_ORDER;
        public static final int QUICK_SETTINGS_POWERSAVING2_ENABLED = 2048;
        public static final String QUICK_SETTINGS_POWERSAVING2_ORDER;
        public static final int QUICK_SETTINGS_RESET = 0;
        public static final int QUICK_SETTINGS_SILENT_ENABLED = 8;
        public static final String QUICK_SETTINGS_SILENT_ORDER;
        public static final int QUICK_SETTINGS_SPLENDID_ENABLED = 4096;
        public static final String QUICK_SETTINGS_SPLENDID_ORDER;
        public static final int QUICK_SETTINGS_USER_ENABLED = 65536;
        public static final String QUICK_SETTINGS_USER_ORDER;
        public static final int QUICK_SETTINGS_VIBRATE_ENABLED = 8192;
        public static final String QUICK_SETTINGS_VIBRATE_ORDER;
        public static final int QUICK_SETTINGS_WIFISHARING_ENABLED = 128;
        public static final String QUICK_SETTINGS_WIFISHARING_ORDER;
        public static final int QUICK_SETTINGS_WIFI_ENABLED = 16;
        public static final String QUICK_SETTINGS_WIFI_ORDER;
        @Deprecated
        public static final String RADIO_BLUETOOTH = "bluetooth";
        @Deprecated
        public static final String RADIO_CELL = "cell";
        @Deprecated
        public static final String RADIO_NFC = "nfc";
        @Deprecated
        public static final String RADIO_WIFI = "wifi";
        @Deprecated
        public static final String RADIO_WIMAX = "wimax";
        public static final String RIGHT_BUTTON_MAPPING = "right_button_mapping";
        public static final String RINGTONE = "ringtone";
        public static final String RINGTONE_2 = "ringtone_2";
        public static final String SCREENSHOT = "screenshot";
        public static final String SCREENSHOT_FORMAT = "screenshot_format";
        public static final String SCREEN_AUTO_BRIGHTNESS_ADJ = "screen_auto_brightness_adj";
        public static final String SCREEN_BRIGHTNESS = "screen_brightness";
        public static final String SCREEN_BRIGHTNESS_MODE = "screen_brightness_mode";
        public static final int SCREEN_BRIGHTNESS_MODE_AUTOMATIC = 1;
        public static final int SCREEN_BRIGHTNESS_MODE_MANUAL = 0;
        public static final String SCREEN_HIGH_BRIGHTNESS_MODE = "screen_high_brightness_mode";
        public static final String SCREEN_OFF_TIMEOUT = "screen_off_timeout";
        public static final String SENTMAIL_SOUND = "sentmail_sound";
        @Deprecated
        public static final String SETTINGS_CLASSNAME = "settings_classname";
        public static final String[] SETTINGS_TO_BACKUP;
        public static final String SETTING_DO_NOT_DISTURB = "asus_do_not_disturb";
        public static final String SETTING_INSTANT_DICTIONARY = "setting_instant_dictionary";
        public static final int SETTING_INSTANT_DICTIONARY_DEFAULT_MODE = 0;
        public static final int SETTING_INSTANT_DICTIONARY_DISABLED = 0;
        public static final int SETTING_INSTANT_DICTIONARY_ENABLED = 1;
        public static final int SETTING_READING_MODE_DEFAULT_MODE = 0;
        public static final int SETTING_READING_MODE_DISABLED = 0;
        public static final String SETTING_SPLENDID_READING_MODE = "asus_splendid_reading_mode_main_switch";
        public static final String SETUP_WIZARD_HAS_RUN = "setup_wizard_has_run";
        public static final String SET_PAD_WALLPAPER_FOR = "set_pad_wallpaper_for";
        public static final String SET_PHONE_WALLPAPER_FOR = "set_phone_wallpaper_for";
        public static final String SET_WALLPAPER_FOR = "set_wallpaper_for";
        public static final String SHOW_BATTERY = "show_battery";
        public static final String SHOW_GTALK_SERVICE_STATUS = "SHOW_GTALK_SERVICE_STATUS";
        @Deprecated
        public static final String SHOW_PROCESSES = "show_processes";
        public static final String SHOW_TOUCHES = "show_touches";
        @Deprecated
        public static final String SHOW_WEB_SUGGESTIONS = "show_web_suggestions";
        public static final String SIP_ADDRESS_ONLY = "SIP_ADDRESS_ONLY";
        public static final String SIP_ALWAYS = "SIP_ALWAYS";
        @Deprecated
        public static final String SIP_ASK_ME_EACH_TIME = "SIP_ASK_ME_EACH_TIME";
        public static final String SIP_CALL_OPTIONS = "sip_call_options";
        public static final String SIP_RECEIVE_CALLS = "sip_receive_calls";
        public static final String SOUND_EFFECTS_ENABLED = "sound_effects_enabled";
        @Deprecated
        public static final String STAY_ON_WHILE_PLUGGED_IN = "stay_on_while_plugged_in";
        public static final String SYS_PROP_SETTING_VERSION = "sys.settings_system_version";
        public static final String TEXT_AUTO_CAPS = "auto_caps";
        public static final String TEXT_AUTO_PUNCTUATE = "auto_punctuate";
        public static final String TEXT_AUTO_REPLACE = "auto_replace";
        public static final String TEXT_SHOW_PASSWORD = "show_password";
        public static final String TIME_12_24 = "time_12_24";
        public static final String TOUCHPAD_MODE = "touchpad_mode";
        public static final int TOUCHPAD_MODE_ANDROID = 0;
        public static final int TOUCHPAD_MODE_CLASSIC = 1;
        @Deprecated
        public static final String TRANSITION_ANIMATION_SCALE = "transition_animation_scale";
        public static final String TTY_MODE = "tty_mode";
        @Deprecated
        public static final String UNLOCK_SOUND = "unlock_sound";
        @Deprecated
        public static final String USB_MASS_STORAGE_ENABLED = "usb_mass_storage_enabled";
        public static final String USER_ROTATION = "user_rotation";
        @Deprecated
        public static final String USE_GOOGLE_MAIL = "use_google_mail";
        public static final String VIBRATE_INPUT_DEVICES = "vibrate_input_devices";
        public static final String VIBRATE_IN_SILENT = "vibrate_in_silent";
        public static final String VIBRATE_ON = "vibrate_on";
        public static final String VIBRATE_WHEN_RINGING = "vibrate_when_ringing";
        public static final String VOLUME_ALARM = "volume_alarm";
        public static final String VOLUME_BLUETOOTH_SCO = "volume_bluetooth_sco";
        public static final String VOLUME_MASTER = "volume_master";
        public static final String VOLUME_MASTER_MUTE = "volume_master_mute";
        public static final String VOLUME_MUSIC = "volume_music";
        public static final String VOLUME_NOTIFICATION = "volume_notification";
        public static final String VOLUME_RING = "volume_ring";
        public static final String[] VOLUME_SETTINGS;
        public static final String VOLUME_SYSTEM = "volume_system";
        public static final String VOLUME_VOICE = "volume_voice";
        @Deprecated
        public static final String WAIT_FOR_DEBUGGER = "wait_for_debugger";
        @Deprecated
        public static final String WALLPAPER_ACTIVITY = "wallpaper_activity";
        public static final int WALLPAPER_BOTH = 2;
        public static final int WALLPAPER_HOME = 0;
        public static final int WALLPAPER_LOCKSCREEN = 1;
        public static final int WALLPAPER_NONE = -1;
        public static final String WHEN_TO_MAKE_WIFI_CALLS = "when_to_make_wifi_calls";
        @Deprecated
        public static final String WIFI_MAX_DHCP_RETRY_COUNT = "wifi_max_dhcp_retry_count";
        @Deprecated
        public static final String WIFI_MOBILE_DATA_TRANSITION_WAKELOCK_TIMEOUT_MS = "wifi_mobile_data_transition_wakelock_timeout_ms";
        @Deprecated
        public static final String WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON = "wifi_networks_available_notification_on";
        @Deprecated
        public static final String WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY = "wifi_networks_available_repeat_delay";
        @Deprecated
        public static final String WIFI_NUM_OPEN_NETWORKS_KEPT = "wifi_num_open_networks_kept";
        @Deprecated
        public static final String WIFI_ON = "wifi_on";
        @Deprecated
        public static final String WIFI_SLEEP_POLICY = "wifi_sleep_policy";
        @Deprecated
        public static final int WIFI_SLEEP_POLICY_DEFAULT = 0;
        @Deprecated
        public static final int WIFI_SLEEP_POLICY_NEVER = 2;
        @Deprecated
        public static final int WIFI_SLEEP_POLICY_NEVER_WHILE_PLUGGED = 1;
        @Deprecated
        public static final String WIFI_STATIC_DNS1 = "wifi_static_dns1";
        @Deprecated
        public static final String WIFI_STATIC_DNS2 = "wifi_static_dns2";
        @Deprecated
        public static final String WIFI_STATIC_GATEWAY = "wifi_static_gateway";
        @Deprecated
        public static final String WIFI_STATIC_IP = "wifi_static_ip";
        @Deprecated
        public static final String WIFI_STATIC_NETMASK = "wifi_static_netmask";
        @Deprecated
        public static final String WIFI_USE_STATIC_IP = "wifi_use_static_ip";
        @Deprecated
        public static final String WIFI_WATCHDOG_ACCEPTABLE_PACKET_LOSS_PERCENTAGE = "wifi_watchdog_acceptable_packet_loss_percentage";
        @Deprecated
        public static final String WIFI_WATCHDOG_AP_COUNT = "wifi_watchdog_ap_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_DELAY_MS = "wifi_watchdog_background_check_delay_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_ENABLED = "wifi_watchdog_background_check_enabled";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_TIMEOUT_MS = "wifi_watchdog_background_check_timeout_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_INITIAL_IGNORED_PING_COUNT = "wifi_watchdog_initial_ignored_ping_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_MAX_AP_CHECKS = "wifi_watchdog_max_ap_checks";
        @Deprecated
        public static final String WIFI_WATCHDOG_ON = "wifi_watchdog_on";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_COUNT = "wifi_watchdog_ping_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_DELAY_MS = "wifi_watchdog_ping_delay_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_TIMEOUT_MS = "wifi_watchdog_ping_timeout_ms";
        @Deprecated
        public static final String WINDOW_ANIMATION_SCALE = "window_animation_scale";
        public static final String WINDOW_ORIENTATION_LISTENER_LOG = "window_orientation_listener_log";
        private static final NameValueCache sNameValueCache;

        /*
         * Enabled aggressive block sorting
         */
        static {
            CONTENT_URI = Uri.parse("content://settings/system");
            sNameValueCache = new NameValueCache(SYS_PROP_SETTING_VERSION, CONTENT_URI, Settings.CALL_METHOD_GET_SYSTEM, Settings.CALL_METHOD_PUT_SYSTEM);
            MOVED_TO_SECURE = new HashSet(30);
            MOVED_TO_SECURE.add(ANDROID_ID);
            MOVED_TO_SECURE.add(HTTP_PROXY);
            MOVED_TO_SECURE.add(LOCATION_PROVIDERS_ALLOWED);
            MOVED_TO_SECURE.add("lock_biometric_weak_flags");
            MOVED_TO_SECURE.add(LOCK_PATTERN_ENABLED);
            MOVED_TO_SECURE.add(LOCK_PATTERN_VISIBLE);
            MOVED_TO_SECURE.add(LOCK_PATTERN_TACTILE_FEEDBACK_ENABLED);
            MOVED_TO_SECURE.add(LOGGING_ID);
            MOVED_TO_SECURE.add(PARENTAL_CONTROL_ENABLED);
            MOVED_TO_SECURE.add(PARENTAL_CONTROL_LAST_UPDATE);
            MOVED_TO_SECURE.add(PARENTAL_CONTROL_REDIRECT_URL);
            MOVED_TO_SECURE.add(SETTINGS_CLASSNAME);
            MOVED_TO_SECURE.add(USE_GOOGLE_MAIL);
            MOVED_TO_SECURE.add(WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON);
            MOVED_TO_SECURE.add(WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY);
            MOVED_TO_SECURE.add(WIFI_NUM_OPEN_NETWORKS_KEPT);
            MOVED_TO_SECURE.add(WIFI_ON);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_ACCEPTABLE_PACKET_LOSS_PERCENTAGE);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_AP_COUNT);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_BACKGROUND_CHECK_DELAY_MS);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_BACKGROUND_CHECK_ENABLED);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_BACKGROUND_CHECK_TIMEOUT_MS);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_INITIAL_IGNORED_PING_COUNT);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_MAX_AP_CHECKS);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_ON);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_PING_COUNT);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_PING_DELAY_MS);
            MOVED_TO_SECURE.add(WIFI_WATCHDOG_PING_TIMEOUT_MS);
            MOVED_TO_SECURE.add(INSTALL_NON_MARKET_APPS);
            MOVED_TO_GLOBAL = new HashSet();
            MOVED_TO_SECURE_THEN_GLOBAL = new HashSet();
            MOVED_TO_SECURE_THEN_GLOBAL.add(ADB_ENABLED);
            MOVED_TO_SECURE_THEN_GLOBAL.add(BLUETOOTH_ON);
            MOVED_TO_SECURE_THEN_GLOBAL.add(DATA_ROAMING);
            MOVED_TO_SECURE_THEN_GLOBAL.add(DEVICE_PROVISIONED);
            MOVED_TO_SECURE_THEN_GLOBAL.add(USB_MASS_STORAGE_ENABLED);
            MOVED_TO_SECURE_THEN_GLOBAL.add(HTTP_PROXY);
            MOVED_TO_GLOBAL.add(AIRPLANE_MODE_ON);
            MOVED_TO_GLOBAL.add(AIRPLANE_MODE_RADIOS);
            MOVED_TO_GLOBAL.add(AIRPLANE_MODE_TOGGLEABLE_RADIOS);
            MOVED_TO_GLOBAL.add(AUTO_TIME);
            MOVED_TO_GLOBAL.add(AUTO_TIME_ZONE);
            MOVED_TO_GLOBAL.add(CAR_DOCK_SOUND);
            MOVED_TO_GLOBAL.add(CAR_UNDOCK_SOUND);
            MOVED_TO_GLOBAL.add(DESK_DOCK_SOUND);
            MOVED_TO_GLOBAL.add(DESK_UNDOCK_SOUND);
            MOVED_TO_GLOBAL.add(DOCK_SOUNDS_ENABLED);
            MOVED_TO_GLOBAL.add(LOCK_SOUND);
            MOVED_TO_GLOBAL.add(UNLOCK_SOUND);
            MOVED_TO_GLOBAL.add(LOW_BATTERY_SOUND);
            MOVED_TO_GLOBAL.add(POWER_SOUNDS_ENABLED);
            MOVED_TO_GLOBAL.add(STAY_ON_WHILE_PLUGGED_IN);
            MOVED_TO_GLOBAL.add(WIFI_SLEEP_POLICY);
            MOVED_TO_GLOBAL.add(MOBILE_SLEEP_POLICY);
            MOVED_TO_GLOBAL.add(MODE_RINGER);
            MOVED_TO_GLOBAL.add(WINDOW_ANIMATION_SCALE);
            MOVED_TO_GLOBAL.add(TRANSITION_ANIMATION_SCALE);
            MOVED_TO_GLOBAL.add(ANIMATOR_DURATION_SCALE);
            MOVED_TO_GLOBAL.add("fancy_ime_animations");
            MOVED_TO_GLOBAL.add("compatibility_mode");
            MOVED_TO_GLOBAL.add("emergency_tone");
            MOVED_TO_GLOBAL.add("call_auto_retry");
            MOVED_TO_GLOBAL.add(DEBUG_APP);
            MOVED_TO_GLOBAL.add(WAIT_FOR_DEBUGGER);
            MOVED_TO_GLOBAL.add(SHOW_PROCESSES);
            MOVED_TO_GLOBAL.add(ALWAYS_FINISH_ACTIVITIES);
            MOVED_TO_GLOBAL.add("tzinfo_content_url");
            MOVED_TO_GLOBAL.add("tzinfo_metadata_url");
            MOVED_TO_GLOBAL.add("selinux_content_url");
            MOVED_TO_GLOBAL.add("selinux_metadata_url");
            MOVED_TO_GLOBAL.add("sms_short_codes_content_url");
            MOVED_TO_GLOBAL.add("sms_short_codes_metadata_url");
            MOVED_TO_GLOBAL.add("cert_pin_content_url");
            MOVED_TO_GLOBAL.add("cert_pin_metadata_url");
            MOVED_TO_GLOBAL.add(CPU_TURBE_MODE);
            MOVED_TO_GLOBAL.add(POWER_SAVER_ENABLED);
            MOVED_TO_GLOBAL.add(DOCK_POWER_SAVING);
            MOVED_TO_GLOBAL.add("primary_slot_voice");
            int n = Build.PRODUCT.substring(0, 4).equals("ATT_") ? 600000 : 480000;
            HOTSPOT_DISABLE_POLICY_DEFAULT = n;
            VOLUME_SETTINGS = new String[]{VOLUME_VOICE, VOLUME_SYSTEM, VOLUME_RING, VOLUME_MUSIC, VOLUME_ALARM, VOLUME_NOTIFICATION, VOLUME_BLUETOOTH_SCO};
            DEFAULT_RINGTONE_URI = System.getUriFor(RINGTONE);
            DEFAULT_NOTIFICATION_URI = System.getUriFor(NOTIFICATION_SOUND);
            DEFAULT_NEWMAIL_URI = System.getUriFor(NEWMAIL_SOUND);
            DEFAULT_SENTMAIL_URI = System.getUriFor(SENTMAIL_SOUND);
            DEFAULT_CALENDARALERT_URI = System.getUriFor(CALENDARALERT_SOUND);
            DEFAULT_ALARM_ALERT_URI = System.getUriFor(ALARM_ALERT);
            DEFAULT_RINGTONE_URI_2 = System.getUriFor(RINGTONE_2);
            DEFAULT_NOTIFICATION_URI_2 = System.getUriFor(NOTIFICATION_SOUND_2);
            SETTINGS_TO_BACKUP = new String[]{STAY_ON_WHILE_PLUGGED_IN, WIFI_USE_STATIC_IP, WIFI_STATIC_IP, WIFI_STATIC_GATEWAY, WIFI_STATIC_NETMASK, WIFI_STATIC_DNS1, WIFI_STATIC_DNS2, BLUETOOTH_DISCOVERABILITY, BLUETOOTH_DISCOVERABILITY_TIMEOUT, DIM_SCREEN, SCREEN_OFF_TIMEOUT, SCREEN_BRIGHTNESS, SCREEN_BRIGHTNESS_MODE, SCREEN_AUTO_BRIGHTNESS_ADJ, VIBRATE_INPUT_DEVICES, MODE_RINGER_STREAMS_AFFECTED, VOLUME_VOICE, VOLUME_SYSTEM, VOLUME_RING, VOLUME_MUSIC, VOLUME_ALARM, VOLUME_NOTIFICATION, VOLUME_BLUETOOTH_SCO, "volume_voice_last_audible", "volume_system_last_audible", "volume_ring_last_audible", "volume_music_last_audible", "volume_alarm_last_audible", "volume_notification_last_audible", "volume_bluetooth_sco_last_audible", TEXT_AUTO_REPLACE, TEXT_AUTO_CAPS, TEXT_AUTO_PUNCTUATE, TEXT_SHOW_PASSWORD, AUTO_TIME, AUTO_TIME_ZONE, TIME_12_24, DATE_FORMAT, DTMF_TONE_WHEN_DIALING, DTMF_TONE_TYPE_WHEN_DIALING, HEARING_AID, TTY_MODE, SOUND_EFFECTS_ENABLED, HAPTIC_FEEDBACK_ENABLED, POWER_SOUNDS_ENABLED, DOCK_SOUNDS_ENABLED, LOCKSCREEN_SOUNDS_ENABLED, SHOW_WEB_SUGGESTIONS, NOTIFICATION_LIGHT_PULSE, SIP_CALL_OPTIONS, SIP_RECEIVE_CALLS, POINTER_SPEED, VIBRATE_WHEN_RINGING, RINGTONE, NOTIFICATION_SOUND};
            CLONE_TO_MANAGED_PROFILE = new String[]{DATE_FORMAT, HAPTIC_FEEDBACK_ENABLED, SOUND_EFFECTS_ENABLED, TEXT_SHOW_PASSWORD, TIME_12_24};
            QUICK_SETTINGS_AIRPLANEMODE_ORDER = String.valueOf(1);
            QUICK_SETTINGS_GPS_ORDER = String.valueOf(2);
            QUICK_SETTINGS_BLUETOOTH_ORDER = String.valueOf(4);
            QUICK_SETTINGS_SILENT_ORDER = String.valueOf(8);
            QUICK_SETTINGS_WIFI_ORDER = String.valueOf(16);
            QUICK_SETTINGS_AUTOROTATE_ORDER = String.valueOf(32);
            QUICK_SETTINGS_AUTOSYNC_ORDER = String.valueOf(64);
            QUICK_SETTINGS_WIFISHARING_ORDER = String.valueOf(128);
            QUICK_SETTINGS_INSTANTDIC_ORDER = String.valueOf(256);
            QUICK_SETTINGS_MOBILEDATA_ORDER = String.valueOf(512);
            QUICK_SETTINGS_NFC_ORDER = String.valueOf(1024);
            QUICK_SETTINGS_POWERSAVING2_ORDER = String.valueOf(2048);
            QUICK_SETTINGS_SPLENDID_ORDER = String.valueOf(4096);
            QUICK_SETTINGS_VIBRATE_ORDER = String.valueOf(8192);
            QUICK_SETTINGS_ONEHAND_ORDER = String.valueOf(16384);
            QUICK_SETTINGS_MIRACAST_ORDER = String.valueOf(32768);
            QUICK_SETTINGS_USER_ORDER = String.valueOf(65536);
            QUICK_SETTINGS_GLOVEMODE_ORDER = String.valueOf(131072);
            QUICK_SETTINGS_PLAYTO_ORDER = String.valueOf(262144);
            QUICK_SETTINGS_DUAL_APPS_ORDER = String.valueOf(524288);
            QUICK_SETTINGS_MULTISIM_ORDER = String.valueOf(0x2000000);
            QUICK_SETTINGS_DO_NOT_DISTURB_ORDER = String.valueOf(0x100000);
        }

        public static void clearConfiguration(Configuration configuration) {
            configuration.fontScale = 0.0f;
        }

        public static void getConfiguration(ContentResolver contentResolver, Configuration configuration) {
            System.getConfigurationForUser(contentResolver, configuration, UserHandle.myUserId());
        }

        public static void getConfigurationForUser(ContentResolver contentResolver, Configuration configuration, int n) {
            configuration.fontScale = System.getFloatForUser(contentResolver, FONT_SCALE, configuration.fontScale, n);
            if (configuration.fontScale < 0.0f) {
                configuration.fontScale = 1.0f;
            }
        }

        public static float getFloat(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            return System.getFloatForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static float getFloat(ContentResolver contentResolver, String string2, float f) {
            return System.getFloatForUser(contentResolver, string2, f, UserHandle.myUserId());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static float getFloatForUser(ContentResolver contentResolver, String string2, float f, int n) {
            String string3 = System.getStringForUser(contentResolver, string2, n);
            if (string3 == null) return f;
            try {
                float f2 = Float.parseFloat(string3);
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        public static float getFloatForUser(ContentResolver contentResolver, String string2, int n) throws SettingNotFoundException {
            String string3 = System.getStringForUser(contentResolver, string2, n);
            if (string3 == null) {
                throw new SettingNotFoundException(string2);
            }
            try {
                float f = Float.parseFloat(string3);
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        public static int getInt(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            return System.getIntForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static int getInt(ContentResolver contentResolver, String string2, int n) {
            return System.getIntForUser(contentResolver, string2, n, UserHandle.myUserId());
        }

        public static int getIntForUser(ContentResolver contentResolver, String string2, int n) throws SettingNotFoundException {
            String string3 = System.getStringForUser(contentResolver, string2, n);
            try {
                int n2 = Integer.parseInt(string3);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int getIntForUser(ContentResolver contentResolver, String string2, int n, int n2) {
            String string3 = System.getStringForUser(contentResolver, string2, n2);
            if (string3 == null) return n;
            try {
                int n3 = Integer.parseInt(string3);
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        public static long getLong(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            return System.getLongForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static long getLong(ContentResolver contentResolver, String string2, long l) {
            return System.getLongForUser(contentResolver, string2, l, UserHandle.myUserId());
        }

        public static long getLongForUser(ContentResolver contentResolver, String string2, int n) throws SettingNotFoundException {
            String string3 = System.getStringForUser(contentResolver, string2, n);
            try {
                long l = Long.parseLong(string3);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static long getLongForUser(ContentResolver contentResolver, String string2, long l, int n) {
            String string3 = System.getStringForUser(contentResolver, string2, n);
            if (string3 == null) return l;
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        public static void getMovedKeys(HashSet<String> hashSet) {
            hashSet.addAll(MOVED_TO_GLOBAL);
            hashSet.addAll(MOVED_TO_SECURE_THEN_GLOBAL);
        }

        public static void getNonLegacyMovedKeys(HashSet<String> hashSet) {
            hashSet.addAll(MOVED_TO_GLOBAL);
        }

        @Deprecated
        public static boolean getShowGTalkServiceStatus(ContentResolver contentResolver) {
            return System.getShowGTalkServiceStatusForUser(contentResolver, UserHandle.myUserId());
        }

        public static boolean getShowGTalkServiceStatusForUser(ContentResolver contentResolver, int n) {
            int n2 = System.getIntForUser(contentResolver, SHOW_GTALK_SERVICE_STATUS, 0, n);
            boolean bl = false;
            if (n2 != 0) {
                bl = true;
            }
            return bl;
        }

        public static String getString(ContentResolver contentResolver, String string2) {
            return System.getStringForUser(contentResolver, string2, UserHandle.myUserId());
        }

        public static String getStringForUser(ContentResolver contentResolver, String string2, int n) {
            if (MOVED_TO_SECURE.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Secure, returning read-only value.");
                return Secure.getStringForUser(contentResolver, string2, n);
            }
            if (MOVED_TO_GLOBAL.contains(string2) || MOVED_TO_SECURE_THEN_GLOBAL.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Global, returning read-only value.");
                return Global.getStringForUser(contentResolver, string2, n);
            }
            return sNameValueCache.getStringForUser(contentResolver, string2, n);
        }

        public static Uri getUriFor(String string2) {
            if (MOVED_TO_SECURE.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Secure, returning Secure URI.");
                return Secure.getUriFor(Secure.CONTENT_URI, string2);
            }
            if (MOVED_TO_GLOBAL.contains(string2) || MOVED_TO_SECURE_THEN_GLOBAL.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Global, returning read-only global URI.");
                return Global.getUriFor(Global.CONTENT_URI, string2);
            }
            return System.getUriFor(CONTENT_URI, string2);
        }

        public static boolean hasInterestingConfigurationChanges(int n) {
            return (0x40000000 & n) != 0;
        }

        public static boolean putConfiguration(ContentResolver contentResolver, Configuration configuration) {
            return System.putConfigurationForUser(contentResolver, configuration, UserHandle.myUserId());
        }

        public static boolean putConfigurationForUser(ContentResolver contentResolver, Configuration configuration, int n) {
            return System.putFloatForUser(contentResolver, FONT_SCALE, configuration.fontScale, n);
        }

        public static boolean putFloat(ContentResolver contentResolver, String string2, float f) {
            return System.putFloatForUser(contentResolver, string2, f, UserHandle.myUserId());
        }

        public static boolean putFloatForUser(ContentResolver contentResolver, String string2, float f, int n) {
            return System.putStringForUser(contentResolver, string2, Float.toString(f), n);
        }

        public static boolean putInt(ContentResolver contentResolver, String string2, int n) {
            return System.putIntForUser(contentResolver, string2, n, UserHandle.myUserId());
        }

        public static boolean putIntForUser(ContentResolver contentResolver, String string2, int n, int n2) {
            return System.putStringForUser(contentResolver, string2, Integer.toString(n), n2);
        }

        public static boolean putLong(ContentResolver contentResolver, String string2, long l) {
            return System.putLongForUser(contentResolver, string2, l, UserHandle.myUserId());
        }

        public static boolean putLongForUser(ContentResolver contentResolver, String string2, long l, int n) {
            return System.putStringForUser(contentResolver, string2, Long.toString(l), n);
        }

        public static boolean putString(ContentResolver contentResolver, String string2, String string3) {
            return System.putStringForUser(contentResolver, string2, string3, UserHandle.myUserId());
        }

        public static boolean putStringForUser(ContentResolver contentResolver, String string2, String string3, int n) {
            if (MOVED_TO_SECURE.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Secure, value is unchanged.");
                return false;
            }
            if (MOVED_TO_GLOBAL.contains(string2) || MOVED_TO_SECURE_THEN_GLOBAL.contains(string2)) {
                Log.w(Settings.TAG, "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Global, value is unchanged.");
                return false;
            }
            return sNameValueCache.putStringForUser(contentResolver, string2, string3, n);
        }

        @Deprecated
        public static void setShowGTalkServiceStatus(ContentResolver contentResolver, boolean bl) {
            System.setShowGTalkServiceStatusForUser(contentResolver, bl, UserHandle.myUserId());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Deprecated
        public static void setShowGTalkServiceStatusForUser(ContentResolver contentResolver, boolean bl, int n) {
            int n2 = bl ? 1 : 0;
            System.putIntForUser(contentResolver, SHOW_GTALK_SERVICE_STATUS, n2, n);
        }
    }
}

