/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.ILayoutResultCallback;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintDocumentAdapterObserver;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintManager;
import android.print.IWriteResultCallback;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintJob;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterDiscoverySession;
import android.printservice.PrintServiceInfo;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;

public final class PrintManager {
    public static final String ACTION_PRINT_DIALOG = "android.print.PRINT_DIALOG";
    public static final int APP_ID_ANY = -2;
    private static final boolean DEBUG = false;
    public static final String EXTRA_PRINT_DIALOG_INTENT = "android.print.intent.extra.EXTRA_PRINT_DIALOG_INTENT";
    public static final String EXTRA_PRINT_DOCUMENT_ADAPTER = "android.print.intent.extra.EXTRA_PRINT_DOCUMENT_ADAPTER";
    public static final String EXTRA_PRINT_JOB = "android.print.intent.extra.EXTRA_PRINT_JOB";
    private static final String LOG_TAG = "PrintManager";
    private static final int MSG_NOTIFY_PRINT_JOB_STATE_CHANGED = 1;
    private final int mAppId;
    private final Context mContext;
    private final Handler mHandler;
    private Map<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper> mPrintJobStateChangeListeners;
    private final IPrintManager mService;
    private final int mUserId;

    public PrintManager(Context context, IPrintManager iPrintManager, int n, int n2) {
        this.mContext = context;
        this.mService = iPrintManager;
        this.mUserId = n;
        this.mAppId = n2;
        this.mHandler = new Handler(context.getMainLooper(), null, false){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: 
                }
                SomeArgs someArgs = (SomeArgs)message.obj;
                PrintJobStateChangeListener printJobStateChangeListener = ((PrintJobStateChangeListenerWrapper)someArgs.arg1).getListener();
                if (printJobStateChangeListener != null) {
                    printJobStateChangeListener.onPrintJobStateChanged((PrintJobId)someArgs.arg2);
                }
                someArgs.recycle();
            }
        };
    }

    public void addPrintJobStateChangeListener(PrintJobStateChangeListener printJobStateChangeListener) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        if (this.mPrintJobStateChangeListeners == null) {
            this.mPrintJobStateChangeListeners = new ArrayMap<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper>();
        }
        PrintJobStateChangeListenerWrapper printJobStateChangeListenerWrapper = new PrintJobStateChangeListenerWrapper(printJobStateChangeListener, this.mHandler);
        try {
            this.mService.addPrintJobStateChangeListener(printJobStateChangeListenerWrapper, this.mAppId, this.mUserId);
            this.mPrintJobStateChangeListeners.put(printJobStateChangeListener, printJobStateChangeListenerWrapper);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error adding print job state change listener", remoteException);
            return;
        }
    }

    void cancelPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.cancelPrintJob(printJobId, this.mAppId, this.mUserId);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error canceling a print job: " + printJobId, remoteException);
            return;
        }
    }

    public PrinterDiscoverySession createPrinterDiscoverySession() {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        return new PrinterDiscoverySession(this.mService, this.mContext, this.mUserId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<PrintServiceInfo> getEnabledPrintServices() {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return Collections.emptyList();
        }
        try {
            List<PrintServiceInfo> list = this.mService.getEnabledPrintServices(this.mUserId);
            List<PrintServiceInfo> list2 = list;
            if (list2 != null) return list2;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error getting the enabled print services", remoteException);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public PrintManager getGlobalPrintManagerForUser(int n) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        return new PrintManager(this.mContext, this.mService, n, -2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<PrintServiceInfo> getInstalledPrintServices() {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return Collections.emptyList();
        }
        try {
            List<PrintServiceInfo> list = this.mService.getInstalledPrintServices(this.mUserId);
            List<PrintServiceInfo> list2 = list;
            if (list2 != null) return list2;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error getting the installed print services", remoteException);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrintJob getPrintJob(PrintJobId printJobId) {
        PrintJobInfo printJobInfo;
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        try {
            printJobInfo = this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
            if (printJobInfo == null) return null;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error getting print job", remoteException);
            return null;
        }
        return new PrintJob(printJobInfo, this);
    }

    PrintJobInfo getPrintJobInfo(PrintJobId printJobId) {
        try {
            PrintJobInfo printJobInfo = this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
            return printJobInfo;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error getting a print job info:" + printJobId, remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PrintJob> getPrintJobs() {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return Collections.emptyList();
        }
        try {
            List<PrintJobInfo> list = this.mService.getPrintJobInfos(this.mAppId, this.mUserId);
            if (list == null) {
                return Collections.emptyList();
            }
            int n = list.size();
            List<PrintJob> list2 = new ArrayList<PrintJob>(n);
            int n2 = 0;
            while (n2 < n) {
                list2.add(new PrintJob(list.get(n2), this));
                ++n2;
            }
            return list2;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error getting print jobs", remoteException);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrintJob print(String string2, PrintDocumentAdapter printDocumentAdapter, PrintAttributes printAttributes) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        if (!(this.mContext instanceof Activity)) {
            throw new IllegalStateException("Can print only from an activity");
        }
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("printJobName cannot be empty");
        }
        if (printDocumentAdapter == null) {
            throw new IllegalArgumentException("documentAdapter cannot be null");
        }
        PrintDocumentAdapterDelegate printDocumentAdapterDelegate = new PrintDocumentAdapterDelegate((Activity)this.mContext, printDocumentAdapter);
        try {
            Bundle bundle = this.mService.print(string2, printDocumentAdapterDelegate, printAttributes, this.mContext.getPackageName(), this.mAppId, this.mUserId);
            if (bundle == null) return null;
            PrintJobInfo printJobInfo = (PrintJobInfo)bundle.getParcelable(EXTRA_PRINT_JOB);
            IntentSender intentSender = (IntentSender)bundle.getParcelable(EXTRA_PRINT_DIALOG_INTENT);
            if (printJobInfo == null) return null;
            if (intentSender == null) {
                return null;
            }
            try {
                this.mContext.startIntentSender(intentSender, null, 0, 0, 0);
                return new PrintJob(printJobInfo, this);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.e(LOG_TAG, "Couldn't start print job config activity.", sendIntentException);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error creating a print job", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePrintJobStateChangeListener(PrintJobStateChangeListener printJobStateChangeListener) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        } else {
            PrintJobStateChangeListenerWrapper printJobStateChangeListenerWrapper;
            if (this.mPrintJobStateChangeListeners == null || (printJobStateChangeListenerWrapper = this.mPrintJobStateChangeListeners.remove(printJobStateChangeListener)) == null) return;
            if (this.mPrintJobStateChangeListeners.isEmpty()) {
                this.mPrintJobStateChangeListeners = null;
            }
            printJobStateChangeListenerWrapper.destroy();
            try {
                this.mService.removePrintJobStateChangeListener(printJobStateChangeListenerWrapper, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error removing print job state change listener", remoteException);
                return;
            }
        }
    }

    void restartPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.restartPrintJob(printJobId, this.mAppId, this.mUserId);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error restarting a print job: " + printJobId, remoteException);
            return;
        }
    }

    private static final class PrintDocumentAdapterDelegate
    extends IPrintDocumentAdapter.Stub
    implements Application.ActivityLifecycleCallbacks {
        private Activity mActivity;
        private PrintDocumentAdapter mDocumentAdapter;
        private Handler mHandler;
        private final Object mLock = new Object();
        private IPrintDocumentAdapterObserver mObserver;
        private DestroyableCallback mPendingCallback;

        public PrintDocumentAdapterDelegate(Activity activity, PrintDocumentAdapter printDocumentAdapter) {
            this.mActivity = activity;
            this.mDocumentAdapter = printDocumentAdapter;
            this.mHandler = new MyHandler(this.mActivity.getMainLooper());
            this.mActivity.getApplication().registerActivityLifecycleCallbacks(this);
        }

        static /* synthetic */ DestroyableCallback access$202(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, DestroyableCallback destroyableCallback) {
            printDocumentAdapterDelegate.mPendingCallback = destroyableCallback;
            return destroyableCallback;
        }

        private void destroyLocked() {
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks(this);
            this.mActivity = null;
            this.mDocumentAdapter = null;
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            this.mHandler = null;
            this.mObserver = null;
            if (this.mPendingCallback != null) {
                this.mPendingCallback.destroy();
                this.mPendingCallback = null;
            }
        }

        private boolean isDestroyedLocked() {
            return this.mActivity == null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void finish() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(4, this.mDocumentAdapter).sendToTarget();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void layout(PrintAttributes printAttributes, PrintAttributes printAttributes2, ILayoutResultCallback iLayoutResultCallback, Bundle bundle, int n) {
            Object object;
            ICancellationSignal iCancellationSignal = CancellationSignal.createTransport();
            try {
                iLayoutResultCallback.onLayoutStarted(iCancellationSignal, n);
                object = this.mLock;
            }
            catch (RemoteException remoteException) {
                Log.e(PrintManager.LOG_TAG, "Error notifying for layout start", remoteException);
                return;
            }
            synchronized (object) {
                if (this.isDestroyedLocked()) {
                    return;
                }
                CancellationSignal cancellationSignal = CancellationSignal.fromTransport(iCancellationSignal);
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = this.mDocumentAdapter;
                someArgs.arg2 = printAttributes;
                someArgs.arg3 = printAttributes2;
                someArgs.arg4 = cancellationSignal;
                someArgs.arg5 = new MyLayoutResultCallback(iLayoutResultCallback, n);
                someArgs.arg6 = bundle;
                this.mHandler.obtainMessage(2, someArgs).sendToTarget();
                return;
            }
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onActivityDestroyed(Activity activity) {
            Object object = this.mLock;
            // MONITORENTER : object
            Activity activity2 = this.mActivity;
            IPrintDocumentAdapterObserver iPrintDocumentAdapterObserver = null;
            if (activity == activity2) {
                iPrintDocumentAdapterObserver = this.mObserver;
                this.destroyLocked();
            }
            // MONITOREXIT : object
            if (iPrintDocumentAdapterObserver == null) return;
            try {
                iPrintDocumentAdapterObserver.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(PrintManager.LOG_TAG, "Error announcing destroyed state", remoteException);
                return;
            }
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onActivityResumed(Activity activity) {
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        @Override
        public void onActivityStarted(Activity activity) {
        }

        @Override
        public void onActivityStopped(Activity activity) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setObserver(IPrintDocumentAdapterObserver iPrintDocumentAdapterObserver) {
            Object object = this.mLock;
            // MONITORENTER : object
            this.mObserver = iPrintDocumentAdapterObserver;
            boolean bl = this.isDestroyedLocked();
            // MONITOREXIT : object
            if (!bl) return;
            if (iPrintDocumentAdapterObserver == null) return;
            try {
                iPrintDocumentAdapterObserver.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(PrintManager.LOG_TAG, "Error announcing destroyed state", remoteException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void start() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(1, this.mDocumentAdapter).sendToTarget();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(PageRange[] pageRangeArray, ParcelFileDescriptor parcelFileDescriptor, IWriteResultCallback iWriteResultCallback, int n) {
            Object object;
            ICancellationSignal iCancellationSignal = CancellationSignal.createTransport();
            try {
                iWriteResultCallback.onWriteStarted(iCancellationSignal, n);
                object = this.mLock;
            }
            catch (RemoteException remoteException) {
                Log.e(PrintManager.LOG_TAG, "Error notifying for write start", remoteException);
                return;
            }
            synchronized (object) {
                if (this.isDestroyedLocked()) {
                    return;
                }
                CancellationSignal cancellationSignal = CancellationSignal.fromTransport(iCancellationSignal);
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = this.mDocumentAdapter;
                someArgs.arg2 = pageRangeArray;
                someArgs.arg3 = parcelFileDescriptor;
                someArgs.arg4 = cancellationSignal;
                someArgs.arg5 = new MyWriteResultCallback(iWriteResultCallback, parcelFileDescriptor, n);
                this.mHandler.obtainMessage(3, someArgs).sendToTarget();
                return;
            }
        }

        private static interface DestroyableCallback {
            public void destroy();
        }

        private final class MyHandler
        extends Handler {
            public static final int MSG_ON_FINISH = 4;
            public static final int MSG_ON_LAYOUT = 2;
            public static final int MSG_ON_START = 1;
            public static final int MSG_ON_WRITE = 3;

            public MyHandler(Looper looper) {
                super(looper, null, true);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        throw new IllegalArgumentException("Unknown message: " + message.what);
                    }
                    case 1: {
                        ((PrintDocumentAdapter)message.obj).onStart();
                        return;
                    }
                    case 2: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        PrintDocumentAdapter printDocumentAdapter = (PrintDocumentAdapter)someArgs.arg1;
                        PrintAttributes printAttributes = (PrintAttributes)someArgs.arg2;
                        PrintAttributes printAttributes2 = (PrintAttributes)someArgs.arg3;
                        CancellationSignal cancellationSignal = (CancellationSignal)someArgs.arg4;
                        PrintDocumentAdapter.LayoutResultCallback layoutResultCallback = (PrintDocumentAdapter.LayoutResultCallback)someArgs.arg5;
                        Bundle bundle = (Bundle)someArgs.arg6;
                        someArgs.recycle();
                        printDocumentAdapter.onLayout(printAttributes, printAttributes2, cancellationSignal, layoutResultCallback, bundle);
                        return;
                    }
                    case 3: {
                        SomeArgs someArgs = (SomeArgs)message.obj;
                        PrintDocumentAdapter printDocumentAdapter = (PrintDocumentAdapter)someArgs.arg1;
                        PageRange[] pageRangeArray = (PageRange[])someArgs.arg2;
                        ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)someArgs.arg3;
                        CancellationSignal cancellationSignal = (CancellationSignal)someArgs.arg4;
                        PrintDocumentAdapter.WriteResultCallback writeResultCallback = (PrintDocumentAdapter.WriteResultCallback)someArgs.arg5;
                        someArgs.recycle();
                        printDocumentAdapter.onWrite(pageRangeArray, parcelFileDescriptor, cancellationSignal, writeResultCallback);
                        return;
                    }
                    case 4: 
                }
                ((PrintDocumentAdapter)message.obj).onFinish();
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    PrintDocumentAdapterDelegate.this.destroyLocked();
                    return;
                }
            }
        }

        private final class MyLayoutResultCallback
        extends PrintDocumentAdapter.LayoutResultCallback
        implements DestroyableCallback {
            private ILayoutResultCallback mCallback;
            private final int mSequence;

            public MyLayoutResultCallback(ILayoutResultCallback iLayoutResultCallback, int n) {
                this.mCallback = iLayoutResultCallback;
                this.mSequence = n;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void destroy() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    this.mCallback = null;
                    PrintDocumentAdapterDelegate.access$202(PrintDocumentAdapterDelegate.this, null);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onLayoutCancelled() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                // MONITORENTER : object
                ILayoutResultCallback iLayoutResultCallback = this.mCallback;
                // MONITOREXIT : object
                if (iLayoutResultCallback == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    iLayoutResultCallback.onLayoutCanceled(this.mSequence);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onLayoutFailed", remoteException);
                    return;
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onLayoutFailed(CharSequence charSequence) {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                // MONITORENTER : object
                ILayoutResultCallback iLayoutResultCallback = this.mCallback;
                // MONITOREXIT : object
                if (iLayoutResultCallback == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    iLayoutResultCallback.onLayoutFailed(charSequence, this.mSequence);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onLayoutFailed", remoteException);
                    return;
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onLayoutFinished(PrintDocumentInfo var1_1, boolean var2_2) {
                var3_3 = PrintDocumentAdapterDelegate.access$000(PrintDocumentAdapterDelegate.this);
                synchronized (var3_3) {
                    var5_4 = this.mCallback;
                    ** if (var5_4 != null) goto lbl8
                }
lbl-1000:
                // 1 sources

                {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
lbl8:
                // 1 sources

                if (var1_1 == null) {
                    throw new NullPointerException("document info cannot be null");
                }
                ** try [egrp 3[TRYBLOCK] [4, 3 : 62->75)] { 
lbl14:
                // 1 sources

                var5_4.onLayoutFinished(var1_1, var2_2, this.mSequence);
                return;
lbl16:
                // 1 sources

                catch (RemoteException var6_6) {
                    Log.e("PrintManager", "Error calling onLayoutFinished", var6_6);
                    return;
                }
lbl20:
                // 1 sources

                finally {
                    this.destroy();
                }
            }
        }

        private final class MyWriteResultCallback
        extends PrintDocumentAdapter.WriteResultCallback
        implements DestroyableCallback {
            private IWriteResultCallback mCallback;
            private ParcelFileDescriptor mFd;
            private final int mSequence;

            public MyWriteResultCallback(IWriteResultCallback iWriteResultCallback, ParcelFileDescriptor parcelFileDescriptor, int n) {
                this.mFd = parcelFileDescriptor;
                this.mSequence = n;
                this.mCallback = iWriteResultCallback;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void destroy() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    IoUtils.closeQuietly((AutoCloseable)this.mFd);
                    this.mCallback = null;
                    this.mFd = null;
                    PrintDocumentAdapterDelegate.access$202(PrintDocumentAdapterDelegate.this, null);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onWriteCancelled() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                // MONITORENTER : object
                IWriteResultCallback iWriteResultCallback = this.mCallback;
                // MONITOREXIT : object
                if (iWriteResultCallback == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    iWriteResultCallback.onWriteCanceled(this.mSequence);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onWriteCanceled", remoteException);
                    return;
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onWriteFailed(CharSequence charSequence) {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                // MONITORENTER : object
                IWriteResultCallback iWriteResultCallback = this.mCallback;
                // MONITOREXIT : object
                if (iWriteResultCallback == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    iWriteResultCallback.onWriteFailed(charSequence, this.mSequence);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onWriteFailed", remoteException);
                    return;
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onWriteFinished(PageRange[] var1_1) {
                var2_2 = PrintDocumentAdapterDelegate.access$000(PrintDocumentAdapterDelegate.this);
                synchronized (var2_2) {
                    var4_3 = this.mCallback;
                    ** if (var4_3 != null) goto lbl8
                }
lbl-1000:
                // 1 sources

                {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
lbl8:
                // 1 sources

                if (var1_1 != null) ** GOTO lbl14
                throw new IllegalArgumentException("pages cannot be null");
                {
                    catch (Throwable var7_4) {
                        this.destroy();
                        throw var7_4;
                    }
lbl14:
                    // 1 sources

                    if (var1_1.length == 0) {
                        throw new IllegalArgumentException("pages cannot be empty");
                    }
                    try {
                        var4_3.onWriteFinished(var1_1, this.mSequence);
lbl18:
                        // 2 sources

                        while (true) {
                            this.destroy();
                            return;
                        }
                    }
                    catch (RemoteException var5_5) {}
                    {
                        Log.e("PrintManager", "Error calling onWriteFinished", var5_5);
                        ** continue;
                    }
                }
            }
        }
    }

    public static interface PrintJobStateChangeListener {
        public void onPrintJobStateChanged(PrintJobId var1);
    }

    private static final class PrintJobStateChangeListenerWrapper
    extends IPrintJobStateChangeListener.Stub {
        private final WeakReference<Handler> mWeakHandler;
        private final WeakReference<PrintJobStateChangeListener> mWeakListener;

        public PrintJobStateChangeListenerWrapper(PrintJobStateChangeListener printJobStateChangeListener, Handler handler) {
            this.mWeakListener = new WeakReference<PrintJobStateChangeListener>(printJobStateChangeListener);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        public void destroy() {
            this.mWeakListener.clear();
        }

        public PrintJobStateChangeListener getListener() {
            return (PrintJobStateChangeListener)this.mWeakListener.get();
        }

        @Override
        public void onPrintJobStateChanged(PrintJobId printJobId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintJobStateChangeListener printJobStateChangeListener = (PrintJobStateChangeListener)this.mWeakListener.get();
            if (handler != null && printJobStateChangeListener != null) {
                SomeArgs someArgs = SomeArgs.obtain();
                someArgs.arg1 = this;
                someArgs.arg2 = printJobId;
                handler.obtainMessage(1, someArgs).sendToTarget();
            }
        }
    }
}

