/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Fragment;
import android.app.FragmentBreadCrumbs;
import android.app.FragmentTransaction;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public abstract class PreferenceActivity
extends ListActivity
implements PreferenceManager.OnPreferenceTreeClickListener,
PreferenceFragment.OnPreferenceStartFragmentCallback {
    private static final String BACK_STACK_PREFS = ":android:prefs";
    private static final String CUR_HEADER_TAG = ":android:cur_header";
    public static final String EXTRA_NO_HEADERS = ":android:no_headers";
    private static final String EXTRA_PREFS_SET_BACK_TEXT = "extra_prefs_set_back_text";
    private static final String EXTRA_PREFS_SET_NEXT_TEXT = "extra_prefs_set_next_text";
    private static final String EXTRA_PREFS_SHOW_BUTTON_BAR = "extra_prefs_show_button_bar";
    private static final String EXTRA_PREFS_SHOW_SKIP = "extra_prefs_show_skip";
    public static final String EXTRA_SHOW_FRAGMENT = ":android:show_fragment";
    public static final String EXTRA_SHOW_FRAGMENT_ARGUMENTS = ":android:show_fragment_args";
    public static final String EXTRA_SHOW_FRAGMENT_SHORT_TITLE = ":android:show_fragment_short_title";
    public static final String EXTRA_SHOW_FRAGMENT_TITLE = ":android:show_fragment_title";
    private static final int FIRST_REQUEST_CODE = 100;
    private static final String HEADERS_TAG = ":android:headers";
    public static final long HEADER_ID_UNDEFINED = -1L;
    private static final int MSG_BIND_PREFERENCES = 1;
    private static final int MSG_BUILD_HEADERS = 2;
    private static final String PREFERENCES_TAG = ":android:preferences";
    private static final String TAG = "PreferenceActivity";
    private Header mCurHeader;
    private FragmentBreadCrumbs mFragmentBreadCrumbs;
    private Handler mHandler;
    private final ArrayList<Header> mHeaders = new ArrayList();
    private FrameLayout mListFooter;
    private Button mNextButton;
    private int mPreferenceHeaderItemResId = 0;
    private boolean mPreferenceHeaderRemoveEmptyIcon = false;
    private PreferenceManager mPreferenceManager;
    private ViewGroup mPrefsContainer;
    private Bundle mSavedInstanceState;
    private boolean mSinglePane;

    public PreferenceActivity() {
        this.mHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        PreferenceActivity.this.bindPreferences();
                        return;
                    }
                    case 2: {
                        Header header;
                        Header header2;
                        ArrayList<Header> arrayList = new ArrayList<Header>(PreferenceActivity.this.mHeaders);
                        PreferenceActivity.this.mHeaders.clear();
                        PreferenceActivity.this.onBuildHeaders(PreferenceActivity.this.mHeaders);
                        if (PreferenceActivity.this.mAdapter instanceof BaseAdapter) {
                            ((BaseAdapter)PreferenceActivity.this.mAdapter).notifyDataSetChanged();
                        }
                        if ((header2 = PreferenceActivity.this.onGetNewHeader()) != null && header2.fragment != null) {
                            Header header3 = PreferenceActivity.this.findBestMatchingHeader(header2, arrayList);
                            if (header3 != null && PreferenceActivity.this.mCurHeader == header3) return;
                            PreferenceActivity.this.switchToHeader(header2);
                            return;
                        }
                        if (PreferenceActivity.this.mCurHeader == null || (header = PreferenceActivity.this.findBestMatchingHeader(PreferenceActivity.this.mCurHeader, PreferenceActivity.this.mHeaders)) == null) return;
                        PreferenceActivity.this.setSelectedHeader(header);
                        return;
                    }
                }
            }
        };
    }

    private void bindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            preferenceScreen.bind(this.getListView());
            if (this.mSavedInstanceState != null) {
                super.onRestoreInstanceState(this.mSavedInstanceState);
                this.mSavedInstanceState = null;
            }
        }
    }

    private void postBindPreferences() {
        if (this.mHandler.hasMessages(1)) {
            return;
        }
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void requirePreferenceManager() {
        if (this.mPreferenceManager == null) {
            if (this.mAdapter == null) {
                throw new RuntimeException("This should be called after super.onCreate.");
            }
            throw new RuntimeException("Modern two-pane PreferenceActivity requires use of a PreferenceFragment");
        }
    }

    private void switchToHeaderInner(String string2, Bundle bundle) {
        this.getFragmentManager().popBackStack(BACK_STACK_PREFS, 1);
        if (!this.isValidFragment(string2)) {
            throw new IllegalArgumentException("Invalid fragment for this activity: " + string2);
        }
        Fragment fragment = Fragment.instantiate(this, string2, bundle);
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.setTransition(4099);
        fragmentTransaction.replace(16909071, fragment);
        fragmentTransaction.commitAllowingStateLoss();
    }

    @Deprecated
    public void addPreferencesFromIntent(Intent intent) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromIntent(intent, this.getPreferenceScreen()));
    }

    @Deprecated
    public void addPreferencesFromResource(int n) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromResource(this, n, this.getPreferenceScreen()));
    }

    /*
     * Enabled aggressive block sorting
     */
    Header findBestMatchingHeader(Header header, ArrayList<Header> arrayList) {
        int n;
        ArrayList<Header> arrayList2 = new ArrayList<Header>();
        int n2 = 0;
        while (true) {
            Header header2;
            block18: {
                block17: {
                    if (n2 >= arrayList.size()) break block17;
                    header2 = arrayList.get(n2);
                    if (header != header2 && (header.id == -1L || header.id != header2.id)) break block18;
                    arrayList2.clear();
                    arrayList2.add(header2);
                }
                if ((n = arrayList2.size()) != 1) break;
                return (Header)arrayList2.get(0);
            }
            if (header.fragment != null) {
                if (header.fragment.equals(header2.fragment)) {
                    arrayList2.add(header2);
                }
            } else if (header.intent != null) {
                if (header.intent.equals(header2.intent)) {
                    arrayList2.add(header2);
                }
            } else if (header.title != null && header.title.equals(header2.title)) {
                arrayList2.add(header2);
            }
            ++n2;
        }
        if (n <= 1) return null;
        int n3 = 0;
        while (n3 < n) {
            Header header3 = (Header)arrayList2.get(n3);
            if (header.fragmentArguments != null) {
                if (header.fragmentArguments.equals(header3.fragmentArguments)) return header3;
            }
            if (header.extras != null) {
                if (header.extras.equals(header3.extras)) return header3;
            }
            if (header.title != null) {
                if (header.title.equals(header3.title)) return header3;
            }
            ++n3;
        }
        return null;
    }

    @Deprecated
    public Preference findPreference(CharSequence charSequence) {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(charSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void finishPreferencePanel(Fragment fragment, int n, Intent intent) {
        if (this.mSinglePane) {
            this.setResult(n, intent);
            this.finish();
            return;
        } else {
            this.onBackPressed();
            if (fragment == null || fragment.getTargetFragment() == null) return;
            fragment.getTargetFragment().onActivityResult(fragment.getTargetRequestCode(), n, intent);
            return;
        }
    }

    public List<Header> getHeaders() {
        return this.mHeaders;
    }

    protected Button getNextButton() {
        return this.mNextButton;
    }

    @Deprecated
    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    @Deprecated
    public PreferenceScreen getPreferenceScreen() {
        if (this.mPreferenceManager != null) {
            return this.mPreferenceManager.getPreferenceScreen();
        }
        return null;
    }

    public boolean hasHeaders() {
        return this.getListView().getVisibility() == 0 && this.mPreferenceManager == null;
    }

    protected boolean hasNextButton() {
        return this.mNextButton != null;
    }

    public void invalidateHeaders() {
        if (!this.mHandler.hasMessages(2)) {
            this.mHandler.sendEmptyMessage(2);
        }
    }

    public boolean isMultiPane() {
        return this.hasHeaders() && this.mPrefsContainer.getVisibility() == 0;
    }

    protected boolean isValidFragment(String string2) {
        if (this.getApplicationInfo().targetSdkVersion >= 19) {
            throw new RuntimeException("Subclasses of PreferenceActivity must override isValidFragment(String) to verify that the Fragment class is valid! " + this.getClass().getName() + " has not checked if fragment " + string2 + " is valid.");
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadHeadersFromResource(int n, List<Header> list) {
        int n2;
        Bundle bundle;
        AttributeSet attributeSet;
        XmlResourceParser xmlResourceParser = null;
        try {
            int n3;
            xmlResourceParser = this.getResources().getXml(n);
            attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n3 = xmlResourceParser.next()) != 1 && n3 != 2) {
            }
            String string2 = xmlResourceParser.getName();
            if (!"preference-headers".equals(string2)) {
                throw new RuntimeException("XML document must start with <preference-headers> tag; found" + string2 + " at " + xmlResourceParser.getPositionDescription());
            }
            bundle = null;
            n2 = xmlResourceParser.getDepth();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException("Error parsing headers", xmlPullParserException);
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
        while (true) {
            int n4;
            int n5;
            Header header;
            block31: {
                block27: {
                    block28: {
                        TypedValue typedValue;
                        TypedValue typedValue2;
                        TypedArray typedArray;
                        block29: {
                            TypedValue typedValue3;
                            block30: {
                                int n6;
                                if ((n6 = xmlResourceParser.next()) == 1 || n6 == 3 && xmlResourceParser.getDepth() <= n2) break block27;
                                if (n6 == 3 || n6 == 4) continue;
                                if (!"header".equals(xmlResourceParser.getName())) break block28;
                                header = new Header();
                                typedArray = this.obtainStyledAttributes(attributeSet, R.styleable.PreferenceHeader);
                                header.id = typedArray.getResourceId(1, -1);
                                TypedValue typedValue4 = typedArray.peekValue(2);
                                if (typedValue4 != null && typedValue4.type == 3) {
                                    if (typedValue4.resourceId != 0) {
                                        header.titleRes = typedValue4.resourceId;
                                    } else {
                                        header.title = typedValue4.string;
                                    }
                                }
                                if ((typedValue3 = typedArray.peekValue(3)) == null || typedValue3.type != 3) break block29;
                                if (typedValue3.resourceId == 0) break block30;
                                header.summaryRes = typedValue3.resourceId;
                                break block29;
                                catch (IOException iOException) {
                                    throw new RuntimeException("Error parsing headers", iOException);
                                }
                            }
                            header.summary = typedValue3.string;
                        }
                        if ((typedValue2 = typedArray.peekValue(5)) != null && typedValue2.type == 3) {
                            if (typedValue2.resourceId != 0) {
                                header.breadCrumbTitleRes = typedValue2.resourceId;
                            } else {
                                header.breadCrumbTitle = typedValue2.string;
                            }
                        }
                        if ((typedValue = typedArray.peekValue(6)) != null && typedValue.type == 3) {
                            if (typedValue.resourceId != 0) {
                                header.breadCrumbShortTitleRes = typedValue.resourceId;
                            } else {
                                header.breadCrumbShortTitle = typedValue.string;
                            }
                        }
                        header.iconRes = typedArray.getResourceId(0, 0);
                        header.fragment = typedArray.getString(4);
                        typedArray.recycle();
                        if (bundle == null) {
                            bundle = new Bundle();
                        }
                        n5 = xmlResourceParser.getDepth();
                        break block31;
                    }
                    XmlUtils.skipCurrentTag(xmlResourceParser);
                    continue;
                }
                return;
            }
            while ((n4 = xmlResourceParser.next()) != 1 && (n4 != 3 || xmlResourceParser.getDepth() > n5)) {
                if (n4 == 3 || n4 == 4) continue;
                String string3 = xmlResourceParser.getName();
                if (string3.equals("extra")) {
                    this.getResources().parseBundleExtra("extra", attributeSet, bundle);
                    XmlUtils.skipCurrentTag(xmlResourceParser);
                    continue;
                }
                if (string3.equals("intent")) {
                    header.intent = Intent.parseIntent(this.getResources(), xmlResourceParser, attributeSet);
                    continue;
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
            }
            if (bundle.size() > 0) {
                header.fragmentArguments = bundle;
                bundle = null;
            }
            list.add(header);
        }
    }

    @Override
    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityResult(n, n2, intent);
        }
    }

    public void onBuildHeaders(List<Header> list) {
    }

    public Intent onBuildStartFragmentIntent(String string2, Bundle bundle, int n, int n2) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setClass(this, this.getClass());
        intent.putExtra(EXTRA_SHOW_FRAGMENT, string2);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_ARGUMENTS, bundle);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_TITLE, n);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_SHORT_TITLE, n2);
        intent.putExtra(EXTRA_NO_HEADERS, true);
        return intent;
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        if (this.mPreferenceManager != null) {
            this.postBindPreferences();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        Intent intent;
        int n;
        int n2;
        String string2;
        block26: {
            Bundle bundle2;
            block25: {
                super.onCreate(bundle);
                TypedArray typedArray = this.obtainStyledAttributes(null, R.styleable.PreferenceActivity, 16843813, 0);
                int n3 = typedArray.getResourceId(0, 17367222);
                this.mPreferenceHeaderItemResId = typedArray.getResourceId(1, 17367216);
                this.mPreferenceHeaderRemoveEmptyIcon = typedArray.getBoolean(2, false);
                typedArray.recycle();
                this.setContentView(n3);
                this.mListFooter = (FrameLayout)this.findViewById(16909069);
                this.mPrefsContainer = (ViewGroup)this.findViewById(16909070);
                boolean bl = this.onIsHidingHeaders() || !this.onIsMultiPane();
                this.mSinglePane = bl;
                string2 = this.getIntent().getStringExtra(EXTRA_SHOW_FRAGMENT);
                bundle2 = this.getIntent().getBundleExtra(EXTRA_SHOW_FRAGMENT_ARGUMENTS);
                n2 = this.getIntent().getIntExtra(EXTRA_SHOW_FRAGMENT_TITLE, 0);
                n = this.getIntent().getIntExtra(EXTRA_SHOW_FRAGMENT_SHORT_TITLE, 0);
                if (bundle == null) break block25;
                ArrayList arrayList = bundle.getParcelableArrayList(HEADERS_TAG);
                if (arrayList != null) {
                    this.mHeaders.addAll(arrayList);
                    int n4 = bundle.getInt(CUR_HEADER_TAG, -1);
                    if (n4 >= 0 && n4 < this.mHeaders.size()) {
                        this.setSelectedHeader(this.mHeaders.get(n4));
                    }
                }
                break block26;
            }
            if (string2 != null && this.mSinglePane) {
                this.switchToHeader(string2, bundle2);
                if (n2 != 0) {
                    CharSequence charSequence = this.getText(n2);
                    CharSequence charSequence2 = n != 0 ? this.getText(n) : null;
                    this.showBreadCrumbs(charSequence, charSequence2);
                }
            } else {
                this.onBuildHeaders(this.mHeaders);
                if (this.mHeaders.size() > 0 && !this.mSinglePane) {
                    if (string2 == null) {
                        this.switchToHeader(this.onGetInitialHeader());
                    } else {
                        this.switchToHeader(string2, bundle2);
                    }
                }
            }
        }
        if (string2 != null && this.mSinglePane) {
            this.findViewById(16909068).setVisibility(8);
            this.mPrefsContainer.setVisibility(0);
            if (n2 != 0) {
                CharSequence charSequence = this.getText(n2);
                CharSequence charSequence3 = n != 0 ? this.getText(n) : null;
                this.showBreadCrumbs(charSequence, charSequence3);
            } else {
                this.showBreadCrumbs(this.getTitle(), null);
            }
        } else if (this.mHeaders.size() > 0) {
            HeaderAdapter headerAdapter = new HeaderAdapter((Context)this, this.mHeaders, this.mPreferenceHeaderItemResId, this.mPreferenceHeaderRemoveEmptyIcon);
            this.setListAdapter(headerAdapter);
            if (!this.mSinglePane) {
                this.getListView().setChoiceMode(1);
                if (this.mCurHeader != null) {
                    this.setSelectedHeader(this.mCurHeader);
                }
                this.mPrefsContainer.setVisibility(0);
            }
        } else {
            PreferenceManager preferenceManager;
            this.setContentView(17367224);
            this.mListFooter = (FrameLayout)this.findViewById(16909069);
            this.mPrefsContainer = (ViewGroup)this.findViewById(16909071);
            this.mPreferenceManager = preferenceManager = new PreferenceManager(this, 100);
            this.mPreferenceManager.setOnPreferenceTreeClickListener(this);
        }
        if ((intent = this.getIntent()).getBooleanExtra(EXTRA_PREFS_SHOW_BUTTON_BAR, false)) {
            this.findViewById(16909031).setVisibility(0);
            Button button = (Button)this.findViewById(16909072);
            View.OnClickListener onClickListener = new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    PreferenceActivity.this.setResult(0);
                    PreferenceActivity.this.finish();
                }
            };
            button.setOnClickListener(onClickListener);
            Button button2 = (Button)this.findViewById(16909073);
            View.OnClickListener onClickListener2 = new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    PreferenceActivity.this.setResult(-1);
                    PreferenceActivity.this.finish();
                }
            };
            button2.setOnClickListener(onClickListener2);
            Button button3 = this.mNextButton = (Button)this.findViewById(16909074);
            View.OnClickListener onClickListener3 = new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    PreferenceActivity.this.setResult(-1);
                    PreferenceActivity.this.finish();
                }
            };
            button3.setOnClickListener(onClickListener3);
            if (intent.hasExtra(EXTRA_PREFS_SET_NEXT_TEXT)) {
                String string3 = intent.getStringExtra(EXTRA_PREFS_SET_NEXT_TEXT);
                if (TextUtils.isEmpty(string3)) {
                    this.mNextButton.setVisibility(8);
                } else {
                    this.mNextButton.setText(string3);
                }
            }
            if (intent.hasExtra(EXTRA_PREFS_SET_BACK_TEXT)) {
                String string4 = intent.getStringExtra(EXTRA_PREFS_SET_BACK_TEXT);
                if (TextUtils.isEmpty(string4)) {
                    button.setVisibility(8);
                } else {
                    button.setText(string4);
                }
            }
            if (intent.getBooleanExtra(EXTRA_PREFS_SHOW_SKIP, false)) {
                button2.setVisibility(0);
            }
        }
    }

    @Override
    protected void onDestroy() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        super.onDestroy();
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityDestroy();
        }
    }

    public Header onGetInitialHeader() {
        for (int i = 0; i < this.mHeaders.size(); ++i) {
            Header header = this.mHeaders.get(i);
            if (header.fragment == null) continue;
            return header;
        }
        throw new IllegalStateException("Must have at least one header with a fragment");
    }

    public Header onGetNewHeader() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onHeaderClick(Header header, int n) {
        if (header.fragment != null) {
            if (!this.mSinglePane) {
                this.switchToHeader(header);
                return;
            }
            int n2 = header.breadCrumbTitleRes;
            int n3 = header.breadCrumbShortTitleRes;
            if (n2 == 0) {
                n2 = header.titleRes;
                n3 = 0;
            }
            this.startWithFragment(header.fragment, header.fragmentArguments, null, 0, n2, n3);
            return;
        } else {
            if (header.intent == null) return;
            this.startActivity(header.intent);
            return;
        }
    }

    public boolean onIsHidingHeaders() {
        return this.getIntent().getBooleanExtra(EXTRA_NO_HEADERS, false);
    }

    public boolean onIsMultiPane() {
        return this.getResources().getBoolean(17956871);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onListItemClick(ListView listView, View view, int n, long l) {
        Object object;
        block3: {
            block2: {
                if (!this.isResumed()) break block2;
                super.onListItemClick(listView, view, n, l);
                if (this.mAdapter != null && (object = this.mAdapter.getItem(n)) instanceof Header) break block3;
            }
            return;
        }
        this.onHeaderClick((Header)object, n);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchNewIntent(intent);
        }
    }

    @Override
    public boolean onPreferenceStartFragment(PreferenceFragment preferenceFragment, Preference preference) {
        this.startPreferencePanel(preference.getFragment(), preference.getExtras(), preference.getTitleRes(), preference.getTitle(), null, 0);
        return true;
    }

    @Override
    @Deprecated
    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        return false;
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        PreferenceScreen preferenceScreen;
        Bundle bundle2;
        if (this.mPreferenceManager != null && (bundle2 = bundle.getBundle(PREFERENCES_TAG)) != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            preferenceScreen.restoreHierarchyState(bundle2);
            this.mSavedInstanceState = bundle;
            return;
        }
        super.onRestoreInstanceState(bundle);
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        PreferenceScreen preferenceScreen;
        super.onSaveInstanceState(bundle);
        if (this.mHeaders.size() > 0) {
            int n;
            bundle.putParcelableArrayList(HEADERS_TAG, this.mHeaders);
            if (this.mCurHeader != null && (n = this.mHeaders.indexOf(this.mCurHeader)) >= 0) {
                bundle.putInt(CUR_HEADER_TAG, n);
            }
        }
        if (this.mPreferenceManager != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            Bundle bundle2 = new Bundle();
            preferenceScreen.saveHierarchyState(bundle2);
            bundle.putBundle(PREFERENCES_TAG, bundle2);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityStop();
        }
    }

    public void setListFooter(View view) {
        this.mListFooter.removeAllViews();
        this.mListFooter.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    public void setParentTitle(CharSequence charSequence, CharSequence charSequence2, View.OnClickListener onClickListener) {
        if (this.mFragmentBreadCrumbs != null) {
            this.mFragmentBreadCrumbs.setParentTitle(charSequence, charSequence2, onClickListener);
        }
    }

    @Deprecated
    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        this.requirePreferenceManager();
        if (this.mPreferenceManager.setPreferences(preferenceScreen) && preferenceScreen != null) {
            this.postBindPreferences();
            CharSequence charSequence = this.getPreferenceScreen().getTitle();
            if (charSequence != null) {
                this.setTitle(charSequence);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setSelectedHeader(Header header) {
        this.mCurHeader = header;
        int n = this.mHeaders.indexOf(header);
        if (n >= 0) {
            this.getListView().setItemChecked(n, true);
        } else {
            this.getListView().clearChoices();
        }
        this.showBreadCrumbs(header);
    }

    void showBreadCrumbs(Header header) {
        if (header != null) {
            CharSequence charSequence = header.getBreadCrumbTitle(this.getResources());
            if (charSequence == null) {
                charSequence = header.getTitle(this.getResources());
            }
            if (charSequence == null) {
                charSequence = this.getTitle();
            }
            this.showBreadCrumbs(charSequence, header.getBreadCrumbShortTitle(this.getResources()));
            return;
        }
        this.showBreadCrumbs(this.getTitle(), null);
    }

    public void showBreadCrumbs(CharSequence charSequence, CharSequence charSequence2) {
        if (this.mFragmentBreadCrumbs == null) {
            block6: {
                block7: {
                    View view = this.findViewById(16908310);
                    try {
                        this.mFragmentBreadCrumbs = (FragmentBreadCrumbs)view;
                        if (this.mFragmentBreadCrumbs != null) break block6;
                        if (charSequence == null) break block7;
                    }
                    catch (ClassCastException classCastException) {
                        this.setTitle(charSequence);
                        return;
                    }
                    this.setTitle(charSequence);
                }
                return;
            }
            if (this.mSinglePane) {
                this.mFragmentBreadCrumbs.setVisibility(8);
                View view = this.findViewById(16909089);
                if (view != null) {
                    view.setVisibility(8);
                }
                this.setTitle(charSequence);
            }
            this.mFragmentBreadCrumbs.setMaxVisible(2);
            this.mFragmentBreadCrumbs.setActivity(this);
        }
        if (this.mFragmentBreadCrumbs.getVisibility() != 0) {
            this.setTitle(charSequence);
            return;
        }
        this.mFragmentBreadCrumbs.setTitle(charSequence, charSequence2);
        this.mFragmentBreadCrumbs.setParentTitle(null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startPreferenceFragment(Fragment fragment, boolean bl) {
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.replace(16909071, fragment);
        if (bl) {
            fragmentTransaction.setTransition(4097);
            fragmentTransaction.addToBackStack(BACK_STACK_PREFS);
        } else {
            fragmentTransaction.setTransition(4099);
        }
        fragmentTransaction.commitAllowingStateLoss();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startPreferencePanel(String string2, Bundle bundle, int n, CharSequence charSequence, Fragment fragment, int n2) {
        if (this.mSinglePane) {
            this.startWithFragment(string2, bundle, fragment, n2, n, 0);
            return;
        }
        Fragment fragment2 = Fragment.instantiate(this, string2, bundle);
        if (fragment != null) {
            fragment2.setTargetFragment(fragment, n2);
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.replace(16909071, fragment2);
        if (n != 0) {
            fragmentTransaction.setBreadCrumbTitle(n);
        } else if (charSequence != null) {
            fragmentTransaction.setBreadCrumbTitle(charSequence);
        }
        fragmentTransaction.setTransition(4097);
        fragmentTransaction.addToBackStack(BACK_STACK_PREFS);
        fragmentTransaction.commitAllowingStateLoss();
    }

    public void startWithFragment(String string2, Bundle bundle, Fragment fragment, int n) {
        this.startWithFragment(string2, bundle, fragment, n, 0, 0);
    }

    public void startWithFragment(String string2, Bundle bundle, Fragment fragment, int n, int n2, int n3) {
        Intent intent = this.onBuildStartFragmentIntent(string2, bundle, n2, n3);
        if (fragment == null) {
            this.startActivity(intent);
            return;
        }
        fragment.startActivityForResult(intent, n);
    }

    public void switchToHeader(Header header) {
        if (this.mCurHeader == header) {
            this.getFragmentManager().popBackStack(BACK_STACK_PREFS, 1);
            return;
        }
        if (header.fragment == null) {
            throw new IllegalStateException("can't switch to header that has no fragment");
        }
        this.switchToHeaderInner(header.fragment, header.fragmentArguments);
        this.setSelectedHeader(header);
    }

    public void switchToHeader(String string2, Bundle bundle) {
        int n = 0;
        while (true) {
            block4: {
                Header header;
                block3: {
                    int n2 = this.mHeaders.size();
                    header = null;
                    if (n >= n2) break block3;
                    if (!string2.equals(this.mHeaders.get((int)n).fragment)) break block4;
                    header = this.mHeaders.get(n);
                }
                this.setSelectedHeader(header);
                this.switchToHeaderInner(string2, bundle);
                return;
            }
            ++n;
        }
    }

    public static final class Header
    implements Parcelable {
        public static final Parcelable.Creator<Header> CREATOR = new Parcelable.Creator<Header>(){

            @Override
            public Header createFromParcel(Parcel parcel) {
                return new Header(parcel);
            }

            public Header[] newArray(int n) {
                return new Header[n];
            }
        };
        public CharSequence breadCrumbShortTitle;
        public int breadCrumbShortTitleRes;
        public CharSequence breadCrumbTitle;
        public int breadCrumbTitleRes;
        public Bundle extras;
        public String fragment;
        public Bundle fragmentArguments;
        public int iconRes;
        public long id = -1L;
        public Intent intent;
        public CharSequence summary;
        public int summaryRes;
        public CharSequence title;
        public int titleRes;

        public Header() {
        }

        Header(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public CharSequence getBreadCrumbShortTitle(Resources resources) {
            if (this.breadCrumbShortTitleRes != 0) {
                return resources.getText(this.breadCrumbShortTitleRes);
            }
            return this.breadCrumbShortTitle;
        }

        public CharSequence getBreadCrumbTitle(Resources resources) {
            if (this.breadCrumbTitleRes != 0) {
                return resources.getText(this.breadCrumbTitleRes);
            }
            return this.breadCrumbTitle;
        }

        public CharSequence getSummary(Resources resources) {
            if (this.summaryRes != 0) {
                return resources.getText(this.summaryRes);
            }
            return this.summary;
        }

        public CharSequence getTitle(Resources resources) {
            if (this.titleRes != 0) {
                return resources.getText(this.titleRes);
            }
            return this.title;
        }

        public void readFromParcel(Parcel parcel) {
            this.id = parcel.readLong();
            this.titleRes = parcel.readInt();
            this.title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.summaryRes = parcel.readInt();
            this.summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.breadCrumbTitleRes = parcel.readInt();
            this.breadCrumbTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.breadCrumbShortTitleRes = parcel.readInt();
            this.breadCrumbShortTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.iconRes = parcel.readInt();
            this.fragment = parcel.readString();
            this.fragmentArguments = parcel.readBundle();
            if (parcel.readInt() != 0) {
                this.intent = Intent.CREATOR.createFromParcel(parcel);
            }
            this.extras = parcel.readBundle();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.id);
            parcel.writeInt(this.titleRes);
            TextUtils.writeToParcel(this.title, parcel, n);
            parcel.writeInt(this.summaryRes);
            TextUtils.writeToParcel(this.summary, parcel, n);
            parcel.writeInt(this.breadCrumbTitleRes);
            TextUtils.writeToParcel(this.breadCrumbTitle, parcel, n);
            parcel.writeInt(this.breadCrumbShortTitleRes);
            TextUtils.writeToParcel(this.breadCrumbShortTitle, parcel, n);
            parcel.writeInt(this.iconRes);
            parcel.writeString(this.fragment);
            parcel.writeBundle(this.fragmentArguments);
            if (this.intent != null) {
                parcel.writeInt(1);
                this.intent.writeToParcel(parcel, n);
            } else {
                parcel.writeInt(0);
            }
            parcel.writeBundle(this.extras);
        }
    }

    private static class HeaderAdapter
    extends ArrayAdapter<Header> {
        private LayoutInflater mInflater;
        private int mLayoutResId;
        private boolean mRemoveIconIfEmpty;

        public HeaderAdapter(Context context, List<Header> list, int n, boolean bl) {
            super(context, 0, list);
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mLayoutResId = n;
            this.mRemoveIconIfEmpty = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            HeaderViewHolder headerViewHolder;
            View view2;
            if (view == null) {
                view2 = this.mInflater.inflate(this.mLayoutResId, viewGroup, false);
                headerViewHolder = new HeaderViewHolder();
                headerViewHolder.icon = (ImageView)view2.findViewById(16908294);
                headerViewHolder.title = (TextView)view2.findViewById(16908310);
                headerViewHolder.summary = (TextView)view2.findViewById(0x1020010);
                view2.setTag(headerViewHolder);
            } else {
                view2 = view;
                headerViewHolder = (HeaderViewHolder)view2.getTag();
            }
            Header header = (Header)this.getItem(n);
            if (this.mRemoveIconIfEmpty) {
                if (header.iconRes == 0) {
                    headerViewHolder.icon.setVisibility(8);
                } else {
                    headerViewHolder.icon.setVisibility(0);
                    headerViewHolder.icon.setImageResource(header.iconRes);
                }
            } else {
                headerViewHolder.icon.setImageResource(header.iconRes);
            }
            headerViewHolder.title.setText(header.getTitle(this.getContext().getResources()));
            CharSequence charSequence = header.getSummary(this.getContext().getResources());
            if (!TextUtils.isEmpty(charSequence)) {
                headerViewHolder.summary.setVisibility(0);
                headerViewHolder.summary.setText(charSequence);
                return view2;
            }
            headerViewHolder.summary.setVisibility(8);
            return view2;
        }

        private static class HeaderViewHolder {
            ImageView icon;
            TextView summary;
            TextView title;

            private HeaderViewHolder() {
            }
        }
    }
}

