/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IObbActionListener;
import android.os.storage.OnObbStateChangeListener;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageVolume;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageManager {
    public static final int CRYPT_TYPE_DEFAULT = 1;
    public static final int CRYPT_TYPE_PASSWORD = 0;
    public static final int CRYPT_TYPE_PATTERN = 2;
    public static final int CRYPT_TYPE_PIN = 3;
    private static final long DEFAULT_FULL_THRESHOLD_BYTES = 0x100000L;
    private static final long DEFAULT_THRESHOLD_MAX_BYTES = 524288000L;
    private static final int DEFAULT_THRESHOLD_PERCENTAGE = 10;
    public static final String OWNER_INFO_KEY = "OwnerInfo";
    public static final String PATTERN_VISIBLE_KEY = "PatternVisible";
    public static final String SYSTEM_LOCALE_KEY = "SystemLocale";
    private static final String TAG = "StorageManager";
    private MountServiceBinderListener mBinderListener;
    private List<ListenerDelegate> mListeners = new ArrayList<ListenerDelegate>();
    private final IMountService mMountService;
    private final AtomicInteger mNextNonce = new AtomicInteger(0);
    private final ObbActionListener mObbActionListener = new ObbActionListener();
    private final ContentResolver mResolver;
    private final Looper mTgtLooper;

    public StorageManager(ContentResolver contentResolver, Looper looper) throws RemoteException {
        this.mResolver = contentResolver;
        this.mTgtLooper = looper;
        this.mMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        if (this.mMountService == null) {
            Log.e(TAG, "Unable to connect to mount service! - is it running yet?");
        }
    }

    public static StorageManager from(Context context) {
        return (StorageManager)context.getSystemService("storage");
    }

    private int getNextNonce() {
        return this.mNextNonce.getAndIncrement();
    }

    public static StorageVolume getPrimaryVolume(StorageVolume[] storageVolumeArray) {
        for (StorageVolume storageVolume : storageVolumeArray) {
            if (!storageVolume.isPrimary()) continue;
            return storageVolume;
        }
        Log.w(TAG, "No primary storage defined");
        return null;
    }

    public static StorageVolume getSecondaryVolume(StorageVolume[] storageVolumeArray) {
        for (StorageVolume storageVolume : storageVolumeArray) {
            if (!storageVolume.getPath().equals(Environment.MOUNT_POINT_MICROSD) && !storageVolume.getPath().equals("/storage/MicroSD")) continue;
            return storageVolume;
        }
        Log.w(TAG, "No secondary volume found");
        return null;
    }

    public void disableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(false);
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "Failed to disable UMS", exception);
            return;
        }
    }

    public void enableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(true);
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "Failed to enable UMS", exception);
            return;
        }
    }

    public String getMountedObbPath(String string2) {
        Preconditions.checkNotNull(string2, "rawPath cannot be null");
        try {
            String string3 = this.mMountService.getMountedObbPath(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to find mounted path for OBB", remoteException);
            return null;
        }
    }

    public StorageVolume getPrimaryVolume() {
        return StorageManager.getPrimaryVolume(this.getVolumeList());
    }

    public StorageVolume getSecondaryVolume() {
        return StorageManager.getSecondaryVolume(this.getVolumeList());
    }

    public long getStorageBytesUntilLow(File file) {
        return file.getUsableSpace() - this.getStorageFullBytes(file);
    }

    public long getStorageFullBytes(File file) {
        return Settings.Global.getLong(this.mResolver, "sys_storage_full_threshold_bytes", 0x100000L);
    }

    public long getStorageLowBytes(File file) {
        return Math.min((long)Settings.Global.getInt(this.mResolver, "sys_storage_threshold_percentage", 10) * file.getTotalSpace() / 100L, Settings.Global.getLong(this.mResolver, "sys_storage_threshold_max_bytes", 524288000L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StorageVolume[] getVolumeList() {
        if (this.mMountService == null) {
            return new StorageVolume[0];
        }
        try {
            StorageVolume[] storageVolumeArray = this.mMountService.getVolumeList();
            if (storageVolumeArray == null) {
                return new StorageVolume[0];
            }
            int n = storageVolumeArray.length;
            StorageVolume[] storageVolumeArray2 = new StorageVolume[n];
            int n2 = 0;
            while (n2 < n) {
                storageVolumeArray2[n2] = storageVolumeArray[n2];
                ++n2;
            }
            return storageVolumeArray2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get volume list", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getVolumePaths() {
        StorageVolume[] storageVolumeArray = this.getVolumeList();
        if (storageVolumeArray == null) {
            return null;
        }
        int n = storageVolumeArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = storageVolumeArray[n2].getPath();
            ++n2;
        }
        return stringArray;
    }

    public String getVolumeState(String string2) {
        if (this.mMountService == null) {
            return "removed";
        }
        try {
            String string3 = this.mMountService.getVolumeState(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get volume state", remoteException);
            return null;
        }
    }

    public boolean isObbMounted(String string2) {
        Preconditions.checkNotNull(string2, "rawPath cannot be null");
        try {
            boolean bl = this.mMountService.isObbMounted(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to check if OBB is mounted", remoteException);
            return false;
        }
    }

    public boolean isUsbMassStorageConnected() {
        try {
            boolean bl = this.mMountService.isUsbMassStorageConnected();
            return bl;
        }
        catch (Exception exception) {
            Log.e(TAG, "Failed to get UMS connection state", exception);
            return false;
        }
    }

    public boolean isUsbMassStorageEnabled() {
        try {
            boolean bl = this.mMountService.isUsbMassStorageEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get UMS enable state", remoteException);
            return false;
        }
    }

    public boolean mountObb(String string2, String string3, OnObbStateChangeListener onObbStateChangeListener) {
        Preconditions.checkNotNull(string2, "rawPath cannot be null");
        Preconditions.checkNotNull(onObbStateChangeListener, "listener cannot be null");
        try {
            String string4 = new File(string2).getCanonicalPath();
            int n = this.mObbActionListener.addListener(onObbStateChangeListener);
            this.mMountService.mountObb(string2, string4, string3, this.mObbActionListener, n);
            return true;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to resolve path: " + string2, iOException);
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to mount OBB", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerListener(StorageEventListener storageEventListener) {
        if (storageEventListener == null) {
            return;
        }
        List<ListenerDelegate> list = this.mListeners;
        synchronized (list) {
            MountServiceBinderListener mountServiceBinderListener = this.mBinderListener;
            if (mountServiceBinderListener == null) {
                try {
                    this.mBinderListener = new MountServiceBinderListener();
                    this.mMountService.registerListener(this.mBinderListener);
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "Register mBinderListener failed");
                    return;
                }
            }
            this.mListeners.add(new ListenerDelegate(storageEventListener));
            return;
        }
    }

    public boolean unmountObb(String string2, boolean bl, OnObbStateChangeListener onObbStateChangeListener) {
        Preconditions.checkNotNull(string2, "rawPath cannot be null");
        Preconditions.checkNotNull(onObbStateChangeListener, "listener cannot be null");
        try {
            int n = this.mObbActionListener.addListener(onObbStateChangeListener);
            this.mMountService.unmountObb(string2, bl, this.mObbActionListener, n);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to mount OBB", remoteException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterListener(StorageEventListener var1_1) {
        if (var1_1 == null) {
            return;
        }
        var2_2 = this.mListeners;
        synchronized (var2_2) {
            var4_3 = this.mListeners.size();
            var5_4 = 0;
            while (true) {
                block8: {
                    block7: {
                        if (var5_4 >= var4_3) break block7;
                        if (this.mListeners.get(var5_4).getListener() != var1_1) break block8;
                        this.mListeners.remove(var5_4);
                    }
                    if (this.mListeners.size() != 0 || (var7_5 = this.mBinderListener) == null) ** GOTO lbl16
                    try {
                        this.mMountService.unregisterListener(this.mBinderListener);
lbl16:
                        // 2 sources

                        return;
                    }
                    catch (RemoteException var8_6) {
                        Log.e("StorageManager", "Unregister mBinderListener failed");
                        return;
                    }
                }
                ++var5_4;
            }
        }
    }

    private class ListenerDelegate {
        private final Handler mHandler;
        final StorageEventListener mStorageEventListener;

        ListenerDelegate(StorageEventListener storageEventListener) {
            this.mStorageEventListener = storageEventListener;
            this.mHandler = new Handler(StorageManager.this.mTgtLooper){

                @Override
                public void handleMessage(Message message) {
                    StorageEvent storageEvent = (StorageEvent)message.obj;
                    if (message.what == 1) {
                        UmsConnectionChangedStorageEvent umsConnectionChangedStorageEvent = (UmsConnectionChangedStorageEvent)storageEvent;
                        ListenerDelegate.this.mStorageEventListener.onUsbMassStorageConnectionChanged(umsConnectionChangedStorageEvent.available);
                        return;
                    }
                    if (message.what == 2) {
                        StorageStateChangedStorageEvent storageStateChangedStorageEvent = (StorageStateChangedStorageEvent)storageEvent;
                        ListenerDelegate.this.mStorageEventListener.onStorageStateChanged(storageStateChangedStorageEvent.path, storageStateChangedStorageEvent.oldState, storageStateChangedStorageEvent.newState);
                        return;
                    }
                    Log.e(StorageManager.TAG, "Unsupported event " + message.what);
                }
            };
        }

        StorageEventListener getListener() {
            return this.mStorageEventListener;
        }

        void sendShareAvailabilityChanged(boolean bl) {
            UmsConnectionChangedStorageEvent umsConnectionChangedStorageEvent = new UmsConnectionChangedStorageEvent(bl);
            this.mHandler.sendMessage(umsConnectionChangedStorageEvent.getMessage());
        }

        void sendStorageStateChanged(String string2, String string3, String string4) {
            StorageStateChangedStorageEvent storageStateChangedStorageEvent = new StorageStateChangedStorageEvent(string2, string3, string4);
            this.mHandler.sendMessage(storageStateChangedStorageEvent.getMessage());
        }
    }

    private class MountServiceBinderListener
    extends IMountServiceListener.Stub {
        private MountServiceBinderListener() {
        }

        @Override
        public void onStorageStateChanged(String string2, String string3, String string4) {
            int n = StorageManager.this.mListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ListenerDelegate)StorageManager.this.mListeners.get(i)).sendStorageStateChanged(string2, string3, string4);
            }
        }

        @Override
        public void onUsbMassStorageConnectionChanged(boolean bl) {
            int n = StorageManager.this.mListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ListenerDelegate)StorageManager.this.mListeners.get(i)).sendShareAvailabilityChanged(bl);
            }
        }
    }

    private class ObbActionListener
    extends IObbActionListener.Stub {
        private SparseArray<ObbListenerDelegate> mListeners = new SparseArray();

        private ObbActionListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int addListener(OnObbStateChangeListener onObbStateChangeListener) {
            ObbListenerDelegate obbListenerDelegate = new ObbListenerDelegate(onObbStateChangeListener);
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                this.mListeners.put(obbListenerDelegate.nonce, obbListenerDelegate);
                return obbListenerDelegate.nonce;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onObbResult(String string2, int n, int n2) {
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            // MONITORENTER : sparseArray
            ObbListenerDelegate obbListenerDelegate = this.mListeners.get(n);
            if (obbListenerDelegate != null) {
                this.mListeners.remove(n);
            }
            // MONITOREXIT : sparseArray
            if (obbListenerDelegate == null) return;
            obbListenerDelegate.sendObbStateChanged(string2, n2);
        }
    }

    private class ObbListenerDelegate {
        private final Handler mHandler;
        private final WeakReference<OnObbStateChangeListener> mObbEventListenerRef;
        private final int nonce;

        ObbListenerDelegate(OnObbStateChangeListener onObbStateChangeListener) {
            this.nonce = StorageManager.this.getNextNonce();
            this.mObbEventListenerRef = new WeakReference<OnObbStateChangeListener>(onObbStateChangeListener);
            this.mHandler = new Handler(StorageManager.this.mTgtLooper){

                @Override
                public void handleMessage(Message message) {
                    OnObbStateChangeListener onObbStateChangeListener = ObbListenerDelegate.this.getListener();
                    if (onObbStateChangeListener == null) {
                        return;
                    }
                    StorageEvent storageEvent = (StorageEvent)message.obj;
                    if (message.what == 3) {
                        ObbStateChangedStorageEvent obbStateChangedStorageEvent = (ObbStateChangedStorageEvent)storageEvent;
                        onObbStateChangeListener.onObbStateChange(obbStateChangedStorageEvent.path, obbStateChangedStorageEvent.state);
                        return;
                    }
                    Log.e(StorageManager.TAG, "Unsupported event " + message.what);
                }
            };
        }

        OnObbStateChangeListener getListener() {
            if (this.mObbEventListenerRef == null) {
                return null;
            }
            return (OnObbStateChangeListener)this.mObbEventListenerRef.get();
        }

        void sendObbStateChanged(String string2, int n) {
            ObbStateChangedStorageEvent obbStateChangedStorageEvent = new ObbStateChangedStorageEvent(string2, n);
            this.mHandler.sendMessage(obbStateChangedStorageEvent.getMessage());
        }
    }

    private class ObbStateChangedStorageEvent
    extends StorageEvent {
        public final String path;
        public final int state;

        public ObbStateChangedStorageEvent(String string2, int n) {
            super(3);
            this.path = string2;
            this.state = n;
        }
    }

    private class StorageEvent {
        static final int EVENT_OBB_STATE_CHANGED = 3;
        static final int EVENT_STORAGE_STATE_CHANGED = 2;
        static final int EVENT_UMS_CONNECTION_CHANGED = 1;
        private Message mMessage = Message.obtain();

        public StorageEvent(int n) {
            this.mMessage.what = n;
            this.mMessage.obj = this;
        }

        public Message getMessage() {
            return this.mMessage;
        }
    }

    private class StorageStateChangedStorageEvent
    extends StorageEvent {
        public String newState;
        public String oldState;
        public String path;

        public StorageStateChangedStorageEvent(String string2, String string3, String string4) {
            super(2);
            this.path = string2;
            this.oldState = string3;
            this.newState = string4;
        }
    }

    private class UmsConnectionChangedStorageEvent
    extends StorageEvent {
        public boolean available;

        public UmsConnectionChangedStorageEvent(boolean bl) {
            super(1);
            this.available = bl;
        }
    }
}

