/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.storage.IMountServiceListener;
import android.os.storage.IMountShutdownObserver;
import android.os.storage.IObbActionListener;
import android.os.storage.StorageVolume;

public interface IMountService
extends IInterface {
    public static final int ENCRYPTION_STATE_ERROR_CORRUPT = -4;
    public static final int ENCRYPTION_STATE_ERROR_INCOMPLETE = -2;
    public static final int ENCRYPTION_STATE_ERROR_INCONSISTENT = -3;
    public static final int ENCRYPTION_STATE_ERROR_UNKNOWN = -1;
    public static final int ENCRYPTION_STATE_NONE = 1;
    public static final int ENCRYPTION_STATE_OK;

    public int bindObb(String var1, Boolean var2) throws RemoteException;

    public int changeEncryptionPassword(int var1, String var2) throws RemoteException;

    public void clearPassword() throws RemoteException;

    public int createSecureContainer(String var1, int var2, String var3, String var4, int var5, boolean var6) throws RemoteException;

    public int decryptStorage(String var1) throws RemoteException;

    public int destroySecureContainer(String var1, boolean var2) throws RemoteException;

    public int encryptStorage(int var1, String var2) throws RemoteException;

    public int finalizeSecureContainer(String var1) throws RemoteException;

    public void finishMediaUpdate() throws RemoteException;

    public int fixPermissionsSecureContainer(String var1, int var2, String var3) throws RemoteException;

    public int formatVolume(String var1) throws RemoteException;

    public int getEncryptionState() throws RemoteException;

    public String getField(String var1) throws RemoteException;

    public String getMountedObbPath(String var1) throws RemoteException;

    public String getPassword() throws RemoteException;

    public int getPasswordType() throws RemoteException;

    public String getSecureContainerFilesystemPath(String var1) throws RemoteException;

    public String[] getSecureContainerList() throws RemoteException;

    public String getSecureContainerPath(String var1) throws RemoteException;

    public int[] getStorageUsers(String var1) throws RemoteException;

    public StorageVolume[] getVolumeList() throws RemoteException;

    public String getVolumeState(String var1) throws RemoteException;

    public boolean isExternalStorageEmulated() throws RemoteException;

    public boolean isObbMounted(String var1) throws RemoteException;

    public boolean isSecureContainerMounted(String var1) throws RemoteException;

    public boolean isUsbMassStorageConnected() throws RemoteException;

    public boolean isUsbMassStorageEnabled() throws RemoteException;

    public int mkdirs(String var1, String var2) throws RemoteException;

    public void mountObb(String var1, String var2, String var3, IObbActionListener var4, int var5) throws RemoteException;

    public int mountSecureContainer(String var1, String var2, int var3, boolean var4) throws RemoteException;

    public int mountVolume(String var1) throws RemoteException;

    public void registerListener(IMountServiceListener var1) throws RemoteException;

    public int renameSecureContainer(String var1, String var2) throws RemoteException;

    public int resizeSecureContainer(String var1, int var2, String var3) throws RemoteException;

    public void setField(String var1, String var2) throws RemoteException;

    public void setUsbMassStorageEnabled(boolean var1) throws RemoteException;

    public void shutdown(IMountShutdownObserver var1) throws RemoteException;

    public int unbindObb(String var1, Boolean var2) throws RemoteException;

    public void unmountObb(String var1, boolean var2, IObbActionListener var3, int var4) throws RemoteException;

    public int unmountSecureContainer(String var1, boolean var2) throws RemoteException;

    public void unmountVolume(String var1, boolean var2, boolean var3) throws RemoteException;

    public void unregisterListener(IMountServiceListener var1) throws RemoteException;

    public int verifyEncryptionPassword(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMountService {
        private static final String DESCRIPTOR = "IMountService";
        static final int TRANSACTION_bindObb = 42;
        static final int TRANSACTION_changeEncryptionPassword = 29;
        static final int TRANSACTION_clearPassword = 38;
        static final int TRANSACTION_createSecureContainer = 11;
        static final int TRANSACTION_decryptStorage = 27;
        static final int TRANSACTION_destroySecureContainer = 13;
        static final int TRANSACTION_encryptStorage = 28;
        static final int TRANSACTION_finalizeSecureContainer = 12;
        static final int TRANSACTION_finishMediaUpdate = 21;
        static final int TRANSACTION_fixPermissionsSecureContainer = 34;
        static final int TRANSACTION_formatVolume = 8;
        static final int TRANSACTION_getEncryptionState = 32;
        static final int TRANSACTION_getField = 40;
        static final int TRANSACTION_getMountedObbPath = 25;
        static final int TRANSACTION_getPassword = 37;
        static final int TRANSACTION_getPasswordType = 36;
        static final int TRANSACTION_getSecureContainerFilesystemPath = 31;
        static final int TRANSACTION_getSecureContainerList = 19;
        static final int TRANSACTION_getSecureContainerPath = 18;
        static final int TRANSACTION_getStorageUsers = 9;
        static final int TRANSACTION_getVolumeList = 30;
        static final int TRANSACTION_getVolumeState = 10;
        static final int TRANSACTION_isExternalStorageEmulated = 26;
        static final int TRANSACTION_isObbMounted = 24;
        static final int TRANSACTION_isSecureContainerMounted = 16;
        static final int TRANSACTION_isUsbMassStorageConnected = 3;
        static final int TRANSACTION_isUsbMassStorageEnabled = 5;
        static final int TRANSACTION_mkdirs = 35;
        static final int TRANSACTION_mountObb = 22;
        static final int TRANSACTION_mountSecureContainer = 14;
        static final int TRANSACTION_mountVolume = 6;
        static final int TRANSACTION_registerListener = 1;
        static final int TRANSACTION_renameSecureContainer = 17;
        static final int TRANSACTION_resizeSecureContainer = 41;
        static final int TRANSACTION_setField = 39;
        static final int TRANSACTION_setUsbMassStorageEnabled = 4;
        static final int TRANSACTION_shutdown = 20;
        static final int TRANSACTION_unmountObb = 23;
        static final int TRANSACTION_unmountSecureContainer = 15;
        static final int TRANSACTION_unmountVolume = 7;
        static final int TRANSACTION_unregisterListener = 2;
        static final int TRANSACTION_verifyEncryptionPassword = 33;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMountService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IMountService) {
                return (IMountService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            int n3;
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.registerListener(IMountServiceListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterListener(IMountServiceListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isUsbMassStorageConnected();
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setUsbMassStorageEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isUsbMassStorageEnabled();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = this.mountVolume(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    this.unmountVolume(string2, bl, bl2);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.formatVolume(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.getStorageUsers(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = this.getVolumeState(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    int n8 = parcel.readInt();
                    String string5 = parcel.readString();
                    String string6 = parcel.readString();
                    int n9 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    int n10 = this.createSecureContainer(string4, n8, string5, string6, n9, bl);
                    parcel2.writeNoException();
                    parcel2.writeInt(n10);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = this.finalizeSecureContainer(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n11);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string7 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    int n12 = this.destroySecureContainer(string7, bl);
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string8 = parcel.readString();
                    String string9 = parcel.readString();
                    int n13 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    int n14 = this.mountSecureContainer(string8, string9, n13, bl);
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string10 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    int n15 = this.unmountSecureContainer(string10, bl);
                    parcel2.writeNoException();
                    parcel2.writeInt(n15);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSecureContainerMounted(parcel.readString());
                    parcel2.writeNoException();
                    int n16 = bl ? 1 : 0;
                    parcel2.writeInt(n16);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n17 = this.renameSecureContainer(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n17);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string11 = this.getSecureContainerPath(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string11);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getSecureContainerList();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.shutdown(IMountShutdownObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishMediaUpdate();
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.mountObb(parcel.readString(), parcel.readString(), parcel.readString(), IObbActionListener.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string12 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    IObbActionListener iObbActionListener = IObbActionListener.Stub.asInterface(parcel.readStrongBinder());
                    int n18 = parcel.readInt();
                    this.unmountObb(string12, bl, iObbActionListener, n18);
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isObbMounted(parcel.readString());
                    parcel2.writeNoException();
                    int n19 = bl ? 1 : 0;
                    parcel2.writeInt(n19);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string13 = this.getMountedObbPath(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string13);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isExternalStorageEmulated();
                    parcel2.writeNoException();
                    int n20 = bl ? 1 : 0;
                    parcel2.writeInt(n20);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n21 = this.decryptStorage(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n21);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n22 = this.encryptStorage(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n23 = this.changeEncryptionPassword(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n23);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getVolumeList();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string14 = this.getSecureContainerFilesystemPath(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string14);
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n24 = this.getEncryptionState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n25 = this.fixPermissionsSecureContainer(parcel.readString(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n25);
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n26 = this.mkdirs(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n26);
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n27 = this.getPasswordType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n27);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string15 = this.getPassword();
                    parcel2.writeNoException();
                    parcel2.writeString(string15);
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearPassword();
                    parcel2.writeNoException();
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setField(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string16 = this.getField(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string16);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n28 = this.resizeSecureContainer(parcel.readString(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n28);
                    return true;
                }
                case 42: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            String string17 = parcel.readString();
            String string18 = parcel.readString();
            int n29 = parcel.readInt();
            if (string18.equals("bind")) {
                boolean bl = n29 != 0;
                n3 = this.bindObb(string17, bl);
            } else if (string18.equals("unbind")) {
                boolean bl = n29 != 0;
                n3 = this.unbindObb(string17, bl);
            } else {
                n3 = -1;
            }
            parcel2.writeNoException();
            parcel2.writeInt(n3);
            return true;
        }

        private static class Proxy
        implements IMountService {
            private final IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public int bindObb(String string2, Boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    parcel2.writeString("bind");
                    boolean bl2 = bl;
                    n = 0;
                    if (!bl2) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(42, parcel2, parcel, 0);
                    parcel.readException();
                    int n2 = parcel.readInt();
                    return n2;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public int changeEncryptionPassword(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearPassword() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, parcel, parcel2, 1);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int createSecureContainer(String string2, int n, String string3, String string4, int n2, boolean bl) throws RemoteException {
                int n3;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    parcel2.writeInt(n);
                    parcel2.writeString(string3);
                    parcel2.writeString(string4);
                    parcel2.writeInt(n2);
                    n3 = 0;
                    if (!bl) break block4;
                    n3 = 1;
                }
                try {
                    parcel2.writeInt(n3);
                    this.mRemote.transact(11, parcel2, parcel, 0);
                    parcel.readException();
                    int n4 = parcel.readInt();
                    return n4;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public int decryptStorage(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int destroySecureContainer(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(13, parcel2, parcel, 0);
                    parcel.readException();
                    int n2 = parcel.readInt();
                    return n2;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public int encryptStorage(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int finalizeSecureContainer(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void finishMediaUpdate() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int fixPermissionsSecureContainer(String string2, int n, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int formatVolume(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getEncryptionState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getField(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public String getMountedObbPath(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getPassword() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPasswordType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getSecureContainerFilesystemPath(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getSecureContainerList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getSecureContainerPath(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int[] getStorageUsers(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public StorageVolume[] getVolumeList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    StorageVolume[] storageVolumeArray = parcel2.createTypedArray(StorageVolume.CREATOR);
                    return storageVolumeArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getVolumeState(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isExternalStorageEmulated() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isObbMounted(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isSecureContainerMounted(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isUsbMassStorageConnected() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isUsbMassStorageEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int mkdirs(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void mountObb(String string2, String string3, String string4, IObbActionListener iObbActionListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    IBinder iBinder = iObbActionListener != null ? iObbActionListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int mountSecureContainer(String string2, String string3, int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    parcel2.writeString(string3);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(14, parcel2, parcel, 0);
                    parcel.readException();
                    int n3 = parcel.readInt();
                    return n3;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public int mountVolume(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerListener(IMountServiceListener iMountServiceListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iMountServiceListener != null ? iMountServiceListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int renameSecureContainer(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int resizeSecureContainer(String string2, int n, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setField(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(39, parcel, parcel2, 1);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setUsbMassStorageEnabled(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(4, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void shutdown(IMountShutdownObserver iMountShutdownObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iMountShutdownObserver != null ? iMountShutdownObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int unbindObb(String string2, Boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    parcel2.writeString("unbind");
                    boolean bl2 = bl;
                    n = 0;
                    if (!bl2) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(42, parcel2, parcel, 0);
                    parcel.readException();
                    int n2 = parcel.readInt();
                    return n2;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unmountObb(String string2, boolean bl, IObbActionListener iObbActionListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n2 = 0;
                    if (bl) {
                        n2 = 1;
                    }
                    parcel.writeInt(n2);
                    IBinder iBinder = iObbActionListener != null ? iObbActionListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int unmountSecureContainer(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(15, parcel2, parcel, 0);
                    parcel.readException();
                    int n2 = parcel.readInt();
                    return n2;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unmountVolume(String string2, boolean bl, boolean bl2) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n2 = bl ? n : 0;
                    parcel.writeInt(n2);
                    if (!bl2) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterListener(IMountServiceListener iMountServiceListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iMountServiceListener != null ? iMountServiceListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int verifyEncryptionPassword(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

