/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.IAlarmManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;

public final class SystemClock {
    private static final String TAG = "SystemClock";

    private SystemClock() {
    }

    public static native long currentThreadTimeMicro();

    public static native long currentThreadTimeMillis();

    public static native long currentTimeMicro();

    public static native long elapsedRealtime();

    public static native long elapsedRealtimeNanos();

    public static boolean setCurrentTimeMillis(long l) {
        IAlarmManager iAlarmManager = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        if (iAlarmManager == null) {
            return false;
        }
        try {
            boolean bl = iAlarmManager.setTime(l);
            return bl;
        }
        catch (RemoteException remoteException) {
            Slog.e(TAG, "Unable to set RTC", remoteException);
            return false;
        }
        catch (SecurityException securityException) {
            Slog.e(TAG, "Unable to set RTC", securityException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sleep(long l) {
        long l2 = SystemClock.uptimeMillis();
        long l3 = l;
        boolean bl = false;
        do {
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while ((l3 = l2 + l - SystemClock.uptimeMillis()) > 0L);
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public static native long uptimeMillis();
}

