/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.system.ErrnoException;
import android.system.Os;
import android.system.StructStatVfs;

public class StatFs {
    private StructStatVfs mStat;

    public StatFs(String string2) {
        this.mStat = StatFs.doStat(string2);
    }

    private static StructStatVfs doStat(String string2) {
        try {
            StructStatVfs structStatVfs = Os.statvfs(string2);
            return structStatVfs;
        }
        catch (ErrnoException errnoException) {
            throw new IllegalArgumentException("Invalid path: " + string2, errnoException);
        }
    }

    @Deprecated
    public int getAvailableBlocks() {
        return (int)this.mStat.f_bavail;
    }

    public long getAvailableBlocksLong() {
        return this.mStat.f_bavail;
    }

    public long getAvailableBytes() {
        return this.mStat.f_bavail * this.mStat.f_bsize;
    }

    @Deprecated
    public int getBlockCount() {
        return (int)this.mStat.f_blocks;
    }

    public long getBlockCountLong() {
        return this.mStat.f_blocks;
    }

    @Deprecated
    public int getBlockSize() {
        return (int)this.mStat.f_bsize;
    }

    public long getBlockSizeLong() {
        return this.mStat.f_bsize;
    }

    @Deprecated
    public int getFreeBlocks() {
        return (int)this.mStat.f_bfree;
    }

    public long getFreeBlocksLong() {
        return this.mStat.f_bfree;
    }

    public long getFreeBytes() {
        return this.mStat.f_bfree * this.mStat.f_bsize;
    }

    public long getTotalBytes() {
        return this.mStat.f_blocks * this.mStat.f_bsize;
    }

    public void restat(String string2) {
        this.mStat = StatFs.doStat(string2);
    }
}

