/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public abstract class FileObserver {
    public static final int ACCESS = 1;
    public static final int ALL_EVENTS = 4095;
    public static final int ATTRIB = 4;
    public static final int CLOSE_NOWRITE = 16;
    public static final int CLOSE_WRITE = 8;
    public static final int CREATE = 256;
    public static final int DELETE = 512;
    public static final int DELETE_SELF = 1024;
    private static final String LOG_TAG = "FileObserver";
    public static final int MODIFY = 2;
    public static final int MOVED_FROM = 64;
    public static final int MOVED_TO = 128;
    public static final int MOVE_SELF = 2048;
    public static final int OPEN = 32;
    private static ObserverThread s_observerThread = new ObserverThread();
    private Integer m_descriptor;
    private int m_mask;
    private String m_path;

    static {
        s_observerThread.start();
    }

    public FileObserver(String string2) {
        this(string2, 4095);
    }

    public FileObserver(String string2, int n) {
        this.m_path = string2;
        this.m_mask = n;
        this.m_descriptor = -1;
    }

    protected void finalize() {
        this.stopWatching();
    }

    public abstract void onEvent(int var1, String var2);

    public void startWatching() {
        if (this.m_descriptor < 0) {
            this.m_descriptor = s_observerThread.startWatching(this.m_path, this.m_mask, this);
        }
    }

    public void stopWatching() {
        if (this.m_descriptor >= 0) {
            s_observerThread.stopWatching(this.m_descriptor);
            this.m_descriptor = -1;
        }
    }

    private static class ObserverThread
    extends Thread {
        private int m_fd;
        private HashMap<Integer, WeakReference> m_observers = new HashMap();

        public ObserverThread() {
            super(FileObserver.LOG_TAG);
            this.m_fd = this.init();
        }

        private native int init();

        private native void observe(int var1);

        private native int startWatching(int var1, String var2, int var3);

        private native void stopWatching(int var1, int var2);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onEvent(int n, int n2, String string2) {
            HashMap<Integer, WeakReference> hashMap = this.m_observers;
            // MONITORENTER : hashMap
            WeakReference weakReference = this.m_observers.get(n);
            FileObserver fileObserver = null;
            if (weakReference != null && (fileObserver = (FileObserver)weakReference.get()) == null) {
                this.m_observers.remove(n);
            }
            // MONITOREXIT : hashMap
            if (fileObserver == null) return;
            try {
                fileObserver.onEvent(n2, string2);
                return;
            }
            catch (Throwable throwable) {
                Log.wtf(FileObserver.LOG_TAG, "Unhandled exception in FileObserver " + fileObserver, throwable);
                return;
            }
        }

        @Override
        public void run() {
            this.observe(this.m_fd);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int startWatching(String string2, int n, FileObserver fileObserver) {
            int n2 = this.startWatching(this.m_fd, string2, n);
            Integer n3 = new Integer(n2);
            if (n2 >= 0) {
                HashMap<Integer, WeakReference> hashMap = this.m_observers;
                synchronized (hashMap) {
                    this.m_observers.put(n3, new WeakReference<FileObserver>(fileObserver));
                }
            }
            return n3;
        }

        public void stopWatching(int n) {
            this.stopWatching(this.m_fd, n);
        }
    }
}

