/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.system.OsConstants;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Locale;

class CommonTimeUtils {
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -4;
    public static final int ERROR_DEAD_OBJECT = -7;
    public static final int SUCCESS;
    private String mInterfaceDesc;
    private IBinder mRemote;

    public CommonTimeUtils(IBinder iBinder, String string2) {
        this.mRemote = iBinder;
        this.mInterfaceDesc = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int transactGetInt(int n, int n2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            int n3;
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(n, parcel, parcel2, 0);
            int n4 = parcel2.readInt() == 0 ? (n3 = parcel2.readInt()) : n2;
            return n4;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long transactGetLong(int n, long l) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            long l2;
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(n, parcel, parcel2, 0);
            long l3 = parcel2.readInt() == 0 ? (l2 = parcel2.readLong()) : l;
            return l3;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetSocketAddress transactGetSockaddr(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(n, parcel, parcel2, 0);
            int n2 = parcel2.readInt();
            InetSocketAddress inetSocketAddress = null;
            if (n2 == 0) {
                String string2;
                int n3;
                int n4 = parcel2.readInt();
                if (OsConstants.AF_INET == n4) {
                    int n5 = parcel2.readInt();
                    n3 = parcel2.readInt();
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{0xFF & n5 >> 24, 0xFF & n5 >> 16, 0xFF & n5 >> 8, n5 & 0xFF};
                    string2 = String.format(locale, "%d.%d.%d.%d", objectArray);
                } else {
                    int n6 = OsConstants.AF_INET6;
                    string2 = null;
                    n3 = 0;
                    if (n6 == n4) {
                        String string3;
                        int n7 = parcel2.readInt();
                        int n8 = parcel2.readInt();
                        int n9 = parcel2.readInt();
                        int n10 = parcel2.readInt();
                        n3 = parcel2.readInt();
                        parcel2.readInt();
                        parcel2.readInt();
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{0xFFFF & n7 >> 16, 0xFFFF & n7, 0xFFFF & n8 >> 16, 0xFFFF & n8, 0xFFFF & n9 >> 16, 0xFFFF & n9, 0xFFFF & n10 >> 16, 0xFFFF & n10};
                        string2 = string3 = String.format(locale, "[%04X:%04X:%04X:%04X:%04X:%04X:%04X:%04X]", objectArray);
                    }
                }
                inetSocketAddress = null;
                if (string2 != null) {
                    inetSocketAddress = new InetSocketAddress(string2, n3);
                }
            }
            parcel2.recycle();
            parcel.recycle();
            return inetSocketAddress;
        }
        catch (Throwable throwable) {
            parcel2.recycle();
            parcel.recycle();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String transactGetString(int n, String string2) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            String string3;
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(n, parcel, parcel2, 0);
            String string4 = parcel2.readInt() == 0 ? (string3 = parcel2.readString()) : string2;
            return string4;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    public int transactSetInt(int n, int n2) {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            parcel.writeInt(n2);
            this.mRemote.transact(n, parcel, parcel2, 0);
            int n3 = parcel2.readInt();
            return n3;
        }
        catch (RemoteException remoteException) {
            return -7;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    public int transactSetLong(int n, long l) {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            parcel.writeLong(l);
            this.mRemote.transact(n, parcel, parcel2, 0);
            int n2 = parcel2.readInt();
            return n2;
        }
        catch (RemoteException remoteException) {
            return -7;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int transactSetSockaddr(int n, InetSocketAddress inetSocketAddress) {
        Parcel parcel;
        Parcel parcel2;
        block11: {
            int n2;
            parcel2 = Parcel.obtain();
            parcel = Parcel.obtain();
            try {
                int n3;
                parcel2.writeInterfaceToken(this.mInterfaceDesc);
                if (inetSocketAddress == null) {
                    parcel2.writeInt(0);
                } else {
                    parcel2.writeInt(1);
                    InetAddress inetAddress = inetSocketAddress.getAddress();
                    byte[] byArray = inetAddress.getAddress();
                    int n4 = inetSocketAddress.getPort();
                    if (inetAddress instanceof Inet4Address) {
                        int n5 = (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
                        parcel2.writeInt(OsConstants.AF_INET);
                        parcel2.writeInt(n5);
                        parcel2.writeInt(n4);
                    } else {
                        if (!(inetAddress instanceof Inet6Address)) break block11;
                        Inet6Address inet6Address = (Inet6Address)inetAddress;
                        parcel2.writeInt(OsConstants.AF_INET6);
                        for (int i = 0; i < 4; ++i) {
                            parcel2.writeInt((0xFF & byArray[0 + i * 4]) << 24 | (0xFF & byArray[1 + i * 4]) << 16 | (0xFF & byArray[2 + i * 4]) << 8 | 0xFF & byArray[3 + i * 4]);
                        }
                        parcel2.writeInt(n4);
                        parcel2.writeInt(0);
                        parcel2.writeInt(inet6Address.getScopeId());
                    }
                }
                this.mRemote.transact(n, parcel2, parcel, 0);
                n2 = n3 = parcel.readInt();
                parcel.recycle();
                parcel2.recycle();
                return n2;
            }
            catch (RemoteException remoteException) {
                n2 = -7;
                parcel.recycle();
                parcel2.recycle();
                return n2;
            }
            catch (Throwable throwable) {
                parcel.recycle();
                parcel2.recycle();
                throw throwable;
            }
        }
        parcel.recycle();
        parcel2.recycle();
        return -4;
    }

    public int transactSetString(int n, String string2) {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            parcel.writeString(string2);
            this.mRemote.transact(n, parcel, parcel2, 0);
            int n2 = parcel2.readInt();
            return n2;
        }
        catch (RemoteException remoteException) {
            return -7;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
        }
    }
}

