/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.CommonTimeUtils;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;

public class CommonClock {
    public static final int ERROR_ESTIMATE_UNKNOWN = Integer.MAX_VALUE;
    public static final long INVALID_TIMELINE_ID = 0L;
    private static final int METHOD_CBK_ON_TIMELINE_CHANGED = 1;
    private static final int METHOD_COMMON_TIME_TO_LOCAL_TIME = 2;
    private static final int METHOD_GET_COMMON_FREQ = 5;
    private static final int METHOD_GET_COMMON_TIME = 4;
    private static final int METHOD_GET_ESTIMATED_ERROR = 8;
    private static final int METHOD_GET_LOCAL_FREQ = 7;
    private static final int METHOD_GET_LOCAL_TIME = 6;
    private static final int METHOD_GET_MASTER_ADDRESS = 11;
    private static final int METHOD_GET_STATE = 10;
    private static final int METHOD_GET_TIMELINE_ID = 9;
    private static final int METHOD_IS_COMMON_TIME_VALID = 1;
    private static final int METHOD_LOCAL_TIME_TO_COMMON_TIME = 3;
    private static final int METHOD_REGISTER_LISTENER = 12;
    private static final int METHOD_UNREGISTER_LISTENER = 13;
    public static final String SERVICE_NAME = "common_time.clock";
    public static final int STATE_CLIENT = 1;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_INVALID = -1;
    public static final int STATE_MASTER = 2;
    public static final int STATE_RONIN = 3;
    public static final int STATE_WAIT_FOR_ELECTION = 4;
    public static final long TIME_NOT_SYNCED = -1L;
    private TimelineChangedListener mCallbackTgt = null;
    private IBinder.DeathRecipient mDeathHandler;
    private String mInterfaceDesc = "";
    private final Object mListenerLock = new Object();
    private IBinder mRemote = null;
    private OnServerDiedListener mServerDiedListener = null;
    private OnTimelineChangedListener mTimelineChangedListener = null;
    private CommonTimeUtils mUtils;

    public CommonClock() throws RemoteException {
        this.mDeathHandler = new IBinder.DeathRecipient(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void binderDied() {
                Object object = CommonClock.this.mListenerLock;
                synchronized (object) {
                    if (CommonClock.this.mServerDiedListener != null) {
                        CommonClock.this.mServerDiedListener.onServerDied();
                    }
                    return;
                }
            }
        };
        this.mRemote = ServiceManager.getService(SERVICE_NAME);
        if (this.mRemote == null) {
            throw new RemoteException();
        }
        this.mInterfaceDesc = this.mRemote.getInterfaceDescriptor();
        this.mUtils = new CommonTimeUtils(this.mRemote, this.mInterfaceDesc);
        this.mRemote.linkToDeath(this.mDeathHandler, 0);
        this.registerTimelineChangeListener();
    }

    public static CommonClock create() {
        try {
            CommonClock commonClock = new CommonClock();
            return commonClock;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerTimelineChangeListener() throws RemoteException {
        block8: {
            block7: {
                boolean bl;
                block6: {
                    if (this.mCallbackTgt != null) break block7;
                    Parcel parcel = Parcel.obtain();
                    Parcel parcel2 = Parcel.obtain();
                    this.mCallbackTgt = new TimelineChangedListener();
                    try {
                        parcel.writeInterfaceToken(this.mInterfaceDesc);
                        parcel.writeStrongBinder(this.mCallbackTgt);
                        this.mRemote.transact(12, parcel, parcel2, 0);
                        int n = parcel2.readInt();
                        bl = n == 0;
                    }
                    catch (RemoteException remoteException) {
                        parcel2.recycle();
                        parcel.recycle();
                        bl = false;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        parcel2.recycle();
                        parcel.recycle();
                        throw throwable;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                }
                if (!bl) break block8;
            }
            return;
        }
        this.mCallbackTgt = null;
        this.mRemote = null;
        this.mUtils = null;
    }

    private void throwOnDeadServer() throws RemoteException {
        if (this.mRemote == null || this.mUtils == null) {
            throw new RemoteException();
        }
    }

    private void unregisterTimelineChangeListener() {
        if (this.mCallbackTgt == null) {
            return;
        }
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        try {
            parcel.writeInterfaceToken(this.mInterfaceDesc);
            parcel.writeStrongBinder(this.mCallbackTgt);
            this.mRemote.transact(13, parcel, parcel2, 0);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        finally {
            parcel2.recycle();
            parcel.recycle();
            this.mCallbackTgt = null;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public int getEstimatedError() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetInt(8, Integer.MAX_VALUE);
    }

    public InetSocketAddress getMasterAddr() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetSockaddr(11);
    }

    public int getState() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetInt(10, -1);
    }

    public long getTime() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetLong(4, -1L);
    }

    public long getTimelineId() throws RemoteException {
        this.throwOnDeadServer();
        return this.mUtils.transactGetLong(9, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        this.unregisterTimelineChangeListener();
        if (this.mRemote != null) {
            try {
                this.mRemote.unlinkToDeath(this.mDeathHandler, 0);
            }
            catch (NoSuchElementException noSuchElementException) {}
            this.mRemote = null;
        }
        this.mUtils = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setServerDiedListener(OnServerDiedListener onServerDiedListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mServerDiedListener = onServerDiedListener;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTimelineChangedListener(OnTimelineChangedListener onTimelineChangedListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mTimelineChangedListener = onTimelineChangedListener;
            return;
        }
    }

    public static interface OnServerDiedListener {
        public void onServerDied();
    }

    public static interface OnTimelineChangedListener {
        public void onTimelineChanged(long var1);
    }

    private class TimelineChangedListener
    extends Binder {
        private static final String DESCRIPTOR = "android.os.ICommonClockListener";

        private TimelineChangedListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            long l = parcel.readLong();
            Object object = CommonClock.this.mListenerLock;
            synchronized (object) {
                if (CommonClock.this.mTimelineChangedListener != null) {
                    CommonClock.this.mTimelineChangedListener.onTimelineChanged(l);
                }
                return true;
            }
        }
    }
}

