/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ICancellationSignal;
import android.os.OperationCanceledException;
import android.os.RemoteException;

public final class CancellationSignal {
    private boolean mCancelInProgress;
    private boolean mIsCanceled;
    private OnCancelListener mOnCancelListener;
    private ICancellationSignal mRemote;

    public static ICancellationSignal createTransport() {
        return new Transport();
    }

    public static CancellationSignal fromTransport(ICancellationSignal iCancellationSignal) {
        if (iCancellationSignal instanceof Transport) {
            return ((Transport)iCancellationSignal).mCancellationSignal;
        }
        return null;
    }

    private void waitForCancelFinishedLocked() {
        while (this.mCancelInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel() {
        synchronized (this) {
            if (this.mIsCanceled) {
                return;
            }
            this.mIsCanceled = true;
            this.mCancelInProgress = true;
            var2_1 = this.mOnCancelListener;
            var3_2 = this.mRemote;
            if (var2_1 == null) ** GOTO lbl11
        }
        try {
            var2_1.onCancel();
lbl11:
            // 2 sources

            if (var3_2 == null) return;
            try {
                var3_2.cancel();
                return;
            }
            catch (RemoteException var5_4) {
                return;
            }
        }
        finally {
            synchronized (this) {
                this.mCancelInProgress = false;
                this.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCanceled() {
        synchronized (this) {
            return this.mIsCanceled;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnCancelListener(OnCancelListener onCancelListener) {
        synchronized (this) {
            this.waitForCancelFinishedLocked();
            if (this.mOnCancelListener == onCancelListener) {
                return;
            }
            this.mOnCancelListener = onCancelListener;
            if (this.mIsCanceled && onCancelListener != null) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl8 : MonitorExitStatement: MONITOREXIT : this
                onCancelListener.onCancel();
                return;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRemote(ICancellationSignal iCancellationSignal) {
        synchronized (this) {
            this.waitForCancelFinishedLocked();
            if (this.mRemote == iCancellationSignal) {
                return;
            }
            this.mRemote = iCancellationSignal;
            if (!this.mIsCanceled || iCancellationSignal == null) {
                return;
            }
        }
        try {
            iCancellationSignal.cancel();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void throwIfCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }

    private static final class Transport
    extends ICancellationSignal.Stub {
        final CancellationSignal mCancellationSignal = new CancellationSignal();

        private Transport() {
        }

        @Override
        public void cancel() throws RemoteException {
            this.mCancellationSignal.cancel();
        }
    }
}

