/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.telephony.SignalStrength;
import android.text.format.DateFormat;
import android.util.Printer;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BatteryStats
implements Parcelable {
    private static final String APK_DATA = "apk";
    public static final int AUDIO_TURNED_ON = 7;
    private static final String BATTERY_DATA = "bt";
    private static final String BATTERY_DISCHARGE_DATA = "dc";
    private static final String BATTERY_LEVEL_DATA = "lv";
    private static final int BATTERY_STATS_CHECKIN_VERSION = 9;
    private static final String BLUETOOTH_STATE_COUNT_DATA = "bsc";
    public static final int BLUETOOTH_STATE_HIGH = 3;
    public static final int BLUETOOTH_STATE_INACTIVE = 0;
    public static final int BLUETOOTH_STATE_LOW = 1;
    public static final int BLUETOOTH_STATE_MEDIUM = 2;
    static final String[] BLUETOOTH_STATE_NAMES;
    private static final String BLUETOOTH_STATE_TIME_DATA = "bst";
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final String CHARGE_STEP_DATA = "csd";
    private static final String CHARGE_TIME_REMAIN_DATA = "ctr";
    public static final int DATA_CONNECTION_1xRTT = 7;
    public static final int DATA_CONNECTION_CDMA = 4;
    private static final String DATA_CONNECTION_COUNT_DATA = "dcc";
    public static final int DATA_CONNECTION_EDGE = 2;
    public static final int DATA_CONNECTION_EHRPD = 14;
    public static final int DATA_CONNECTION_EVDO_0 = 5;
    public static final int DATA_CONNECTION_EVDO_A = 6;
    public static final int DATA_CONNECTION_EVDO_B = 12;
    public static final int DATA_CONNECTION_GPRS = 1;
    public static final int DATA_CONNECTION_HSDPA = 8;
    public static final int DATA_CONNECTION_HSPA = 10;
    public static final int DATA_CONNECTION_HSPAP = 15;
    public static final int DATA_CONNECTION_HSUPA = 9;
    public static final int DATA_CONNECTION_IDEN = 11;
    public static final int DATA_CONNECTION_LTE = 13;
    static final String[] DATA_CONNECTION_NAMES;
    public static final int DATA_CONNECTION_NONE = 0;
    public static final int DATA_CONNECTION_OTHER = 16;
    private static final String DATA_CONNECTION_TIME_DATA = "dct";
    public static final int DATA_CONNECTION_UMTS = 3;
    private static final String DISCHARGE_STEP_DATA = "dsd";
    private static final String DISCHARGE_TIME_REMAIN_DATA = "dtr";
    public static final int DUMP_CHARGED_ONLY = 2;
    public static final int DUMP_DEVICE_WIFI_ONLY = 32;
    public static final int DUMP_HISTORY_ONLY = 4;
    public static final int DUMP_INCLUDE_HISTORY = 8;
    public static final int DUMP_UNPLUGGED_ONLY = 1;
    public static final int DUMP_VERBOSE = 16;
    public static final int FOREGROUND_ACTIVITY = 10;
    private static final String FOREGROUND_DATA = "fg";
    public static final int FULL_WIFI_LOCK = 5;
    private static final String GLOBAL_NETWORK_DATA = "gn";
    private static final String HISTORY_DATA = "h";
    public static final String[] HISTORY_EVENT_CHECKIN_NAMES;
    public static final String[] HISTORY_EVENT_NAMES;
    public static final BitDescription[] HISTORY_STATE2_DESCRIPTIONS;
    public static final BitDescription[] HISTORY_STATE_DESCRIPTIONS;
    private static final String HISTORY_STRING_POOL = "hsp";
    public static final int JOB = 14;
    private static final String JOB_DATA = "jb";
    private static final String KERNEL_WAKELOCK_DATA = "kwl";
    private static final boolean LOCAL_LOGV = false;
    private static final String MISC_DATA = "m";
    private static final String NETWORK_DATA = "nt";
    public static final int NETWORK_MOBILE_RX_DATA = 0;
    public static final int NETWORK_MOBILE_TX_DATA = 1;
    public static final int NETWORK_WIFI_RX_DATA = 2;
    public static final int NETWORK_WIFI_TX_DATA = 3;
    public static final int NUM_BLUETOOTH_STATES = 4;
    public static final int NUM_DATA_CONNECTION_TYPES = 17;
    public static final int NUM_NETWORK_ACTIVITY_TYPES = 4;
    public static final int NUM_SCREEN_BRIGHTNESS_BINS = 5;
    public static final int NUM_WIFI_SIGNAL_STRENGTH_BINS = 5;
    public static final int NUM_WIFI_STATES = 8;
    public static final int NUM_WIFI_SUPPL_STATES = 13;
    private static final String POWER_USE_ITEM_DATA = "pwi";
    private static final String POWER_USE_SUMMARY_DATA = "pws";
    private static final String PROCESS_DATA = "pr";
    public static final int PROCESS_STATE = 12;
    public static final int SCREEN_BRIGHTNESS_BRIGHT = 4;
    public static final int SCREEN_BRIGHTNESS_DARK = 0;
    private static final String SCREEN_BRIGHTNESS_DATA = "br";
    public static final int SCREEN_BRIGHTNESS_DIM = 1;
    public static final int SCREEN_BRIGHTNESS_LIGHT = 3;
    public static final int SCREEN_BRIGHTNESS_MEDIUM = 2;
    static final String[] SCREEN_BRIGHTNESS_NAMES;
    static final String[] SCREEN_BRIGHTNESS_SHORT_NAMES;
    public static final int SENSOR = 3;
    private static final String SENSOR_DATA = "sr";
    public static final String SERVICE_NAME = "batterystats";
    private static final String SIGNAL_SCANNING_TIME_DATA = "sst";
    private static final String SIGNAL_STRENGTH_COUNT_DATA = "sgc";
    private static final String SIGNAL_STRENGTH_TIME_DATA = "sgt";
    private static final String STATE_TIME_DATA = "st";
    public static final int STATS_CURRENT = 1;
    public static final int STATS_SINCE_CHARGED = 0;
    public static final int STATS_SINCE_UNPLUGGED = 2;
    private static final String[] STAT_NAMES;
    public static final long STEP_LEVEL_INITIAL_MODE_MASK = 0xFF000000000000L;
    public static final long STEP_LEVEL_INITIAL_MODE_SHIFT = 48L;
    public static final long STEP_LEVEL_LEVEL_MASK = 0xFF0000000000L;
    public static final long STEP_LEVEL_LEVEL_SHIFT = 40L;
    public static final int STEP_LEVEL_MODE_POWER_SAVE = 4;
    public static final int STEP_LEVEL_MODE_SCREEN_STATE = 3;
    public static final long STEP_LEVEL_MODIFIED_MODE_MASK = -72057594037927936L;
    public static final long STEP_LEVEL_MODIFIED_MODE_SHIFT = 56L;
    public static final long STEP_LEVEL_TIME_MASK = 0xFFFFFFFFFFL;
    public static final int SYNC = 13;
    private static final String SYNC_DATA = "sy";
    private static final String UID_DATA = "uid";
    private static final String USER_ACTIVITY_DATA = "ua";
    private static final String VERSION_DATA = "vers";
    private static final String VIBRATOR_DATA = "vib";
    public static final int VIBRATOR_ON = 9;
    public static final int VIDEO_TURNED_ON = 8;
    private static final String WAKELOCK_DATA = "wl";
    private static final String WAKEUP_REASON_DATA = "wr";
    public static final int WAKE_TYPE_FULL = 1;
    public static final int WAKE_TYPE_PARTIAL = 0;
    public static final int WAKE_TYPE_WINDOW = 2;
    public static final int WIFI_BATCHED_SCAN = 11;
    private static final String WIFI_DATA = "wfl";
    public static final int WIFI_MULTICAST_ENABLED = 7;
    public static final int WIFI_RUNNING = 4;
    public static final int WIFI_SCAN = 6;
    private static final String WIFI_SIGNAL_STRENGTH_COUNT_DATA = "wsgc";
    private static final String WIFI_SIGNAL_STRENGTH_TIME_DATA = "wsgt";
    private static final String WIFI_STATE_COUNT_DATA = "wsc";
    static final String[] WIFI_STATE_NAMES;
    public static final int WIFI_STATE_OFF = 0;
    public static final int WIFI_STATE_OFF_SCANNING = 1;
    public static final int WIFI_STATE_ON_CONNECTED_P2P = 5;
    public static final int WIFI_STATE_ON_CONNECTED_STA = 4;
    public static final int WIFI_STATE_ON_CONNECTED_STA_P2P = 6;
    public static final int WIFI_STATE_ON_DISCONNECTED = 3;
    public static final int WIFI_STATE_ON_NO_NETWORKS = 2;
    public static final int WIFI_STATE_SOFT_AP = 7;
    private static final String WIFI_STATE_TIME_DATA = "wst";
    public static final int WIFI_SUPPL_STATE_ASSOCIATED = 7;
    public static final int WIFI_SUPPL_STATE_ASSOCIATING = 6;
    public static final int WIFI_SUPPL_STATE_AUTHENTICATING = 5;
    public static final int WIFI_SUPPL_STATE_COMPLETED = 10;
    private static final String WIFI_SUPPL_STATE_COUNT_DATA = "wssc";
    public static final int WIFI_SUPPL_STATE_DISCONNECTED = 1;
    public static final int WIFI_SUPPL_STATE_DORMANT = 11;
    public static final int WIFI_SUPPL_STATE_FOUR_WAY_HANDSHAKE = 8;
    public static final int WIFI_SUPPL_STATE_GROUP_HANDSHAKE = 9;
    public static final int WIFI_SUPPL_STATE_INACTIVE = 3;
    public static final int WIFI_SUPPL_STATE_INTERFACE_DISABLED = 2;
    public static final int WIFI_SUPPL_STATE_INVALID = 0;
    static final String[] WIFI_SUPPL_STATE_NAMES;
    public static final int WIFI_SUPPL_STATE_SCANNING = 4;
    static final String[] WIFI_SUPPL_STATE_SHORT_NAMES;
    private static final String WIFI_SUPPL_STATE_TIME_DATA = "wsst";
    public static final int WIFI_SUPPL_STATE_UNINITIALIZED = 12;
    private final StringBuilder mFormatBuilder = new StringBuilder(32);
    private final Formatter mFormatter = new Formatter(this.mFormatBuilder);

    static {
        STAT_NAMES = new String[]{"l", "c", "u"};
        SCREEN_BRIGHTNESS_NAMES = new String[]{"dark", "dim", "medium", "light", "bright"};
        SCREEN_BRIGHTNESS_SHORT_NAMES = new String[]{"0", "1", "2", "3", "4"};
        DATA_CONNECTION_NAMES = new String[]{"none", "gprs", "edge", "umts", "cdma", "evdo_0", "evdo_A", "1xrtt", "hsdpa", "hsupa", "hspa", "iden", "evdo_b", "lte", "ehrpd", "hspap", "other"};
        WIFI_SUPPL_STATE_NAMES = new String[]{"invalid", "disconn", "disabled", "inactive", "scanning", "authenticating", "associating", "associated", "4-way-handshake", "group-handshake", "completed", "dormant", "uninit"};
        WIFI_SUPPL_STATE_SHORT_NAMES = new String[]{"inv", "dsc", "dis", "inact", "scan", "auth", "ascing", "asced", "4-way", "group", "compl", "dorm", "uninit"};
        BitDescription[] bitDescriptionArray = new BitDescription[]{new BitDescription(Integer.MIN_VALUE, "running", "r"), new BitDescription(0x40000000, "wake_lock", "w"), new BitDescription(0x800000, "sensor", "s"), new BitDescription(0x20000000, "gps", "g"), new BitDescription(0x10000000, "wifi_full_lock", "Wl"), new BitDescription(0x8000000, "wifi_scan", "Ws"), new BitDescription(0x4000000, "wifi_multicast", "Wm"), new BitDescription(0x2000000, "mobile_radio", "Pr"), new BitDescription(0x200000, "phone_scanning", "Psc"), new BitDescription(0x400000, "audio", "a"), new BitDescription(0x100000, "screen", "S"), new BitDescription(524288, "plugged", "BP"), new BitDescription(262144, "phone_in_call", "Pcl"), new BitDescription(65536, "bluetooth", "b"), new BitDescription(15872, 9, "data_conn", "Pcn", DATA_CONNECTION_NAMES, DATA_CONNECTION_NAMES), new BitDescription(448, 6, "phone_state", "Pst", new String[]{"in", "out", "emergency", "off"}, new String[]{"in", "out", "em", "off"}), new BitDescription(56, 3, "phone_signal_strength", "Pss", SignalStrength.SIGNAL_STRENGTH_NAMES, new String[]{"0", "1", "2", "3", "4"}), new BitDescription(7, 0, "brightness", "Sb", SCREEN_BRIGHTNESS_NAMES, SCREEN_BRIGHTNESS_SHORT_NAMES)};
        HISTORY_STATE_DESCRIPTIONS = bitDescriptionArray;
        BitDescription[] bitDescriptionArray2 = new BitDescription[]{new BitDescription(Integer.MIN_VALUE, "low_power", "lp"), new BitDescription(0x40000000, "video", "v"), new BitDescription(0x20000000, "wifi_running", "Wr"), new BitDescription(0x10000000, "wifi", "W"), new BitDescription(0x8000000, "flashlight", "fl"), new BitDescription(112, 4, "wifi_signal_strength", "Wss", new String[]{"0", "1", "2", "3", "4"}, new String[]{"0", "1", "2", "3", "4"}), new BitDescription(15, 0, "wifi_suppl", "Wsp", WIFI_SUPPL_STATE_NAMES, WIFI_SUPPL_STATE_SHORT_NAMES)};
        HISTORY_STATE2_DESCRIPTIONS = bitDescriptionArray2;
        HISTORY_EVENT_NAMES = new String[]{"null", "proc", FOREGROUND_DATA, "top", "sync", "wake_lock_in", "job", "user", "userfg"};
        HISTORY_EVENT_CHECKIN_NAMES = new String[]{"Enl", "Epr", "Efg", "Etp", "Esy", "Ewl", "Ejb", "Eur", "Euf"};
        WIFI_STATE_NAMES = new String[]{"off", "scanning", "no_net", "disconn", "sta", "p2p", "sta_p2p", "soft_ap"};
        BLUETOOTH_STATE_NAMES = new String[]{"inactive", "low", "med", "high"};
    }

    private static long computeWakeLock(Timer timer, long l, int n) {
        if (timer != null) {
            return (500L + timer.getTotalTimeLocked(l, n)) / 1000L;
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean dumpDurationSteps(PrintWriter printWriter, String string2, long[] lArray, int n, boolean bl) {
        if (n <= 0) {
            return false;
        }
        if (!bl) {
            printWriter.println(string2);
        }
        String[] stringArray = new String[4];
        int n2 = 0;
        while (n2 < n) {
            long l = 0xFFFFFFFFFFL & lArray[n2];
            int n3 = (int)((0xFF0000000000L & lArray[n2]) >> 40);
            long l2 = (0xFF000000000000L & lArray[n2]) >> 48;
            long l3 = (0xFF00000000000000L & lArray[n2]) >> 56;
            if (bl) {
                stringArray[0] = Long.toString(l);
                stringArray[1] = Integer.toString(n3);
                if ((3L & l3) == 0L) {
                    switch (1 + (int)(3L & l2)) {
                        default: {
                            stringArray[1] = "?";
                            break;
                        }
                        case 1: {
                            stringArray[2] = "s-";
                            break;
                        }
                        case 2: {
                            stringArray[2] = "s+";
                            break;
                        }
                        case 3: {
                            stringArray[2] = "sd";
                            break;
                        }
                        case 4: {
                            stringArray[2] = "sds";
                            break;
                        }
                    }
                } else {
                    stringArray[2] = "";
                }
                if ((4L & l3) == 0L) {
                    String string3 = (4L & l2) != 0L ? "p+" : "p-";
                    stringArray[3] = string3;
                } else {
                    stringArray[3] = "";
                }
                BatteryStats.dumpLine(printWriter, 0, "i", string2, stringArray);
            } else {
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                TimeUtils.formatDuration(l, printWriter);
                printWriter.print(" to ");
                printWriter.print(n3);
                long l4 = (3L & l3) - 0L;
                long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                boolean bl2 = false;
                if (l5 == false) {
                    printWriter.print(" (");
                    switch (1 + (int)(3L & l2)) {
                        default: {
                            stringArray[1] = "screen-?";
                            break;
                        }
                        case 1: {
                            printWriter.print("screen-off");
                            break;
                        }
                        case 2: {
                            printWriter.print("screen-on");
                            break;
                        }
                        case 3: {
                            printWriter.print("screen-doze");
                            break;
                        }
                        case 4: {
                            printWriter.print("screen-doze-suspend");
                        }
                    }
                    bl2 = true;
                }
                if ((4L & l3) == 0L) {
                    String string4 = bl2 ? ", " : " (";
                    printWriter.print(string4);
                    String string5 = (4L & l2) != 0L ? "power-save-on" : "power-save-off";
                    printWriter.print(string5);
                    bl2 = true;
                }
                if (bl2) {
                    printWriter.print(")");
                }
                printWriter.println();
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dumpHistoryLocked(PrintWriter printWriter, int n, long l, boolean bl) {
        HistoryPrinter historyPrinter = new HistoryPrinter();
        HistoryItem historyItem = new HistoryItem();
        long l2 = -1L;
        long l3 = -1L;
        boolean bl2 = false;
        while (this.getNextHistoryLocked(historyItem)) {
            l2 = historyItem.time;
            if (l3 < 0L) {
                l3 = l2;
            }
            if (historyItem.time < l) continue;
            if (l >= 0L && !bl2) {
                if (historyItem.cmd == 5 || historyItem.cmd == 7 || historyItem.cmd == 4) {
                    bl2 = true;
                    boolean bl3 = (n & 0x10) != 0;
                    historyPrinter.printNextItem(printWriter, historyItem, l3, bl, bl3);
                    historyItem.cmd = 0;
                } else if (historyItem.currentTime != 0L) {
                    bl2 = true;
                    byte by = historyItem.cmd;
                    historyItem.cmd = (byte)5;
                    boolean bl4 = (n & 0x10) != 0;
                    historyPrinter.printNextItem(printWriter, historyItem, l3, bl, bl4);
                    historyItem.cmd = by;
                }
            }
            boolean bl5 = (n & 0x10) != 0;
            historyPrinter.printNextItem(printWriter, historyItem, l3, bl, bl5);
        }
        if (l >= 0L) {
            this.commitCurrentHistoryBatchLocked();
            String string2 = bl ? "NEXT: " : "  NEXT: ";
            printWriter.print(string2);
            printWriter.println(1L + l2);
        }
    }

    private static final void dumpLine(PrintWriter printWriter, int n, String string2, String string3, Object ... objectArray) {
        printWriter.print(9);
        printWriter.print(',');
        printWriter.print(n);
        printWriter.print(',');
        printWriter.print(string2);
        printWriter.print(',');
        printWriter.print(string3);
        for (Object object : objectArray) {
            printWriter.print(',');
            printWriter.print(object);
        }
        printWriter.println();
    }

    public static final void formatTime(StringBuilder stringBuilder, long l) {
        long l2 = l / 100L;
        BatteryStats.formatTimeRaw(stringBuilder, l2);
        stringBuilder.append(10L * (l - 100L * l2));
        stringBuilder.append("ms ");
    }

    public static final void formatTimeMs(StringBuilder stringBuilder, long l) {
        long l2 = l / 1000L;
        BatteryStats.formatTimeRaw(stringBuilder, l2);
        stringBuilder.append(l - 1000L * l2);
        stringBuilder.append("ms ");
    }

    public static final void formatTimeMsNoSpace(StringBuilder stringBuilder, long l) {
        long l2 = l / 1000L;
        BatteryStats.formatTimeRaw(stringBuilder, l2);
        stringBuilder.append(l - 1000L * l2);
        stringBuilder.append("ms");
    }

    private static final void formatTimeRaw(StringBuilder stringBuilder, long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6 = l / 86400L;
        if (l6 != 0L) {
            stringBuilder.append(l6);
            stringBuilder.append("d ");
        }
        if ((l5 = (l - (l4 = 24L * (60L * (60L * l6)))) / 3600L) != 0L || l4 != 0L) {
            stringBuilder.append(l5);
            stringBuilder.append("h ");
        }
        if ((l3 = (l - (l2 = l4 + 60L * (60L * l5))) / 60L) != 0L || l2 != 0L) {
            stringBuilder.append(l3);
            stringBuilder.append("m ");
        }
        long l7 = l2 + 60L * l3;
        if (l != 0L || l7 != 0L) {
            stringBuilder.append(l - l7);
            stringBuilder.append("s ");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void printBitDescriptions(PrintWriter printWriter, int n, int n2, HistoryTag historyTag, BitDescription[] bitDescriptionArray, boolean bl) {
        block9: {
            block8: {
                int n3 = n ^ n2;
                if (n3 == 0) break block8;
                boolean bl2 = false;
                for (int i = 0; i < bitDescriptionArray.length; ++i) {
                    BitDescription bitDescription = bitDescriptionArray[i];
                    if ((n3 & bitDescription.mask) == 0) continue;
                    String string2 = bl ? " " : ",";
                    printWriter.print(string2);
                    if (bitDescription.shift < 0) {
                        String string3 = (n2 & bitDescription.mask) != 0 ? "+" : "-";
                        printWriter.print(string3);
                        String string4 = bl ? bitDescription.name : bitDescription.shortName;
                        printWriter.print(string4);
                        if (bitDescription.mask != 0x40000000 || historyTag == null) continue;
                        bl2 = true;
                        printWriter.print("=");
                        if (bl) {
                            UserHandle.formatUid(printWriter, historyTag.uid);
                            printWriter.print(":\"");
                            printWriter.print(historyTag.string);
                            printWriter.print("\"");
                            continue;
                        }
                        printWriter.print(historyTag.poolIdx);
                        continue;
                    }
                    String string5 = bl ? bitDescription.name : bitDescription.shortName;
                    printWriter.print(string5);
                    printWriter.print("=");
                    int n4 = (n2 & bitDescription.mask) >> bitDescription.shift;
                    if (bitDescription.values != null && n4 >= 0 && n4 < bitDescription.values.length) {
                        String string6 = bl ? bitDescription.values[n4] : bitDescription.shortValues[n4];
                        printWriter.print(string6);
                        continue;
                    }
                    printWriter.print(n4);
                }
                if (!bl2 && historyTag != null) break block9;
            }
            return;
        }
        String string7 = bl ? " wake_lock=" : ",w=";
        printWriter.print(string7);
        if (bl) {
            UserHandle.formatUid(printWriter, historyTag.uid);
            printWriter.print(":\"");
            printWriter.print(historyTag.string);
            printWriter.print("\"");
            return;
        }
        printWriter.print(historyTag.poolIdx);
    }

    private void printSizeValue(PrintWriter printWriter, long l) {
        float f = l;
        String string2 = "";
        if (f >= 10240.0f) {
            string2 = "KB";
            f /= 1024.0f;
        }
        if (f >= 10240.0f) {
            string2 = "MB";
            f /= 1024.0f;
        }
        if (f >= 10240.0f) {
            string2 = "GB";
            f /= 1024.0f;
        }
        if (f >= 10240.0f) {
            string2 = "TB";
            f /= 1024.0f;
        }
        if (f >= 10240.0f) {
            string2 = "PB";
            f /= 1024.0f;
        }
        printWriter.print((int)f);
        printWriter.print(string2);
    }

    private static final String printWakeLock(StringBuilder stringBuilder, Timer timer, long l, String string2, int n, String string3) {
        if (timer != null) {
            long l2 = BatteryStats.computeWakeLock(timer, l, n);
            int n2 = timer.getCountLocked(n);
            if (l2 != 0L) {
                stringBuilder.append(string3);
                BatteryStats.formatTimeMs(stringBuilder, l2);
                if (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(' ');
                }
                stringBuilder.append('(');
                stringBuilder.append(n2);
                stringBuilder.append(" times)");
                string3 = ", ";
            }
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String printWakeLockCheckin(StringBuilder stringBuilder, Timer timer, long l, String string2, int n, String string3) {
        long l2 = 0L;
        int n2 = 0;
        if (timer != null) {
            l2 = timer.getTotalTimeLocked(l, n);
            n2 = timer.getCountLocked(n);
        }
        stringBuilder.append(string3);
        stringBuilder.append((500L + l2) / 1000L);
        stringBuilder.append(',');
        String string4 = string2 != null ? string2 + "," : "";
        stringBuilder.append(string4);
        stringBuilder.append(n2);
        return ",";
    }

    private void printmAh(PrintWriter printWriter, double d) {
        printWriter.print(BatteryStatsHelper.makemAh(d));
    }

    public abstract void commitCurrentHistoryBatchLocked();

    public abstract long computeBatteryRealtime(long var1, int var3);

    public abstract long computeBatteryScreenOffRealtime(long var1, int var3);

    public abstract long computeBatteryScreenOffUptime(long var1, int var3);

    public abstract long computeBatteryTimeRemaining(long var1);

    public abstract long computeBatteryUptime(long var1, int var3);

    public abstract long computeChargeTimeRemaining(long var1);

    public abstract long computeRealtime(long var1, int var3);

    public abstract long computeUptime(long var1, int var3);

    public final void dumpCheckinLocked(Context context, PrintWriter printWriter, int n, int n2) {
        this.dumpCheckinLocked(context, printWriter, n, n2, BatteryStatsHelper.checkWifiOnly(context));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void dumpCheckinLocked(Context context, PrintWriter printWriter, int n, int n2, boolean bl) {
        long l = 1000L * SystemClock.uptimeMillis();
        long l2 = 1000L * SystemClock.elapsedRealtime();
        long l3 = this.getBatteryUptime(l);
        long l4 = this.computeBatteryUptime(l, n);
        long l5 = this.computeBatteryRealtime(l2, n);
        long l6 = this.computeBatteryScreenOffUptime(l, n);
        long l7 = this.computeBatteryScreenOffRealtime(l2, n);
        long l8 = this.computeRealtime(l2, n);
        long l9 = this.computeUptime(l, n);
        long l10 = this.getScreenOnTime(l2, n);
        long l11 = this.getInteractiveTime(l2, n);
        long l12 = this.getLowPowerModeEnabledTime(l2, n);
        long l13 = this.getPhoneOnTime(l2, n);
        long l14 = this.getWifiOnTime(l2, n);
        long l15 = this.getGlobalWifiRunningTime(l2, n);
        long l16 = this.getBluetoothOnTime(l2, n);
        StringBuilder stringBuilder = new StringBuilder(128);
        SparseArray<? extends Uid> sparseArray = this.getUidStats();
        int n3 = sparseArray.size();
        String string2 = STAT_NAMES[n];
        Object[] objectArray = new Object[8];
        Object object = n == 0 ? Integer.valueOf(this.getStartCount()) : "N/A";
        objectArray[0] = object;
        objectArray[1] = l5 / 1000L;
        objectArray[2] = l4 / 1000L;
        objectArray[3] = l8 / 1000L;
        objectArray[4] = l9 / 1000L;
        objectArray[5] = this.getStartClockTime();
        objectArray[6] = l7 / 1000L;
        objectArray[7] = l6 / 1000L;
        BatteryStats.dumpLine(printWriter, 0, string2, BATTERY_DATA, objectArray);
        long l17 = 0L;
        long l18 = 0L;
        for (int i = 0; i < n3; ++i) {
            Map<String, ? extends Uid.Wakelock> map = sparseArray.valueAt(i).getWakelockStats();
            if (map.size() <= 0) continue;
            Iterator<Map.Entry<String, ? extends Uid.Wakelock>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Timer timer;
                Uid.Wakelock wakelock = iterator.next().getValue();
                Timer timer2 = wakelock.getWakeTime(1);
                if (timer2 != null) {
                    l17 += timer2.getTotalTimeLocked(l2, n);
                }
                if ((timer = wakelock.getWakeTime(0)) == null) continue;
                l18 += timer.getTotalTimeLocked(l2, n);
            }
        }
        long l19 = this.getNetworkActivityBytes(0, n);
        long l20 = this.getNetworkActivityBytes(1, n);
        long l21 = this.getNetworkActivityBytes(2, n);
        long l22 = this.getNetworkActivityBytes(3, n);
        long l23 = this.getNetworkActivityPackets(0, n);
        long l24 = this.getNetworkActivityPackets(1, n);
        long l25 = this.getNetworkActivityPackets(2, n);
        long l26 = this.getNetworkActivityPackets(3, n);
        Object[] objectArray2 = new Object[]{l19, l20, l21, l22, l23, l24, l25, l26};
        BatteryStats.dumpLine(printWriter, 0, string2, GLOBAL_NETWORK_DATA, objectArray2);
        Object[] objectArray3 = new Object[]{l10 / 1000L, l13 / 1000L, l14 / 1000L, l15 / 1000L, l16 / 1000L, l19, l20, l21, l22, l17 / 1000L, l18 / 1000L, 0, this.getMobileRadioActiveTime(l2, n) / 1000L, this.getMobileRadioActiveAdjustedTime(n) / 1000L, l11 / 1000L, l12 / 1000L};
        BatteryStats.dumpLine(printWriter, 0, string2, MISC_DATA, objectArray3);
        Object[] objectArray4 = new Object[5];
        for (int i = 0; i < 5; ++i) {
            objectArray4[i] = this.getScreenBrightnessTime(i, l2, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, SCREEN_BRIGHTNESS_DATA, objectArray4);
        Object[] objectArray5 = new Object[5];
        for (int i = 0; i < 5; ++i) {
            objectArray5[i] = this.getPhoneSignalStrengthTime(i, l2, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, SIGNAL_STRENGTH_TIME_DATA, objectArray5);
        Object[] objectArray6 = new Object[]{this.getPhoneSignalScanningTime(l2, n) / 1000L};
        BatteryStats.dumpLine(printWriter, 0, string2, SIGNAL_SCANNING_TIME_DATA, objectArray6);
        for (int i = 0; i < 5; ++i) {
            objectArray5[i] = this.getPhoneSignalStrengthCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, SIGNAL_STRENGTH_COUNT_DATA, objectArray5);
        Object[] objectArray7 = new Object[17];
        for (int i = 0; i < 17; ++i) {
            objectArray7[i] = this.getPhoneDataConnectionTime(i, l2, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, DATA_CONNECTION_TIME_DATA, objectArray7);
        for (int i = 0; i < 17; ++i) {
            objectArray7[i] = this.getPhoneDataConnectionCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, DATA_CONNECTION_COUNT_DATA, objectArray7);
        Object[] objectArray8 = new Object[8];
        for (int i = 0; i < 8; ++i) {
            objectArray8[i] = this.getWifiStateTime(i, l2, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, WIFI_STATE_TIME_DATA, objectArray8);
        for (int i = 0; i < 8; ++i) {
            objectArray8[i] = this.getWifiStateCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, WIFI_STATE_COUNT_DATA, objectArray8);
        Object[] objectArray9 = new Object[13];
        for (int i = 0; i < 13; ++i) {
            objectArray9[i] = this.getWifiSupplStateTime(i, l2, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, WIFI_SUPPL_STATE_TIME_DATA, objectArray9);
        for (int i = 0; i < 13; ++i) {
            objectArray9[i] = this.getWifiSupplStateCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, WIFI_SUPPL_STATE_COUNT_DATA, objectArray9);
        Object[] objectArray10 = new Object[5];
        for (int i = 0; i < 5; ++i) {
            objectArray10[i] = this.getWifiSignalStrengthTime(i, l2, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, WIFI_SIGNAL_STRENGTH_TIME_DATA, objectArray10);
        for (int i = 0; i < 5; ++i) {
            objectArray10[i] = this.getWifiSignalStrengthCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, WIFI_SIGNAL_STRENGTH_COUNT_DATA, objectArray10);
        Object[] objectArray11 = new Object[4];
        for (int i = 0; i < 4; ++i) {
            objectArray11[i] = this.getBluetoothStateTime(i, l2, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, BLUETOOTH_STATE_TIME_DATA, objectArray11);
        for (int i = 0; i < 4; ++i) {
            objectArray11[i] = this.getBluetoothStateCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, BLUETOOTH_STATE_COUNT_DATA, objectArray11);
        if (n == 2) {
            Object[] objectArray12 = new Object[]{this.getDischargeStartLevel(), this.getDischargeCurrentLevel()};
            BatteryStats.dumpLine(printWriter, 0, string2, BATTERY_LEVEL_DATA, objectArray12);
        }
        if (n == 2) {
            Object[] objectArray13 = new Object[]{this.getDischargeStartLevel() - this.getDischargeCurrentLevel(), this.getDischargeStartLevel() - this.getDischargeCurrentLevel(), this.getDischargeAmountScreenOn(), this.getDischargeAmountScreenOff()};
            BatteryStats.dumpLine(printWriter, 0, string2, BATTERY_DISCHARGE_DATA, objectArray13);
        } else {
            Object[] objectArray14 = new Object[]{this.getLowDischargeAmountSinceCharge(), this.getHighDischargeAmountSinceCharge(), this.getDischargeAmountScreenOnSinceCharge(), this.getDischargeAmountScreenOffSinceCharge()};
            BatteryStats.dumpLine(printWriter, 0, string2, BATTERY_DISCHARGE_DATA, objectArray14);
        }
        if (n2 < 0) {
            Map<String, ? extends Timer> map;
            Map<String, ? extends Timer> map2 = this.getKernelWakelockStats();
            if (map2.size() > 0) {
                for (Map.Entry<String, ? extends Timer> entry : map2.entrySet()) {
                    stringBuilder.setLength(0);
                    BatteryStats.printWakeLockCheckin(stringBuilder, entry.getValue(), l2, null, n, "");
                    Object[] objectArray15 = new Object[]{entry.getKey(), stringBuilder.toString()};
                    BatteryStats.dumpLine(printWriter, 0, string2, KERNEL_WAKELOCK_DATA, objectArray15);
                }
            }
            if ((map = this.getWakeupReasonStats()).size() > 0) {
                for (Map.Entry<String, ? extends Timer> entry : map.entrySet()) {
                    long l27 = entry.getValue().getTotalTimeLocked(l2, n);
                    int n4 = entry.getValue().getCountLocked(n);
                    Object[] objectArray16 = new Object[]{"\"" + entry.getKey() + "\"", (500L + l27) / 1000L, n4};
                    BatteryStats.dumpLine(printWriter, 0, string2, WAKEUP_REASON_DATA, objectArray16);
                }
            }
        }
        BatteryStatsHelper batteryStatsHelper = new BatteryStatsHelper(context, false, bl);
        batteryStatsHelper.create(this);
        batteryStatsHelper.refreshStats(n, -1);
        List<BatterySipper> list = batteryStatsHelper.getUsageList();
        if (list != null && list.size() > 0) {
            int n5;
            Object[] objectArray17 = new Object[]{BatteryStatsHelper.makemAh(batteryStatsHelper.getPowerProfile().getBatteryCapacity()), BatteryStatsHelper.makemAh(batteryStatsHelper.getComputedPower()), BatteryStatsHelper.makemAh(batteryStatsHelper.getMinDrainedPower()), BatteryStatsHelper.makemAh(batteryStatsHelper.getMaxDrainedPower())};
            BatteryStats.dumpLine(printWriter, 0, string2, POWER_USE_SUMMARY_DATA, objectArray17);
            for (int i = 0; i < (n5 = list.size()); ++i) {
                String string3;
                BatterySipper batterySipper = list.get(i);
                int n6 = 0;
                switch (2.$SwitchMap$com$android$internal$os$BatterySipper$DrainType[batterySipper.drainType.ordinal()]) {
                    default: {
                        string3 = "???";
                        break;
                    }
                    case 1: {
                        string3 = "idle";
                        n6 = 0;
                        break;
                    }
                    case 2: {
                        string3 = "cell";
                        n6 = 0;
                        break;
                    }
                    case 3: {
                        string3 = "phone";
                        n6 = 0;
                        break;
                    }
                    case 4: {
                        string3 = "wifi";
                        n6 = 0;
                        break;
                    }
                    case 5: {
                        string3 = "blue";
                        n6 = 0;
                        break;
                    }
                    case 6: {
                        string3 = "scrn";
                        n6 = 0;
                        break;
                    }
                    case 7: {
                        string3 = "flashlight";
                        n6 = 0;
                        break;
                    }
                    case 8: {
                        n6 = batterySipper.uidObj.getUid();
                        string3 = UID_DATA;
                        break;
                    }
                    case 9: {
                        n6 = UserHandle.getUid(batterySipper.userId, 0);
                        string3 = "user";
                        break;
                    }
                    case 10: {
                        string3 = "unacc";
                        n6 = 0;
                        break;
                    }
                    case 11: {
                        string3 = "over";
                        n6 = 0;
                    }
                }
                Object[] objectArray18 = new Object[]{string3, BatteryStatsHelper.makemAh(batterySipper.value)};
                BatteryStats.dumpLine(printWriter, n6, string2, POWER_USE_ITEM_DATA, objectArray18);
            }
        }
        int n7 = 0;
        while (n7 < n3) {
            int n8 = sparseArray.keyAt(n7);
            if (n2 < 0 || n8 == n2) {
                Map<String, ? extends Uid.Pkg> map;
                Map<String, ? extends Uid.Proc> map3;
                Timer timer;
                Map<String, ? extends Timer> map4;
                Map<String, ? extends Timer> map5;
                Map<String, ? extends Uid.Wakelock> map6;
                Uid uid = sparseArray.valueAt(n7);
                long l28 = uid.getNetworkActivityBytes(0, n);
                long l29 = uid.getNetworkActivityBytes(1, n);
                long l30 = uid.getNetworkActivityBytes(2, n);
                long l31 = uid.getNetworkActivityBytes(3, n);
                long l32 = uid.getNetworkActivityPackets(0, n);
                long l33 = uid.getNetworkActivityPackets(1, n);
                long l34 = uid.getMobileRadioActiveTime(n);
                int n9 = uid.getMobileRadioActiveCount(n);
                long l35 = uid.getNetworkActivityPackets(2, n);
                long l36 = uid.getNetworkActivityPackets(3, n);
                long l37 = uid.getFullWifiLockTime(l2, n);
                long l38 = uid.getWifiScanTime(l2, n);
                long l39 = uid.getWifiRunningTime(l2, n);
                if (l28 > 0L || l29 > 0L || l30 > 0L || l31 > 0L || l32 > 0L || l33 > 0L || l35 > 0L || l36 > 0L || l34 > 0L || n9 > 0) {
                    Object[] objectArray19 = new Object[]{l28, l29, l30, l31, l32, l33, l35, l36, l34, n9};
                    BatteryStats.dumpLine(printWriter, n8, string2, NETWORK_DATA, objectArray19);
                }
                if (l37 != 0L || l38 != 0L || l39 != 0L) {
                    Object[] objectArray20 = new Object[]{l37, l38, l39};
                    BatteryStats.dumpLine(printWriter, n8, string2, WIFI_DATA, objectArray20);
                }
                if (uid.hasUserActivity()) {
                    Object[] objectArray21 = new Object[3];
                    boolean bl2 = false;
                    for (int i = 0; i < 3; ++i) {
                        int n10 = uid.getUserActivityCount(i, n);
                        objectArray21[i] = n10;
                        if (n10 == 0) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        BatteryStats.dumpLine(printWriter, n8, string2, USER_ACTIVITY_DATA, objectArray21);
                    }
                }
                if ((map6 = uid.getWakelockStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Uid.Wakelock> entry : map6.entrySet()) {
                        Uid.Wakelock wakelock = entry.getValue();
                        stringBuilder.setLength(0);
                        String string4 = BatteryStats.printWakeLockCheckin(stringBuilder, wakelock.getWakeTime(1), l2, "f", n, "");
                        String string5 = BatteryStats.printWakeLockCheckin(stringBuilder, wakelock.getWakeTime(0), l2, "p", n, string4);
                        BatteryStats.printWakeLockCheckin(stringBuilder, wakelock.getWakeTime(2), l2, "w", n, string5);
                        if (stringBuilder.length() <= 0) continue;
                        String string6 = entry.getKey();
                        if (string6.indexOf(44) >= 0) {
                            string6 = string6.replace(',', '_');
                        }
                        Object[] objectArray22 = new Object[]{string6, stringBuilder.toString()};
                        BatteryStats.dumpLine(printWriter, n8, string2, WAKELOCK_DATA, objectArray22);
                    }
                }
                if ((map5 = uid.getSyncStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Timer> entry : map5.entrySet()) {
                        Timer timer3 = entry.getValue();
                        long l40 = (500L + timer3.getTotalTimeLocked(l2, n)) / 1000L;
                        int n11 = timer3.getCountLocked(n);
                        if (l40 == 0L) continue;
                        Object[] objectArray23 = new Object[]{entry.getKey(), l40, n11};
                        BatteryStats.dumpLine(printWriter, n8, string2, SYNC_DATA, objectArray23);
                    }
                }
                if ((map4 = uid.getJobStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Timer> entry : map4.entrySet()) {
                        Timer timer4 = entry.getValue();
                        long l41 = (500L + timer4.getTotalTimeLocked(l2, n)) / 1000L;
                        int n12 = timer4.getCountLocked(n);
                        if (l41 == 0L) continue;
                        Object[] objectArray24 = new Object[]{entry.getKey(), l41, n12};
                        BatteryStats.dumpLine(printWriter, n8, string2, JOB_DATA, objectArray24);
                    }
                }
                SparseArray<? extends Uid.Sensor> sparseArray2 = uid.getSensorStats();
                int n13 = sparseArray2.size();
                for (int i = 0; i < n13; ++i) {
                    Uid.Sensor sensor = sparseArray2.valueAt(i);
                    int n14 = sparseArray2.keyAt(i);
                    Timer timer5 = sensor.getSensorTime();
                    if (timer5 == null) continue;
                    long l42 = (500L + timer5.getTotalTimeLocked(l2, n)) / 1000L;
                    int n15 = timer5.getCountLocked(n);
                    if (l42 == 0L) continue;
                    Object[] objectArray25 = new Object[]{n14, l42, n15};
                    BatteryStats.dumpLine(printWriter, n8, string2, SENSOR_DATA, objectArray25);
                }
                Timer timer6 = uid.getVibratorOnTimer();
                if (timer6 != null) {
                    long l43 = (500L + timer6.getTotalTimeLocked(l2, n)) / 1000L;
                    int n16 = timer6.getCountLocked(n);
                    if (l43 != 0L) {
                        Object[] objectArray26 = new Object[]{l43, n16};
                        BatteryStats.dumpLine(printWriter, n8, string2, VIBRATOR_DATA, objectArray26);
                    }
                }
                if ((timer = uid.getForegroundActivityTimer()) != null) {
                    long l44 = (500L + timer.getTotalTimeLocked(l2, n)) / 1000L;
                    int n17 = timer.getCountLocked(n);
                    if (l44 != 0L) {
                        Object[] objectArray27 = new Object[]{l44, n17};
                        BatteryStats.dumpLine(printWriter, n8, string2, FOREGROUND_DATA, objectArray27);
                    }
                }
                Object[] objectArray28 = new Object[3];
                long l45 = 0L;
                for (int i = 0; i < 3; ++i) {
                    objectArray28[i] = (500L + (l45 += uid.getProcessStateTime(i, l2, n))) / 1000L;
                }
                if (l45 > 0L) {
                    BatteryStats.dumpLine(printWriter, n8, string2, STATE_TIME_DATA, objectArray28);
                }
                if ((map3 = uid.getProcessStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Uid.Proc> entry : map3.entrySet()) {
                        Uid.Proc proc = entry.getValue();
                        long l46 = 10L * proc.getUserTime(n);
                        long l47 = 10L * proc.getSystemTime(n);
                        long l48 = 10L * proc.getForegroundTime(n);
                        long l49 = proc.getStarts(n);
                        if (l46 == 0L && l47 == 0L && l48 == 0L && l49 == 0L) continue;
                        Object[] objectArray29 = new Object[]{entry.getKey(), l46, l47, l48, l49};
                        BatteryStats.dumpLine(printWriter, n8, string2, PROCESS_DATA, objectArray29);
                    }
                }
                if ((map = uid.getPackageStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Uid.Pkg> entry : map.entrySet()) {
                        Uid.Pkg pkg = entry.getValue();
                        int n18 = pkg.getWakeups(n);
                        for (Map.Entry<String, ? extends Uid.Pkg.Serv> entry2 : pkg.getServiceStats().entrySet()) {
                            Uid.Pkg.Serv serv = entry2.getValue();
                            long l50 = serv.getStartTime(l3, n);
                            int n19 = serv.getStarts(n);
                            int n20 = serv.getLaunches(n);
                            if (l50 == 0L && n19 == 0 && n20 == 0) continue;
                            Object[] objectArray30 = new Object[]{n18, entry.getKey(), entry2.getKey(), l50 / 1000L, n19, n20};
                            BatteryStats.dumpLine(printWriter, n8, string2, APK_DATA, objectArray30);
                        }
                    }
                }
            }
            ++n7;
        }
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dumpCheckinLocked(Context context, PrintWriter printWriter, List<ApplicationInfo> list, int n, long l) {
        boolean bl;
        block16: {
            this.prepareForDumpLocked();
            Object[] objectArray = new Object[]{"11", this.getParcelVersion(), this.getStartPlatformVersion(), this.getEndPlatformVersion()};
            BatteryStats.dumpLine(printWriter, 0, "i", VERSION_DATA, objectArray);
            long cfr_ignored_0 = this.getHistoryBaseTime() + SystemClock.elapsedRealtime();
            bl = (n & 7) != 0;
            if (((n & 8) != 0 || (n & 4) != 0) && this.startIteratingHistoryLocked()) {
                for (int i = 0; i < this.getHistoryStringPoolSize(); ++i) {
                    printWriter.print(9);
                    printWriter.print(',');
                    printWriter.print(HISTORY_STRING_POOL);
                    printWriter.print(',');
                    printWriter.print(i);
                    printWriter.print(",");
                    printWriter.print(this.getHistoryTagPoolUid(i));
                    printWriter.print(",\"");
                    printWriter.print(this.getHistoryTagPoolString(i).replace("\\", "\\\\").replace("\"", "\\\""));
                    printWriter.print("\"");
                    printWriter.println();
                }
                this.dumpHistoryLocked(printWriter, n, l, true);
            }
            if (bl && (n & 3) == 0) {
                return;
            }
            break block16;
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (list != null) {
            SparseArray<ArrayList<String>> sparseArray = new SparseArray<ArrayList<String>>();
            for (int i = 0; i < list.size(); ++i) {
                ApplicationInfo applicationInfo = list.get(i);
                ArrayList<String> arrayList = (ArrayList<String>)sparseArray.get(applicationInfo.uid);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    sparseArray.put(applicationInfo.uid, arrayList);
                }
                arrayList.add(applicationInfo.packageName);
            }
            SparseArray<? extends Uid> sparseArray2 = this.getUidStats();
            int n2 = sparseArray2.size();
            String[] stringArray = new String[2];
            for (int i = 0; i < n2; ++i) {
                int n3 = sparseArray2.keyAt(i);
                ArrayList arrayList = (ArrayList)sparseArray.get(n3);
                if (arrayList == null) continue;
                for (int j = 0; j < arrayList.size(); ++j) {
                    stringArray[0] = Integer.toString(n3);
                    stringArray[1] = (String)arrayList.get(j);
                    BatteryStats.dumpLine(printWriter, 0, "i", UID_DATA, stringArray);
                }
            }
        }
        if (!bl || (n & 2) != 0) {
            BatteryStats.dumpDurationSteps(printWriter, DISCHARGE_STEP_DATA, this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), true);
            String[] stringArray = new String[1];
            long l2 = this.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
            if (l2 >= 0L) {
                stringArray[0] = Long.toString(l2);
                BatteryStats.dumpLine(printWriter, 0, "i", DISCHARGE_TIME_REMAIN_DATA, stringArray);
            }
            BatteryStats.dumpDurationSteps(printWriter, CHARGE_STEP_DATA, this.getChargeStepDurationsArray(), this.getNumChargeStepDurations(), true);
            long l3 = this.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
            if (l3 >= 0L) {
                stringArray[0] = Long.toString(l3);
                BatteryStats.dumpLine(printWriter, 0, "i", CHARGE_TIME_REMAIN_DATA, stringArray);
            }
            boolean bl2 = (n & 0x20) != 0;
            this.dumpCheckinLocked(context, printWriter, 0, -1, bl2);
        }
        if (bl) {
            if ((n & 1) == 0) return;
        }
        boolean bl3 = (n & 0x20) != 0;
        this.dumpCheckinLocked(context, printWriter, 2, -1, bl3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dumpLocked(Context var1_1, PrintWriter var2_2, int var3_3, int var4_4, long var5_5) {
        block27: {
            block26: {
                block25: {
                    this.prepareForDumpLocked();
                    var7_6 = (var3_3 & 7) != 0;
                    if ((var3_3 & 4) == 0 && var7_6) break block25;
                    var8_7 = this.getHistoryTotalSize();
                    var10_8 = this.getHistoryUsedSize();
                    if (this.startIteratingHistoryLocked()) {
                        var2_2.print("Battery History (");
                        var2_2.print(100L * var10_8 / var8_7);
                        var2_2.print("% used, ");
                        this.printSizeValue(var2_2, var10_8);
                        var2_2.print(" used of ");
                        this.printSizeValue(var2_2, var8_7);
                        var2_2.print(", ");
                        var2_2.print(this.getHistoryStringPoolSize());
                        var2_2.print(" strings using ");
                        this.printSizeValue(var2_2, this.getHistoryStringPoolBytes());
                        var2_2.println("):");
                        this.dumpHistoryLocked(var2_2, var3_3, var5_5, false);
                        var2_2.println();
                    }
                    if (!this.startIteratingOldHistoryLocked()) break block25;
                    try {
                        var34_9 = new HistoryItem();
                        var2_2.println("Old battery History:");
                        var36_10 = new HistoryPrinter();
                        var37_11 = -1L;
lbl27:
                        // 2 sources

                        while (true) {
                            if (this.getNextOldHistoryLocked(var34_9)) {
                                if (var37_11 >= 0L) ** GOTO lbl96
                                var37_11 = var34_9.time;
                            }
                            break;
                        }
                    }
                    catch (Throwable var35_13) {
                        this.finishIteratingOldHistoryLocked();
                        throw var35_13;
                    }
                    finally {
                        this.finishIteratingHistoryLocked();
                    }
                    {
                        var2_2.println();
                        this.finishIteratingOldHistoryLocked();
                    }
                }
                if (var7_6 && (var3_3 & 3) == 0) break block26;
                if (!var7_6) {
                    var18_15 = this.getUidStats();
                    var19_16 = var18_15.size();
                    var20_17 = false;
                    var21_18 = SystemClock.elapsedRealtime();
                    for (var23_19 = 0; var23_19 < var19_16; ++var23_19) {
                        var24_20 = var18_15.valueAt(var23_19).getPidStats();
                        if (var24_20 == null) continue;
                        for (var25_21 = 0; var25_21 < (var26_22 = var24_20.size()); ++var25_21) {
                            var27_23 = var24_20.valueAt(var25_21);
                            if (!var20_17) {
                                var2_2.println("Per-PID Stats:");
                                var20_17 = true;
                            }
                            var28_24 = var27_23.mWakeSumMs;
                            var30_25 = var27_23.mWakeNesting > 0 ? var21_18 - var27_23.mWakeStartMs : 0L;
                            var32_26 = var28_24 + var30_25;
                            var2_2.print("  PID ");
                            var2_2.print(var24_20.keyAt(var25_21));
                            var2_2.print(" wake time: ");
                            TimeUtils.formatDuration(var32_26, var2_2);
                            var2_2.println("");
                        }
                    }
                    if (var20_17) {
                        var2_2.println();
                    }
                }
                if (!var7_6 || (var3_3 & 2) != 0) {
                    if (BatteryStats.dumpDurationSteps(var2_2, "Discharge step durations:", this.getDischargeStepDurationsArray(), this.getNumDischargeStepDurations(), false)) {
                        var16_27 = this.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
                        if (var16_27 >= 0L) {
                            var2_2.print("  Estimated discharge time remaining: ");
                            TimeUtils.formatDuration(var16_27 / 1000L, var2_2);
                            var2_2.println();
                        }
                        var2_2.println();
                    }
                    if (BatteryStats.dumpDurationSteps(var2_2, "Charge step durations:", this.getChargeStepDurationsArray(), this.getNumChargeStepDurations(), false)) {
                        var14_28 = this.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
                        if (var14_28 >= 0L) {
                            var2_2.print("  Estimated charge time remaining: ");
                            TimeUtils.formatDuration(var14_28 / 1000L, var2_2);
                            var2_2.println();
                        }
                        var2_2.println();
                    }
                    var2_2.println("Statistics since last charge:");
                    var2_2.println("  System starts: " + this.getStartCount() + ", currently on battery: " + this.getIsOnBattery());
                    var12_29 = (var3_3 & 32) != 0;
                    this.dumpLocked(var1_1, var2_2, "", 0, var4_4, var12_29);
                    var2_2.println();
                }
                if (!var7_6 || (var3_3 & 1) != 0) break block27;
            }
            return;
        }
        var2_2.println("Statistics since last unplugged:");
        var13_30 = (var3_3 & 32) != 0;
        this.dumpLocked(var1_1, var2_2, "", 2, var4_4, var13_30);
        return;
lbl96:
        // 2 sources

        if ((var3_3 & 16) != 0) {
            var39_12 = true;
lbl98:
            // 2 sources

            while (true) {
                var36_10.printNextItem(var2_2, var34_9, var37_11, false, var39_12);
                ** continue;
                break;
            }
        }
        var39_12 = false;
        ** while (true)
    }

    public final void dumpLocked(Context context, PrintWriter printWriter, String string2, int n, int n2) {
        this.dumpLocked(context, printWriter, string2, n, n2, BatteryStatsHelper.checkWifiOnly(context));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public final void dumpLocked(Context var1_1, PrintWriter var2_2, String var3_3, int var4_4, int var5_5, boolean var6_6) {
        block114: {
            var7_7 = 1000L * SystemClock.uptimeMillis();
            var9_8 = 1000L * SystemClock.elapsedRealtime();
            var11_9 = this.getBatteryUptime(var7_7);
            var13_10 = this.computeBatteryUptime(var7_7, var4_4);
            var15_11 = this.computeBatteryRealtime(var9_8, var4_4);
            var17_12 = this.computeRealtime(var9_8, var4_4);
            var19_13 = this.computeUptime(var7_7, var4_4);
            var21_14 = this.computeBatteryScreenOffUptime(var7_7, var4_4);
            var23_15 = this.computeBatteryScreenOffRealtime(var9_8, var4_4);
            var25_16 = this.computeBatteryTimeRemaining(var9_8);
            var27_17 = this.computeChargeTimeRemaining(var9_8);
            var29_18 = new StringBuilder(128);
            var30_19 = this.getUidStats();
            var31_20 = var30_19.size();
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Time on battery: ");
            BatteryStats.formatTimeMs(var29_18, var15_11 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var15_11, var17_12));
            var29_18.append(") realtime, ");
            BatteryStats.formatTimeMs(var29_18, var13_10 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var13_10, var17_12));
            var29_18.append(") uptime");
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Time on battery screen off: ");
            BatteryStats.formatTimeMs(var29_18, var23_15 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var23_15, var17_12));
            var29_18.append(") realtime, ");
            BatteryStats.formatTimeMs(var29_18, var21_14 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var21_14, var17_12));
            var29_18.append(") uptime");
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Total run time: ");
            BatteryStats.formatTimeMs(var29_18, var17_12 / 1000L);
            var29_18.append("realtime, ");
            BatteryStats.formatTimeMs(var29_18, var19_13 / 1000L);
            var29_18.append("uptime");
            var2_2.println(var29_18.toString());
            if (var25_16 >= 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Battery time remaining: ");
                BatteryStats.formatTimeMs(var29_18, var25_16 / 1000L);
                var2_2.println(var29_18.toString());
            }
            if (var27_17 >= 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Charge time remaining: ");
                BatteryStats.formatTimeMs(var29_18, var27_17 / 1000L);
                var2_2.println(var29_18.toString());
            }
            var2_2.print("  Start clock time: ");
            var2_2.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.getStartClockTime()).toString());
            var52_21 = this.getScreenOnTime(var9_8, var4_4);
            var54_22 = this.getInteractiveTime(var9_8, var4_4);
            var56_23 = this.getLowPowerModeEnabledTime(var9_8, var4_4);
            var58_24 = this.getPhoneOnTime(var9_8, var4_4);
            var60_25 = this.getGlobalWifiRunningTime(var9_8, var4_4);
            var62_26 = this.getWifiOnTime(var9_8, var4_4);
            var64_27 = this.getBluetoothOnTime(var9_8, var4_4);
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Screen on: ");
            BatteryStats.formatTimeMs(var29_18, var52_21 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var52_21, var15_11));
            var29_18.append(") ");
            var29_18.append(this.getScreenOnCount(var4_4));
            var29_18.append("x, Interactive: ");
            BatteryStats.formatTimeMs(var29_18, var54_22 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var54_22, var15_11));
            var29_18.append(")");
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Screen brightnesses:");
            var78_28 = false;
            for (var79_29 = 0; var79_29 < 5; ++var79_29) {
                var550_30 = this.getScreenBrightnessTime(var79_29, var9_8, var4_4);
                if (var550_30 == 0L) continue;
                var29_18.append("\n    ");
                var29_18.append(var3_3);
                var78_28 = true;
                var29_18.append(BatteryStats.SCREEN_BRIGHTNESS_NAMES[var79_29]);
                var29_18.append(" ");
                BatteryStats.formatTimeMs(var29_18, var550_30 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var550_30, var52_21));
                var29_18.append(")");
            }
            if (!var78_28) {
                var29_18.append(" (no activity)");
            }
            var2_2.println(var29_18.toString());
            if (var56_23 != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Low power mode enabled: ");
                BatteryStats.formatTimeMs(var29_18, var56_23 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var56_23, var15_11));
                var29_18.append(")");
                var2_2.println(var29_18.toString());
            }
            if (var58_24 != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Active phone call: ");
                BatteryStats.formatTimeMs(var29_18, var58_24 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var58_24, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getPhoneOnCount(var4_4));
            }
            var80_31 = 0L;
            var82_32 = 0L;
            var84_33 = new ArrayList<TimerEntry>();
            for (var85_34 = 0; var85_34 < var31_20; ++var85_34) {
                var528_35 = var30_19.valueAt(var85_34);
                var529_36 = var528_35.getWakelockStats();
                if (var529_36.size() <= 0) continue;
                for (Map.Entry<String, ? extends Uid.Wakelock> var531_38 : var529_36.entrySet()) {
                    var532_39 = var531_38.getValue();
                    var533_40 = var532_39.getWakeTime(1);
                    if (var533_40 != null) {
                        var80_31 += var533_40.getTotalTimeLocked(var9_8, var4_4);
                    }
                    if ((var534_41 = var532_39.getWakeTime(0)) == null || (var535_42 = var534_41.getTotalTimeLocked(var9_8, var4_4)) <= 0L) continue;
                    if (var5_5 < 0) {
                        var84_33.add(new TimerEntry(var531_38.getKey(), var528_35.getUid(), var534_41, var535_42));
                    }
                    var82_32 += var535_42;
                }
            }
            var86_43 = this.getNetworkActivityBytes(0, var4_4);
            var88_44 = this.getNetworkActivityBytes(1, var4_4);
            var90_45 = this.getNetworkActivityBytes(2, var4_4);
            var92_46 = this.getNetworkActivityBytes(3, var4_4);
            var94_47 = this.getNetworkActivityPackets(0, var4_4);
            var96_48 = this.getNetworkActivityPackets(1, var4_4);
            var98_49 = this.getNetworkActivityPackets(2, var4_4);
            var100_50 = this.getNetworkActivityPackets(3, var4_4);
            if (var80_31 != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Total full wakelock time: ");
                BatteryStats.formatTimeMsNoSpace(var29_18, (500L + var80_31) / 1000L);
                var2_2.println(var29_18.toString());
            }
            if (var82_32 != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Total partial wakelock time: ");
                BatteryStats.formatTimeMsNoSpace(var29_18, (500L + var82_32) / 1000L);
                var2_2.println(var29_18.toString());
            }
            var2_2.print(var3_3);
            var2_2.print("  Mobile total received: ");
            var2_2.print(this.formatBytesLocked(var86_43));
            var2_2.print(", sent: ");
            var2_2.print(this.formatBytesLocked(var88_44));
            var2_2.print(" (packets received ");
            var2_2.print(var94_47);
            var2_2.print(", sent ");
            var2_2.print(var96_48);
            var2_2.println(")");
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Phone signal levels:");
            var104_51 = false;
            for (var105_52 = 0; var105_52 < 5; ++var105_52) {
                var513_53 = this.getPhoneSignalStrengthTime(var105_52, var9_8, var4_4);
                if (var513_53 == 0L) continue;
                var29_18.append("\n    ");
                var29_18.append(var3_3);
                var104_51 = true;
                var29_18.append(SignalStrength.SIGNAL_STRENGTH_NAMES[var105_52]);
                var29_18.append(" ");
                BatteryStats.formatTimeMs(var29_18, var513_53 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var513_53, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getPhoneSignalStrengthCount(var105_52, var4_4));
                var29_18.append("x");
            }
            if (!var104_51) {
                var29_18.append(" (no activity)");
            }
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Signal scanning time: ");
            BatteryStats.formatTimeMsNoSpace(var29_18, this.getPhoneSignalScanningTime(var9_8, var4_4) / 1000L);
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Radio types:");
            var110_54 = false;
            for (var111_55 = 0; var111_55 < 17; ++var111_55) {
                var501_56 = this.getPhoneDataConnectionTime(var111_55, var9_8, var4_4);
                if (var501_56 == 0L) continue;
                var29_18.append("\n    ");
                var29_18.append(var3_3);
                var110_54 = true;
                var29_18.append(BatteryStats.DATA_CONNECTION_NAMES[var111_55]);
                var29_18.append(" ");
                BatteryStats.formatTimeMs(var29_18, var501_56 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var501_56, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getPhoneDataConnectionCount(var111_55, var4_4));
                var29_18.append("x");
            }
            if (!var110_54) {
                var29_18.append(" (no activity)");
            }
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Mobile radio active time: ");
            var114_57 = this.getMobileRadioActiveTime(var9_8, var4_4);
            BatteryStats.formatTimeMs(var29_18, var114_57 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var114_57, var15_11));
            var29_18.append(") ");
            var29_18.append(this.getMobileRadioActiveCount(var4_4));
            var29_18.append("x");
            var2_2.println(var29_18.toString());
            var121_58 = this.getMobileRadioActiveUnknownTime(var4_4);
            if (var121_58 != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Mobile radio active unknown time: ");
                BatteryStats.formatTimeMs(var29_18, var121_58 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var121_58, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getMobileRadioActiveUnknownCount(var4_4));
                var29_18.append("x");
                var2_2.println(var29_18.toString());
            }
            if ((var123_59 = this.getMobileRadioActiveAdjustedTime(var4_4)) != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("  Mobile radio active adjusted time: ");
                BatteryStats.formatTimeMs(var29_18, var123_59 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var123_59, var15_11));
                var29_18.append(")");
                var2_2.println(var29_18.toString());
            }
            var2_2.print(var3_3);
            var2_2.print("  Wi-Fi total received: ");
            var2_2.print(this.formatBytesLocked(var90_45));
            var2_2.print(", sent: ");
            var2_2.print(this.formatBytesLocked(var92_46));
            var2_2.print(" (packets received ");
            var2_2.print(var98_49);
            var2_2.print(", sent ");
            var2_2.print(var100_50);
            var2_2.println(")");
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Wifi on: ");
            BatteryStats.formatTimeMs(var29_18, var62_26 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var62_26, var15_11));
            var29_18.append("), Wifi running: ");
            BatteryStats.formatTimeMs(var29_18, var60_25 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var60_25, var15_11));
            var29_18.append(")");
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Wifi states:");
            var135_60 = false;
            for (var136_61 = 0; var136_61 < 8; ++var136_61) {
                var478_62 = this.getWifiStateTime(var136_61, var9_8, var4_4);
                if (var478_62 == 0L) continue;
                var29_18.append("\n    ");
                var135_60 = true;
                var29_18.append(BatteryStats.WIFI_STATE_NAMES[var136_61]);
                var29_18.append(" ");
                BatteryStats.formatTimeMs(var29_18, var478_62 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var478_62, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getWifiStateCount(var136_61, var4_4));
                var29_18.append("x");
            }
            if (!var135_60) {
                var29_18.append(" (no activity)");
            }
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Wifi supplicant states:");
            var139_63 = false;
            for (var140_64 = 0; var140_64 < 13; ++var140_64) {
                var467_65 = this.getWifiSupplStateTime(var140_64, var9_8, var4_4);
                if (var467_65 == 0L) continue;
                var29_18.append("\n    ");
                var139_63 = true;
                var29_18.append(BatteryStats.WIFI_SUPPL_STATE_NAMES[var140_64]);
                var29_18.append(" ");
                BatteryStats.formatTimeMs(var29_18, var467_65 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var467_65, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getWifiSupplStateCount(var140_64, var4_4));
                var29_18.append("x");
            }
            if (!var139_63) {
                var29_18.append(" (no activity)");
            }
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Wifi signal levels:");
            var143_66 = false;
            for (var144_67 = 0; var144_67 < 5; ++var144_67) {
                var454_68 = this.getWifiSignalStrengthTime(var144_67, var9_8, var4_4);
                if (var454_68 == 0L) continue;
                var29_18.append("\n    ");
                var29_18.append(var3_3);
                var143_66 = true;
                var29_18.append("level(");
                var29_18.append(var144_67);
                var29_18.append(") ");
                BatteryStats.formatTimeMs(var29_18, var454_68 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var454_68, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getWifiSignalStrengthCount(var144_67, var4_4));
                var29_18.append("x");
            }
            if (!var143_66) {
                var29_18.append(" (no activity)");
            }
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Bluetooth on: ");
            BatteryStats.formatTimeMs(var29_18, var64_27 / 1000L);
            var29_18.append("(");
            var29_18.append(this.formatRatioLocked(var64_27, var15_11));
            var29_18.append(")");
            var2_2.println(var29_18.toString());
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("  Bluetooth states:");
            var152_69 = false;
            for (var153_70 = 0; var153_70 < 4; ++var153_70) {
                var443_71 = this.getBluetoothStateTime(var153_70, var9_8, var4_4);
                if (var443_71 == 0L) continue;
                var29_18.append("\n    ");
                var152_69 = true;
                var29_18.append(BatteryStats.BLUETOOTH_STATE_NAMES[var153_70]);
                var29_18.append(" ");
                BatteryStats.formatTimeMs(var29_18, var443_71 / 1000L);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var443_71, var15_11));
                var29_18.append(") ");
                var29_18.append(this.getPhoneDataConnectionCount(var153_70, var4_4));
                var29_18.append("x");
            }
            if (!var152_69) {
                var29_18.append(" (no activity)");
            }
            var2_2.println(var29_18.toString());
            var2_2.println();
            if (var4_4 == 2) {
                if (this.getIsOnBattery()) {
                    var2_2.print(var3_3);
                    var2_2.println("  Device is currently unplugged");
                    var2_2.print(var3_3);
                    var2_2.print("    Discharge cycle start level: ");
                    var2_2.println(this.getDischargeStartLevel());
                    var2_2.print(var3_3);
                    var2_2.print("    Discharge cycle current level: ");
                    var2_2.println(this.getDischargeCurrentLevel());
                } else {
                    var2_2.print(var3_3);
                    var2_2.println("  Device is currently plugged into power");
                    var2_2.print(var3_3);
                    var2_2.print("    Last discharge cycle start level: ");
                    var2_2.println(this.getDischargeStartLevel());
                    var2_2.print(var3_3);
                    var2_2.print("    Last discharge cycle end level: ");
                    var2_2.println(this.getDischargeCurrentLevel());
                }
                var2_2.print(var3_3);
                var2_2.print("    Amount discharged while screen on: ");
                var2_2.println(this.getDischargeAmountScreenOn());
                var2_2.print(var3_3);
                var2_2.print("    Amount discharged while screen off: ");
                var2_2.println(this.getDischargeAmountScreenOff());
                var2_2.println(" ");
            } else {
                var2_2.print(var3_3);
                var2_2.println("  Device battery use since last full charge");
                var2_2.print(var3_3);
                var2_2.print("    Amount discharged (lower bound): ");
                var2_2.println(this.getLowDischargeAmountSinceCharge());
                var2_2.print(var3_3);
                var2_2.print("    Amount discharged (upper bound): ");
                var2_2.println(this.getHighDischargeAmountSinceCharge());
                var2_2.print(var3_3);
                var2_2.print("    Amount discharged while screen on: ");
                var2_2.println(this.getDischargeAmountScreenOnSinceCharge());
                var2_2.print(var3_3);
                var2_2.print("    Amount discharged while screen off: ");
                var2_2.println(this.getDischargeAmountScreenOffSinceCharge());
                var2_2.println();
            }
            var154_72 = new BatteryStatsHelper(var1_1, false, var6_6);
            var154_72.create(this);
            var154_72.refreshStats(var4_4, -1);
            var155_73 = var154_72.getUsageList();
            if (var155_73 != null && var155_73.size() > 0) {
                var2_2.print(var3_3);
                var2_2.println("  Estimated power use (mAh):");
                var2_2.print(var3_3);
                var2_2.print("    Capacity: ");
                this.printmAh(var2_2, var154_72.getPowerProfile().getBatteryCapacity());
                var2_2.print(", Computed drain: ");
                this.printmAh(var2_2, var154_72.getComputedPower());
                var2_2.print(", actual drain: ");
                this.printmAh(var2_2, var154_72.getMinDrainedPower());
                if (var154_72.getMinDrainedPower() != var154_72.getMaxDrainedPower()) {
                    var2_2.print("-");
                    this.printmAh(var2_2, var154_72.getMaxDrainedPower());
                }
                var2_2.println();
                block22: for (var439_74 = 0; var439_74 < (var440_75 = var155_73.size()); ++var439_74) {
                    var441_76 = var155_73.get(var439_74);
                    switch (2.$SwitchMap$com$android$internal$os$BatterySipper$DrainType[var441_76.drainType.ordinal()]) {
                        case 1: {
                            var2_2.print(var3_3);
                            var2_2.print("    Idle: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 2: {
                            var2_2.print(var3_3);
                            var2_2.print("    Cell standby: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 3: {
                            var2_2.print(var3_3);
                            var2_2.print("    Phone calls: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 4: {
                            var2_2.print(var3_3);
                            var2_2.print("    Wifi: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 5: {
                            var2_2.print(var3_3);
                            var2_2.print("    Bluetooth: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 6: {
                            var2_2.print(var3_3);
                            var2_2.print("    Screen: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 7: {
                            var2_2.print(var3_3);
                            var2_2.print("    Flashlight: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 8: {
                            var2_2.print(var3_3);
                            var2_2.print("    Uid ");
                            UserHandle.formatUid(var2_2, var441_76.uidObj.getUid());
                            var2_2.print(": ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 9: {
                            var2_2.print(var3_3);
                            var2_2.print("    User ");
                            var2_2.print(var441_76.userId);
                            var2_2.print(": ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                            ** break;
                        }
                        case 10: {
                            var2_2.print(var3_3);
                            var2_2.print("    Unaccounted: ");
                            this.printmAh(var2_2, var441_76.value);
                            var2_2.println();
                        }
lbl656:
                        // 11 sources

                        default: {
                            continue block22;
                        }
                        case 11: 
                    }
                    var2_2.print(var3_3);
                    var2_2.print("    Over-counted: ");
                    this.printmAh(var2_2, var441_76.value);
                    var2_2.println();
                }
                var2_2.println();
            }
            if ((var156_77 = var154_72.getMobilemsppList()) != null && var156_77.size() > 0) {
                var2_2.print(var3_3);
                var2_2.println("  Per-app mobile ms per packet:");
                var419_78 = 0L;
                for (var421_79 = 0; var421_79 < (var422_80 = var156_77.size()); var419_78 += var428_81.mobileActive, ++var421_79) {
                    var428_81 = var156_77.get(var421_79);
                    var29_18.setLength(0);
                    var29_18.append(var3_3);
                    var29_18.append("    Uid ");
                    UserHandle.formatUid(var29_18, var428_81.uidObj.getUid());
                    var29_18.append(": ");
                    var29_18.append(BatteryStatsHelper.makemAh(var428_81.mobilemspp));
                    var29_18.append(" (");
                    var29_18.append(var428_81.mobileRxPackets + var428_81.mobileTxPackets);
                    var29_18.append(" packets over ");
                    BatteryStats.formatTimeMsNoSpace(var29_18, var428_81.mobileActive);
                    var29_18.append(") ");
                    var29_18.append(var428_81.mobileActiveCount);
                    var29_18.append("x");
                    var2_2.println(var29_18.toString());
                }
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    TOTAL TIME: ");
                BatteryStats.formatTimeMs(var29_18, var419_78);
                var29_18.append("(");
                var29_18.append(this.formatRatioLocked(var419_78, var15_11));
                var29_18.append(")");
                var2_2.println(var29_18.toString());
                var2_2.println();
            }
            var157_82 = new Comparator<TimerEntry>(){

                @Override
                public int compare(TimerEntry timerEntry, TimerEntry timerEntry2) {
                    long l = timerEntry.mTime;
                    long l2 = timerEntry2.mTime;
                    if (l < l2) {
                        return 1;
                    }
                    if (l > l2) {
                        return -1;
                    }
                    return 0;
                }
            };
            if (var5_5 < 0) {
                var382_83 = this.getKernelWakelockStats();
                if (var382_83.size() > 0) {
                    var383_84 = new ArrayList<TimerEntry>();
                    for (Map.Entry<String, ? extends Timer> var414_86 : var382_83.entrySet()) {
                        var415_87 = var414_86.getValue();
                        var416_88 = BatteryStats.computeWakeLock(var415_87, var9_8, var4_4);
                        if (var416_88 <= 0L) continue;
                        var383_84.add(new TimerEntry(var414_86.getKey(), 0, var415_87, var416_88));
                    }
                    if (var383_84.size() > 0) {
                        Collections.sort(var383_84, var157_82);
                        var2_2.print(var3_3);
                        var2_2.println("  All kernel wake locks:");
                        for (var407_89 = 0; var407_89 < (var408_90 = var383_84.size()); ++var407_89) {
                            var409_91 = (TimerEntry)var383_84.get(var407_89);
                            var29_18.setLength(0);
                            var29_18.append(var3_3);
                            var29_18.append("  Kernel Wake lock ");
                            var29_18.append(var409_91.mName);
                            if (BatteryStats.printWakeLock(var29_18, var409_91.mTimer, var9_8, null, var4_4, ": ").equals(": ")) continue;
                            var29_18.append(" realtime");
                            var2_2.println(var29_18.toString());
                        }
                        var2_2.println();
                    }
                }
                if (var84_33.size() > 0) {
                    Collections.sort(var84_33, var157_82);
                    var2_2.print(var3_3);
                    var2_2.println("  All partial wake locks:");
                    for (var399_92 = 0; var399_92 < (var400_93 = var84_33.size()); ++var399_92) {
                        var401_94 = (TimerEntry)var84_33.get(var399_92);
                        var29_18.setLength(0);
                        var29_18.append("  Wake lock ");
                        UserHandle.formatUid(var29_18, var401_94.mId);
                        var29_18.append(" ");
                        var29_18.append(var401_94.mName);
                        BatteryStats.printWakeLock(var29_18, var401_94.mTimer, var9_8, null, var4_4, ": ");
                        var29_18.append(" realtime");
                        var2_2.println(var29_18.toString());
                    }
                    var84_33.clear();
                    var2_2.println();
                }
                if ((var385_95 = this.getWakeupReasonStats()).size() > 0) {
                    var2_2.print(var3_3);
                    var2_2.println("  All wakeup reasons:");
                    var386_96 = new ArrayList<TimerEntry>();
                    for (Map.Entry<String, ? extends Timer> var396_98 : var385_95.entrySet()) {
                        var397_99 = var396_98.getValue();
                        var386_96.add(new TimerEntry(var396_98.getKey(), 0, var397_99, var397_99.getCountLocked(var4_4)));
                    }
                    Collections.sort(var386_96, var157_82);
                    for (var388_100 = 0; var388_100 < (var389_101 = var386_96.size()); ++var388_100) {
                        var390_102 = (TimerEntry)var386_96.get(var388_100);
                        var29_18.setLength(0);
                        var29_18.append(var3_3);
                        var29_18.append("  Wakeup reason ");
                        var29_18.append(var390_102.mName);
                        BatteryStats.printWakeLock(var29_18, var390_102.mTimer, var9_8, null, var4_4, ": ");
                        var29_18.append(" realtime");
                        var2_2.println(var29_18.toString());
                    }
                    var2_2.println();
                }
            }
            var158_103 = 0;
            block29: while (true) {
                if (var158_103 >= var31_20) {
                    return;
                }
                var159_145 = var30_19.keyAt(var158_103);
                if (var5_5 < 0 || var159_145 == var5_5 || var159_145 == 1000) {
                    var160_146 = var30_19.valueAt(var158_103);
                    var2_2.print(var3_3);
                    var2_2.print("  ");
                    UserHandle.formatUid(var2_2, var159_145);
                    var2_2.println(":");
                    var161_147 = var160_146.getNetworkActivityBytes(0, var4_4);
                    var163_148 = var160_146.getNetworkActivityBytes(1, var4_4);
                    var165_149 = var160_146.getNetworkActivityBytes(2, var4_4);
                    var167_150 = var160_146.getNetworkActivityBytes(3, var4_4);
                    var169_151 = var160_146.getNetworkActivityPackets(0, var4_4);
                    var171_152 = var160_146.getNetworkActivityPackets(1, var4_4);
                    var173_153 = var160_146.getMobileRadioActiveTime(var4_4);
                    var175_154 = var160_146.getMobileRadioActiveCount(var4_4);
                    var176_155 = var160_146.getNetworkActivityPackets(2, var4_4);
                    var178_156 = var160_146.getNetworkActivityPackets(3, var4_4);
                    var180_157 = var160_146.getFullWifiLockTime(var9_8, var4_4);
                    var182_158 = var160_146.getWifiScanTime(var9_8, var4_4);
                    var184_159 = var160_146.getWifiRunningTime(var9_8, var4_4);
                    if (var161_147 > 0L || var163_148 > 0L || var169_151 > 0L || var171_152 > 0L) {
                        var2_2.print(var3_3);
                        var2_2.print("    Mobile network: ");
                        var2_2.print(this.formatBytesLocked(var161_147));
                        var2_2.print(" received, ");
                        var2_2.print(this.formatBytesLocked(var163_148));
                        var2_2.print(" sent (packets ");
                        var2_2.print(var169_151);
                        var2_2.print(" received, ");
                        var2_2.print(var171_152);
                        var2_2.println(" sent)");
                    }
                    if (var173_153 > 0L || var175_154 > 0) {
                        var29_18.setLength(0);
                        var29_18.append(var3_3);
                        var29_18.append("    Mobile radio active: ");
                        BatteryStats.formatTimeMs(var29_18, var173_153 / 1000L);
                        var29_18.append("(");
                        var29_18.append(this.formatRatioLocked(var173_153, var114_57));
                        var29_18.append(") ");
                        var29_18.append(var175_154);
                        var29_18.append("x");
                        var193_160 = var169_151 + var171_152;
                        if (var193_160 == 0L) {
                            var193_160 = 1L;
                        }
                        var29_18.append(" @ ");
                        var29_18.append(BatteryStatsHelper.makemAh((double)(var173_153 / 1000L) / (double)var193_160));
                        var29_18.append(" mspp");
                        var2_2.println(var29_18.toString());
                    }
                    if (var165_149 > 0L || var167_150 > 0L || var176_155 > 0L || var178_156 > 0L) {
                        var2_2.print(var3_3);
                        var2_2.print("    Wi-Fi network: ");
                        var2_2.print(this.formatBytesLocked(var165_149));
                        var2_2.print(" received, ");
                        var2_2.print(this.formatBytesLocked(var167_150));
                        var2_2.print(" sent (packets ");
                        var2_2.print(var176_155);
                        var2_2.print(" received, ");
                        var2_2.print(var178_156);
                        var2_2.println(" sent)");
                    }
                    if (var180_157 != 0L || var182_158 != 0L || var184_159 != 0L) {
                        var29_18.setLength(0);
                        var29_18.append(var3_3);
                        var29_18.append("    Wifi Running: ");
                        BatteryStats.formatTimeMs(var29_18, var184_159 / 1000L);
                        var29_18.append("(");
                        var29_18.append(this.formatRatioLocked(var184_159, var15_11));
                        var29_18.append(")\n");
                        var29_18.append(var3_3);
                        var29_18.append("    Full Wifi Lock: ");
                        BatteryStats.formatTimeMs(var29_18, var180_157 / 1000L);
                        var29_18.append("(");
                        var29_18.append(this.formatRatioLocked(var180_157, var15_11));
                        var29_18.append(")\n");
                        var29_18.append(var3_3);
                        var29_18.append("    Wifi Scan: ");
                        BatteryStats.formatTimeMs(var29_18, var182_158 / 1000L);
                        var29_18.append("(");
                        var29_18.append(this.formatRatioLocked(var182_158, var15_11));
                        var29_18.append(")");
                        var2_2.println(var29_18.toString());
                    }
                    if (var160_146.hasUserActivity()) {
                        var374_142 = false;
                        break;
                    }
                    break block114;
                }
lbl902:
                // 4 sources

                while (true) {
                    ++var158_103;
                    continue block29;
                    break;
                }
                break;
            }
            for (var375_143 = 0; var375_143 < 3; ++var375_143) {
                var376_144 = var160_146.getUserActivityCount(var375_143, var4_4);
                if (var376_144 == 0) continue;
                if (!var374_142) {
                    var29_18.setLength(0);
                    var29_18.append("    User activity: ");
                    var374_142 = true;
                } else {
                    var29_18.append(", ");
                }
                var29_18.append(var376_144);
                var29_18.append(" ");
                var29_18.append(Uid.USER_ACTIVITY_TYPES[var375_143]);
            }
            if (var374_142) {
                var2_2.println(var29_18.toString());
            }
        }
        var213_161 = var160_146.getWakelockStats();
        var214_162 = var213_161.size();
        var215_163 = false;
        if (var214_162 > 0) {
            var347_131 = 0L;
            var349_132 = 0L;
            var351_133 = 0L;
            var353_134 = 0;
            for (Map.Entry<String, ? extends Uid.Wakelock> var365_138 : var213_161.entrySet()) {
                var366_139 = var365_138.getValue();
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    Wake lock ");
                var29_18.append(var365_138.getKey());
                var370_140 = BatteryStats.printWakeLock(var29_18, var366_139.getWakeTime(1), var9_8, "full", var4_4, ": ");
                var371_141 = BatteryStats.printWakeLock(var29_18, var366_139.getWakeTime(0), var9_8, "partial", var4_4, var370_140);
                BatteryStats.printWakeLock(var29_18, var366_139.getWakeTime(2), var9_8, "window", var4_4, var371_141);
                var29_18.append(" realtime");
                var2_2.println(var29_18.toString());
                var215_163 = true;
                ++var353_134;
                var347_131 += BatteryStats.computeWakeLock(var366_139.getWakeTime(1), var9_8, var4_4);
                var349_132 += BatteryStats.computeWakeLock(var366_139.getWakeTime(0), var9_8, var4_4);
                var351_133 += BatteryStats.computeWakeLock(var366_139.getWakeTime(2), var9_8, var4_4);
            }
            if (var353_134 > 1 && (var347_131 != 0L || var349_132 != 0L || var351_133 != 0L)) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    TOTAL wake: ");
                cfr_temp_0 = var347_131 - 0L;
                var357_136 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                var358_137 = false;
                if (var357_136 != false) {
                    var358_137 = true;
                    BatteryStats.formatTimeMs(var29_18, var347_131);
                    var29_18.append("full");
                }
                if (var349_132 != 0L) {
                    if (var358_137) {
                        var29_18.append(", ");
                    }
                    var358_137 = true;
                    BatteryStats.formatTimeMs(var29_18, var349_132);
                    var29_18.append("partial");
                }
                if (var351_133 != 0L) {
                    if (var358_137) {
                        var29_18.append(", ");
                    }
                    BatteryStats.formatTimeMs(var29_18, var351_133);
                    var29_18.append("window");
                }
                var29_18.append(" realtime");
                var2_2.println(var29_18.toString());
            }
        }
        if ((var216_164 = var160_146.getSyncStats()).size() > 0) {
            for (Map.Entry<String, ? extends Timer> var334_127 : var216_164.entrySet()) {
                var335_128 = var334_127.getValue();
                var336_129 = (500L + var335_128.getTotalTimeLocked(var9_8, var4_4)) / 1000L;
                var338_130 = var335_128.getCountLocked(var4_4);
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    Sync ");
                var29_18.append(var334_127.getKey());
                var29_18.append(": ");
                if (var336_129 != 0L) {
                    BatteryStats.formatTimeMs(var29_18, var336_129);
                    var29_18.append("realtime (");
                    var29_18.append(var338_130);
                    var29_18.append(" times)");
                } else {
                    var29_18.append("(not used)");
                }
                var2_2.println(var29_18.toString());
                var215_163 = true;
            }
        }
        if ((var217_165 = var160_146.getJobStats()).size() > 0) {
            for (Map.Entry<String, ? extends Timer> var320_122 : var217_165.entrySet()) {
                var321_123 = var320_122.getValue();
                var322_124 = (500L + var321_123.getTotalTimeLocked(var9_8, var4_4)) / 1000L;
                var324_125 = var321_123.getCountLocked(var4_4);
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    Job ");
                var29_18.append(var320_122.getKey());
                var29_18.append(": ");
                if (var322_124 != 0L) {
                    BatteryStats.formatTimeMs(var29_18, var322_124);
                    var29_18.append("realtime (");
                    var29_18.append(var324_125);
                    var29_18.append(" times)");
                } else {
                    var29_18.append("(not used)");
                }
                var2_2.println(var29_18.toString());
                var215_163 = true;
            }
        }
        var218_166 = var160_146.getSensorStats();
        var219_167 = var218_166.size();
        for (var220_168 = 0; var220_168 < var219_167; ++var220_168) {
            var302_116 = var218_166.valueAt(var220_168);
            var218_166.keyAt(var220_168);
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("    Sensor ");
            var306_117 = var302_116.getHandle();
            if (var306_117 == -10000) {
                var29_18.append("GPS");
            } else {
                var29_18.append(var306_117);
            }
            var29_18.append(": ");
            var309_118 = var302_116.getSensorTime();
            if (var309_118 != null) {
                var311_119 = (500L + var309_118.getTotalTimeLocked(var9_8, var4_4)) / 1000L;
                var313_120 = var309_118.getCountLocked(var4_4);
                if (var311_119 != 0L) {
                    BatteryStats.formatTimeMs(var29_18, var311_119);
                    var29_18.append("realtime (");
                    var29_18.append(var313_120);
                    var29_18.append(" times)");
                } else {
                    var29_18.append("(not used)");
                }
            } else {
                var29_18.append("(not used)");
            }
            var2_2.println(var29_18.toString());
            var215_163 = true;
        }
        var221_169 = var160_146.getVibratorOnTimer();
        if (var221_169 != null) {
            var294_114 = (500L + var221_169.getTotalTimeLocked(var9_8, var4_4)) / 1000L;
            var296_115 = var221_169.getCountLocked(var4_4);
            if (var294_114 != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    Vibrator: ");
                BatteryStats.formatTimeMs(var29_18, var294_114);
                var29_18.append("realtime (");
                var29_18.append(var296_115);
                var29_18.append(" times)");
                var2_2.println(var29_18.toString());
                var215_163 = true;
            }
        }
        if ((var222_170 = var160_146.getForegroundActivityTimer()) != null) {
            var286_112 = (500L + var222_170.getTotalTimeLocked(var9_8, var4_4)) / 1000L;
            var288_113 = var222_170.getCountLocked(var4_4);
            if (var286_112 != 0L) {
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    Foreground activities: ");
                BatteryStats.formatTimeMs(var29_18, var286_112);
                var29_18.append("realtime (");
                var29_18.append(var288_113);
                var29_18.append(" times)");
                var2_2.println(var29_18.toString());
                var215_163 = true;
            }
        }
        var223_171 = 0L;
        for (var225_172 = 0; var225_172 < 3; ++var225_172) {
            var280_111 = var160_146.getProcessStateTime(var225_172, var9_8, var4_4);
            if (var280_111 <= 0L) continue;
            var223_171 += var280_111;
            var29_18.setLength(0);
            var29_18.append(var3_3);
            var29_18.append("    ");
            var29_18.append(Uid.PROCESS_STATE_NAMES[var225_172]);
            var29_18.append(" for: ");
            BatteryStats.formatTimeMs(var29_18, (500L + var223_171) / 1000L);
            var2_2.println(var29_18.toString());
            var215_163 = true;
        }
        var226_173 = var160_146.getProcessStats();
        if (var226_173.size() > 0) {
            for (Map.Entry<String, ? extends Uid.Proc> var254_188 : var226_173.entrySet()) {
                var255_189 = var254_188.getValue();
                var256_104 = var255_189.getUserTime(var4_4);
                var258_105 = var255_189.getSystemTime(var4_4);
                var260_106 = var255_189.getForegroundTime(var4_4);
                var262_107 = var255_189.getStarts(var4_4);
                var263_108 = var4_4 == 0 ? var255_189.countExcessivePowers() : 0;
                if (var256_104 == 0L && var258_105 == 0L && var260_106 == 0L && var262_107 == 0 && var263_108 == 0) continue;
                var29_18.setLength(0);
                var29_18.append(var3_3);
                var29_18.append("    Proc ");
                var29_18.append(var254_188.getKey());
                var29_18.append(":\n");
                var29_18.append(var3_3);
                var29_18.append("      CPU: ");
                BatteryStats.formatTime(var29_18, var256_104);
                var29_18.append("usr + ");
                BatteryStats.formatTime(var29_18, var258_105);
                var29_18.append("krn ; ");
                BatteryStats.formatTime(var29_18, var260_106);
                var29_18.append("fg");
                if (var262_107 != 0) {
                    var29_18.append("\n");
                    var29_18.append(var3_3);
                    var29_18.append("      ");
                    var29_18.append(var262_107);
                    var29_18.append(" proc starts");
                }
                var2_2.println(var29_18.toString());
                for (var273_109 = 0; var273_109 < var263_108; ++var273_109) {
                    var274_110 = var255_189.getExcessivePower(var273_109);
                    if (var274_110 == null) continue;
                    var2_2.print(var3_3);
                    var2_2.print("      * Killed for ");
                    if (var274_110.type == 1) {
                        var2_2.print("wake lock");
                    } else if (var274_110.type == 2) {
                        var2_2.print("cpu");
                    } else {
                        var2_2.print("unknown");
                    }
                    var2_2.print(" use: ");
                    TimeUtils.formatDuration(var274_110.usedTime, var2_2);
                    var2_2.print(" over ");
                    TimeUtils.formatDuration(var274_110.overTime, var2_2);
                    if (var274_110.overTime == 0L) continue;
                    var2_2.print(" (");
                    var2_2.print(100L * var274_110.usedTime / var274_110.overTime);
                    var2_2.println("%)");
                }
                var215_163 = true;
            }
        }
        if ((var227_174 = var160_146.getPackageStats()).size() > 0) {
            for (Map.Entry<String, ? extends Uid.Pkg> var229_176 : var227_174.entrySet()) {
                var2_2.print(var3_3);
                var2_2.print("    Apk ");
                var2_2.print(var229_176.getKey());
                var2_2.println(":");
                var230_177 = var229_176.getValue();
                var231_178 = var230_177.getWakeups(var4_4);
                var232_179 = false;
                if (var231_178 != 0) {
                    var2_2.print(var3_3);
                    var2_2.print("      ");
                    var2_2.print(var231_178);
                    var2_2.println(" wakeup alarms");
                    var232_179 = true;
                }
                if ((var233_180 = var230_177.getServiceStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Uid.Pkg.Serv> var235_182 : var233_180.entrySet()) {
                        var236_183 = var235_182.getValue();
                        var237_184 = var236_183.getStartTime(var11_9, var4_4);
                        var239_185 = var236_183.getStarts(var4_4);
                        var240_186 = var236_183.getLaunches(var4_4);
                        if (var237_184 == 0L && var239_185 == 0 && var240_186 == 0) continue;
                        var29_18.setLength(0);
                        var29_18.append(var3_3);
                        var29_18.append("      Service ");
                        var29_18.append(var235_182.getKey());
                        var29_18.append(":\n");
                        var29_18.append(var3_3);
                        var29_18.append("        Created for: ");
                        BatteryStats.formatTimeMs(var29_18, var237_184 / 1000L);
                        var29_18.append("uptime\n");
                        var29_18.append(var3_3);
                        var29_18.append("        Starts: ");
                        var29_18.append(var239_185);
                        var29_18.append(", launches: ");
                        var29_18.append(var240_186);
                        var2_2.println(var29_18.toString());
                        var232_179 = true;
                    }
                }
                if (!var232_179) {
                    var2_2.print(var3_3);
                    var2_2.println("      (nothing executed)");
                }
                var215_163 = true;
            }
        }
        if (var215_163) ** GOTO lbl902
        var2_2.print(var3_3);
        var2_2.println("    (nothing executed)");
        ** while (true)
    }

    public abstract void finishIteratingHistoryLocked();

    public abstract void finishIteratingOldHistoryLocked();

    final String formatBytesLocked(long l) {
        this.mFormatBuilder.setLength(0);
        if (l < 1024L) {
            return l + "B";
        }
        if (l < 0x100000L) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[]{(double)l / 1024.0};
            formatter.format("%.2fKB", objectArray);
            return this.mFormatBuilder.toString();
        }
        if (l < 0x40000000L) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[]{(double)l / 1048576.0};
            formatter.format("%.2fMB", objectArray);
            return this.mFormatBuilder.toString();
        }
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[]{(double)l / 1.073741824E9};
        formatter.format("%.2fGB", objectArray);
        return this.mFormatBuilder.toString();
    }

    public final String formatRatioLocked(long l, long l2) {
        if (l2 == 0L) {
            return "--%";
        }
        float f = 100.0f * ((float)l / (float)l2);
        this.mFormatBuilder.setLength(0);
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[]{Float.valueOf(f)};
        formatter.format("%.1f%%", objectArray);
        return this.mFormatBuilder.toString();
    }

    public abstract long getBatteryRealtime(long var1);

    public abstract long getBatteryUptime(long var1);

    public abstract long getBluetoothOnTime(long var1, int var3);

    public abstract int getBluetoothPingCount();

    public abstract int getBluetoothStateCount(int var1, int var2);

    public abstract long getBluetoothStateTime(int var1, long var2, int var4);

    public abstract long[] getChargeStepDurationsArray();

    public abstract int getCpuSpeedSteps();

    public abstract int getDischargeAmount(int var1);

    public abstract int getDischargeAmountScreenOff();

    public abstract int getDischargeAmountScreenOffSinceCharge();

    public abstract int getDischargeAmountScreenOn();

    public abstract int getDischargeAmountScreenOnSinceCharge();

    public abstract int getDischargeCurrentLevel();

    public abstract int getDischargeStartLevel();

    public abstract long[] getDischargeStepDurationsArray();

    public abstract String getEndPlatformVersion();

    public abstract long getFlashlightOnCount(int var1);

    public abstract long getFlashlightOnTime(long var1, int var3);

    public abstract long getGlobalWifiRunningTime(long var1, int var3);

    public abstract int getHighDischargeAmountSinceCharge();

    public abstract long getHistoryBaseTime();

    public abstract int getHistoryStringPoolBytes();

    public abstract int getHistoryStringPoolSize();

    public abstract String getHistoryTagPoolString(int var1);

    public abstract int getHistoryTagPoolUid(int var1);

    public abstract int getHistoryTotalSize();

    public abstract int getHistoryUsedSize();

    public abstract long getInteractiveTime(long var1, int var3);

    public abstract boolean getIsOnBattery();

    public abstract Map<String, ? extends Timer> getKernelWakelockStats();

    public abstract int getLowDischargeAmountSinceCharge();

    public abstract int getLowPowerModeEnabledCount(int var1);

    public abstract long getLowPowerModeEnabledTime(long var1, int var3);

    public abstract long getMobileRadioActiveAdjustedTime(int var1);

    public abstract int getMobileRadioActiveCount(int var1);

    public abstract long getMobileRadioActiveTime(long var1, int var3);

    public abstract int getMobileRadioActiveUnknownCount(int var1);

    public abstract long getMobileRadioActiveUnknownTime(int var1);

    public abstract long getNetworkActivityBytes(int var1, int var2);

    public abstract long getNetworkActivityPackets(int var1, int var2);

    public abstract boolean getNextHistoryLocked(HistoryItem var1);

    public abstract boolean getNextOldHistoryLocked(HistoryItem var1);

    public abstract int getNumChargeStepDurations();

    public abstract int getNumDischargeStepDurations();

    public abstract int getParcelVersion();

    public abstract int getPhoneDataConnectionCount(int var1, int var2);

    public abstract long getPhoneDataConnectionTime(int var1, long var2, int var4);

    public abstract int getPhoneOnCount(int var1);

    public abstract long getPhoneOnTime(long var1, int var3);

    public abstract long getPhoneSignalScanningTime(long var1, int var3);

    public abstract int getPhoneSignalStrengthCount(int var1, int var2);

    public abstract long getPhoneSignalStrengthTime(int var1, long var2, int var4);

    public abstract long getScreenBrightnessTime(int var1, long var2, int var4);

    public abstract int getScreenOnCount(int var1);

    public abstract long getScreenOnTime(long var1, int var3);

    public abstract long getStartClockTime();

    public abstract int getStartCount();

    public abstract String getStartPlatformVersion();

    public abstract SparseArray<? extends Uid> getUidStats();

    public abstract Map<String, ? extends Timer> getWakeupReasonStats();

    public abstract long getWifiOnTime(long var1, int var3);

    public abstract int getWifiSignalStrengthCount(int var1, int var2);

    public abstract long getWifiSignalStrengthTime(int var1, long var2, int var4);

    public abstract int getWifiStateCount(int var1, int var2);

    public abstract long getWifiStateTime(int var1, long var2, int var4);

    public abstract int getWifiSupplStateCount(int var1, int var2);

    public abstract long getWifiSupplStateTime(int var1, long var2, int var4);

    public void prepareForDumpLocked() {
    }

    public abstract boolean startIteratingHistoryLocked();

    public abstract boolean startIteratingOldHistoryLocked();

    public abstract void writeToParcelWithoutUids(Parcel var1, int var2);

    public static final class BitDescription {
        public final int mask;
        public final String name;
        public final int shift;
        public final String shortName;
        public final String[] shortValues;
        public final String[] values;

        public BitDescription(int n, int n2, String string2, String string3, String[] stringArray, String[] stringArray2) {
            this.mask = n;
            this.shift = n2;
            this.name = string2;
            this.shortName = string3;
            this.values = stringArray;
            this.shortValues = stringArray2;
        }

        public BitDescription(int n, String string2, String string3) {
            this.mask = n;
            this.shift = -1;
            this.name = string2;
            this.shortName = string3;
            this.values = null;
            this.shortValues = null;
        }
    }

    public static abstract class Counter {
        public abstract int getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }

    public static final class HistoryEventTracker {
        private final HashMap<String, SparseIntArray>[] mActiveEvents = new HashMap[9];

        public HashMap<String, SparseIntArray> getStateForEvent(int n) {
            return this.mActiveEvents[n];
        }

        public void removeEvents(int n) {
            int n2 = n & 0xFFFF3FFF;
            this.mActiveEvents[n2] = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean updateState(int n, String string2, int n2, int n3) {
            SparseIntArray sparseIntArray;
            if ((0x8000 & n) == 0) {
                if ((n & 0x4000) == 0) return true;
                int n4 = n & 0xFFFF3FFF;
                HashMap<String, SparseIntArray> hashMap = this.mActiveEvents[n4];
                if (hashMap == null) return false;
                SparseIntArray sparseIntArray2 = hashMap.get(string2);
                if (sparseIntArray2 == null) return false;
                int n5 = sparseIntArray2.indexOfKey(n2);
                if (n5 < 0) return false;
                sparseIntArray2.removeAt(n5);
                if (sparseIntArray2.size() > 0) return true;
                hashMap.remove(string2);
                return true;
            }
            int n6 = n & 0xFFFF3FFF;
            HashMap<String, SparseIntArray> hashMap = this.mActiveEvents[n6];
            if (hashMap == null) {
                hashMap = new HashMap();
                this.mActiveEvents[n6] = hashMap;
            }
            if ((sparseIntArray = hashMap.get(string2)) == null) {
                sparseIntArray = new SparseIntArray();
                hashMap.put(string2, sparseIntArray);
            }
            if (sparseIntArray.indexOfKey(n2) >= 0) {
                return false;
            }
            sparseIntArray.put(n2, n3);
            return true;
        }
    }

    public static final class HistoryItem
    implements Parcelable {
        public static final byte CMD_CURRENT_TIME = 5;
        public static final byte CMD_NULL = -1;
        public static final byte CMD_OVERFLOW = 6;
        public static final byte CMD_RESET = 7;
        public static final byte CMD_START = 4;
        public static final byte CMD_UPDATE = 0;
        public static final int EVENT_COUNT = 9;
        public static final int EVENT_FLAG_FINISH = 16384;
        public static final int EVENT_FLAG_START = 32768;
        public static final int EVENT_FOREGROUND = 2;
        public static final int EVENT_FOREGROUND_FINISH = 16386;
        public static final int EVENT_FOREGROUND_START = 32770;
        public static final int EVENT_JOB = 6;
        public static final int EVENT_JOB_FINISH = 16390;
        public static final int EVENT_JOB_START = 32774;
        public static final int EVENT_NONE = 0;
        public static final int EVENT_PROC = 1;
        public static final int EVENT_PROC_FINISH = 16385;
        public static final int EVENT_PROC_START = 32769;
        public static final int EVENT_SYNC = 4;
        public static final int EVENT_SYNC_FINISH = 16388;
        public static final int EVENT_SYNC_START = 32772;
        public static final int EVENT_TOP = 3;
        public static final int EVENT_TOP_FINISH = 16387;
        public static final int EVENT_TOP_START = 32771;
        public static final int EVENT_TYPE_MASK = -49153;
        public static final int EVENT_USER_FOREGROUND = 8;
        public static final int EVENT_USER_FOREGROUND_FINISH = 16392;
        public static final int EVENT_USER_FOREGROUND_START = 32776;
        public static final int EVENT_USER_RUNNING = 7;
        public static final int EVENT_USER_RUNNING_FINISH = 16391;
        public static final int EVENT_USER_RUNNING_START = 32775;
        public static final int EVENT_WAKE_LOCK = 5;
        public static final int EVENT_WAKE_LOCK_FINISH = 16389;
        public static final int EVENT_WAKE_LOCK_START = 32773;
        public static final int MOST_INTERESTING_STATES = 0x1D0000;
        public static final int MOST_INTERESTING_STATES2 = -1879048192;
        public static final int STATE2_FLASHLIGHT_FLAG = 0x8000000;
        public static final int STATE2_LOW_POWER_FLAG = Integer.MIN_VALUE;
        public static final int STATE2_VIDEO_ON_FLAG = 0x40000000;
        public static final int STATE2_WIFI_ON_FLAG = 0x10000000;
        public static final int STATE2_WIFI_RUNNING_FLAG = 0x20000000;
        public static final int STATE2_WIFI_SIGNAL_STRENGTH_MASK = 112;
        public static final int STATE2_WIFI_SIGNAL_STRENGTH_SHIFT = 4;
        public static final int STATE2_WIFI_SUPPL_STATE_MASK = 15;
        public static final int STATE2_WIFI_SUPPL_STATE_SHIFT = 0;
        public static final int STATE_AUDIO_ON_FLAG = 0x400000;
        public static final int STATE_BATTERY_PLUGGED_FLAG = 524288;
        public static final int STATE_BLUETOOTH_ON_FLAG = 65536;
        public static final int STATE_BRIGHTNESS_MASK = 7;
        public static final int STATE_BRIGHTNESS_SHIFT = 0;
        public static final int STATE_CPU_RUNNING_FLAG = Integer.MIN_VALUE;
        public static final int STATE_DATA_CONNECTION_MASK = 15872;
        public static final int STATE_DATA_CONNECTION_SHIFT = 9;
        public static final int STATE_GPS_ON_FLAG = 0x20000000;
        public static final int STATE_MOBILE_RADIO_ACTIVE_FLAG = 0x2000000;
        public static final int STATE_PHONE_IN_CALL_FLAG = 262144;
        public static final int STATE_PHONE_SCANNING_FLAG = 0x200000;
        public static final int STATE_PHONE_SIGNAL_STRENGTH_MASK = 56;
        public static final int STATE_PHONE_SIGNAL_STRENGTH_SHIFT = 3;
        public static final int STATE_PHONE_STATE_MASK = 448;
        public static final int STATE_PHONE_STATE_SHIFT = 6;
        public static final int STATE_SCREEN_ON_FLAG = 0x100000;
        public static final int STATE_SENSOR_ON_FLAG = 0x800000;
        public static final int STATE_WAKE_LOCK_FLAG = 0x40000000;
        public static final int STATE_WIFI_FULL_LOCK_FLAG = 0x10000000;
        public static final int STATE_WIFI_MULTICAST_ON_FLAG = 0x4000000;
        public static final int STATE_WIFI_SCAN_FLAG = 0x8000000;
        public byte batteryHealth;
        public byte batteryLevel;
        public byte batteryPlugType;
        public byte batteryStatus;
        public short batteryTemperature;
        public char batteryVoltage;
        public byte cmd = (byte)-1;
        public long currentTime;
        public int eventCode;
        public HistoryTag eventTag;
        public final HistoryTag localEventTag;
        public final HistoryTag localWakeReasonTag;
        public final HistoryTag localWakelockTag = new HistoryTag();
        public HistoryItem next;
        public int numReadInts;
        public int states;
        public int states2;
        public long time;
        public HistoryTag wakeReasonTag;
        public HistoryTag wakelockTag;

        public HistoryItem() {
            this.localWakeReasonTag = new HistoryTag();
            this.localEventTag = new HistoryTag();
        }

        public HistoryItem(long l, Parcel parcel) {
            this.localWakeReasonTag = new HistoryTag();
            this.localEventTag = new HistoryTag();
            this.time = l;
            this.numReadInts = 2;
            this.readFromParcel(parcel);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setToCommon(HistoryItem historyItem) {
            this.batteryLevel = historyItem.batteryLevel;
            this.batteryStatus = historyItem.batteryStatus;
            this.batteryHealth = historyItem.batteryHealth;
            this.batteryPlugType = historyItem.batteryPlugType;
            this.batteryTemperature = historyItem.batteryTemperature;
            this.batteryVoltage = historyItem.batteryVoltage;
            this.states = historyItem.states;
            this.states2 = historyItem.states2;
            if (historyItem.wakelockTag != null) {
                this.wakelockTag = this.localWakelockTag;
                this.wakelockTag.setTo(historyItem.wakelockTag);
            } else {
                this.wakelockTag = null;
            }
            if (historyItem.wakeReasonTag != null) {
                this.wakeReasonTag = this.localWakeReasonTag;
                this.wakeReasonTag.setTo(historyItem.wakeReasonTag);
            } else {
                this.wakeReasonTag = null;
            }
            this.eventCode = historyItem.eventCode;
            if (historyItem.eventTag != null) {
                this.eventTag = this.localEventTag;
                this.eventTag.setTo(historyItem.eventTag);
            } else {
                this.eventTag = null;
            }
            this.currentTime = historyItem.currentTime;
        }

        public void clear() {
            this.time = 0L;
            this.cmd = (byte)-1;
            this.batteryLevel = 0;
            this.batteryStatus = 0;
            this.batteryHealth = 0;
            this.batteryPlugType = 0;
            this.batteryTemperature = 0;
            this.batteryVoltage = '\u0000';
            this.states = 0;
            this.states2 = 0;
            this.wakelockTag = null;
            this.wakeReasonTag = null;
            this.eventCode = 0;
            this.eventTag = null;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean isDeltaData() {
            return this.cmd == 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            int n = parcel.dataPosition();
            int n2 = parcel.readInt();
            this.cmd = (byte)(n2 & 0xFF);
            this.batteryLevel = (byte)(0xFF & n2 >> 8);
            this.batteryStatus = (byte)(0xF & n2 >> 16);
            this.batteryHealth = (byte)(0xF & n2 >> 20);
            this.batteryPlugType = (byte)(0xF & n2 >> 24);
            int n3 = parcel.readInt();
            this.batteryTemperature = (short)(n3 & 0xFFFF);
            this.batteryVoltage = (char)(0xFFFF & n3 >> 16);
            this.states = parcel.readInt();
            this.states2 = parcel.readInt();
            if ((0x10000000 & n2) != 0) {
                this.wakelockTag = this.localWakelockTag;
                this.wakelockTag.readFromParcel(parcel);
            } else {
                this.wakelockTag = null;
            }
            if ((0x20000000 & n2) != 0) {
                this.wakeReasonTag = this.localWakeReasonTag;
                this.wakeReasonTag.readFromParcel(parcel);
            } else {
                this.wakeReasonTag = null;
            }
            if ((0x40000000 & n2) != 0) {
                this.eventCode = parcel.readInt();
                this.eventTag = this.localEventTag;
                this.eventTag.readFromParcel(parcel);
            } else {
                this.eventCode = 0;
                this.eventTag = null;
            }
            this.currentTime = this.cmd == 5 || this.cmd == 7 ? parcel.readLong() : 0L;
            this.numReadInts += (parcel.dataPosition() - n) / 4;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean same(HistoryItem historyItem) {
            return this.sameNonEvent(historyItem) && this.eventCode == historyItem.eventCode && (this.wakelockTag == historyItem.wakelockTag || this.wakelockTag != null && historyItem.wakelockTag != null && this.wakelockTag.equals(historyItem.wakelockTag)) && (this.wakeReasonTag == historyItem.wakeReasonTag || this.wakeReasonTag != null && historyItem.wakeReasonTag != null && this.wakeReasonTag.equals(historyItem.wakeReasonTag)) && (this.eventTag == historyItem.eventTag || this.eventTag != null && historyItem.eventTag != null && this.eventTag.equals(historyItem.eventTag));
        }

        public boolean sameNonEvent(HistoryItem historyItem) {
            return this.batteryLevel == historyItem.batteryLevel && this.batteryStatus == historyItem.batteryStatus && this.batteryHealth == historyItem.batteryHealth && this.batteryPlugType == historyItem.batteryPlugType && this.batteryTemperature == historyItem.batteryTemperature && this.batteryVoltage == historyItem.batteryVoltage && this.states == historyItem.states && this.states2 == historyItem.states2 && this.currentTime == historyItem.currentTime;
        }

        public void setTo(long l, byte by, HistoryItem historyItem) {
            this.time = l;
            this.cmd = by;
            this.setToCommon(historyItem);
        }

        public void setTo(HistoryItem historyItem) {
            this.time = historyItem.time;
            this.cmd = historyItem.cmd;
            this.setToCommon(historyItem);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.time);
            int n2 = 0xFF & this.cmd | 0xFF00 & this.batteryLevel << 8 | 0xF0000 & this.batteryStatus << 16 | 0xF00000 & this.batteryHealth << 20 | 0xF000000 & this.batteryPlugType << 24;
            int n3 = this.wakelockTag != null ? 0x10000000 : 0;
            int n4 = n2 | n3;
            int n5 = this.wakeReasonTag != null ? 0x20000000 : 0;
            int n6 = n5 | n4;
            int n7 = this.eventCode;
            int n8 = 0;
            if (n7 != 0) {
                n8 = 0x40000000;
            }
            parcel.writeInt(n6 | n8);
            parcel.writeInt(0xFFFF & this.batteryTemperature | 0xFFFF0000 & this.batteryVoltage << 16);
            parcel.writeInt(this.states);
            parcel.writeInt(this.states2);
            if (this.wakelockTag != null) {
                this.wakelockTag.writeToParcel(parcel, n);
            }
            if (this.wakeReasonTag != null) {
                this.wakeReasonTag.writeToParcel(parcel, n);
            }
            if (this.eventCode != 0) {
                parcel.writeInt(this.eventCode);
                this.eventTag.writeToParcel(parcel, n);
            }
            if (this.cmd == 5 || this.cmd == 7) {
                parcel.writeLong(this.currentTime);
            }
        }
    }

    public static class HistoryPrinter {
        long lastTime = -1L;
        int oldHealth = -1;
        int oldLevel = -1;
        int oldPlug = -1;
        int oldState = 0;
        int oldState2 = 0;
        int oldStatus = -1;
        int oldTemp = -1;
        int oldVolt = -1;

        /*
         * Enabled aggressive block sorting
         */
        public void printNextItem(PrintWriter printWriter, HistoryItem historyItem, long l, boolean bl, boolean bl2) {
            if (!bl) {
                printWriter.print("  ");
                TimeUtils.formatDuration(historyItem.time - l, printWriter, 19);
                printWriter.print(" (");
                printWriter.print(historyItem.numReadInts);
                printWriter.print(") ");
            } else {
                printWriter.print(9);
                printWriter.print(',');
                printWriter.print(BatteryStats.HISTORY_DATA);
                printWriter.print(',');
                if (this.lastTime < 0L) {
                    printWriter.print(historyItem.time - l);
                } else {
                    printWriter.print(historyItem.time - this.lastTime);
                }
                this.lastTime = historyItem.time;
            }
            if (historyItem.cmd == 4) {
                if (bl) {
                    printWriter.print(":");
                }
                printWriter.println("START");
                this.reset();
                return;
            }
            if (historyItem.cmd == 5 || historyItem.cmd == 7) {
                if (bl) {
                    printWriter.print(":");
                }
                if (historyItem.cmd == 7) {
                    printWriter.print("RESET:");
                    this.reset();
                }
                printWriter.print("TIME:");
                if (bl) {
                    printWriter.println(historyItem.currentTime);
                    return;
                }
                printWriter.print(" ");
                printWriter.println(DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", historyItem.currentTime).toString());
                return;
            }
            if (historyItem.cmd == 6) {
                if (bl) {
                    printWriter.print(":");
                }
                printWriter.println("*OVERFLOW*");
                return;
            }
            if (!bl) {
                if (historyItem.batteryLevel < 10) {
                    printWriter.print("00");
                } else if (historyItem.batteryLevel < 100) {
                    printWriter.print("0");
                }
                printWriter.print(historyItem.batteryLevel);
                if (bl2) {
                    printWriter.print(" ");
                    if (historyItem.states >= 0) {
                        if (historyItem.states < 16) {
                            printWriter.print("0000000");
                        } else if (historyItem.states < 256) {
                            printWriter.print("000000");
                        } else if (historyItem.states < 4096) {
                            printWriter.print("00000");
                        } else if (historyItem.states < 65536) {
                            printWriter.print("0000");
                        } else if (historyItem.states < 0x100000) {
                            printWriter.print("000");
                        } else if (historyItem.states < 0x1000000) {
                            printWriter.print("00");
                        } else if (historyItem.states < 0x10000000) {
                            printWriter.print("0");
                        }
                    }
                    printWriter.print(Integer.toHexString(historyItem.states));
                }
            } else if (this.oldLevel != historyItem.batteryLevel) {
                this.oldLevel = historyItem.batteryLevel;
                printWriter.print(",Bl=");
                printWriter.print(historyItem.batteryLevel);
            }
            if (this.oldStatus != historyItem.batteryStatus) {
                this.oldStatus = historyItem.batteryStatus;
                String string2 = bl ? ",Bs=" : " status=";
                printWriter.print(string2);
                switch (this.oldStatus) {
                    default: {
                        printWriter.print(this.oldStatus);
                        break;
                    }
                    case 1: {
                        String string3 = bl ? "?" : "unknown";
                        printWriter.print(string3);
                        break;
                    }
                    case 2: {
                        String string4 = bl ? "c" : "charging";
                        printWriter.print(string4);
                        break;
                    }
                    case 3: {
                        String string5 = bl ? "d" : "discharging";
                        printWriter.print(string5);
                        break;
                    }
                    case 4: {
                        String string6 = bl ? "n" : "not-charging";
                        printWriter.print(string6);
                        break;
                    }
                    case 5: {
                        String string7 = bl ? "f" : "full";
                        printWriter.print(string7);
                    }
                }
            }
            if (this.oldHealth != historyItem.batteryHealth) {
                this.oldHealth = historyItem.batteryHealth;
                String string8 = bl ? ",Bh=" : " health=";
                printWriter.print(string8);
                switch (this.oldHealth) {
                    default: {
                        printWriter.print(this.oldHealth);
                        break;
                    }
                    case 1: {
                        String string9 = bl ? "?" : "unknown";
                        printWriter.print(string9);
                        break;
                    }
                    case 2: {
                        String string10 = bl ? "g" : "good";
                        printWriter.print(string10);
                        break;
                    }
                    case 3: {
                        String string11 = bl ? BatteryStats.HISTORY_DATA : "overheat";
                        printWriter.print(string11);
                        break;
                    }
                    case 4: {
                        String string12 = bl ? "d" : "dead";
                        printWriter.print(string12);
                        break;
                    }
                    case 5: {
                        String string13 = bl ? "v" : "over-voltage";
                        printWriter.print(string13);
                        break;
                    }
                    case 6: {
                        String string14 = bl ? "f" : "failure";
                        printWriter.print(string14);
                        break;
                    }
                    case 7: {
                        String string15 = bl ? "c" : "cold";
                        printWriter.print(string15);
                    }
                }
            }
            if (this.oldPlug != historyItem.batteryPlugType) {
                this.oldPlug = historyItem.batteryPlugType;
                String string16 = bl ? ",Bp=" : " plug=";
                printWriter.print(string16);
                switch (this.oldPlug) {
                    default: {
                        printWriter.print(this.oldPlug);
                        break;
                    }
                    case 0: {
                        String string17 = bl ? "n" : "none";
                        printWriter.print(string17);
                        break;
                    }
                    case 1: {
                        String string18 = bl ? "a" : "ac";
                        printWriter.print(string18);
                        break;
                    }
                    case 2: {
                        String string19 = bl ? "u" : "usb";
                        printWriter.print(string19);
                        break;
                    }
                    case 4: {
                        String string20 = bl ? "w" : "wireless";
                        printWriter.print(string20);
                    }
                }
            }
            if (this.oldTemp != historyItem.batteryTemperature) {
                this.oldTemp = historyItem.batteryTemperature;
                String string21 = bl ? ",Bt=" : " temp=";
                printWriter.print(string21);
                printWriter.print(this.oldTemp);
            }
            if (this.oldVolt != historyItem.batteryVoltage) {
                this.oldVolt = historyItem.batteryVoltage;
                String string22 = bl ? ",Bv=" : " volt=";
                printWriter.print(string22);
                printWriter.print(this.oldVolt);
            }
            int n = this.oldState;
            int n2 = historyItem.states;
            HistoryTag historyTag = historyItem.wakelockTag;
            BitDescription[] bitDescriptionArray = HISTORY_STATE_DESCRIPTIONS;
            boolean bl3 = !bl;
            BatteryStats.printBitDescriptions(printWriter, n, n2, historyTag, bitDescriptionArray, bl3);
            int n3 = this.oldState2;
            int n4 = historyItem.states2;
            BitDescription[] bitDescriptionArray2 = HISTORY_STATE2_DESCRIPTIONS;
            boolean bl4 = !bl;
            BatteryStats.printBitDescriptions(printWriter, n3, n4, null, bitDescriptionArray2, bl4);
            if (historyItem.wakeReasonTag != null) {
                if (bl) {
                    printWriter.print(",wr=");
                    printWriter.print(historyItem.wakeReasonTag.poolIdx);
                } else {
                    printWriter.print(" wake_reason=");
                    printWriter.print(historyItem.wakeReasonTag.uid);
                    printWriter.print(":\"");
                    printWriter.print(historyItem.wakeReasonTag.string);
                    printWriter.print("\"");
                }
            }
            if (historyItem.eventCode != 0) {
                String string23 = bl ? "," : " ";
                printWriter.print(string23);
                if ((0x8000 & historyItem.eventCode) != 0) {
                    printWriter.print("+");
                } else if ((0x4000 & historyItem.eventCode) != 0) {
                    printWriter.print("-");
                }
                String[] stringArray = bl ? HISTORY_EVENT_CHECKIN_NAMES : HISTORY_EVENT_NAMES;
                int n5 = 0xFFFF3FFF & historyItem.eventCode;
                if (n5 >= 0 && n5 < stringArray.length) {
                    printWriter.print(stringArray[n5]);
                } else {
                    String string24 = bl ? "Ev" : "event";
                    printWriter.print(string24);
                    printWriter.print(n5);
                }
                printWriter.print("=");
                if (bl) {
                    printWriter.print(historyItem.eventTag.poolIdx);
                } else {
                    UserHandle.formatUid(printWriter, historyItem.eventTag.uid);
                    printWriter.print(":\"");
                    printWriter.print(historyItem.eventTag.string);
                    printWriter.print("\"");
                }
            }
            printWriter.println();
            this.oldState = historyItem.states;
            this.oldState2 = historyItem.states2;
        }

        void reset() {
            this.oldState2 = 0;
            this.oldState = 0;
            this.oldLevel = -1;
            this.oldStatus = -1;
            this.oldHealth = -1;
            this.oldPlug = -1;
            this.oldTemp = -1;
            this.oldVolt = -1;
        }
    }

    public static final class HistoryTag {
        public int poolIdx;
        public String string;
        public int uid;

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    HistoryTag historyTag = (HistoryTag)object;
                    if (this.uid != historyTag.uid) {
                        return false;
                    }
                    if (!this.string.equals(historyTag.string)) break block6;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.string.hashCode() + this.uid;
        }

        public void readFromParcel(Parcel parcel) {
            this.string = parcel.readString();
            this.uid = parcel.readInt();
            this.poolIdx = -1;
        }

        public void setTo(HistoryTag historyTag) {
            this.string = historyTag.string;
            this.uid = historyTag.uid;
            this.poolIdx = historyTag.poolIdx;
        }

        public void setTo(String string2, int n) {
            this.string = string2;
            this.uid = n;
            this.poolIdx = -1;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.string);
            parcel.writeInt(this.uid);
        }
    }

    public static abstract class LongCounter {
        public abstract long getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class Timer {
        public abstract long getBackgroundTimeLocked();

        public abstract int getCountLocked(int var1);

        public abstract long getTotalTimeLocked(long var1, int var3);

        public abstract void logState(Printer var1, String var2);
    }

    static final class TimerEntry {
        final int mId;
        final String mName;
        final long mTime;
        final Timer mTimer;

        TimerEntry(String string2, int n, Timer timer, long l) {
            this.mName = string2;
            this.mId = n;
            this.mTimer = timer;
            this.mTime = l;
        }
    }

    public static abstract class Uid {
        public static final int NUM_PROCESS_STATE = 3;
        public static final int NUM_USER_ACTIVITY_TYPES = 3;
        public static final int NUM_WIFI_BATCHED_SCAN_BINS = 5;
        public static final int PROCESS_STATE_ACTIVE = 1;
        public static final int PROCESS_STATE_FOREGROUND = 0;
        static final String[] PROCESS_STATE_NAMES = new String[]{"Foreground", "Active", "Running"};
        public static final int PROCESS_STATE_RUNNING = 2;
        static final String[] USER_ACTIVITY_TYPES = new String[]{"other", "button", "touch"};

        public abstract long getAudioTurnedOnTime(long var1, int var3);

        public abstract Timer getForegroundActivityTimer();

        public abstract long getFullWifiLockTime(long var1, int var3);

        public abstract Map<String, ? extends Timer> getJobStats();

        public abstract int getMobileRadioActiveCount(int var1);

        public abstract long getMobileRadioActiveTime(int var1);

        public abstract long getNetworkActivityBytes(int var1, int var2);

        public abstract long getNetworkActivityPackets(int var1, int var2);

        public abstract Map<String, ? extends Pkg> getPackageStats();

        public abstract SparseArray<? extends Pid> getPidStats();

        public abstract long getProcessStateTime(int var1, long var2, int var4);

        public abstract Map<String, ? extends Proc> getProcessStats();

        public abstract SparseArray<? extends Sensor> getSensorStats();

        public abstract Map<String, ? extends Timer> getSyncStats();

        public abstract int getUid();

        public abstract int getUserActivityCount(int var1, int var2);

        public abstract Timer getVibratorOnTimer();

        public abstract long getVideoTurnedOnTime(long var1, int var3);

        public abstract Map<String, ? extends Wakelock> getWakelockStats();

        public abstract long getWifiBatchedScanTime(int var1, long var2, int var4);

        public abstract long getWifiMulticastTime(long var1, int var3);

        public abstract long getWifiRunningTime(long var1, int var3);

        public abstract long getWifiScanTime(long var1, int var3);

        public abstract boolean hasNetworkActivity();

        public abstract boolean hasUserActivity();

        public abstract void noteActivityPausedLocked(long var1);

        public abstract void noteActivityResumedLocked(long var1);

        public abstract void noteFullWifiLockAcquiredLocked(long var1);

        public abstract void noteFullWifiLockReleasedLocked(long var1);

        public abstract void noteUserActivityLocked(int var1);

        public abstract void noteWifiBatchedScanStartedLocked(int var1, long var2);

        public abstract void noteWifiBatchedScanStoppedLocked(long var1);

        public abstract void noteWifiMulticastDisabledLocked(long var1);

        public abstract void noteWifiMulticastEnabledLocked(long var1);

        public abstract void noteWifiRunningLocked(long var1);

        public abstract void noteWifiScanStartedLocked(long var1);

        public abstract void noteWifiScanStoppedLocked(long var1);

        public abstract void noteWifiStoppedLocked(long var1);

        public class Pid {
            public int mWakeNesting;
            public long mWakeStartMs;
            public long mWakeSumMs;
        }

        public static abstract class Pkg {
            public abstract Map<String, ? extends Serv> getServiceStats();

            public abstract int getWakeups(int var1);

            public abstract class Serv {
                public abstract int getLaunches(int var1);

                public abstract long getStartTime(long var1, int var3);

                public abstract int getStarts(int var1);
            }
        }

        public static abstract class Proc {
            public abstract int countExcessivePowers();

            public abstract ExcessivePower getExcessivePower(int var1);

            public abstract long getForegroundTime(int var1);

            public abstract int getStarts(int var1);

            public abstract long getSystemTime(int var1);

            public abstract long getTimeAtCpuSpeedStep(int var1, int var2);

            public abstract long getUserTime(int var1);

            public abstract boolean isActive();

            public static class ExcessivePower {
                public static final int TYPE_CPU = 2;
                public static final int TYPE_WAKE = 1;
                public long overTime;
                public int type;
                public long usedTime;
            }
        }

        public static abstract class Sensor {
            public static final int GPS = -10000;

            public abstract int getHandle();

            public abstract Timer getSensorTime();
        }

        public static abstract class Wakelock {
            public abstract Timer getWakeTime(int var1);
        }
    }
}

