/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AsyncTask<Params, Progress, Result> {
    private static final int CORE_POOL_SIZE = 0;
    private static final int CPU_COUNT = 0;
    private static final int KEEP_ALIVE = 1;
    private static final String LOG_TAG = "AsyncTask";
    private static final int MAXIMUM_POOL_SIZE = 0;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static final int MESSAGE_POST_RESULT = 1;
    public static final Executor SERIAL_EXECUTOR;
    public static final Executor THREAD_POOL_EXECUTOR;
    private static volatile Executor sDefaultExecutor;
    private static final InternalHandler sHandler;
    private static final BlockingQueue<Runnable> sPoolWorkQueue;
    private static final ThreadFactory sThreadFactory;
    private final AtomicBoolean mCancelled;
    private final FutureTask<Result> mFuture;
    private volatile Status mStatus = Status.PENDING;
    private final AtomicBoolean mTaskInvoked;
    private final WorkerRunnable<Params, Result> mWorker;

    static {
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = 1 + CPU_COUNT;
        MAXIMUM_POOL_SIZE = 1 + 2 * CPU_COUNT;
        sThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "AsyncTask #" + this.mCount.getAndIncrement());
            }
        };
        sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
        THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
        SERIAL_EXECUTOR = new SerialExecutor();
        sHandler = new InternalHandler();
        sDefaultExecutor = SERIAL_EXECUTOR;
    }

    public AsyncTask() {
        this.mCancelled = new AtomicBoolean();
        this.mTaskInvoked = new AtomicBoolean();
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                AsyncTask.this.mTaskInvoked.set(true);
                Process.setThreadPriority(10);
                return AsyncTask.this.postResult(AsyncTask.this.doInBackground(this.mParams));
            }
        };
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            protected void done() {
                try {
                    AsyncTask.this.postResultIfNotInvoked(this.get());
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Log.w(AsyncTask.LOG_TAG, interruptedException);
                    return;
                }
                catch (ExecutionException executionException) {
                    throw new RuntimeException("An error occured while executing doInBackground()", executionException.getCause());
                }
                catch (CancellationException cancellationException) {
                    AsyncTask.this.postResultIfNotInvoked(null);
                    return;
                }
            }
        };
    }

    public static void execute(Runnable runnable) {
        sDefaultExecutor.execute(runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void finish(Result Result2) {
        if (this.isCancelled()) {
            this.onCancelled(Result2);
        } else {
            this.onPostExecute(Result2);
        }
        this.mStatus = Status.FINISHED;
    }

    public static void init() {
        sHandler.getLooper();
    }

    private Result postResult(Result Result2) {
        sHandler.obtainMessage(1, new AsyncTaskResult<Object>(this, Result2)).sendToTarget();
        return Result2;
    }

    private void postResultIfNotInvoked(Result Result2) {
        if (!this.mTaskInvoked.get()) {
            this.postResult(Result2);
        }
    }

    public static void setDefaultExecutor(Executor executor) {
        sDefaultExecutor = executor;
    }

    public final boolean cancel(boolean bl) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(bl);
    }

    protected abstract Result doInBackground(Params ... var1);

    public final AsyncTask<Params, Progress, Result> execute(Params ... ParamsArray) {
        return this.executeOnExecutor(sDefaultExecutor, ParamsArray);
    }

    /*
     * Unable to fully structure code
     */
    public final AsyncTask<Params, Progress, Result> executeOnExecutor(Executor var1_1, Params ... var2_2) {
        if (this.mStatus == Status.PENDING) ** GOTO lbl-1000
        switch (4.$SwitchMap$android$os$AsyncTask$Status[this.mStatus.ordinal()]) {
            default: lbl-1000:
            // 2 sources

            {
                this.mStatus = Status.RUNNING;
                this.onPreExecute();
                this.mWorker.mParams = var2_2;
                var1_1.execute(this.mFuture);
                return this;
            }
            case 1: {
                throw new IllegalStateException("Cannot execute task: the task is already running.");
            }
            case 2: 
        }
        throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
    }

    public final Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public final Result get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(l, timeUnit);
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    protected void onCancelled() {
    }

    protected void onCancelled(Result Result2) {
        this.onCancelled();
    }

    protected void onPostExecute(Result Result2) {
    }

    protected void onPreExecute() {
    }

    protected void onProgressUpdate(Progress ... ProgressArray) {
    }

    protected final void publishProgress(Progress ... ProgressArray) {
        if (!this.isCancelled()) {
            sHandler.obtainMessage(2, new AsyncTaskResult<Progress>(this, ProgressArray)).sendToTarget();
        }
    }

    private static class AsyncTaskResult<Data> {
        final Data[] mData;
        final AsyncTask mTask;

        AsyncTaskResult(AsyncTask asyncTask, Data ... DataArray) {
            this.mTask = asyncTask;
            this.mData = DataArray;
        }
    }

    private static class InternalHandler
    extends Handler {
        private InternalHandler() {
        }

        @Override
        public void handleMessage(Message message) {
            AsyncTaskResult asyncTaskResult = (AsyncTaskResult)message.obj;
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    asyncTaskResult.mTask.finish(asyncTaskResult.mData[0]);
                    return;
                }
                case 2: 
            }
            asyncTaskResult.mTask.onProgressUpdate(asyncTaskResult.mData);
        }
    }

    private static class SerialExecutor
    implements Executor {
        Runnable mActive;
        final ArrayDeque<Runnable> mTasks = new ArrayDeque();

        private SerialExecutor() {
        }

        @Override
        public void execute(final Runnable runnable) {
            synchronized (this) {
                this.mTasks.offer(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            runnable.run();
                            return;
                        }
                        finally {
                            SerialExecutor.this.scheduleNext();
                        }
                    }
                });
                if (this.mActive == null) {
                    this.scheduleNext();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void scheduleNext() {
            synchronized (this) {
                Runnable runnable;
                this.mActive = runnable = this.mTasks.poll();
                if (runnable != null) {
                    THREAD_POOL_EXECUTOR.execute(this.mActive);
                }
                return;
            }
        }
    }

    public static final class Status
    extends Enum<Status> {
        private static final /* synthetic */ Status[] $VALUES;
        public static final /* enum */ Status FINISHED;
        public static final /* enum */ Status PENDING;
        public static final /* enum */ Status RUNNING;

        static {
            PENDING = new Status();
            RUNNING = new Status();
            FINISHED = new Status();
            Status[] statusArray = new Status[]{PENDING, RUNNING, FINISHED};
            $VALUES = statusArray;
        }

        public static Status valueOf(String string2) {
            return Enum.valueOf(Status.class, string2);
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        private WorkerRunnable() {
        }
    }
}

