/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.BasicTagTechnology;
import android.nfc.tech.NfcA;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class MifareClassic
extends BasicTagTechnology {
    public static final int BLOCK_SIZE = 16;
    public static final byte[] KEY_DEFAULT = new byte[]{-1, -1, -1, -1, -1, -1};
    public static final byte[] KEY_MIFARE_APPLICATION_DIRECTORY = new byte[]{-96, -95, -94, -93, -92, -91};
    public static final byte[] KEY_NFC_FORUM = new byte[]{-45, -9, -45, -9, -45, -9};
    private static final int MAX_BLOCK_COUNT = 256;
    private static final int MAX_SECTOR_COUNT = 40;
    public static final int SIZE_1K = 1024;
    public static final int SIZE_2K = 2048;
    public static final int SIZE_4K = 4096;
    public static final int SIZE_MINI = 320;
    private static final String TAG = "NFC";
    public static final int TYPE_CLASSIC = 0;
    public static final int TYPE_PLUS = 1;
    public static final int TYPE_PRO = 2;
    public static final int TYPE_UNKNOWN = -1;
    private boolean mIsEmulated;
    private int mSize;
    private int mType;

    public MifareClassic(Tag tag) throws RemoteException {
        super(tag, 8);
        NfcA nfcA = NfcA.get(tag);
        this.mIsEmulated = false;
        switch (nfcA.getSak()) {
            default: {
                throw new RuntimeException("Tag incorrectly enumerated as MIFARE Classic, SAK = " + nfcA.getSak());
            }
            case 1: 
            case 8: {
                this.mType = 0;
                this.mSize = 1024;
                return;
            }
            case 9: {
                this.mType = 0;
                this.mSize = 320;
                return;
            }
            case 16: {
                this.mType = 1;
                this.mSize = 2048;
                return;
            }
            case 17: {
                this.mType = 1;
                this.mSize = 4096;
                return;
            }
            case 24: {
                this.mType = 0;
                this.mSize = 4096;
                return;
            }
            case 40: {
                this.mType = 0;
                this.mSize = 1024;
                this.mIsEmulated = true;
                return;
            }
            case 56: {
                this.mType = 0;
                this.mSize = 4096;
                this.mIsEmulated = true;
                return;
            }
            case 136: {
                this.mType = 0;
                this.mSize = 1024;
                return;
            }
            case 152: 
            case 184: 
        }
        this.mType = 2;
        this.mSize = 4096;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean authenticate(int n, byte[] byArray, boolean bl) throws IOException {
        MifareClassic.validateSector(n);
        this.checkConnected();
        byte[] byArray2 = new byte[12];
        byArray2[0] = bl ? 96 : 97;
        byArray2[1] = (byte)this.sectorToBlock(n);
        byte[] byArray3 = this.getTag().getId();
        System.arraycopy((byte[])byArray3, (int)(-4 + byArray3.length), (byte[])byArray2, (int)2, (int)4);
        System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)6, (int)6);
        try {
            byte[] byArray4 = this.transceive(byArray2, false);
            if (byArray4 == null) return false;
            return true;
        }
        catch (TagLostException tagLostException) {
            throw tagLostException;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static MifareClassic get(Tag tag) {
        if (!tag.hasTech(8)) {
            return null;
        }
        try {
            MifareClassic mifareClassic = new MifareClassic(tag);
            return mifareClassic;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static void validateBlock(int n) {
        if (n < 0 || n >= 256) {
            throw new IndexOutOfBoundsException("block out of bounds: " + n);
        }
    }

    private static void validateSector(int n) {
        if (n < 0 || n >= 40) {
            throw new IndexOutOfBoundsException("sector out of bounds: " + n);
        }
    }

    private static void validateValueOperand(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("value operand negative");
        }
    }

    public boolean authenticateSectorWithKeyA(int n, byte[] byArray) throws IOException {
        return this.authenticate(n, byArray, true);
    }

    public boolean authenticateSectorWithKeyB(int n, byte[] byArray) throws IOException {
        return this.authenticate(n, byArray, false);
    }

    public int blockToSector(int n) {
        MifareClassic.validateBlock(n);
        if (n < 128) {
            return n / 4;
        }
        return 32 + (n - 128) / 16;
    }

    public void decrement(int n, int n2) throws IOException {
        MifareClassic.validateBlock(n);
        MifareClassic.validateValueOperand(n2);
        this.checkConnected();
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put((byte)-64);
        byteBuffer.put((byte)n);
        byteBuffer.putInt(n2);
        this.transceive(byteBuffer.array(), false);
    }

    public int getBlockCount() {
        return this.mSize / 16;
    }

    public int getBlockCountInSector(int n) {
        MifareClassic.validateSector(n);
        if (n < 32) {
            return 4;
        }
        return 16;
    }

    public int getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    public int getSectorCount() {
        switch (this.mSize) {
            default: {
                return 0;
            }
            case 1024: {
                return 16;
            }
            case 2048: {
                return 32;
            }
            case 4096: {
                return 40;
            }
            case 320: 
        }
        return 5;
    }

    public int getSize() {
        return this.mSize;
    }

    public int getTimeout() {
        try {
            int n = this.mTag.getTagService().getTimeout(8);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return 0;
        }
    }

    public int getType() {
        return this.mType;
    }

    public void increment(int n, int n2) throws IOException {
        MifareClassic.validateBlock(n);
        MifareClassic.validateValueOperand(n2);
        this.checkConnected();
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put((byte)-63);
        byteBuffer.put((byte)n);
        byteBuffer.putInt(n2);
        this.transceive(byteBuffer.array(), false);
    }

    public boolean isEmulated() {
        return this.mIsEmulated;
    }

    public byte[] readBlock(int n) throws IOException {
        MifareClassic.validateBlock(n);
        this.checkConnected();
        byte[] byArray = new byte[]{48, (byte)n};
        return this.transceive(byArray, false);
    }

    public void restore(int n) throws IOException {
        MifareClassic.validateBlock(n);
        this.checkConnected();
        byte[] byArray = new byte[]{-62, (byte)n};
        this.transceive(byArray, false);
    }

    public int sectorToBlock(int n) {
        if (n < 32) {
            return n * 4;
        }
        return 128 + 16 * (n - 32);
    }

    public void setTimeout(int n) {
        try {
            if (this.mTag.getTagService().setTimeout(8, n) != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
        }
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }

    public void transfer(int n) throws IOException {
        MifareClassic.validateBlock(n);
        this.checkConnected();
        byte[] byArray = new byte[]{-80, (byte)n};
        this.transceive(byArray, false);
    }

    public void writeBlock(int n, byte[] byArray) throws IOException {
        MifareClassic.validateBlock(n);
        this.checkConnected();
        if (byArray.length != 16) {
            throw new IllegalArgumentException("must write 16-bytes");
        }
        byte[] byArray2 = new byte[2 + byArray.length];
        byArray2[0] = -96;
        byArray2[1] = (byte)n;
        System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)2, (int)byArray.length);
        this.transceive(byArray2, false);
    }
}

