/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;

public abstract class HostApduService
extends Service {
    public static final int DEACTIVATION_DESELECTED = 1;
    public static final int DEACTIVATION_LINK_LOSS = 0;
    public static final String KEY_DATA = "data";
    public static final int MSG_COMMAND_APDU = 0;
    public static final int MSG_DEACTIVATED = 2;
    public static final int MSG_RESPONSE_APDU = 1;
    public static final int MSG_UNHANDLED = 3;
    public static final String SERVICE_INTERFACE = "android.nfc.cardemulation.action.HOST_APDU_SERVICE";
    public static final String SERVICE_META_DATA = "android.nfc.cardemulation.host_apdu_service";
    static final String TAG = "ApduService";
    final Messenger mMessenger = new Messenger(new MsgHandler());
    Messenger mNfcService = null;

    public final void notifyUnhandled() {
        Message message = Message.obtain(null, 3);
        try {
            this.mMessenger.send(message);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e("TAG", "Local messenger has died.");
            return;
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mMessenger.getBinder();
    }

    public abstract void onDeactivated(int var1);

    public abstract byte[] processCommandApdu(byte[] var1, Bundle var2);

    public final void sendResponseApdu(byte[] byArray) {
        Message message = Message.obtain(null, 1);
        Bundle bundle = new Bundle();
        bundle.putByteArray(KEY_DATA, byArray);
        message.setData(bundle);
        try {
            this.mMessenger.send(message);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e("TAG", "Local messenger has died.");
            return;
        }
    }

    final class MsgHandler
    extends Handler {
        MsgHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    super.handleMessage(message);
                    return;
                }
                case 0: {
                    byte[] byArray;
                    Bundle bundle = message.getData();
                    if (bundle == null) return;
                    if (HostApduService.this.mNfcService == null) {
                        HostApduService.this.mNfcService = message.replyTo;
                    }
                    if ((byArray = bundle.getByteArray(HostApduService.KEY_DATA)) == null) {
                        Log.e(HostApduService.TAG, "Received MSG_COMMAND_APDU without data.");
                        return;
                    }
                    byte[] byArray2 = HostApduService.this.processCommandApdu(byArray, null);
                    if (byArray2 == null) return;
                    if (HostApduService.this.mNfcService == null) {
                        Log.e(HostApduService.TAG, "Response not sent; service was deactivated.");
                        return;
                    }
                    Message message2 = Message.obtain(null, 1);
                    Bundle bundle2 = new Bundle();
                    bundle2.putByteArray(HostApduService.KEY_DATA, byArray2);
                    message2.setData(bundle2);
                    message2.replyTo = HostApduService.this.mMessenger;
                    try {
                        HostApduService.this.mNfcService.send(message2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e("TAG", "Response not sent; RemoteException calling into NfcService.");
                        return;
                    }
                }
                case 1: {
                    if (HostApduService.this.mNfcService == null) {
                        Log.e(HostApduService.TAG, "Response not sent; service was deactivated.");
                        return;
                    }
                    try {
                        message.replyTo = HostApduService.this.mMessenger;
                        HostApduService.this.mNfcService.send(message);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(HostApduService.TAG, "RemoteException calling into NfcService.");
                        return;
                    }
                }
                case 2: {
                    HostApduService.this.mNfcService = null;
                    HostApduService.this.onDeactivated(message.arg1);
                    return;
                }
                case 3: 
            }
            if (HostApduService.this.mNfcService == null) {
                Log.e(HostApduService.TAG, "notifyUnhandled not sent; service was deactivated.");
                return;
            }
            try {
                message.replyTo = HostApduService.this.mMessenger;
                HostApduService.this.mNfcService.send(message);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(HostApduService.TAG, "RemoteException calling into NfcService.");
                return;
            }
        }
    }
}

