/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.content.Intent;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;

public final class NdefRecord
implements Parcelable {
    public static final Parcelable.Creator<NdefRecord> CREATOR;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final byte FLAG_CF = 32;
    private static final byte FLAG_IL = 8;
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private static final byte FLAG_SR = 16;
    private static final int MAX_PAYLOAD_SIZE = 0xA00000;
    public static final byte[] RTD_ALTERNATIVE_CARRIER;
    public static final byte[] RTD_ANDROID_APP;
    public static final byte[] RTD_HANDOVER_CARRIER;
    public static final byte[] RTD_HANDOVER_REQUEST;
    public static final byte[] RTD_HANDOVER_SELECT;
    public static final byte[] RTD_SMART_POSTER;
    public static final byte[] RTD_TEXT;
    public static final byte[] RTD_URI;
    public static final short TNF_ABSOLUTE_URI = 3;
    public static final short TNF_EMPTY = 0;
    public static final short TNF_EXTERNAL_TYPE = 4;
    public static final short TNF_MIME_MEDIA = 2;
    public static final short TNF_RESERVED = 7;
    public static final short TNF_UNCHANGED = 6;
    public static final short TNF_UNKNOWN = 5;
    public static final short TNF_WELL_KNOWN = 1;
    private static final String[] URI_PREFIX_MAP;
    private final byte[] mId;
    private final byte[] mPayload;
    private final short mTnf;
    private final byte[] mType;

    static {
        RTD_TEXT = new byte[]{84};
        RTD_URI = new byte[]{85};
        RTD_SMART_POSTER = new byte[]{83, 112};
        RTD_ALTERNATIVE_CARRIER = new byte[]{97, 99};
        RTD_HANDOVER_CARRIER = new byte[]{72, 99};
        RTD_HANDOVER_REQUEST = new byte[]{72, 114};
        RTD_HANDOVER_SELECT = new byte[]{72, 115};
        RTD_ANDROID_APP = "android.com:pkg".getBytes();
        URI_PREFIX_MAP = new String[]{"", "http://www.", "https://www.", "http://", "https://", "tel:", "mailto:", "ftp://anonymous:anonymous@", "ftp://ftp.", "ftps://", "sftp://", "smb://", "nfs://", "ftp://", "dav://", "news:", "telnet://", "imap:", "rtsp://", "urn:", "pop:", "sip:", "sips:", "tftp:", "btspp://", "btl2cap://", "btgoep://", "tcpobex://", "irdaobex://", "file://", "urn:epc:id:", "urn:epc:tag:", "urn:epc:pat:", "urn:epc:raw:", "urn:epc:", "urn:nfc:"};
        EMPTY_BYTE_ARRAY = new byte[0];
        CREATOR = new Parcelable.Creator<NdefRecord>(){

            @Override
            public NdefRecord createFromParcel(Parcel parcel) {
                short s = (short)parcel.readInt();
                byte[] byArray = new byte[parcel.readInt()];
                parcel.readByteArray(byArray);
                byte[] byArray2 = new byte[parcel.readInt()];
                parcel.readByteArray(byArray2);
                byte[] byArray3 = new byte[parcel.readInt()];
                parcel.readByteArray(byArray3);
                return new NdefRecord(s, byArray, byArray2, byArray3);
            }

            public NdefRecord[] newArray(int n) {
                return new NdefRecord[n];
            }
        };
    }

    public NdefRecord(short s, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        String string2;
        if (byArray == null) {
            byArray = EMPTY_BYTE_ARRAY;
        }
        if (byArray2 == null) {
            byArray2 = EMPTY_BYTE_ARRAY;
        }
        if (byArray3 == null) {
            byArray3 = EMPTY_BYTE_ARRAY;
        }
        if ((string2 = NdefRecord.validateTnf(s, byArray, byArray2, byArray3)) != null) {
            throw new IllegalArgumentException(string2);
        }
        this.mTnf = s;
        this.mType = byArray;
        this.mId = byArray2;
        this.mPayload = byArray3;
    }

    @Deprecated
    public NdefRecord(byte[] byArray) throws FormatException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        NdefRecord[] ndefRecordArray = NdefRecord.parse(byteBuffer, true);
        if (byteBuffer.remaining() > 0) {
            throw new FormatException("data too long");
        }
        this.mTnf = ndefRecordArray[0].mTnf;
        this.mType = ndefRecordArray[0].mType;
        this.mId = ndefRecordArray[0].mId;
        this.mPayload = ndefRecordArray[0].mPayload;
    }

    private static StringBuilder bytesToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            Object[] objectArray = new Object[]{by};
            stringBuilder.append(String.format("%02X", objectArray));
        }
        return stringBuilder;
    }

    public static NdefRecord createApplicationRecord(String string2) {
        if (string2 == null) {
            throw new NullPointerException("packageName is null");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("packageName is empty");
        }
        return new NdefRecord(4, RTD_ANDROID_APP, null, string2.getBytes(StandardCharsets.UTF_8));
    }

    public static NdefRecord createExternal(String string2, String string3, byte[] byArray) {
        if (string2 == null) {
            throw new NullPointerException("domain is null");
        }
        if (string3 == null) {
            throw new NullPointerException("type is null");
        }
        String string4 = string2.trim().toLowerCase(Locale.ROOT);
        String string5 = string3.trim().toLowerCase(Locale.ROOT);
        if (string4.length() == 0) {
            throw new IllegalArgumentException("domain is empty");
        }
        if (string5.length() == 0) {
            throw new IllegalArgumentException("type is empty");
        }
        byte[] byArray2 = string4.getBytes(StandardCharsets.UTF_8);
        byte[] byArray3 = string5.getBytes(StandardCharsets.UTF_8);
        byte[] byArray4 = new byte[1 + byArray2.length + byArray3.length];
        System.arraycopy((byte[])byArray2, (int)0, (byte[])byArray4, (int)0, (int)byArray2.length);
        byArray4[byArray2.length] = 58;
        System.arraycopy((byte[])byArray3, (int)0, (byte[])byArray4, (int)(1 + byArray2.length), (int)byArray3.length);
        return new NdefRecord(4, byArray4, null, byArray);
    }

    public static NdefRecord createMime(String string2, byte[] byArray) {
        if (string2 == null) {
            throw new NullPointerException("mimeType is null");
        }
        String string3 = Intent.normalizeMimeType(string2);
        if (string3.length() == 0) {
            throw new IllegalArgumentException("mimeType is empty");
        }
        int n = string3.indexOf(47);
        if (n == 0) {
            throw new IllegalArgumentException("mimeType must have major type");
        }
        if (n == -1 + string3.length()) {
            throw new IllegalArgumentException("mimeType must have minor type");
        }
        return new NdefRecord(2, string3.getBytes(StandardCharsets.US_ASCII), null, byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static NdefRecord createTextRecord(String string2, String string3) {
        if (string3 == null) {
            throw new NullPointerException("text is null");
        }
        byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = string2 != null && !string2.isEmpty() ? string2.getBytes(StandardCharsets.US_ASCII) : Locale.getDefault().getLanguage().getBytes(StandardCharsets.US_ASCII);
        if (byArray2.length >= 64) {
            throw new IllegalArgumentException("language code is too long, must be <64 bytes.");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(1 + byArray2.length + byArray.length);
        byteBuffer.put((byte)(0xFF & byArray2.length));
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray);
        return new NdefRecord(1, RTD_TEXT, null, byteBuffer.array());
    }

    public static NdefRecord createUri(Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        String string2 = uri.normalizeScheme().toString();
        if (string2.length() == 0) {
            throw new IllegalArgumentException("uri is empty");
        }
        int n = 1;
        while (true) {
            block7: {
                byte by;
                block6: {
                    int n2 = URI_PREFIX_MAP.length;
                    by = 0;
                    if (n >= n2) break block6;
                    if (!string2.startsWith(URI_PREFIX_MAP[n])) break block7;
                    by = (byte)n;
                    string2 = string2.substring(URI_PREFIX_MAP[n].length());
                }
                byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
                byte[] byArray2 = new byte[1 + byArray.length];
                byArray2[0] = by;
                System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)1, (int)byArray.length);
                return new NdefRecord(1, RTD_URI, null, byArray2);
            }
            ++n;
        }
    }

    public static NdefRecord createUri(String string2) {
        return NdefRecord.createUri(Uri.parse(string2));
    }

    private static void ensureSanePayloadSize(long l) throws FormatException {
        if (l > 0xA00000L) {
            throw new FormatException("payload above max limit: " + l + " > " + 0xA00000);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static NdefRecord[] parse(ByteBuffer byteBuffer, boolean bl) throws FormatException {
        ArrayList<NdefRecord> arrayList = new ArrayList<NdefRecord>();
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
            boolean bl2 = false;
            int n = -1;
            boolean bl3 = false;
            while (!bl3) {
                byte by = byteBuffer.get();
                boolean bl4 = (by & 0xFFFFFF80) != 0;
                bl3 = (by & 0x40) != 0;
                boolean bl5 = (by & 0x20) != 0;
                boolean bl6 = (by & 0x10) != 0;
                boolean bl7 = (by & 8) != 0;
                int n2 = by & 7;
                if (!(bl4 || arrayList.size() != 0 || bl2 || bl)) {
                    throw new FormatException("expected MB flag");
                }
                if (bl4 && arrayList.size() != 0 && !bl) {
                    throw new FormatException("unexpected MB flag");
                }
                if (bl2 && bl7) {
                    throw new FormatException("unexpected IL flag in non-leading chunk");
                }
                if (bl5 && bl3) {
                    throw new FormatException("unexpected ME flag in non-trailing chunk");
                }
                if (bl2 && n2 != 6) {
                    throw new FormatException("expected TNF_UNCHANGED in non-leading chunk");
                }
                if (!bl2 && n2 == 6) {
                    throw new FormatException("unexpected TNF_UNCHANGED in first chunk or unchunked record");
                }
                int n3 = 0xFF & byteBuffer.get();
                long l = bl6 ? (long)(0xFF & byteBuffer.get()) : 0xFFFFFFFFL & (long)byteBuffer.getInt();
                int n4 = bl7 ? 0xFF & byteBuffer.get() : 0;
                if (bl2 && n3 != 0) {
                    throw new FormatException("expected zero-length type in non-leading chunk");
                }
                if (!bl2) {
                    byArray = n3 > 0 ? new byte[n3] : EMPTY_BYTE_ARRAY;
                    byArray2 = n4 > 0 ? new byte[n4] : EMPTY_BYTE_ARRAY;
                    byteBuffer.get(byArray);
                    byteBuffer.get(byArray2);
                }
                NdefRecord.ensureSanePayloadSize(l);
                byte[] byArray3 = l > 0L ? new byte[(int)l] : EMPTY_BYTE_ARRAY;
                byteBuffer.get(byArray3);
                if (bl5 && !bl2) {
                    arrayList2.clear();
                    n = n2;
                }
                if (bl5 || bl2) {
                    arrayList2.add(byArray3);
                }
                if (!bl5 && bl2) {
                    long l2 = 0L;
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        l2 += (long)((byte[])iterator.next()).length;
                    }
                    NdefRecord.ensureSanePayloadSize(l2);
                    byArray3 = new byte[(int)l2];
                    int n5 = 0;
                    for (byte[] byArray4 : arrayList2) {
                        int n6 = byArray4.length;
                        System.arraycopy((byte[])byArray4, (int)0, (byte[])byArray3, (int)n5, (int)n6);
                        n5 += byArray4.length;
                    }
                    n2 = n;
                }
                if (bl5) {
                    bl2 = true;
                    continue;
                }
                String string2 = NdefRecord.validateTnf((short)n2, byArray, byArray2, byArray3);
                if (string2 != null) {
                    FormatException formatException = new FormatException(string2);
                    throw formatException;
                }
                NdefRecord ndefRecord = new NdefRecord((short)n2, byArray, byArray2, byArray3);
                arrayList.add(ndefRecord);
                bl2 = false;
                if (!bl) continue;
                return arrayList.toArray(new NdefRecord[arrayList.size()]);
            }
            return arrayList.toArray(new NdefRecord[arrayList.size()]);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FormatException formatException = new FormatException("expected more data", bufferUnderflowException);
            throw formatException;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Uri parseWktUri() {
        int n;
        if (this.mPayload.length < 2 || (n = 0xFFFFFFFF & this.mPayload[0]) < 0 || n >= URI_PREFIX_MAP.length) {
            return null;
        }
        String string2 = URI_PREFIX_MAP[n];
        String string3 = new String(Arrays.copyOfRange(this.mPayload, 1, this.mPayload.length), StandardCharsets.UTF_8);
        return Uri.parse(string2 + string3);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Uri toUri(boolean bl) {
        switch (this.mTnf) {
            case 1: {
                if (Arrays.equals(this.mType, RTD_SMART_POSTER) && !bl) {
                    NdefRecord[] ndefRecordArray = new NdefMessage(this.mPayload).getRecords();
                    int n = ndefRecordArray.length;
                    for (int i = 0; i < n; ++i) {
                        Uri uri = ndefRecordArray[i].toUri(true);
                        if (uri == null) continue;
                        return uri;
                    }
                } else {
                    Uri uri;
                    if (!Arrays.equals(this.mType, RTD_URI) || (uri = this.parseWktUri()) == null) return null;
                    return uri.normalizeScheme();
                }
            }
            default: {
                return null;
            }
            case 3: {
                return Uri.parse(new String(this.mType, StandardCharsets.UTF_8)).normalizeScheme();
            }
            case 4: {
                if (bl) return null;
                return Uri.parse("vnd.android.nfc://ext/" + new String(this.mType, StandardCharsets.US_ASCII));
            }
        }
        catch (FormatException formatException) {
            return null;
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    static String validateTnf(short s, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        String string2 = null;
        int n = Integer.MIN_VALUE;
        block6: do {
            switch (n == Integer.MIN_VALUE ? s : n) {
                default: {
                    Object[] objectArray = new Object[]{s};
                    string2 = String.format("unexpected tnf value: 0x%02x", objectArray);
                    n = 1;
                    continue block6;
                }
                case 0: {
                    if (byArray.length != 0 || byArray2.length != 0) return "unexpected data in TNF_EMPTY record";
                    int n2 = byArray3.length;
                    string2 = null;
                    n = 1;
                    if (n2 == 0) continue block6;
                    return "unexpected data in TNF_EMPTY record";
                }
                case 5: 
                case 7: {
                    int n3 = byArray.length;
                    string2 = null;
                    if (n3 == 0) return string2;
                    return "unexpected type field in TNF_UNKNOWN or TNF_RESERVEd record";
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return string2;
                }
                case 6: 
            }
            return "unexpected TNF_UNCHANGED in first chunk or logical record";
        } while (true);
        return "unexpected TNF_UNCHANGED in first chunk or logical record";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object == null) return bl;
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = object.getClass();
        bl = false;
        if (clazz != clazz2) return bl;
        NdefRecord ndefRecord = (NdefRecord)object;
        boolean bl2 = Arrays.equals(this.mId, ndefRecord.mId);
        bl = false;
        if (!bl2) return bl;
        boolean bl3 = Arrays.equals(this.mPayload, ndefRecord.mPayload);
        bl = false;
        if (!bl3) return bl;
        short s = this.mTnf;
        short s2 = ndefRecord.mTnf;
        bl = false;
        if (s != s2) return bl;
        return Arrays.equals(this.mType, ndefRecord.mType);
    }

    /*
     * Enabled aggressive block sorting
     */
    int getByteLength() {
        int n = 3 + this.mType.length + this.mId.length + this.mPayload.length;
        boolean bl = this.mPayload.length < 256;
        boolean bl2 = this.mId.length > 0;
        if (!bl) {
            n += 3;
        }
        if (bl2) {
            ++n;
        }
        return n;
    }

    public byte[] getId() {
        return (byte[])this.mId.clone();
    }

    public byte[] getPayload() {
        return (byte[])this.mPayload.clone();
    }

    public short getTnf() {
        return this.mTnf;
    }

    public byte[] getType() {
        return (byte[])this.mType.clone();
    }

    public int hashCode() {
        return 31 * (31 * (31 * (31 + Arrays.hashCode(this.mId)) + Arrays.hashCode(this.mPayload)) + this.mTnf) + Arrays.hashCode(this.mType);
    }

    @Deprecated
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getByteLength());
        this.writeToByteBuffer(byteBuffer, true, true);
        return byteBuffer.array();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toMimeType() {
        switch (this.mTnf) {
            case 1: {
                if (Arrays.equals(this.mType, RTD_TEXT)) {
                    return "text/plain";
                }
            }
            default: {
                return null;
            }
            case 2: 
        }
        return Intent.normalizeMimeType(new String(this.mType, StandardCharsets.US_ASCII));
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.mTnf};
        StringBuilder stringBuilder = new StringBuilder(String.format("NdefRecord tnf=%X", objectArray));
        if (this.mType.length > 0) {
            stringBuilder.append(" type=").append(NdefRecord.bytesToString(this.mType));
        }
        if (this.mId.length > 0) {
            stringBuilder.append(" id=").append(NdefRecord.bytesToString(this.mId));
        }
        if (this.mPayload.length > 0) {
            stringBuilder.append(" payload=").append(NdefRecord.bytesToString(this.mPayload));
        }
        return stringBuilder.toString();
    }

    public Uri toUri() {
        return this.toUri(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeToByteBuffer(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        boolean bl3 = this.mPayload.length < 256;
        boolean bl4 = this.mId.length > 0;
        int n = bl ? -128 : 0;
        int n2 = bl2 ? 64 : 0;
        int n3 = n | n2;
        int n4 = bl3 ? 16 : 0;
        int n5 = n4 | n3;
        int n6 = 0;
        if (bl4) {
            n6 = 8;
        }
        byteBuffer.put((byte)(n5 | n6 | this.mTnf));
        byteBuffer.put((byte)this.mType.length);
        if (bl3) {
            byteBuffer.put((byte)this.mPayload.length);
        } else {
            byteBuffer.putInt(this.mPayload.length);
        }
        if (bl4) {
            byteBuffer.put((byte)this.mId.length);
        }
        byteBuffer.put(this.mType);
        byteBuffer.put(this.mId);
        byteBuffer.put(this.mPayload);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mTnf);
        parcel.writeInt(this.mType.length);
        parcel.writeByteArray(this.mType);
        parcel.writeInt(this.mId.length);
        parcel.writeByteArray(this.mId);
        parcel.writeInt(this.mPayload.length);
        parcel.writeByteArray(this.mPayload);
    }
}

