/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import java.util.ArrayList;
import java.util.List;

public class WifiP2pUpnpServiceResponse
extends WifiP2pServiceResponse {
    private List<String> mUniqueServiceNames;
    private int mVersion;

    protected WifiP2pUpnpServiceResponse(int n, int n2, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        super(2, n, n2, wifiP2pDevice, byArray);
        if (!this.parse()) {
            throw new IllegalArgumentException("Malformed upnp service response");
        }
    }

    static WifiP2pUpnpServiceResponse newInstance(int n, int n2, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        if (n != 0) {
            return new WifiP2pUpnpServiceResponse(n, n2, wifiP2pDevice, null);
        }
        try {
            WifiP2pUpnpServiceResponse wifiP2pUpnpServiceResponse = new WifiP2pUpnpServiceResponse(n, n2, wifiP2pDevice, byArray);
            return wifiP2pUpnpServiceResponse;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parse() {
        if (this.mData != null) {
            if (this.mData.length < 1) {
                return false;
            }
            this.mVersion = 0xFF & this.mData[0];
            String[] stringArray = new String(this.mData, 1, -1 + this.mData.length).split(",");
            this.mUniqueServiceNames = new ArrayList<String>();
            for (String string2 : stringArray) {
                this.mUniqueServiceNames.add(string2);
            }
        }
        return true;
    }

    public List<String> getUniqueServiceNames() {
        return this.mUniqueServiceNames;
    }

    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("serviceType:UPnP(").append(this.mServiceType).append(")");
        stringBuffer.append(" status:").append(WifiP2pServiceResponse.Status.toString(this.mStatus));
        stringBuffer.append(" srcAddr:").append(this.mDevice.deviceAddress);
        StringBuffer stringBuffer2 = stringBuffer.append(" version:");
        Object[] objectArray = new Object[]{this.mVersion};
        stringBuffer2.append(String.format("%02x", objectArray));
        if (this.mUniqueServiceNames != null) {
            for (String string2 : this.mUniqueServiceNames) {
                stringBuffer.append(" usn:").append(string2);
            }
        }
        return stringBuffer.toString();
    }
}

