/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiLinkLayerStats;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.Locale;

public class WifiInfo
implements Parcelable {
    public static final Parcelable.Creator<WifiInfo> CREATOR;
    public static final String FREQUENCY_UNITS = "MHz";
    public static final int INVALID_RSSI = -127;
    public static final String LINK_SPEED_UNITS = "Mbps";
    public static final int MAX_RSSI = 200;
    public static final int MIN_RSSI = -126;
    private static final String TAG = "WifiInfo";
    private static final EnumMap<SupplicantState, NetworkInfo.DetailedState> stateMap;
    public int badRssiCount;
    public int linkStuckCount;
    public int lowRssiCount;
    private String mBSSID;
    private int mFrequency;
    private InetAddress mIpAddress;
    private int mLinkSpeed;
    private String mMacAddress;
    private boolean mMeteredHint;
    private int mNetworkId;
    private int mRssi;
    private SupplicantState mSupplicantState;
    private WifiSsid mWifiSsid;
    public long rxSuccess;
    public double rxSuccessRate;
    public int score;
    public long txBad;
    public double txBadRate;
    public long txRetries;
    public double txRetriesRate;
    public long txSuccess;
    public double txSuccessRate;

    static {
        stateMap = new EnumMap(SupplicantState.class);
        stateMap.put(SupplicantState.DISCONNECTED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INTERFACE_DISABLED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INACTIVE, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.SCANNING, NetworkInfo.DetailedState.SCANNING);
        stateMap.put(SupplicantState.AUTHENTICATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATED, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.FOUR_WAY_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.GROUP_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.COMPLETED, NetworkInfo.DetailedState.OBTAINING_IPADDR);
        stateMap.put(SupplicantState.DORMANT, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.UNINITIALIZED, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.INVALID, NetworkInfo.DetailedState.FAILED);
        CREATOR = new Parcelable.Creator<WifiInfo>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WifiInfo createFromParcel(Parcel parcel) {
                WifiInfo wifiInfo = new WifiInfo();
                wifiInfo.setNetworkId(parcel.readInt());
                wifiInfo.setRssi(parcel.readInt());
                wifiInfo.setLinkSpeed(parcel.readInt());
                wifiInfo.setFrequency(parcel.readInt());
                if (parcel.readByte() == 1) {
                    try {
                        wifiInfo.setInetAddress(InetAddress.getByAddress(parcel.createByteArray()));
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
                if (parcel.readInt() == 1) {
                    WifiInfo.access$002(wifiInfo, WifiSsid.CREATOR.createFromParcel(parcel));
                }
                WifiInfo.access$102(wifiInfo, parcel.readString());
                WifiInfo.access$202(wifiInfo, parcel.readString());
                boolean bl = parcel.readInt() != 0;
                WifiInfo.access$302(wifiInfo, bl);
                wifiInfo.score = parcel.readInt();
                wifiInfo.txSuccessRate = parcel.readDouble();
                wifiInfo.txRetriesRate = parcel.readDouble();
                wifiInfo.txBadRate = parcel.readDouble();
                wifiInfo.rxSuccessRate = parcel.readDouble();
                wifiInfo.badRssiCount = parcel.readInt();
                wifiInfo.lowRssiCount = parcel.readInt();
                WifiInfo.access$402(wifiInfo, SupplicantState.CREATOR.createFromParcel(parcel));
                return wifiInfo;
            }

            public WifiInfo[] newArray(int n) {
                return new WifiInfo[n];
            }
        };
    }

    public WifiInfo() {
        this.mWifiSsid = null;
        this.mBSSID = null;
        this.mNetworkId = -1;
        this.mSupplicantState = SupplicantState.UNINITIALIZED;
        this.mRssi = -127;
        this.mLinkSpeed = -1;
        this.mFrequency = -1;
    }

    public WifiInfo(WifiInfo wifiInfo) {
        if (wifiInfo != null) {
            this.mSupplicantState = wifiInfo.mSupplicantState;
            this.mBSSID = wifiInfo.mBSSID;
            this.mWifiSsid = wifiInfo.mWifiSsid;
            this.mNetworkId = wifiInfo.mNetworkId;
            this.mRssi = wifiInfo.mRssi;
            this.mLinkSpeed = wifiInfo.mLinkSpeed;
            this.mFrequency = wifiInfo.mFrequency;
            this.mIpAddress = wifiInfo.mIpAddress;
            this.mMacAddress = wifiInfo.mMacAddress;
            this.mMeteredHint = wifiInfo.mMeteredHint;
            this.txBad = wifiInfo.txBad;
            this.txRetries = wifiInfo.txRetries;
            this.txSuccess = wifiInfo.txSuccess;
            this.rxSuccess = wifiInfo.rxSuccess;
            this.txBadRate = wifiInfo.txBadRate;
            this.txRetriesRate = wifiInfo.txRetriesRate;
            this.txSuccessRate = wifiInfo.txSuccessRate;
            this.rxSuccessRate = wifiInfo.rxSuccessRate;
            this.score = wifiInfo.score;
            this.badRssiCount = wifiInfo.badRssiCount;
            this.lowRssiCount = wifiInfo.lowRssiCount;
            this.linkStuckCount = wifiInfo.linkStuckCount;
        }
    }

    static /* synthetic */ WifiSsid access$002(WifiInfo wifiInfo, WifiSsid wifiSsid) {
        wifiInfo.mWifiSsid = wifiSsid;
        return wifiSsid;
    }

    static /* synthetic */ String access$102(WifiInfo wifiInfo, String string2) {
        wifiInfo.mBSSID = string2;
        return string2;
    }

    static /* synthetic */ String access$202(WifiInfo wifiInfo, String string2) {
        wifiInfo.mMacAddress = string2;
        return string2;
    }

    static /* synthetic */ boolean access$302(WifiInfo wifiInfo, boolean bl) {
        wifiInfo.mMeteredHint = bl;
        return bl;
    }

    static /* synthetic */ SupplicantState access$402(WifiInfo wifiInfo, SupplicantState supplicantState) {
        wifiInfo.mSupplicantState = supplicantState;
        return supplicantState;
    }

    public static NetworkInfo.DetailedState getDetailedStateOf(SupplicantState supplicantState) {
        return stateMap.get(supplicantState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String removeDoubleQuotes(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        if (n <= 1) return string2;
        if (string2.charAt(0) != '\"') return string2;
        if (string2.charAt(n - 1) != '\"') return string2;
        return string2.substring(1, n - 1);
    }

    static SupplicantState valueOf(String string2) {
        if ("4WAY_HANDSHAKE".equalsIgnoreCase(string2)) {
            return SupplicantState.FOUR_WAY_HANDSHAKE;
        }
        try {
            SupplicantState supplicantState = SupplicantState.valueOf(string2.toUpperCase(Locale.ROOT));
            return supplicantState;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return SupplicantState.INVALID;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getBSSID() {
        return this.mBSSID;
    }

    public int getFrequency() {
        return this.mFrequency;
    }

    public boolean getHiddenSSID() {
        if (this.mWifiSsid == null) {
            return false;
        }
        return this.mWifiSsid.isHidden();
    }

    public int getIpAddress() {
        boolean bl = this.mIpAddress instanceof Inet4Address;
        int n = 0;
        if (bl) {
            n = NetworkUtils.inetAddressToInt((Inet4Address)this.mIpAddress);
        }
        return n;
    }

    public int getLinkSpeed() {
        return this.mLinkSpeed;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    public boolean getMeteredHint() {
        return this.mMeteredHint;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public String getSSID() {
        if (this.mWifiSsid != null) {
            String string2 = this.mWifiSsid.toString();
            if (!TextUtils.isEmpty(string2)) {
                return "\"" + string2 + "\"";
            }
            return this.mWifiSsid.getHexString();
        }
        return "<unknown ssid>";
    }

    public SupplicantState getSupplicantState() {
        return this.mSupplicantState;
    }

    public WifiSsid getWifiSsid() {
        return this.mWifiSsid;
    }

    public boolean is24GHz() {
        return ScanResult.is24GHz(this.mFrequency);
    }

    public boolean is5GHz() {
        return ScanResult.is5GHz(this.mFrequency);
    }

    public void reset() {
        this.setInetAddress(null);
        this.setBSSID(null);
        this.setSSID(null);
        this.setNetworkId(-1);
        this.setRssi(-127);
        this.setLinkSpeed(-1);
        this.setFrequency(-1);
        this.setMeteredHint(false);
        this.txBad = 0L;
        this.txSuccess = 0L;
        this.rxSuccess = 0L;
        this.txRetries = 0L;
        this.txBadRate = 0.0;
        this.txSuccessRate = 0.0;
        this.rxSuccessRate = 0.0;
        this.txRetriesRate = 0.0;
        this.lowRssiCount = 0;
        this.badRssiCount = 0;
        this.linkStuckCount = 0;
        this.score = 0;
    }

    public void setBSSID(String string2) {
        this.mBSSID = string2;
    }

    public void setFrequency(int n) {
        this.mFrequency = n;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.mIpAddress = inetAddress;
    }

    public void setLinkSpeed(int n) {
        this.mLinkSpeed = n;
    }

    public void setMacAddress(String string2) {
        this.mMacAddress = string2;
    }

    public void setMeteredHint(boolean bl) {
        this.mMeteredHint = bl;
    }

    public void setNetworkId(int n) {
        this.mNetworkId = n;
    }

    public void setRssi(int n) {
        if (n < -127) {
            n = -127;
        }
        if (n > 200) {
            n = 200;
        }
        this.mRssi = n;
    }

    public void setSSID(WifiSsid wifiSsid) {
        this.mWifiSsid = wifiSsid;
    }

    public void setSupplicantState(SupplicantState supplicantState) {
        this.mSupplicantState = supplicantState;
    }

    void setSupplicantState(String string2) {
        this.mSupplicantState = WifiInfo.valueOf(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = "<none>";
        StringBuffer stringBuffer2 = stringBuffer.append("SSID: ");
        Object object2 = this.mWifiSsid == null ? "<unknown ssid>" : this.mWifiSsid;
        StringBuffer stringBuffer3 = stringBuffer2.append(object2).append(", BSSID: ");
        Object object3 = this.mBSSID == null ? object : this.mBSSID;
        StringBuffer stringBuffer4 = stringBuffer3.append((String)object3).append(", MAC: ");
        Object object4 = this.mMacAddress == null ? object : this.mMacAddress;
        StringBuffer stringBuffer5 = stringBuffer4.append((String)object4).append(", Supplicant state: ");
        if (this.mSupplicantState != null) {
            object = this.mSupplicantState;
        }
        stringBuffer5.append(object).append(", RSSI: ").append(this.mRssi).append(", Link speed: ").append(this.mLinkSpeed).append(LINK_SPEED_UNITS).append(", Frequency: ").append(this.mFrequency).append(FREQUENCY_UNITS).append(", Net ID: ").append(this.mNetworkId).append(", Metered hint: ").append(this.mMeteredHint).append(", score: ").append(Integer.toString(this.score));
        return stringBuffer.toString();
    }

    public void updatePacketRates(long l, long l2) {
        this.txBad = 0L;
        this.txRetries = 0L;
        this.txBadRate = 0.0;
        this.txRetriesRate = 0.0;
        this.txSuccessRate = 0.5 * this.txSuccessRate + 0.5 * (double)(l - this.txSuccess);
        this.rxSuccessRate = 0.5 * this.rxSuccessRate + 0.5 * (double)(l2 - this.rxSuccess);
        this.txSuccess = l;
        this.rxSuccess = l2;
    }

    public void updatePacketRates(WifiLinkLayerStats wifiLinkLayerStats) {
        if (wifiLinkLayerStats != null) {
            long l = wifiLinkLayerStats.txmpdu_be + wifiLinkLayerStats.txmpdu_bk + wifiLinkLayerStats.txmpdu_vi + wifiLinkLayerStats.txmpdu_vo;
            long l2 = wifiLinkLayerStats.retries_be + wifiLinkLayerStats.retries_bk + wifiLinkLayerStats.retries_vi + wifiLinkLayerStats.retries_vo;
            long l3 = wifiLinkLayerStats.rxmpdu_be + wifiLinkLayerStats.rxmpdu_bk + wifiLinkLayerStats.rxmpdu_vi + wifiLinkLayerStats.rxmpdu_vo;
            long l4 = wifiLinkLayerStats.lostmpdu_be + wifiLinkLayerStats.lostmpdu_bk + wifiLinkLayerStats.lostmpdu_vi + wifiLinkLayerStats.lostmpdu_vo;
            this.txBadRate = 0.5 * this.txBadRate + 0.5 * (double)(l4 - this.txBad);
            this.txSuccessRate = 0.5 * this.txSuccessRate + 0.5 * (double)(l - this.txSuccess);
            this.rxSuccessRate = 0.5 * this.rxSuccessRate + 0.5 * (double)(l3 - this.rxSuccess);
            this.txRetriesRate = 0.5 * this.txRetriesRate + 0.5 * (double)(l2 - this.txRetries);
            this.txBad = l4;
            this.txSuccess = l;
            this.rxSuccess = l3;
            this.txRetries = l2;
            return;
        }
        this.txBad = 0L;
        this.txSuccess = 0L;
        this.rxSuccess = 0L;
        this.txRetries = 0L;
        this.txBadRate = 0.0;
        this.txSuccessRate = 0.0;
        this.rxSuccessRate = 0.0;
        this.txRetriesRate = 0.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        byte by = 1;
        parcel.writeInt(this.mNetworkId);
        parcel.writeInt(this.mRssi);
        parcel.writeInt(this.mLinkSpeed);
        parcel.writeInt(this.mFrequency);
        if (this.mIpAddress != null) {
            parcel.writeByte(by);
            parcel.writeByteArray(this.mIpAddress.getAddress());
        } else {
            parcel.writeByte((byte)0);
        }
        if (this.mWifiSsid != null) {
            parcel.writeInt(by);
            this.mWifiSsid.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString(this.mBSSID);
        parcel.writeString(this.mMacAddress);
        if (!this.mMeteredHint) {
            by = 0;
        }
        parcel.writeInt(by);
        parcel.writeInt(this.score);
        parcel.writeDouble(this.txSuccessRate);
        parcel.writeDouble(this.txRetriesRate);
        parcel.writeDouble(this.txBadRate);
        parcel.writeDouble(this.rxSuccessRate);
        parcel.writeInt(this.badRssiCount);
        parcel.writeInt(this.lowRssiCount);
        this.mSupplicantState.writeToParcel(parcel, n);
    }
}

