/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.SslCertificate;
import java.security.cert.X509Certificate;

public class SslError {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final int SSL_DATE_INVALID = 4;
    public static final int SSL_EXPIRED = 1;
    public static final int SSL_IDMISMATCH = 2;
    public static final int SSL_INVALID = 5;
    @Deprecated
    public static final int SSL_MAX_ERROR = 6;
    public static final int SSL_NOTYETVALID = 0;
    public static final int SSL_UNTRUSTED = 3;
    final SslCertificate mCertificate;
    int mErrors;
    final String mUrl;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !SslError.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    @Deprecated
    public SslError(int n, SslCertificate sslCertificate) {
        this(n, sslCertificate, "");
    }

    public SslError(int n, SslCertificate sslCertificate, String string2) {
        if (!$assertionsDisabled && sslCertificate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        this.addError(n);
        this.mCertificate = sslCertificate;
        this.mUrl = string2;
    }

    @Deprecated
    public SslError(int n, X509Certificate x509Certificate) {
        this(n, x509Certificate, "");
    }

    public SslError(int n, X509Certificate x509Certificate, String string2) {
        this(n, new SslCertificate(x509Certificate), string2);
    }

    public static SslError SslErrorFromChromiumErrorCode(int n, SslCertificate sslCertificate, String string2) {
        if (!($assertionsDisabled || n >= -299 && n <= -200)) {
            throw new AssertionError();
        }
        if (n == -200) {
            return new SslError(2, sslCertificate, string2);
        }
        if (n == -201) {
            return new SslError(4, sslCertificate, string2);
        }
        if (n == -202) {
            return new SslError(3, sslCertificate, string2);
        }
        return new SslError(5, sslCertificate, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addError(int n) {
        if (n < 0) return false;
        if (n >= 6) return false;
        boolean bl = true;
        if (!bl) return bl;
        this.mErrors |= 1 << n;
        return bl;
    }

    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    public int getPrimaryError() {
        if (this.mErrors != 0) {
            for (int i = 5; i >= 0; --i) {
                if ((this.mErrors & 1 << i) == 0) continue;
                return i;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return -1;
    }

    public String getUrl() {
        return this.mUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasError(int n) {
        if (n < 0) return false;
        if (n >= 6) return false;
        boolean bl = true;
        if (!bl) return bl;
        if ((this.mErrors & 1 << n) == 0) return false;
        return true;
    }

    public String toString() {
        return "primary error: " + this.getPrimaryError() + " certificate: " + this.getCertificate() + " on URL: " + this.getUrl();
    }
}

