/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.ParseException;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.EventHandler;
import android.net.http.Request;
import android.net.http.RequestQueue;
import android.webkit.CookieManager;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.codec.binary.Base64;

public class RequestHandle {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    public static final int MAX_REDIRECT_COUNT = 16;
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    private int mBodyLength;
    private InputStream mBodyProvider;
    private Connection mConnection;
    private Map<String, String> mHeaders;
    private String mMethod;
    private int mRedirectCount = 0;
    private Request mRequest;
    private RequestQueue mRequestQueue;
    private WebAddress mUri;
    private String mUrl;

    public RequestHandle(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        this.mHeaders = map;
        this.mBodyProvider = inputStream;
        this.mBodyLength = n;
        if (string3 == null) {
            string3 = "GET";
        }
        this.mMethod = string3;
        this.mUrl = string2;
        this.mUri = webAddress;
        this.mRequestQueue = requestQueue;
        this.mRequest = request;
    }

    public RequestHandle(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request, Connection connection) {
        this(requestQueue, string2, webAddress, string3, map, inputStream, n, request);
        this.mConnection = connection;
    }

    private String H(String string2) {
        block4: {
            if (string2 != null) {
                byte[] byArray;
                try {
                    byArray = MessageDigest.getInstance("MD5").digest(string2.getBytes());
                    if (byArray == null) break block4;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(noSuchAlgorithmException);
                }
                String string3 = this.bufferToHex(byArray);
                return string3;
            }
        }
        return null;
    }

    private String KD(String string2, String string3) {
        return this.H(string2 + ":" + string3);
    }

    public static String authorizationHeader(boolean bl) {
        if (!bl) {
            return AUTHORIZATION_HEADER;
        }
        return PROXY_AUTHORIZATION_HEADER;
    }

    private String bufferToHex(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (byArray != null) {
            int n = byArray.length;
            if (n > 0) {
                StringBuilder stringBuilder = new StringBuilder(n * 2);
                for (int i = 0; i < n; ++i) {
                    byte by = (byte)(0xF & byArray[i]);
                    stringBuilder.append(cArray[(byte)((0xF0 & byArray[i]) >> 4)]);
                    stringBuilder.append(cArray[by]);
                }
                return stringBuilder.toString();
            }
            return "";
        }
        return null;
    }

    public static String computeBasicAuthResponse(String string2, String string3) {
        Assert.assertNotNull(string2);
        Assert.assertNotNull(string3);
        return new String(Base64.encodeBase64((byte[])(string2 + ':' + string3).getBytes()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String computeCnonce() {
        int n;
        int n2 = new Random().nextInt();
        if (n2 == Integer.MIN_VALUE) {
            n = Integer.MAX_VALUE;
            return Integer.toString(n, 16);
        }
        n = Math.abs(n2);
        return Integer.toString(n, 16);
    }

    private String computeDigest(String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string5 == null) {
            return this.KD(this.H(string2), string4 + ":" + this.H(string3));
        }
        if (string5.equalsIgnoreCase("auth")) {
            return this.KD(this.H(string2), string4 + ":" + string6 + ":" + string7 + ":" + string5 + ":" + this.H(string3));
        }
        return null;
    }

    private String computeDigestAuthResponse(String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Assert.assertNotNull(string2);
        Assert.assertNotNull(string3);
        Assert.assertNotNull(string4);
        String string9 = string2 + ":" + string4 + ":" + string3;
        String string10 = this.mMethod + ":" + this.mUrl;
        String string11 = this.computeCnonce();
        String string12 = this.computeDigest(string9, string10, string5, string6, "00000001", string11);
        String string13 = "" + "username=" + this.doubleQuote(string2) + ", ";
        String string14 = string13 + "realm=" + this.doubleQuote(string4) + ", ";
        String string15 = string14 + "nonce=" + this.doubleQuote(string5) + ", ";
        String string16 = string15 + "uri=" + this.doubleQuote(this.mUrl) + ", ";
        String string17 = string16 + "response=" + this.doubleQuote(string12);
        if (string8 != null) {
            string17 = string17 + ", opaque=" + this.doubleQuote(string8);
        }
        if (string7 != null) {
            string17 = string17 + ", algorithm=" + string7;
        }
        if (string6 != null) {
            string17 = string17 + ", qop=" + string6 + ", nc=" + "00000001" + ", cnonce=" + this.doubleQuote(string11);
        }
        return string17;
    }

    private void createAndQueueNewRequest() {
        if (this.mConnection != null) {
            RequestHandle requestHandle = this.mRequestQueue.queueSynchronousRequest(this.mUrl, this.mUri, this.mMethod, this.mHeaders, this.mRequest.mEventHandler, this.mBodyProvider, this.mBodyLength);
            this.mRequest = requestHandle.mRequest;
            this.mConnection = requestHandle.mConnection;
            requestHandle.processRequest();
            return;
        }
        this.mRequest = this.mRequestQueue.queueRequest((String)this.mUrl, (WebAddress)this.mUri, (String)this.mMethod, this.mHeaders, (EventHandler)this.mRequest.mEventHandler, (InputStream)this.mBodyProvider, (int)this.mBodyLength).mRequest;
    }

    private String doubleQuote(String string2) {
        if (string2 != null) {
            return "\"" + string2 + "\"";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupAuthResponse() {
        try {
            if (this.mBodyProvider != null) {
                this.mBodyProvider.reset();
            }
        }
        catch (IOException iOException) {}
        this.createAndQueueNewRequest();
    }

    public void cancel() {
        if (this.mRequest != null) {
            this.mRequest.cancel();
        }
    }

    public String getMethod() {
        return this.mMethod;
    }

    public int getRedirectCount() {
        return this.mRedirectCount;
    }

    public void handleSslErrorResponse(boolean bl) {
        if (this.mRequest != null) {
            this.mRequest.handleSslErrorResponse(bl);
        }
    }

    public boolean isRedirectMax() {
        return this.mRedirectCount >= 16;
    }

    public void pauseRequest(boolean bl) {
        if (this.mRequest != null) {
            this.mRequest.setLoadingPaused(bl);
        }
    }

    public void processRequest() {
        if (this.mConnection != null) {
            this.mConnection.processRequests(this.mRequest);
        }
    }

    public void setRedirectCount(int n) {
        this.mRedirectCount = n;
    }

    public void setupBasicAuthResponse(boolean bl, String string2, String string3) {
        String string4 = RequestHandle.computeBasicAuthResponse(string2, string3);
        this.mHeaders.put(RequestHandle.authorizationHeader(bl), "Basic " + string4);
        this.setupAuthResponse();
    }

    public void setupDigestAuthResponse(boolean bl, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = this.computeDigestAuthResponse(string2, string3, string4, string5, string6, string7, string8);
        this.mHeaders.put(RequestHandle.authorizationHeader(bl), "Digest " + string9);
        this.setupAuthResponse();
    }

    /*
     * Unable to fully structure code
     */
    public boolean setupRedirect(String var1_1, int var2_2, Map<String, String> var3_3) {
        block10: {
            this.mHeaders.remove("Authorization");
            this.mHeaders.remove("Proxy-Authorization");
            this.mRedirectCount = var6_4 = 1 + this.mRedirectCount;
            if (var6_4 == 16) {
                this.mRequest.error(-9, 17039578);
                return false;
            }
            if (this.mUrl.startsWith("https:") && var1_1.startsWith("http:")) {
                this.mHeaders.remove("Referer");
            }
            this.mUrl = var1_1;
            try {
                this.mUri = new WebAddress(this.mUrl);
            }
            catch (ParseException var7_6) {
                var7_6.printStackTrace();
                ** continue;
            }
lbl15:
            // 2 sources

            while (true) {
                block11: {
                    this.mHeaders.remove("Cookie");
                    var9_5 = CookieManager.getInstance().getCookie(this.mUri);
                    if (var9_5 != null && var9_5.length() > 0) {
                        this.mHeaders.put("Cookie", var9_5);
                    }
                    if ((var2_2 == 302 || var2_2 == 303) && this.mMethod.equals("POST")) {
                        this.mMethod = "GET";
                    }
                    if (var2_2 != 307) break block10;
                    if (this.mBodyProvider == null) break block11;
                    this.mBodyProvider.reset();
                }
lbl29:
                // 2 sources

                while (true) {
                    this.mHeaders.putAll(var3_3);
                    this.createAndQueueNewRequest();
                    return true;
                }
                break;
            }
            catch (IOException var11_7) {
                return false;
            }
        }
        this.mHeaders.remove("Content-Type");
        this.mBodyProvider = null;
        ** while (true)
    }

    public void waitUntilComplete() {
        this.mRequest.waitUntilComplete();
    }
}

