/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.NetworkStats;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.server.NetworkManagementSocketTagger;
import dalvik.system.SocketTagger;
import java.net.Socket;
import java.net.SocketException;

public class TrafficStats {
    public static final long GB_IN_BYTES = 0x40000000L;
    public static final long KB_IN_BYTES = 1024L;
    public static final long MB_IN_BYTES = 0x100000L;
    public static final int TAG_SYSTEM_BACKUP = -253;
    public static final int TAG_SYSTEM_DOWNLOAD = -255;
    public static final int TAG_SYSTEM_MEDIA = -254;
    private static final int TYPE_RX_BYTES = 0;
    private static final int TYPE_RX_PACKETS = 1;
    private static final int TYPE_TCP_RX_PACKETS = 4;
    private static final int TYPE_TCP_TX_PACKETS = 5;
    private static final int TYPE_TX_BYTES = 2;
    private static final int TYPE_TX_PACKETS = 3;
    public static final int UID_REMOVED = -4;
    public static final int UID_TETHERING = -5;
    public static final int UNSUPPORTED = -1;
    private static NetworkStats sActiveProfilingStart;
    private static Object sProfilingLock;
    private static INetworkStatsService sStatsService;

    static {
        sProfilingLock = new Object();
    }

    public static void clearThreadStatsTag() {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(-1);
    }

    public static void clearThreadStatsUid() {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(-1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeQuietly(INetworkStatsSession iNetworkStatsSession) {
        if (iNetworkStatsSession == null) return;
        try {
            iNetworkStatsSession.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static NetworkStats getDataLayerSnapshotForUid(Context context) {
        int n = Process.myUid();
        try {
            NetworkStats networkStats = TrafficStats.getStatsService().getDataLayerSnapshotForUid(n);
            return networkStats;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    private static String[] getMobileIfaces() {
        try {
            String[] stringArray = TrafficStats.getStatsService().getMobileIfaces();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public static long getMobileRxBytes() {
        long l = 0L;
        String[] stringArray = TrafficStats.getMobileIfaces();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            l += TrafficStats.getRxBytes(stringArray[i]);
        }
        return l;
    }

    public static long getMobileRxPackets() {
        long l = 0L;
        String[] stringArray = TrafficStats.getMobileIfaces();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            l += TrafficStats.getRxPackets(stringArray[i]);
        }
        return l;
    }

    public static long getMobileTcpRxPackets() {
        long l = 0L;
        String[] stringArray = TrafficStats.getMobileIfaces();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            long l2 = TrafficStats.nativeGetIfaceStat(stringArray[i], 4);
            if (l2 == -1L) continue;
            l += l2;
        }
        return l;
    }

    public static long getMobileTcpTxPackets() {
        long l = 0L;
        String[] stringArray = TrafficStats.getMobileIfaces();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            long l2 = TrafficStats.nativeGetIfaceStat(stringArray[i], 5);
            if (l2 == -1L) continue;
            l += l2;
        }
        return l;
    }

    public static long getMobileTxBytes() {
        long l = 0L;
        String[] stringArray = TrafficStats.getMobileIfaces();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            l += TrafficStats.getTxBytes(stringArray[i]);
        }
        return l;
    }

    public static long getMobileTxPackets() {
        long l = 0L;
        String[] stringArray = TrafficStats.getMobileIfaces();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            l += TrafficStats.getTxPackets(stringArray[i]);
        }
        return l;
    }

    public static long getRxBytes(String string2) {
        return TrafficStats.nativeGetIfaceStat(string2, 0);
    }

    public static long getRxPackets(String string2) {
        return TrafficStats.nativeGetIfaceStat(string2, 1);
    }

    private static INetworkStatsService getStatsService() {
        synchronized (TrafficStats.class) {
            if (sStatsService == null) {
                sStatsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
            }
            INetworkStatsService iNetworkStatsService = sStatsService;
            return iNetworkStatsService;
        }
    }

    public static int getThreadStatsTag() {
        return NetworkManagementSocketTagger.getThreadSocketStatsTag();
    }

    public static long getTotalRxBytes() {
        return TrafficStats.nativeGetTotalStat(0);
    }

    public static long getTotalRxPackets() {
        return TrafficStats.nativeGetTotalStat(1);
    }

    public static long getTotalTxBytes() {
        return TrafficStats.nativeGetTotalStat(2);
    }

    public static long getTotalTxPackets() {
        return TrafficStats.nativeGetTotalStat(3);
    }

    public static long getTxBytes(String string2) {
        return TrafficStats.nativeGetIfaceStat(string2, 2);
    }

    public static long getTxPackets(String string2) {
        return TrafficStats.nativeGetIfaceStat(string2, 3);
    }

    public static long getUidRxBytes(int n) {
        return TrafficStats.nativeGetUidStat(n, 0);
    }

    public static long getUidRxPackets(int n) {
        return TrafficStats.nativeGetUidStat(n, 1);
    }

    @Deprecated
    public static long getUidTcpRxBytes(int n) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpRxSegments(int n) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpTxBytes(int n) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpTxSegments(int n) {
        return -1L;
    }

    public static long getUidTxBytes(int n) {
        return TrafficStats.nativeGetUidStat(n, 2);
    }

    public static long getUidTxPackets(int n) {
        return TrafficStats.nativeGetUidStat(n, 3);
    }

    @Deprecated
    public static long getUidUdpRxBytes(int n) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpRxPackets(int n) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxBytes(int n) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxPackets(int n) {
        return -1L;
    }

    public static void incrementOperationCount(int n) {
        TrafficStats.incrementOperationCount(TrafficStats.getThreadStatsTag(), n);
    }

    public static void incrementOperationCount(int n, int n2) {
        int n3 = Process.myUid();
        try {
            TrafficStats.getStatsService().incrementOperationCount(n3, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    private static native long nativeGetIfaceStat(String var0, int var1);

    private static native long nativeGetTotalStat(int var0);

    private static native long nativeGetUidStat(int var0, int var1);

    public static void setThreadStatsTag(int n) {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(n);
    }

    public static void setThreadStatsTagBackup() {
        TrafficStats.setThreadStatsTag(-253);
    }

    public static void setThreadStatsUid(int n) {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart != null) {
                throw new IllegalStateException("already profiling data");
            }
            sActiveProfilingStart = TrafficStats.getDataLayerSnapshotForUid(context);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NetworkStats stopDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart == null) {
                throw new IllegalStateException("not profiling data");
            }
            NetworkStats networkStats = NetworkStats.subtract(TrafficStats.getDataLayerSnapshotForUid(context), sActiveProfilingStart, null, null);
            sActiveProfilingStart = null;
            return networkStats;
        }
    }

    public static void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }
}

