/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkTemplate;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class NetworkPolicy
implements Parcelable,
Comparable<NetworkPolicy> {
    public static final Parcelable.Creator<NetworkPolicy> CREATOR = new Parcelable.Creator<NetworkPolicy>(){

        @Override
        public NetworkPolicy createFromParcel(Parcel parcel) {
            return new NetworkPolicy(parcel);
        }

        public NetworkPolicy[] newArray(int n) {
            return new NetworkPolicy[n];
        }
    };
    public static final int CYCLE_NONE = -1;
    private static final long DEFAULT_MTU = 1500L;
    public static final long LIMIT_DISABLED = -1L;
    public static final long SNOOZE_NEVER = -1L;
    public static final long WARNING_DISABLED = -1L;
    public int cycleDay;
    public String cycleTimezone;
    public boolean inferred;
    public long lastLimitSnooze;
    public long lastWarningSnooze;
    public long limitBytes;
    public boolean metered;
    public final NetworkTemplate template;
    public long warningBytes;

    public NetworkPolicy(NetworkTemplate networkTemplate, int n, String string2, long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        this.template = Preconditions.checkNotNull(networkTemplate, "missing NetworkTemplate");
        this.cycleDay = n;
        this.cycleTimezone = Preconditions.checkNotNull(string2, "missing cycleTimezone");
        this.warningBytes = l;
        this.limitBytes = l2;
        this.lastWarningSnooze = l3;
        this.lastLimitSnooze = l4;
        this.metered = bl;
        this.inferred = bl2;
    }

    @Deprecated
    public NetworkPolicy(NetworkTemplate networkTemplate, int n, String string2, long l, long l2, boolean bl) {
        this(networkTemplate, n, string2, l, l2, -1L, -1L, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public NetworkPolicy(Parcel parcel) {
        boolean bl = true;
        this.template = (NetworkTemplate)parcel.readParcelable(null);
        this.cycleDay = parcel.readInt();
        this.cycleTimezone = parcel.readString();
        this.warningBytes = parcel.readLong();
        this.limitBytes = parcel.readLong();
        this.lastWarningSnooze = parcel.readLong();
        this.lastLimitSnooze = parcel.readLong();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.metered = bl2;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.inferred = bl;
    }

    public void clearSnooze() {
        this.lastWarningSnooze = -1L;
        this.lastLimitSnooze = -1L;
    }

    @Override
    public int compareTo(NetworkPolicy networkPolicy) {
        if (networkPolicy == null || networkPolicy.limitBytes == -1L) {
            return -1;
        }
        if (this.limitBytes == -1L || networkPolicy.limitBytes < this.limitBytes) {
            return 1;
        }
        return 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof NetworkPolicy;
        boolean bl2 = false;
        if (bl) {
            NetworkPolicy networkPolicy = (NetworkPolicy)object;
            int n = this.cycleDay;
            int n2 = networkPolicy.cycleDay;
            bl2 = false;
            if (n == n2) {
                long l = this.warningBytes - networkPolicy.warningBytes;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                bl2 = false;
                if (l2 == false) {
                    long l3 = this.limitBytes - networkPolicy.limitBytes;
                    long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                    bl2 = false;
                    if (l4 == false) {
                        long l5 = this.lastWarningSnooze - networkPolicy.lastWarningSnooze;
                        long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                        bl2 = false;
                        if (l6 == false) {
                            long l7 = this.lastLimitSnooze - networkPolicy.lastLimitSnooze;
                            long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
                            bl2 = false;
                            if (l8 == false) {
                                boolean bl3 = this.metered;
                                boolean bl4 = networkPolicy.metered;
                                bl2 = false;
                                if (bl3 == bl4) {
                                    boolean bl5 = this.inferred;
                                    boolean bl6 = networkPolicy.inferred;
                                    bl2 = false;
                                    if (bl5 == bl6) {
                                        boolean bl7 = Objects.equals(this.cycleTimezone, networkPolicy.cycleTimezone);
                                        bl2 = false;
                                        if (bl7) {
                                            boolean bl8 = Objects.equals(this.template, networkPolicy.template);
                                            bl2 = false;
                                            if (bl8) {
                                                bl2 = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public boolean hasCycle() {
        return this.cycleDay != -1;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.template, this.cycleDay, this.cycleTimezone, this.warningBytes, this.limitBytes, this.lastWarningSnooze, this.lastLimitSnooze, this.metered, this.inferred};
        return Objects.hash(objectArray);
    }

    public boolean isOverLimit(long l) {
        long l2 = l + 3000L;
        return this.limitBytes != -1L && l2 >= this.limitBytes;
    }

    public boolean isOverWarning(long l) {
        return this.warningBytes != -1L && l >= this.warningBytes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NetworkPolicy");
        stringBuilder.append("[").append(this.template).append("]:");
        stringBuilder.append(" cycleDay=").append(this.cycleDay);
        stringBuilder.append(", cycleTimezone=").append(this.cycleTimezone);
        stringBuilder.append(", warningBytes=").append(this.warningBytes);
        stringBuilder.append(", limitBytes=").append(this.limitBytes);
        stringBuilder.append(", lastWarningSnooze=").append(this.lastWarningSnooze);
        stringBuilder.append(", lastLimitSnooze=").append(this.lastLimitSnooze);
        stringBuilder.append(", metered=").append(this.metered);
        stringBuilder.append(", inferred=").append(this.inferred);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeParcelable(this.template, n);
        parcel.writeInt(this.cycleDay);
        parcel.writeString(this.cycleTimezone);
        parcel.writeLong(this.warningBytes);
        parcel.writeLong(this.limitBytes);
        parcel.writeLong(this.lastWarningSnooze);
        parcel.writeLong(this.lastLimitSnooze);
        int n3 = this.metered ? n2 : 0;
        parcel.writeInt(n3);
        if (!this.inferred) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

