/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityManager;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.EnumMap;

public class NetworkInfo
implements Parcelable {
    public static final Parcelable.Creator<NetworkInfo> CREATOR;
    private static final EnumMap<DetailedState, State> stateMap;
    private DetailedState mDetailedState;
    private String mExtraInfo;
    private boolean mIsAvailable;
    private boolean mIsConnectedToProvisioningNetwork;
    private boolean mIsFailover;
    private boolean mIsRoaming;
    private int mNetworkType;
    private String mReason;
    private State mState;
    private int mSubtype;
    private String mSubtypeName;
    private String mTypeName;

    static {
        stateMap = new EnumMap(DetailedState.class);
        stateMap.put(DetailedState.IDLE, State.DISCONNECTED);
        stateMap.put(DetailedState.SCANNING, State.DISCONNECTED);
        stateMap.put(DetailedState.CONNECTING, State.CONNECTING);
        stateMap.put(DetailedState.AUTHENTICATING, State.CONNECTING);
        stateMap.put(DetailedState.OBTAINING_IPADDR, State.CONNECTING);
        stateMap.put(DetailedState.VERIFYING_POOR_LINK, State.CONNECTING);
        stateMap.put(DetailedState.CAPTIVE_PORTAL_CHECK, State.CONNECTING);
        stateMap.put(DetailedState.CONNECTED, State.CONNECTED);
        stateMap.put(DetailedState.SUSPENDED, State.SUSPENDED);
        stateMap.put(DetailedState.DISCONNECTING, State.DISCONNECTING);
        stateMap.put(DetailedState.DISCONNECTED, State.DISCONNECTED);
        stateMap.put(DetailedState.FAILED, State.DISCONNECTED);
        stateMap.put(DetailedState.BLOCKED, State.DISCONNECTED);
        CREATOR = new Parcelable.Creator<NetworkInfo>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public NetworkInfo createFromParcel(Parcel parcel) {
                boolean bl = true;
                NetworkInfo networkInfo = new NetworkInfo(parcel.readInt(), parcel.readInt(), parcel.readString(), parcel.readString());
                NetworkInfo.access$002(networkInfo, State.valueOf(parcel.readString()));
                NetworkInfo.access$102(networkInfo, DetailedState.valueOf(parcel.readString()));
                boolean bl2 = parcel.readInt() != 0 ? bl : false;
                NetworkInfo.access$202(networkInfo, bl2);
                boolean bl3 = parcel.readInt() != 0 ? bl : false;
                NetworkInfo.access$302(networkInfo, bl3);
                boolean bl4 = parcel.readInt() != 0 ? bl : false;
                NetworkInfo.access$402(networkInfo, bl4);
                if (parcel.readInt() == 0) {
                    bl = false;
                }
                NetworkInfo.access$502(networkInfo, bl);
                NetworkInfo.access$602(networkInfo, parcel.readString());
                NetworkInfo.access$702(networkInfo, parcel.readString());
                return networkInfo;
            }

            public NetworkInfo[] newArray(int n) {
                return new NetworkInfo[n];
            }
        };
    }

    public NetworkInfo(int n, int n2, String string2, String string3) {
        if (!ConnectivityManager.isNetworkTypeValid(n)) {
            throw new IllegalArgumentException("Invalid network type: " + n);
        }
        this.mNetworkType = n;
        this.mSubtype = n2;
        this.mTypeName = string2;
        this.mSubtypeName = string3;
        this.setDetailedState(DetailedState.IDLE, null, null);
        this.mState = State.UNKNOWN;
        this.mIsAvailable = false;
        this.mIsRoaming = false;
        this.mIsConnectedToProvisioningNetwork = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkInfo(NetworkInfo networkInfo) {
        if (networkInfo != null) {
            synchronized (networkInfo) {
                this.mNetworkType = networkInfo.mNetworkType;
                this.mSubtype = networkInfo.mSubtype;
                this.mTypeName = networkInfo.mTypeName;
                this.mSubtypeName = networkInfo.mSubtypeName;
                this.mState = networkInfo.mState;
                this.mDetailedState = networkInfo.mDetailedState;
                this.mReason = networkInfo.mReason;
                this.mExtraInfo = networkInfo.mExtraInfo;
                this.mIsFailover = networkInfo.mIsFailover;
                this.mIsRoaming = networkInfo.mIsRoaming;
                this.mIsAvailable = networkInfo.mIsAvailable;
                this.mIsConnectedToProvisioningNetwork = networkInfo.mIsConnectedToProvisioningNetwork;
                return;
            }
        }
    }

    static /* synthetic */ State access$002(NetworkInfo networkInfo, State state) {
        networkInfo.mState = state;
        return state;
    }

    static /* synthetic */ DetailedState access$102(NetworkInfo networkInfo, DetailedState detailedState) {
        networkInfo.mDetailedState = detailedState;
        return detailedState;
    }

    static /* synthetic */ boolean access$202(NetworkInfo networkInfo, boolean bl) {
        networkInfo.mIsFailover = bl;
        return bl;
    }

    static /* synthetic */ boolean access$302(NetworkInfo networkInfo, boolean bl) {
        networkInfo.mIsAvailable = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(NetworkInfo networkInfo, boolean bl) {
        networkInfo.mIsRoaming = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(NetworkInfo networkInfo, boolean bl) {
        networkInfo.mIsConnectedToProvisioningNetwork = bl;
        return bl;
    }

    static /* synthetic */ String access$602(NetworkInfo networkInfo, String string2) {
        networkInfo.mReason = string2;
        return string2;
    }

    static /* synthetic */ String access$702(NetworkInfo networkInfo, String string2) {
        networkInfo.mExtraInfo = string2;
        return string2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DetailedState getDetailedState() {
        synchronized (this) {
            return this.mDetailedState;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getExtraInfo() {
        synchronized (this) {
            return this.mExtraInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getReason() {
        synchronized (this) {
            return this.mReason;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public State getState() {
        synchronized (this) {
            return this.mState;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSubtype() {
        synchronized (this) {
            return this.mSubtype;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSubtypeName() {
        synchronized (this) {
            return this.mSubtypeName;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getType() {
        synchronized (this) {
            return this.mNetworkType;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTypeName() {
        synchronized (this) {
            return this.mTypeName;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAvailable() {
        synchronized (this) {
            return this.mIsAvailable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        synchronized (this) {
            if (this.mState != State.CONNECTED) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnectedOrConnecting() {
        synchronized (this) {
            if (this.mState == State.CONNECTED) return true;
            if (this.mState != State.CONNECTING) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnectedToProvisioningNetwork() {
        synchronized (this) {
            return this.mIsConnectedToProvisioningNetwork;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFailover() {
        synchronized (this) {
            return this.mIsFailover;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRoaming() {
        synchronized (this) {
            return this.mIsRoaming;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDetailedState(DetailedState detailedState, String string2, String string3) {
        synchronized (this) {
            this.mDetailedState = detailedState;
            this.mState = stateMap.get((Object)detailedState);
            this.mReason = string2;
            this.mExtraInfo = string3;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setExtraInfo(String string2) {
        synchronized (this) {
            this.mExtraInfo = string2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFailover(boolean bl) {
        synchronized (this) {
            this.mIsFailover = bl;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIsAvailable(boolean bl) {
        synchronized (this) {
            this.mIsAvailable = bl;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIsConnectedToProvisioningNetwork(boolean bl) {
        synchronized (this) {
            this.mIsConnectedToProvisioningNetwork = bl;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRoaming(boolean bl) {
        synchronized (this) {
            this.mIsRoaming = bl;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSubtype(int n, String string2) {
        synchronized (this) {
            this.mSubtype = n;
            this.mSubtypeName = string2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setType(int n) {
        synchronized (this) {
            this.mNetworkType = n;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        synchronized (this) {
            StringBuilder stringBuilder = new StringBuilder("[");
            StringBuilder stringBuilder2 = stringBuilder.append("type: ").append(this.getTypeName()).append("[").append(this.getSubtypeName()).append("], state: ").append((Object)this.mState).append("/").append((Object)this.mDetailedState).append(", reason: ");
            String string2 = this.mReason == null ? "(unspecified)" : this.mReason;
            StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(", extra: ");
            String string3 = this.mExtraInfo == null ? "(none)" : this.mExtraInfo;
            stringBuilder3.append(string3).append(", roaming: ").append(this.mIsRoaming).append(", failover: ").append(this.mIsFailover).append(", isAvailable: ").append(this.mIsAvailable).append(", isConnectedToProvisioningNetwork: ").append(this.mIsConnectedToProvisioningNetwork).append("]");
            return stringBuilder.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        synchronized (this) {
            parcel.writeInt(this.mNetworkType);
            parcel.writeInt(this.mSubtype);
            parcel.writeString(this.mTypeName);
            parcel.writeString(this.mSubtypeName);
            parcel.writeString(this.mState.name());
            parcel.writeString(this.mDetailedState.name());
            int n3 = this.mIsFailover ? n2 : 0;
            parcel.writeInt(n3);
            int n4 = this.mIsAvailable ? n2 : 0;
            parcel.writeInt(n4);
            int n5 = this.mIsRoaming ? n2 : 0;
            parcel.writeInt(n5);
            if (!this.mIsConnectedToProvisioningNetwork) {
                n2 = 0;
            }
            parcel.writeInt(n2);
            parcel.writeString(this.mReason);
            parcel.writeString(this.mExtraInfo);
            return;
        }
    }

    public static final class DetailedState
    extends Enum<DetailedState> {
        private static final /* synthetic */ DetailedState[] $VALUES;
        public static final /* enum */ DetailedState AUTHENTICATING;
        public static final /* enum */ DetailedState BLOCKED;
        public static final /* enum */ DetailedState CAPTIVE_PORTAL_CHECK;
        public static final /* enum */ DetailedState CONNECTED;
        public static final /* enum */ DetailedState CONNECTING;
        public static final /* enum */ DetailedState DISCONNECTED;
        public static final /* enum */ DetailedState DISCONNECTING;
        public static final /* enum */ DetailedState FAILED;
        public static final /* enum */ DetailedState IDLE;
        public static final /* enum */ DetailedState OBTAINING_IPADDR;
        public static final /* enum */ DetailedState SCANNING;
        public static final /* enum */ DetailedState SUSPENDED;
        public static final /* enum */ DetailedState VERIFYING_POOR_LINK;

        static {
            IDLE = new DetailedState();
            SCANNING = new DetailedState();
            CONNECTING = new DetailedState();
            AUTHENTICATING = new DetailedState();
            OBTAINING_IPADDR = new DetailedState();
            CONNECTED = new DetailedState();
            SUSPENDED = new DetailedState();
            DISCONNECTING = new DetailedState();
            DISCONNECTED = new DetailedState();
            FAILED = new DetailedState();
            BLOCKED = new DetailedState();
            VERIFYING_POOR_LINK = new DetailedState();
            CAPTIVE_PORTAL_CHECK = new DetailedState();
            DetailedState[] detailedStateArray = new DetailedState[]{IDLE, SCANNING, CONNECTING, AUTHENTICATING, OBTAINING_IPADDR, CONNECTED, SUSPENDED, DISCONNECTING, DISCONNECTED, FAILED, BLOCKED, VERIFYING_POOR_LINK, CAPTIVE_PORTAL_CHECK};
            $VALUES = detailedStateArray;
        }

        public static DetailedState valueOf(String string2) {
            return Enum.valueOf(DetailedState.class, string2);
        }

        public static DetailedState[] values() {
            return (DetailedState[])$VALUES.clone();
        }
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State CONNECTED;
        public static final /* enum */ State CONNECTING;
        public static final /* enum */ State DISCONNECTED;
        public static final /* enum */ State DISCONNECTING;
        public static final /* enum */ State SUSPENDED;
        public static final /* enum */ State UNKNOWN;

        static {
            CONNECTING = new State();
            CONNECTED = new State();
            SUSPENDED = new State();
            DISCONNECTING = new State();
            DISCONNECTED = new State();
            UNKNOWN = new State();
            State[] stateArray = new State[]{CONNECTING, CONNECTED, SUSPENDED, DISCONNECTING, DISCONNECTED, UNKNOWN};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

