/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import java.util.Objects;

public class NetworkIdentity {
    public static final boolean COMBINE_SUBTYPE_ENABLED = true;
    public static final int SUBTYPE_COMBINED = -1;
    final String mNetworkId;
    final boolean mRoaming;
    final int mSubType;
    final String mSubscriberId;
    final int mType;

    public NetworkIdentity(int n, int n2, String string2, String string3, boolean bl) {
        this.mType = n;
        this.mSubType = -1;
        this.mSubscriberId = string2;
        this.mNetworkId = string3;
        this.mRoaming = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static NetworkIdentity buildNetworkIdentity(Context context, NetworkState networkState) {
        String string2;
        boolean bl;
        int n = networkState.networkInfo.getType();
        int n2 = networkState.networkInfo.getSubtype();
        String string3 = null;
        if (ConnectivityManager.isNetworkTypeMobile(n)) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            bl = telephonyManager.isNetworkRoaming();
            if (networkState.subscriberId != null) {
                string2 = networkState.subscriberId;
                return new NetworkIdentity(n, n2, string2, string3, bl);
            }
            string2 = telephonyManager.getSubscriberId();
            string3 = null;
            return new NetworkIdentity(n, n2, string2, string3, bl);
        }
        string2 = null;
        string3 = null;
        bl = false;
        if (n != 1) return new NetworkIdentity(n, n2, string2, string3, bl);
        if (networkState.networkId != null) {
            string3 = networkState.networkId;
            string2 = null;
            bl = false;
            return new NetworkIdentity(n, n2, string2, string3, bl);
        }
        WifiInfo wifiInfo = ((WifiManager)context.getSystemService("wifi")).getConnectionInfo();
        string3 = wifiInfo != null ? wifiInfo.getSSID() : null;
        string2 = null;
        bl = false;
        return new NetworkIdentity(n, n2, string2, string3, bl);
    }

    public static String scrubSubscriberId(String string2) {
        if ("eng".equals(Build.TYPE)) {
            return string2;
        }
        if (string2 != null) {
            return string2.substring(0, Math.min(6, string2.length())) + "...";
        }
        return "null";
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof NetworkIdentity;
        boolean bl2 = false;
        if (bl) {
            NetworkIdentity networkIdentity = (NetworkIdentity)object;
            int n = this.mType;
            int n2 = networkIdentity.mType;
            bl2 = false;
            if (n == n2) {
                int n3 = this.mSubType;
                int n4 = networkIdentity.mSubType;
                bl2 = false;
                if (n3 == n4) {
                    boolean bl3 = this.mRoaming;
                    boolean bl4 = networkIdentity.mRoaming;
                    bl2 = false;
                    if (bl3 == bl4) {
                        boolean bl5 = Objects.equals(this.mSubscriberId, networkIdentity.mSubscriberId);
                        bl2 = false;
                        if (bl5) {
                            boolean bl6 = Objects.equals(this.mNetworkId, networkIdentity.mNetworkId);
                            bl2 = false;
                            if (bl6) {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public String getNetworkId() {
        return this.mNetworkId;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public int getSubType() {
        return this.mSubType;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public int getType() {
        return this.mType;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.mType, this.mSubType, this.mSubscriberId, this.mNetworkId, this.mRoaming};
        return Objects.hash(objectArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append("type=").append(ConnectivityManager.getNetworkTypeName(this.mType));
        stringBuilder.append(", subType=");
        stringBuilder.append("COMBINED");
        if (this.mSubscriberId != null) {
            stringBuilder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mNetworkId != null) {
            stringBuilder.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mRoaming) {
            stringBuilder.append(", ROAMING");
        }
        return stringBuilder.append("]").toString();
    }
}

