/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ParseException;
import android.net.Uri;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MailTo {
    private static final String BODY = "body";
    private static final String CC = "cc";
    public static final String MAILTO_SCHEME = "mailto:";
    private static final String SUBJECT = "subject";
    private static final String TO = "to";
    private HashMap<String, String> mHeaders = new HashMap();

    private MailTo() {
    }

    public static boolean isMailTo(String string2) {
        return string2 != null && string2.startsWith(MAILTO_SCHEME);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MailTo parse(String string2) throws ParseException {
        String string3;
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (!MailTo.isMailTo(string2)) {
            throw new ParseException("Not a mailto scheme");
        }
        Uri uri = Uri.parse(string2.substring(MAILTO_SCHEME.length()));
        MailTo mailTo = new MailTo();
        String string4 = uri.getQuery();
        if (string4 != null) {
            String[] stringArray = string4.split("&");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2.length == 0) continue;
                HashMap<String, String> hashMap = mailTo.mHeaders;
                String string5 = Uri.decode(stringArray2[0]).toLowerCase(Locale.ROOT);
                String string6 = stringArray2.length > 1 ? Uri.decode(stringArray2[1]) : null;
                hashMap.put(string5, string6);
            }
        }
        if ((string3 = uri.getPath()) != null) {
            String string7 = mailTo.getTo();
            if (string7 != null) {
                string3 = string3 + ", " + string7;
            }
            mailTo.mHeaders.put(TO, string3);
        }
        return mailTo;
    }

    public String getBody() {
        return this.mHeaders.get(BODY);
    }

    public String getCc() {
        return this.mHeaders.get(CC);
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public String getSubject() {
        return this.mHeaders.get(SUBJECT);
    }

    public String getTo() {
        return this.mHeaders.get(TO);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(MAILTO_SCHEME);
        stringBuilder.append('?');
        for (Map.Entry<String, String> entry : this.mHeaders.entrySet()) {
            stringBuilder.append(Uri.encode(entry.getKey()));
            stringBuilder.append('=');
            stringBuilder.append(Uri.encode(entry.getValue()));
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }
}

