/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Credentials;
import android.net.LocalSocketAddress;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LocalSocketImpl {
    private FileDescriptor fd;
    private SocketInputStream fis;
    private SocketOutputStream fos;
    FileDescriptor[] inboundFileDescriptors;
    private boolean mFdCreatedInternally;
    FileDescriptor[] outboundFileDescriptors;
    private Object readMonitor = new Object();
    private Object writeMonitor = new Object();

    LocalSocketImpl() {
    }

    LocalSocketImpl(FileDescriptor fileDescriptor) throws IOException {
        this.fd = fileDescriptor;
    }

    private native FileDescriptor accept(FileDescriptor var1, LocalSocketImpl var2) throws IOException;

    private native int available_native(FileDescriptor var1) throws IOException;

    private native void bindLocal(FileDescriptor var1, String var2, int var3) throws IOException;

    private native void connectLocal(FileDescriptor var1, String var2, int var3) throws IOException;

    private native int getOption_native(FileDescriptor var1, int var2) throws IOException;

    private native Credentials getPeerCredentials_native(FileDescriptor var1) throws IOException;

    private native void listen_native(FileDescriptor var1, int var2) throws IOException;

    private native int pending_native(FileDescriptor var1) throws IOException;

    private native int read_native(FileDescriptor var1) throws IOException;

    private native int readba_native(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    private native void setOption_native(FileDescriptor var1, int var2, int var3, int var4) throws IOException;

    private native void shutdown(FileDescriptor var1, boolean var2);

    private native void write_native(int var1, FileDescriptor var2) throws IOException;

    private native void writeba_native(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    protected void accept(LocalSocketImpl localSocketImpl) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        localSocketImpl.fd = this.accept(this.fd, localSocketImpl);
        localSocketImpl.mFdCreatedInternally = true;
    }

    protected int available() throws IOException {
        return this.getInputStream().available();
    }

    public void bind(LocalSocketAddress localSocketAddress) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.bindLocal(this.fd, localSocketAddress.getName(), localSocketAddress.getNamespace().getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        synchronized (this) {
            if (this.fd == null || !this.mFdCreatedInternally) {
                this.fd = null;
                return;
            }
            try {
                Os.close(this.fd);
            }
            catch (ErrnoException errnoException) {
                errnoException.rethrowAsIOException();
            }
            this.fd = null;
            return;
        }
    }

    protected void connect(LocalSocketAddress localSocketAddress, int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.connectLocal(this.fd, localSocketAddress.getName(), localSocketAddress.getNamespace().getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void create(int n) throws IOException {
        int n2;
        if (this.fd != null) return;
        switch (n) {
            default: {
                throw new IllegalStateException("unknown sockType");
            }
            case 1: {
                n2 = OsConstants.SOCK_DGRAM;
                break;
            }
            case 2: {
                n2 = OsConstants.SOCK_STREAM;
                break;
            }
            case 3: {
                n2 = OsConstants.SOCK_SEQPACKET;
            }
        }
        try {
            this.fd = Os.socket(OsConstants.AF_UNIX, n2, 0);
            this.mFdCreatedInternally = true;
            return;
        }
        catch (ErrnoException errnoException) {
            errnoException.rethrowAsIOException();
            return;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        Object object = this.readMonitor;
        synchronized (object) {
            FileDescriptor[] fileDescriptorArray = this.inboundFileDescriptors;
            this.inboundFileDescriptors = null;
            return fileDescriptorArray;
        }
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream getInputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        synchronized (this) {
            if (this.fis != null) return this.fis;
            this.fis = new SocketInputStream();
            return this.fis;
        }
    }

    public Object getOption(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (n == 4102) {
            return 0;
        }
        int n2 = this.getOption_native(this.fd, n);
        switch (n) {
            default: {
                return n2;
            }
            case 4097: 
            case 4098: 
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OutputStream getOutputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        synchronized (this) {
            if (this.fos != null) return this.fos;
            this.fos = new SocketOutputStream();
            return this.fos;
        }
    }

    public Credentials getPeerCredentials() throws IOException {
        return this.getPeerCredentials_native(this.fd);
    }

    public LocalSocketAddress getSockAddress() throws IOException {
        return null;
    }

    protected void listen(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.listen_native(this.fd, n);
    }

    protected void sendUrgentData(int n) throws IOException {
        throw new RuntimeException("not impled");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFileDescriptorsForSend(FileDescriptor[] fileDescriptorArray) {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.outboundFileDescriptors = fileDescriptorArray;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setOption(int n, Object object) throws IOException {
        int n2;
        int n3 = -1;
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (object instanceof Integer) {
            n2 = (Integer)object;
        } else {
            if (!(object instanceof Boolean)) {
                throw new IOException("bad value: " + object);
            }
            n3 = (Boolean)object != false ? 1 : 0;
            n2 = 0;
        }
        this.setOption_native(this.fd, n, n3, n2);
    }

    protected void shutdownInput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.shutdown(this.fd, true);
    }

    protected void shutdownOutput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.shutdown(this.fd, false);
    }

    protected boolean supportsUrgentData() {
        return false;
    }

    public String toString() {
        return super.toString() + " fd:" + this.fd;
    }

    class SocketInputStream
    extends InputStream {
        SocketInputStream() {
        }

        @Override
        public int available() throws IOException {
            FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
            if (fileDescriptor == null) {
                throw new IOException("socket closed");
            }
            return LocalSocketImpl.this.available_native(fileDescriptor);
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read() throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor != null) return LocalSocketImpl.this.read_native(fileDescriptor);
                throw new IOException("socket closed");
            }
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor == null) {
                    throw new IOException("socket closed");
                }
                if (n < 0) throw new ArrayIndexOutOfBoundsException();
                if (n2 < 0) throw new ArrayIndexOutOfBoundsException();
                int n3 = n + n2;
                if (n3 > byArray.length) throw new ArrayIndexOutOfBoundsException();
                return LocalSocketImpl.this.readba_native(byArray, n, n2, fileDescriptor);
            }
        }
    }

    class SocketOutputStream
    extends OutputStream {
        SocketOutputStream() {
        }

        @Override
        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        @Override
        public void flush() throws IOException {
            FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
            if (fileDescriptor == null) {
                throw new IOException("socket closed");
            }
            while (LocalSocketImpl.this.pending_native(fileDescriptor) > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(int n) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor == null) {
                    throw new IOException("socket closed");
                }
                LocalSocketImpl.this.write_native(n, fileDescriptor);
                return;
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                int n3;
                FileDescriptor fileDescriptor = LocalSocketImpl.this.fd;
                if (fileDescriptor == null) {
                    throw new IOException("socket closed");
                }
                if (n >= 0 && n2 >= 0 && (n3 = n + n2) <= byArray.length) {
                    LocalSocketImpl.this.writeba_native(byArray, n, n2, fileDescriptor);
                    return;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }
}

