/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.INetworkStatsSession;
import android.net.NetworkStats;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsService
extends IInterface {
    public void advisePersistThreshold(long var1) throws RemoteException;

    public void forceUpdate() throws RemoteException;

    public NetworkStats getDataLayerSnapshotForUid(int var1) throws RemoteException;

    public String[] getMobileIfaces() throws RemoteException;

    public long getNetworkTotalBytes(NetworkTemplate var1, long var2, long var4) throws RemoteException;

    public void incrementOperationCount(int var1, int var2, int var3) throws RemoteException;

    public INetworkStatsSession openSession() throws RemoteException;

    public void setUidForeground(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsService {
        private static final String DESCRIPTOR = "android.net.INetworkStatsService";
        static final int TRANSACTION_advisePersistThreshold = 8;
        static final int TRANSACTION_forceUpdate = 7;
        static final int TRANSACTION_getDataLayerSnapshotForUid = 3;
        static final int TRANSACTION_getMobileIfaces = 4;
        static final int TRANSACTION_getNetworkTotalBytes = 2;
        static final int TRANSACTION_incrementOperationCount = 5;
        static final int TRANSACTION_openSession = 1;
        static final int TRANSACTION_setUidForeground = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkStatsService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof INetworkStatsService) {
                return (INetworkStatsService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    INetworkStatsSession iNetworkStatsSession = this.openSession();
                    parcel2.writeNoException();
                    IBinder iBinder = iNetworkStatsSession != null ? iNetworkStatsSession.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkTemplate networkTemplate = parcel.readInt() != 0 ? NetworkTemplate.CREATOR.createFromParcel(parcel) : null;
                    long l = this.getNetworkTotalBytes(networkTemplate, parcel.readLong(), parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkStats networkStats = this.getDataLayerSnapshotForUid(parcel.readInt());
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getMobileIfaces();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.incrementOperationCount(parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    this.setUidForeground(n3, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.forceUpdate();
                    parcel2.writeNoException();
                    return true;
                }
                case 8: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.advisePersistThreshold(parcel.readLong());
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements INetworkStatsService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void advisePersistThreshold(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void forceUpdate() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getDataLayerSnapshotForUid(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStats networkStats = parcel2.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel2) : null;
                    return networkStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public String[] getMobileIfaces() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public long getNetworkTotalBytes(NetworkTemplate networkTemplate, long l, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkTemplate != null) {
                        parcel.writeInt(1);
                        networkTemplate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeLong(l);
                    parcel.writeLong(l2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    long l3 = parcel2.readLong();
                    return l3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void incrementOperationCount(int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public INetworkStatsSession openSession() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    INetworkStatsSession iNetworkStatsSession = INetworkStatsSession.Stub.asInterface(parcel2.readStrongBinder());
                    return iNetworkStatsSession;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setUidForeground(int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(6, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }
        }
    }
}

