/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.SamplingDataTracker;
import android.os.Handler;
import android.os.Messenger;
import com.android.internal.util.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseNetworkStateTracker
implements NetworkStateTracker {
    public static final String PROP_TCP_BUFFER_UNKNOWN = "net.tcp.buffersize.unknown";
    public static final String PROP_TCP_BUFFER_WIFI = "net.tcp.buffersize.wifi";
    protected Context mContext;
    private AtomicBoolean mDefaultRouteSet;
    protected LinkProperties mLinkProperties;
    protected Network mNetwork = new Network(0);
    protected NetworkCapabilities mNetworkCapabilities;
    protected NetworkInfo mNetworkInfo;
    private AtomicBoolean mPrivateDnsRouteSet;
    private Handler mTarget;
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);

    protected BaseNetworkStateTracker() {
        this.mPrivateDnsRouteSet = new AtomicBoolean(false);
        this.mDefaultRouteSet = new AtomicBoolean(false);
    }

    public BaseNetworkStateTracker(int n) {
        this.mPrivateDnsRouteSet = new AtomicBoolean(false);
        this.mDefaultRouteSet = new AtomicBoolean(false);
        this.mNetworkInfo = new NetworkInfo(n, -1, ConnectivityManager.getNetworkTypeName(n), null);
        this.mLinkProperties = new LinkProperties();
        this.mNetworkCapabilities = new NetworkCapabilities();
    }

    @Override
    public void addStackedLink(LinkProperties linkProperties) {
        this.mLinkProperties.addStackedLink(linkProperties);
    }

    @Override
    public void captivePortalCheckCompleted(boolean bl) {
    }

    @Override
    public void defaultRouteSet(boolean bl) {
        this.mDefaultRouteSet.set(bl);
    }

    protected final void dispatchConfigurationChanged() {
        this.mTarget.obtainMessage(458753, this.getNetworkInfo()).sendToTarget();
    }

    protected final void dispatchStateChanged() {
        this.mTarget.obtainMessage(458752, this.getNetworkInfo()).sendToTarget();
    }

    @Override
    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    @Override
    public LinkQualityInfo getLinkQualityInfo() {
        return null;
    }

    @Override
    public Network getNetwork() {
        return this.mNetwork;
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities() {
        return new NetworkCapabilities(this.mNetworkCapabilities);
    }

    @Override
    public NetworkInfo getNetworkInfo() {
        return new NetworkInfo(this.mNetworkInfo);
    }

    @Override
    public String getNetworkInterfaceName() {
        if (this.mLinkProperties != null) {
            return this.mLinkProperties.getInterfaceName();
        }
        return null;
    }

    @Deprecated
    protected Handler getTargetHandler() {
        return this.mTarget;
    }

    @Override
    public boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    @Override
    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    @Override
    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    @Override
    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    @Override
    public void privateDnsRouteSet(boolean bl) {
        this.mPrivateDnsRouteSet.set(bl);
    }

    @Override
    public void removeStackedLink(LinkProperties linkProperties) {
        this.mLinkProperties.removeStackedLink(linkProperties);
    }

    @Override
    public void setDependencyMet(boolean bl) {
    }

    @Override
    public void setNetId(int n) {
        this.mNetwork = new Network(n);
    }

    @Override
    public void setPolicyDataEnable(boolean bl) {
    }

    @Override
    public boolean setRadio(boolean bl) {
        return true;
    }

    @Override
    public void setTeardownRequested(boolean bl) {
        this.mTeardownRequested.set(bl);
    }

    @Override
    public void setUserDataEnable(boolean bl) {
    }

    @Override
    public void startMonitoring(Context context, Handler handler) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mTarget = Preconditions.checkNotNull(handler);
        this.startMonitoringInternal();
    }

    protected void startMonitoringInternal() {
    }

    @Override
    public void startSampling(SamplingDataTracker.SamplingSnapshot samplingSnapshot) {
    }

    @Override
    public void stopSampling(SamplingDataTracker.SamplingSnapshot samplingSnapshot) {
    }

    @Override
    public void supplyMessenger(Messenger messenger) {
    }
}

