/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioAttributes;
import java.util.ArrayList;
import java.util.Iterator;

public class AudioMixingRule {
    public static final int RULE_EXCLUDE_ATTRIBUTE_USAGE = 2;
    public static final int RULE_MATCH_ATTRIBUTE_USAGE = 1;
    private ArrayList<AttributeMatchCriterion> mCriteria;

    private AudioMixingRule(ArrayList<AttributeMatchCriterion> arrayList) {
        this.mCriteria = arrayList;
    }

    ArrayList<AttributeMatchCriterion> getCriteria() {
        return this.mCriteria;
    }

    static final class AttributeMatchCriterion {
        AudioAttributes mAttr;
        int mRule;

        AttributeMatchCriterion(AudioAttributes audioAttributes, int n) {
            this.mAttr = audioAttributes;
            this.mRule = n;
        }
    }

    public static class Builder {
        private ArrayList<AttributeMatchCriterion> mCriteria = new ArrayList();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Builder addRule(AudioAttributes audioAttributes, int n) throws IllegalArgumentException {
            if (audioAttributes == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            if (n != 1 && n != 2) {
                throw new IllegalArgumentException("Illegal rule value " + n);
            }
            ArrayList<AttributeMatchCriterion> arrayList = this.mCriteria;
            synchronized (arrayList) {
                AttributeMatchCriterion attributeMatchCriterion;
                Iterator<AttributeMatchCriterion> iterator = this.mCriteria.iterator();
                do {
                    if (!iterator.hasNext()) {
                        this.mCriteria.add(new AttributeMatchCriterion(audioAttributes, n));
                        return this;
                    }
                    attributeMatchCriterion = iterator.next();
                } while (n != 1 && n != 2 || attributeMatchCriterion.mAttr.getUsage() != audioAttributes.getUsage());
                if (attributeMatchCriterion.mRule == n) {
                    return this;
                }
                throw new IllegalArgumentException("Contradictory rule exists for " + audioAttributes);
            }
        }

        public AudioMixingRule build() {
            return new AudioMixingRule(this.mCriteria);
        }
    }
}

